#!/usr/bin/perl -w
# NAME: timelocal.pl
# AIM: Some tests and experiments with timelocal function
# Not totally perfect, but quite good
# 23/05/2015 geoff mclane http://geoffair.net/mperl
use strict;
use warnings;
use File::Basename;  # split path ($name,$dir,$ext) = fileparse($file [, qr/\.[^.]*/] )
use Time::Local;
use DateTime;
use Cwd;
my $os = $^O;
my $perl_dir = '/home/geoff/bin';
my $PATH_SEP = '/';
my $temp_dir = '/tmp';
if ($os =~ /win/i) {
    $perl_dir = 'C:\GTools\perl';
    $temp_dir = $perl_dir;
    $PATH_SEP = "\\";
}
unshift(@INC, $perl_dir);
require 'lib_utils.pl' or die "Unable to load 'lib_utils.pl' Check paths in \@INC...\n";
# log file stuff
our ($LF);
my $pgmname = $0;
if ($pgmname =~ /(\\|\/)/) {
    my @tmpsp = split(/(\\|\/)/,$pgmname);
    $pgmname = $tmpsp[-1];
}
my $outfile = $temp_dir.$PATH_SEP."temp.$pgmname.txt";
open_log($outfile);

# user variables
my $VERS = "0.0.5 2015-01-09";
my $load_log = 0;
my $in_file = '';
my $verbosity = 0;
my $out_file = '';

# ### DEBUG ###
my $debug_on = 0;
my $def_file = 'def_file';

### program variables
my @warnings = ();
my $cwd = cwd();

sub VERB1() { return $verbosity >= 1; }
sub VERB2() { return $verbosity >= 2; }
sub VERB5() { return $verbosity >= 5; }
sub VERB9() { return $verbosity >= 9; }

sub show_warnings($) {
    my ($val) = @_;
    if (@warnings) {
        prt( "\nGot ".scalar @warnings." WARNINGS...\n" );
        foreach my $itm (@warnings) {
           prt("$itm\n");
        }
        prt("\n");
    } else {
        prt( "\nNo warnings issued.\n\n" ) if (VERB9());
    }
}

sub pgm_exit($$) {
    my ($val,$msg) = @_;
    if (length($msg)) {
        $msg .= "\n" if (!($msg =~ /\n$/));
        prt($msg);
    }
    show_warnings($val);
    close_log($outfile,$load_log);
    exit($val);
}


sub prtw($) {
   my ($tx) = shift;
   $tx =~ s/\n$//;
   prt("$tx\n");
   push(@warnings,$tx);
}

sub process_in_file($) {
    my ($inf) = @_;
    if (! open INF, "<$inf") {
        pgm_exit(1,"ERROR: Unable to open file [$inf]\n"); 
    }
    my @lines = <INF>;
    close INF;
    my $lncnt = scalar @lines;
    prt("Processing $lncnt lines, from [$inf]...\n");
    my ($line,$inc,$lnn);
    $lnn = 0;
    foreach $line (@lines) {
        chomp $line;
        $lnn++;
        if ($line =~ /\s*#\s*include\s+(.+)$/) {
            $inc = $1;
            prt("$lnn: $inc\n");
        }
    }
}

sub get_dates() {
    my $txt = <<EOF;
Date:   Fri May 22 19:06:17 2015 +0200
Date:   Thu Apr 9 23:51:23 2015 +0800
Date:   Fri Apr 10 15:42:49 2015 -0700
Date:   Fri Mar 20 13:56:20 2015 +0100
Date:   Sat Mar 7 22:28:58 2015 +0000
Date:   Fri Jun 28 16:20:02 2013 -0700
Date:   Tue Aug 21 20:37:24 2012 +0900
Date:   Tue Feb 28 08:18:25 2012 -0800
Date:   Sun Feb 26 11:53:53 2012 -0500
EOF
    return $txt;
}

sub get_dates2() {
    my $txt = <<EOF;
Date: Wed Dec 31 23:59:17 2014 +0200
Date: Thu Jan 01 00:22:27 2015 -0200
Date: Fri May 22 16:06:48 2015 +0200
Date: Fri May 15 16:17:46 2015 +0200
Date: Fri May 15 15:06:52 2015 +0200
Date: Fri May 22 15:59:51 2015 +0200
Date: Wed May 20 20:09:57 2015 +0200
Date: Wed May 20 14:07:39 2015 +0200
Date: Wed May 20 14:06:30 2015 +0200
Date: Tue May 19 16:53:29 2015 +0200
Date: Tue May 19 16:51:15 2015 +0200
Date: Fri May 15 16:17:46 2015 +0200
Date: Fri May 15 15:06:52 2015 +0200
Date: Thu May 14 15:03:36 2015 +0200
Date: Thu May 14 15:02:46 2015 +0200
Date: Thu May 14 14:52:05 2015 +0200
Date: Thu May 14 14:47:02 2015 +0200
Date: Thu May 14 14:34:25 2015 +0200
Date: Wed May 13 14:25:29 2015 +0200
Date: Wed May 13 14:13:35 2015 +0200
Date: Wed May 13 14:12:03 2015 +0200
Date: Wed May 13 14:10:29 2015 +0200
Date: Wed May 13 13:38:40 2015 +0200
Date: Wed May 13 13:22:11 2015 +0200
Date: Wed May 13 12:40:46 2015 +0200
Date: Wed May 13 12:38:50 2015 +0200
Date: Wed May 13 12:37:20 2015 +0200
Date: Wed May 13 12:31:23 2015 +0200
Date: Tue May 12 17:14:09 2015 +0200
Date: Tue May 12 17:13:23 2015 +0200
Date: Tue May 12 17:11:48 2015 +0200
Date: Tue May 12 14:25:12 2015 +0200
Date: Tue May 12 13:22:03 2015 +0200
Date: Tue May 12 13:18:16 2015 +0200
Date: Wed Apr 29 18:23:28 2015 +0200
Date: Sun Apr 26 19:19:55 2015 +0200
Date: Sun Apr 26 13:36:13 2015 +0200
Date: Sun Apr 26 13:17:43 2015 +0300
Date: Sat Apr 25 20:37:35 2015 +0200
Date: Sat Apr 25 19:20:16 2015 +0200
EOF
    return $txt;
}

sub get_dates_short() {
    my $txt = <<EOF;
Date: Fri May 22 19:06:17 2015
Date: Fri May 22 16:22:27 2015
Date: Fri May 22 16:06:48 2015
Date: Fri May 15 16:17:46 2015
Date: Fri May 15 15:06:52 2015
Date: Fri May 22 15:59:51 2015
Date: Wed May 20 20:09:57 2015
Date: Wed May 20 14:07:39 2015
Date: Wed May 20 14:06:30 2015
Date: Tue May 19 16:53:29 2015
Date: Tue May 19 16:51:15 2015
Date: Fri May 15 16:17:46 2015
Date: Fri May 15 15:06:52 2015
Date: Thu May 14 15:03:36 2015
Date: Thu May 14 15:02:46 2015
Date: Thu May 14 14:52:05 2015
Date: Thu May 14 14:47:02 2015
Date: Thu May 14 14:34:25 2015
Date: Wed May 13 14:25:29 2015
Date: Wed May 13 14:13:35 2015
Date: Wed May 13 14:12:03 2015
Date: Wed May 13 14:10:29 2015
Date: Wed May 13 13:38:40 2015
Date: Wed May 13 13:22:11 2015
Date: Wed May 13 12:40:46 2015
Date: Wed May 13 12:38:50 2015
Date: Wed May 13 12:37:20 2015
Date: Wed May 13 12:31:23 2015
Date: Tue May 12 17:14:09 2015
Date: Tue May 12 17:13:23 2015
Date: Tue May 12 17:11:48 2015
Date: Tue May 12 14:25:12 2015
Date: Tue May 12 13:22:03 2015
Date: Tue May 12 13:18:16 2015
Date: Wed Apr 29 18:23:28 2015
Date: Sun Apr 26 19:19:55 2015
Date: Sun Apr 26 13:36:13 2015
Date: Sun Apr 26 13:17:43 2015
Date: Sat Apr 25 20:37:35 2015
Date: Sat Apr 25 19:20:16 2015
EOF
    return $txt;
}


my %days = (
    0 => 'Sun',
    1 => 'Mon',
    2 => 'Tue',
    3 => 'Wed',
    4 => 'Thu',
    5 => 'Fri',
    6 => 'Sat',
    7 => 'Sun'
    );

my %months = (
    'Jan' => 1,
    'Feb' => 2,
    'Mar' => 3,
    'Apr' => 4,
    'May' => 5,
    'Jun' => 6,
    'Jul' => 7,
    'Aug' => 8,
    'Sep' => 9,
    'Oct' => 10,
    'Nov' => 11,
    'Dec' => 12
    );

my %days_in_month = (
    'Jan' => 31,
    'Feb' => 28,    # 29 days in Leap Years
    'Mar' => 31,
    'Apr' => 30,
    'May' => 31,
    'Jun' => 30,
    'Jul' => 31,
    'Aug' => 31,
    'Sep' => 30,
    'Oct' => 31,
    'Nov' => 30,
    'Dec' => 31
    );

sub is_leap_year($) {
    my $year = shift;
    if (( 0 == ($year % 4) ) && ( (0 != ($year % 100)) || (0 == ( $year % 400 )) ) ) {
        return 1;   # Then $year is a leap year.
    }
    return 0;
}

# sec,     # seconds of minutes from 0 to 61 (leap secs)
# min,     # minutes of hour from 0 to 59
# hour,    # hours of day from 0 to 24
# mday,    # day of month from 1 to 31
# mon,     # month of year from 0 to 11
# year,    # year since 1900
# wday,    # days since sunday
# yday,    # days since January 1st
# isdst    # hours of daylight savings time
#
# Please note, however, that the range of dates that can be actually be handled 
# depends on the size of an integer (time_t) on a given platform. 
# Currently, this is 32 bits for most systems, yielding an approximate range 
# from Dec 1901 to Jan 2038.
sub parsedate_simp($) { 
  my ($s) = @_;
  my ($cday, $year, $month, $day, $hour, $minute, $second, $mon);
  #              cday    mon     day     hour   min      sec       year
  #              1       2       3       4      5        6         7
  if($s =~ /^\s*(\w+)\s+(\w+)\s+(\d+)\s+(\d{2}):(\d{2}):(\d{2})\s+(\d{4})\b/) {
      $cday   = $1;
      $month  = $2;
      $day    = $3;
      $hour   = $4;
      $minute = $5;
      $second = $6;
      $year   = $7;
      if (defined $months{$month}) {
          $mon = $months{$month};
          #prt("timelocal($second,$minute,$hour,$day,".($mon-1).",$year)\n");  
          return timelocal($second,$minute,$hour,$day,$mon-1,$year);  
          #return timegm($second,$minute,$hour,$day,$mon-1,$year);
       }
  }
  return -1;
}

# /^\s*(\w+)\s+(\w+)\s+(\d+)\s+(\d{2}):(\d{2}):(\d{2}\s+(\d{4})/
#       Wed     May      13    12:37:20               2015       +0200
sub parsedate($) { 
  my ($s) = @_;
  my ($cday, $year, $month, $day, $hour, $minute, $second, $mon, $pm, $off, $dim);
  #              cday    mon     day     hour   min      sec       year      +|-    offset
  #              1       2       3       4      5        6         7         8      9
  if($s =~ /^\s*(\w+)\s+(\w+)\s+(\d+)\s+(\d{2}):(\d{2}):(\d{2})\s+(\d{4})\s+(\+|\-)(\d{4})/) {
      $cday   = $1;
      $month  = $2;
      $day    = $3;
      $hour   = $4;
      $minute = $5;
      $second = $6;
      $year   = $7;
      $pm     = $8;
      $off    = $9;
      if (defined $months{$month}) {
          $mon = $months{$month};
          $dim = $days_in_month{$month};
          $dim = 31 if (!defined $dim); # should NOT happen
          if (($dim == 28) && ($mon eq 'Feb')) {
              if (is_leap_year($year)) {
                  $dim++;
              }
          }
          if ($pm eq '-') {
              $hour += int($off/100);
              if ($hour > 24) {
                  $hour -= 24;
                  $day++;
                  if ($day > $dim) {
                      $day = 1;
                      $mon++;
                      if ($mon > 11) {
                          $mon = 1;
                          $year++;
                      }
                  }
              }
          } elsif ($pm eq '+') {
              $hour -= int($off/100);
              if ($hour < 0) {
                  $hour += 24;
                  $day--;
                  if ($day <= 0) {
                      $day = $dim;
                      $mon--;
                      if ($mon <= 0) {
                          $mon = 12;
                          $year--;
                      }
                  }
              }
          }
          return timegm($second,$minute,$hour,$day,$mon-1,$year);
          #prt("timelocal($second,$minute,$hour,$day,".($mon-1).",$year)\n");  
          #return timelocal($second,$minute,$hour,$day,$mon-1,$year);  
      }
  } elsif($s =~ /^\s*(\w+)\s+(\w+)\s+(\d+)\s+(\d{2}):(\d{2}):(\d{2})\s+(\d{4})\b/) {
      $cday   = $1;
      $month  = $2;
      $day    = $3;
      $hour   = $4;
      $minute = $5;
      $second = $6;
      $year   = $7;
      if (defined $months{$month}) {
          $mon = $months{$month};
          #prt("timelocal($second,$minute,$hour,$day,".($mon-1).",$year)\n");  
          return timelocal($second,$minute,$hour,$day,$mon-1,$year);  
          #return timegm($second,$minute,$hour,$day,$mon-1,$year);
      }
  }
  return -1;
}



sub get_datetime($) {
    my $epoch = shift;
    my $dt = DateTime->from_epoch( epoch => $epoch );
    my $year   = $dt->year;
    my $month  = $dt->month; # 1-12 - you can also use '$dt->mon'
    my $day    = $dt->day; # 1-31 - also 'day_of_month', 'mday'
    my $dow    = $dt->day_of_week; # 1-7 (Monday is 1) - also 'dow', 'wday'
    my $hour   = $dt->hour; # 0-23
    my $minute = $dt->minute; # 0-59 - also 'min'
    my $second = $dt->second; # 0-61 (leap seconds!) - also 'sec'
    my $doy    = $dt->day_of_year; # 1-366 (leap years) - also 'doy'
    my $doq    = $dt->day_of_quarter; # 1.. - also 'doq'
    my $qtr    = $dt->quarter; # 1-4
    my $ymd    = $dt->ymd; # 1974-11-30
    #my $ymd    = $dt->ymd('/'); # 1974/11/30 - also 'date'
    my $hms    = $dt->hms; # 13:30:00
    #my $hms    = $dt->hms('|'); # 13|30|00 - also 'time'
    my ($key,$val,$cmon,$cday);
    my @arr = keys %months;
    foreach $key (@arr) {
        if ($months{$key} == $month) {
            $cmon = $key;
            last;
        }
    }
    my $str = 'failed';
    if ((defined $cmon) && (defined $days{$dow})) {
        $day = '0'.$day if ($day < 10);
        $str = $days{$dow}." $cmon $day $hms $year";
    }
    return $str;
}
 

sub test_dates() {
    my $dates = get_dates();
    my @arr = split("\n",$dates);
    my ($date,$epoch,$str,$loc,$gmt);
    $epoch = time();
    $str = get_datetime($epoch);
    my $datestring = localtime()." +0200";
    $loc = lu_get_YYYYMMDD_hhmmss($epoch);
    $gmt = lu_get_YYYYMMDD_hhmmss_UTC($epoch);
    #prt("$epoch: $datestring $str $loc $gmt UTC\n");
    prt("$epoch:\n$datestring\n$str\n$loc\n$gmt UTC\n");
    $epoch = parsedate($datestring);
    $str = get_datetime($epoch);
    $loc = lu_get_YYYYMMDD_hhmmss($epoch);
    $gmt = lu_get_YYYYMMDD_hhmmss_UTC($epoch);
    #prt("$epoch: $datestring $str $loc $gmt UTC\n");
    prt("$epoch:\n$datestring\n$str\n$loc\n$gmt UTC\n");
    foreach $date (@arr) {
        if ($date =~ /^Date:\s+/) {
            $date =~ s/^Date:\s+//;
            $epoch = parsedate($date);
            $str = get_datetime($epoch);
            $loc = lu_get_YYYYMMDD_hhmmss($epoch);
            $gmt = lu_get_YYYYMMDD_hhmmss_UTC($epoch);
            #prt("$epoch: $date $str $loc $gmt UTC\n");
            prt("$epoch:\n$datestring\n$str\n$loc\n$gmt UTC\n");
        }
    }

}

#########################################
### MAIN ###
##parse_args(@ARGV);
##process_in_file($in_file);
test_dates();
pgm_exit(0,"");
########################################

sub need_arg {
    my ($arg,@av) = @_;
    pgm_exit(1,"ERROR: [$arg] must have a following argument!\n") if (!@av);
}

sub parse_args {
    my (@av) = @_;
    my ($arg,$sarg);
    my $verb = VERB2();
    while (@av) {
        $arg = $av[0];
        if ($arg =~ /^-/) {
            $sarg = substr($arg,1);
            $sarg = substr($sarg,1) while ($sarg =~ /^-/);
            if (($sarg =~ /^h/i)||($sarg eq '?')) {
                give_help();
                pgm_exit(0,"Help exit(0)");
            } elsif ($sarg =~ /^v/) {
                if ($sarg =~ /^v.*(\d+)$/) {
                    $verbosity = $1;
                } else {
                    while ($sarg =~ /^v/) {
                        $verbosity++;
                        $sarg = substr($sarg,1);
                    }
                }
                $verb = VERB2();
                prt("Verbosity = $verbosity\n") if ($verb);
            } elsif ($sarg =~ /^l/) {
                if ($sarg =~ /^ll/) {
                    $load_log = 2;
                } else {
                    $load_log = 1;
                }
                prt("Set to load log at end. ($load_log)\n") if ($verb);
            } elsif ($sarg =~ /^o/) {
                need_arg(@av);
                shift @av;
                $sarg = $av[0];
                $out_file = $sarg;
                prt("Set out file to [$out_file].\n") if ($verb);
            } else {
                pgm_exit(1,"ERROR: Invalid argument [$arg]! Try -?\n");
            }
        } else {
            $in_file = $arg;
            prt("Set input to [$in_file]\n") if ($verb);
        }
        shift @av;
    }

    if ($debug_on) {
        prtw("WARNING: DEBUG is ON!\n");
        if (length($in_file) ==  0) {
            $in_file = $def_file;
            prt("Set DEFAULT input to [$in_file]\n");
        }
    }
    if (length($in_file) ==  0) {
        pgm_exit(1,"ERROR: No input files found in command!\n");
    }
    if (! -f $in_file) {
        pgm_exit(1,"ERROR: Unable to find in file [$in_file]! Check name, location...\n");
    }
}

sub give_help {
    prt("$pgmname: version $VERS\n");
    prt("Usage: $pgmname [options] in-file\n");
    prt("Options:\n");
    prt(" --help  (-h or -?) = This help, and exit 0.\n");
    prt(" --verb[n]     (-v) = Bump [or set] verbosity. def=$verbosity\n");
    prt(" --load        (-l) = Load LOG at end. ($outfile)\n");
    prt(" --out <file>  (-o) = Write output to this file.\n");
}

# eof - template.pl
