#!/perl -w
# trimdf01.pl
# AIM: To input the output of a directory command,
# and output a TRIMMED version ...
# a) remove blank lines ...
# b) remove leading spaces off lines
# c) remove lines -
#	i.  Volume in drive C has no label.
#	ii. Volume Serial Number is D833-AEFA
#	iii.                1 File(s)          7,117 bytes
#	iv.      Total Files Listed:
#	v.             163 File(s)      2,271,636 bytes
#	vi.               0 Dir(s)  176,651,669,504 bytes free
# 2009/09/28 - called by cleandir.bat file, so some improvements
# 2006/11/25  - geoff mclane - http://geoffair.net/mperl/
use strict;
use warnings;
use Cwd;
use File::Basename;
unshift(@INC, 'C:/GTools/perl');
use Cwd;
use File::Basename;
unshift(@INC, 'C:/GTools/perl');
require 'fgutils.pl' or die "Unable to load fgutils.pl ...\n";
# log file stuff
my ($LF);
my $pgmname = $0;
if ($pgmname =~ /\w{1}:\\.*/) {
    my @tmpsp = split(/\\/,$pgmname);
    $pgmname = $tmpsp[-1];
}
my $perl_dir = 'C:/GTools/perl';
my $outfile = $perl_dir."\\temp.$pgmname.txt";
open_log($outfile);

# features
my $load_log = 0;   # load log file at end

my $act_in_file = 'tempdir.txt';

sub pgm_exit($$) {
    my ($val,$msg) = @_;
    prt( "$msg" ) if (length($msg));
    close_log($outfile,$load_log);
    exit($val);
}

sub trim_leading($) {
	my ($ln) = shift;
    $ln = substr($ln,1) while ($ln =~ /^\s/);
	return $ln;
}

sub process_file($) {
    my ($inf) = @_;
    open INF, "<$inf" or mydie( "ERROR: Unable to OPEN [$inf] ... $! ...\nCheck name, location ...\n" );
    my @lines = ();
    my $line = '';
    my $lncnt = 0;
    my $i = 0;
    my @discards = ();
    my @newlist = ();
    @lines = <INF>; # slurp it all in ...
    close INF;
    $lncnt = scalar @lines;
    prt( "Loaded $lncnt lines from [$inf] ...\n" );
    for ($i = 0; $i < $lncnt; $i++) {
        $line = trim_leading($lines[$i]);
        if ($line =~ /^Volume in drive/i) {
            push(@discards, $line);
        } elsif ($line =~ /^Volume Serial Number is/i) {
            push(@discards, $line);
        } elsif ($line =~ /\d+\s+File\(s\)\s+[\d,]+\s+bytes/i) {
            push(@discards, $line);
        } elsif ($line =~ /^Total Files Listed:/i) {
            push(@discards, $line);
        } elsif ($line =~ /\d+\s+Dir\(s\)\s+[\d,]+\s+bytes/i) {
            #	vi. 0 Dir(s)  176,651,669,504 bytes free
            push(@discards, $line);
        } else {
            push(@newlist, $line);
        }
    }
    prt( "Discard ". scalar @discards ." lines, leaving ". scalar @newlist ." lines for output ...\n" );
    return \@newlist;
}

#############################################
### MAIN ###

parse_args(@ARGV);
my $rl = process_file($act_in_file);
pgm_exit(0,"Normal exit\n");

#############################################

sub parse_args {
    my (@av) = @_;
    while (@av) {
        my $arg = $av[0];
        if ($arg =~ /^-/) {
            if ($arg eq '-ll') {
                $load_log = 1;
                prt( "Setting log load at end...\n" );
            } else {
                prt( "ERROR: Unnown arg [$arg]!\n" );
                pgm_exit(1,"Error exit\n");
            }

        } else {
            $act_in_file = $arg;
            prt("Set input file to [$act_in_file]...\n");
        }
        shift @av;
    }
    if ( !( -f $act_in_file ) ) {
        prt( "ERROR: Unable to find [$act_in_file] ... $! ...\nCheck name, location ...\n" );
        pgm_exit(1,"Error exit\n");
    }
}

# eof trimdf01.pl
