#!/usr/bin/perl -w
use strict;
use warnings;
# from : http://search.cpan.org/~jouke/Speech-Synthesis-0.03/lib/Speech/Synthesis.pm
# 16/07/2015 geoff mclane http://geoffair.net/mperl
use Speech::Synthesis;
my $engine = 'SAPI5'; # or 'SAPI4', 'MSAgent', 'MacSpeech' or 'Festival' 
my @voices = Speech::Synthesis->InstalledVoices(engine => $engine);
my @avatars = Speech::Synthesis->InstalledAvatars(engine => $engine);
my $cnt = scalar @voices;

sub prt($) { print shift }

prt("Using engine $engine, got $cnt voices...\n");
$cnt = 0;
foreach my $voice (@voices)
{
    $cnt++;
     my %params = (  engine   => $engine,
                     avatar   => undef,
                     language => $voice->{language},
                     voice    => $voice->{id},
                     async    => 0
                  );
     my $ss = Speech::Synthesis->new( %params );
     $ss->speak("Description of voice $cnt: ");
     $ss->speak($voice->{description}||"test");
}



