#!/Perl
# use module
use XML::Simple;
use Data::Dumper;
require "logfile.pl" or die "Missing logfile.pl ...\n"; # my simple log file
# log file stuff
my ($LF);
my $outfile = 'temp'.$0.'.txt';
open_log($outfile);

# create object
$xml = new XML::Simple (ForceArray => 1);
$xml2 = new XML::Simple;
my $fl1 = 'Files';
my $fl2 = 'File';
my $fl3 = 'RelativePath';
my $fl4 = 'Filter';
my $cnt = 0;

# create XML document
$raw = <<EOF;
<?xml version='1.0'?>
<employee>
	<name>John Doe</name>
	<age>43</age>
	<sex>M</sex>
	<department>Operations</department>
</employee>
EOF

$raw2 = <<EOF;
<?xml version='1.0'?>
<VisualStudioProject
	ProjectType="Visual C++"
	Version="8,00"
	Name="FlightGear"
	ProjectGUID="{0E698D36-EA1C-434F-A524-21A673C19F2E}"
	Keyword="Win32Proj"
	>
	<Platforms>
		<Platform
			Name="Win32"
		/>
	</Platforms>
	<ToolFiles>
	</ToolFiles>
	<Configurations>
		<Configuration
			Name="Debug|Win32"
			OutputDirectory="Debug"
			IntermediateDirectory="Debug"
			ConfigurationType="1"
			>
			<Tool
				Name="VCPreBuildEventTool"
			/>
			<Tool
				Name="VCCustomBuildTool"
			/>
			<Tool
				Name="VCXMLDataGeneratorTool"
			/>
			<Tool
				Name="VCWebServiceProxyGeneratorTool"
			/>
			<Tool
				Name="VCMIDLTool"
			/>
			<Tool
				Name="VCCLCompilerTool"
				Optimization="0"
				AdditionalIncludeDirectories="../../../;../../../Simgear;../../src;../../../AL/include;../../../zlib-1.2.3;../../../freeglut-2.4.0/include;../../../Pre-built.2/include;../../src/include;../../src/input;../../src/FDM/JSBSim"
				PreprocessorDefinitions="WIN32;_DEBUG;_WINDOWS;ENABLE_THREADS;HAVE_CONFIG_H;_CRT_SECURE_NO_DEPRECATE;_CONST_CORRECT_OVERLOADS;NOMINMAX;FREEGLUT_STATIC"
				MinimalRebuild="true"
				BasicRuntimeChecks="3"
				RuntimeLibrary="1"
				UsePrecompiledHeader="0"
				WarningLevel="3"
				Detect64BitPortabilityProblems="false"
				DebugInformationFormat="4"
			/>
			<Tool
				Name="VCManagedResourceCompilerTool"
			/>
			<Tool
				Name="VCResourceCompilerTool"
			/>
			<Tool
				Name="VCPreLinkEventTool"
			/>
			<Tool
				Name="VCLinkerTool"
				AdditionalDependencies="FlightgearLib.lib Simgear.lib fnt_d.lib js_d.lib net_d.lib psl_d.lib puAux_d.lib pui_d.lib pw_d.lib sg_d.lib sl_d.lib ssg_d.lib ssgAux_d.lib ul_d.lib pthreadvc2.lib Alut.lib openal32.lib zlibd.lib wsock32.lib advapi32.lib comdlg32.lib shell32.lib user32.lib"
				LinkIncremental="2"
				AdditionalLibraryDirectories="&quot;FG$(IntDir)&quot;;../../../plib/;&quot;../../../Simgear/Projects/VC8/$(IntDir)&quot;;&quot;../../../freeglut-2.4.0/$(IntDir)Static&quot;;&quot;../../../Pre-Built.2/lib&quot;;&quot;../../../zlib-1.2.3/projects/visualc6/win32_lib_asm_$(IntDir)&quot;;../../../al/lib"
				GenerateDebugInformation="true"
				SubSystem="2"
				TargetMachine="1"
			/>
			<Tool
				Name="VCALinkTool"
			/>
			<Tool
				Name="VCManifestTool"
			/>
			<Tool
				Name="VCXDCMakeTool"
			/>
			<Tool
				Name="VCBscMakeTool"
			/>
			<Tool
				Name="VCFxCopTool"
			/>
			<Tool
				Name="VCAppVerifierTool"
			/>
			<Tool
				Name="VCWebDeploymentTool"
			/>
			<Tool
				Name="VCPostBuildEventTool"
			/>
		</Configuration>
		<Configuration
			Name="Release|Win32"
			OutputDirectory="Release"
			IntermediateDirectory="Release"
			ConfigurationType="1"
			>
			<Tool
				Name="VCPreBuildEventTool"
			/>
			<Tool
				Name="VCCustomBuildTool"
			/>
			<Tool
				Name="VCXMLDataGeneratorTool"
			/>
			<Tool
				Name="VCWebServiceProxyGeneratorTool"
			/>
			<Tool
				Name="VCMIDLTool"
			/>
			<Tool
				Name="VCCLCompilerTool"
				AdditionalIncludeDirectories="../../../;../../../Simgear;../../src;../../../AL/include;../../../zlib-1.2.3;../../../freeglut-2.4.0/include;../../../Pre-built.2/include;../../src/include;../../src/input;../../src/FDM/JSBSim"
				PreprocessorDefinitions="WIN32;NDEBUG;_CONSOLE;ENABLE_THREADS;HAVE_CONFIG_H;_CRT_SECURE_NO_DEPRECATE;_CONST_CORRECT_OVERLOADS;_USE_MATH_DEFINES;NOMINMAX;FREEGLUT_STATIC"
				StringPooling="true"
				RuntimeLibrary="0"
				UsePrecompiledHeader="0"
				WarningLevel="3"
				Detect64BitPortabilityProblems="false"
				DebugInformationFormat="3"
			/>
			<Tool
				Name="VCManagedResourceCompilerTool"
			/>
			<Tool
				Name="VCResourceCompilerTool"
			/>
			<Tool
				Name="VCPreLinkEventTool"
			/>
			<Tool
				Name="VCLinkerTool"
				AdditionalDependencies="FlightgearLib.lib Simgear.lib fnt.lib js.lib net.lib psl.lib puAux.lib pui.lib pw.lib sg.lib sl.lib ssg.lib ssgAux.lib ul.lib pthreadvc2.lib Alut.lib openal32.lib zlib.lib wsock32.lib advapi32.lib comdlg32.lib shell32.lib user32.lib"
				LinkIncremental="2"
				AdditionalLibraryDirectories="&quot;FG$(IntDir)&quot;;../../../plib/;&quot;../../../Simgear/Projects/VC8/$(IntDir)&quot;;&quot;../../../freeglut-2.4.0/$(IntDir)Static&quot;;&quot;../../../Pre-Built.2/lib&quot;;&quot;../../../zlib-1.2.3/projects/visualc6/win32_lib_asm_$(IntDir)&quot;;../../../al/lib"
				GenerateDebugInformation="true"
				SubSystem="2"
				OptimizeReferences="2"
				EnableCOMDATFolding="2"
				TargetMachine="1"
			/>
			<Tool
				Name="VCALinkTool"
			/>
			<Tool
				Name="VCManifestTool"
			/>
			<Tool
				Name="VCXDCMakeTool"
			/>
			<Tool
				Name="VCBscMakeTool"
			/>
			<Tool
				Name="VCFxCopTool"
			/>
			<Tool
				Name="VCAppVerifierTool"
			/>
			<Tool
				Name="VCWebDeploymentTool"
			/>
			<Tool
				Name="VCPostBuildEventTool"
			/>
		</Configuration>
	</Configurations>
	<References>
	</References>
	<Files>
		<Filter
			Name="Header Files"
			Filter="h;hpp;hxx;hm;inl;inc;xsd"
			UniqueIdentifier="{93995380-89BD-4b04-88EB-625FBE52EBFB}"
			>
			<File
				RelativePath="..\\..\\src\\main\\fg_commands.hxx"
				>
			</File>
			<File
				RelativePath="..\\..\\src\\main\\fg_init.hxx"
				>
			</File>
			<File
				RelativePath="..\\..\\src\\main\\fg_io.hxx"
				>
			</File>
			<File
				RelativePath="..\\..\\src\\main\\fg_os.hxx"
				>
			</File>
			<File
				RelativePath="..\\..\\src\\main\\fg_props.hxx"
				>
			</File>
			<File
				RelativePath="..\\..\\src\\main\\globals.hxx"
				>
			</File>
			<File
				RelativePath="..\\..\\src\\main\\logger.hxx"
				>
			</File>
			<File
				RelativePath="..\\..\\src\\main\\main.hxx"
				>
			</File>
			<File
				RelativePath="..\\..\\src\\main\\options.hxx"
				>
			</File>
			<File
				RelativePath="..\\..\\src\\main\\renderer.hxx"
				>
			</File>
			<File
				RelativePath="..\\..\\src\\main\\splash.hxx"
				>
			</File>
			<File
				RelativePath="..\\..\\src\\main\\util.hxx"
				>
			</File>
			<File
				RelativePath="..\\..\\src\\main\\viewer.hxx"
				>
			</File>
			<File
				RelativePath="..\\..\\src\\main\\viewmgr.hxx"
				>
			</File>
		</Filter>
		<Filter
			Name="Resource Files"
			Filter="rc;ico;cur;bmp;dlg;rc2;rct;bin;rgs;gif;jpg;jpeg;jpe;resx"
			UniqueIdentifier="{67DA6AB6-F800-4c08-8B7A-83BB121AAD01}"
			>
		</Filter>
		<Filter
			Name="Source Files"
			Filter="cpp;c;cc;cxx;def;odl;idl;hpj;bat;asm;asmx"
			UniqueIdentifier="{4FC737F1-C7A5-4376-A066-2A32D752A2FF}"
			>
			<File
				RelativePath="..\\..\\src\\main\\bootstrap.cxx"
				>
			</File>
			<File
				RelativePath="..\\..\\src\\main\\fg_commands.cxx"
				>
			</File>
			<File
				RelativePath="..\\..\\src\\main\\fg_init.cxx"
				>
			</File>
			<File
				RelativePath="..\\..\\src\\main\\fg_io.cxx"
				>
			</File>
			<File
				RelativePath="..\\..\\src\\main\\fg_os.cxx"
				>
			</File>
			<File
				RelativePath="..\\..\\src\\main\\fg_props.cxx"
				>
			</File>
			<File
				RelativePath="..\\..\\src\\main\\globals.cxx"
				>
			</File>
			<File
				RelativePath="..\\..\\src\\main\\logger.cxx"
				>
			</File>
			<File
				RelativePath="..\\..\\src\\main\\main.cxx"
				>
			</File>
			<File
				RelativePath="..\\..\\src\\main\\options.cxx"
				>
			</File>
			<File
				RelativePath="..\\..\\src\\main\\renderer.cxx"
				>
			</File>
			<File
				RelativePath="..\\..\\src\\main\\splash.cxx"
				>
			</File>
			<File
				RelativePath="..\\..\\src\\main\\util.cxx"
				>
			</File>
			<File
				RelativePath="..\\..\\src\\main\\viewer.cxx"
				>
			</File>
			<File
				RelativePath="..\\..\\src\\main\\viewmgr.cxx"
				>
			</File>
		</Filter>
	</Files>
	<Globals>
	</Globals>
</VisualStudioProject>
EOF

$raw3 = <<EOF;
<?xml version="1.0" encoding="Windows-1252"?>
<VisualStudioProject
	ProjectType="Visual C++"
	Version="8,00"
	Name="FlightGear"
	ProjectGUID="{0E698D36-EA1C-434F-A524-21A673C19F2E}"
	Keyword="Win32Proj"
	>
	<Platforms>
		<Platform
			Name="Win32"
		/>
	</Platforms>
	<ToolFiles>
	</ToolFiles>
	<Configurations>
		<Configuration
			Name="Debug|Win32"
			OutputDirectory="Debug"
			IntermediateDirectory="Debug"
			ConfigurationType="1"
			>
			<Tool
				Name="VCPreBuildEventTool"
			/>
			<Tool
				Name="VCCustomBuildTool"
			/>
			<Tool
				Name="VCXMLDataGeneratorTool"
			/>
			<Tool
				Name="VCWebServiceProxyGeneratorTool"
			/>
			<Tool
				Name="VCMIDLTool"
			/>
			<Tool
				Name="VCCLCompilerTool"
				Optimization="0"
				AdditionalIncludeDirectories="../../../;../../../Simgear;../../src;../../../AL/include;../../../zlib-1.2.3;../../../freeglut-2.4.0/include;../../../Pre-built.2/include;../../src/include;../../src/input;../../src/FDM/JSBSim"
				PreprocessorDefinitions="WIN32;_DEBUG;_WINDOWS;ENABLE_THREADS;HAVE_CONFIG_H;_CRT_SECURE_NO_DEPRECATE;_CONST_CORRECT_OVERLOADS;NOMINMAX;FREEGLUT_STATIC"
				MinimalRebuild="true"
				BasicRuntimeChecks="3"
				RuntimeLibrary="1"
				UsePrecompiledHeader="0"
				WarningLevel="3"
				Detect64BitPortabilityProblems="false"
				DebugInformationFormat="4"
			/>
			<Tool
				Name="VCManagedResourceCompilerTool"
			/>
			<Tool
				Name="VCResourceCompilerTool"
			/>
			<Tool
				Name="VCPreLinkEventTool"
			/>
			<Tool
				Name="VCLinkerTool"
				AdditionalDependencies="FlightgearLib.lib Simgear.lib fnt_d.lib js_d.lib net_d.lib psl_d.lib puAux_d.lib pui_d.lib pw_d.lib sg_d.lib sl_d.lib ssg_d.lib ssgAux_d.lib ul_d.lib pthreadvc2.lib Alut.lib openal32.lib zlibd.lib wsock32.lib advapi32.lib comdlg32.lib shell32.lib user32.lib"
				LinkIncremental="2"
				AdditionalLibraryDirectories="&quot;FG$(IntDir)&quot;;../../../plib/;&quot;../../../Simgear/Projects/VC8/$(IntDir)&quot;;&quot;../../../freeglut-2.4.0/$(IntDir)Static&quot;;&quot;../../../Pre-Built.2/lib&quot;;&quot;../../../zlib-1.2.3/projects/visualc6/win32_lib_asm_$(IntDir)&quot;;../../../al/lib"
				GenerateDebugInformation="true"
				SubSystem="2"
				TargetMachine="1"
			/>
			<Tool
				Name="VCALinkTool"
			/>
			<Tool
				Name="VCManifestTool"
			/>
			<Tool
				Name="VCXDCMakeTool"
			/>
			<Tool
				Name="VCBscMakeTool"
			/>
			<Tool
				Name="VCFxCopTool"
			/>
			<Tool
				Name="VCAppVerifierTool"
			/>
			<Tool
				Name="VCWebDeploymentTool"
			/>
			<Tool
				Name="VCPostBuildEventTool"
			/>
		</Configuration>
		<Configuration
			Name="Release|Win32"
			OutputDirectory="Release"
			IntermediateDirectory="Release"
			ConfigurationType="1"
			>
			<Tool
				Name="VCPreBuildEventTool"
			/>
			<Tool
				Name="VCCustomBuildTool"
			/>
			<Tool
				Name="VCXMLDataGeneratorTool"
			/>
			<Tool
				Name="VCWebServiceProxyGeneratorTool"
			/>
			<Tool
				Name="VCMIDLTool"
			/>
			<Tool
				Name="VCCLCompilerTool"
				AdditionalIncludeDirectories="../../../;../../../Simgear;../../src;../../../AL/include;../../../zlib-1.2.3;../../../freeglut-2.4.0/include;../../../Pre-built.2/include;../../src/include;../../src/input;../../src/FDM/JSBSim"
				PreprocessorDefinitions="WIN32;NDEBUG;_CONSOLE;ENABLE_THREADS;HAVE_CONFIG_H;_CRT_SECURE_NO_DEPRECATE;_CONST_CORRECT_OVERLOADS;_USE_MATH_DEFINES;NOMINMAX;FREEGLUT_STATIC"
				StringPooling="true"
				RuntimeLibrary="0"
				UsePrecompiledHeader="0"
				WarningLevel="3"
				Detect64BitPortabilityProblems="false"
				DebugInformationFormat="3"
			/>
			<Tool
				Name="VCManagedResourceCompilerTool"
			/>
			<Tool
				Name="VCResourceCompilerTool"
			/>
			<Tool
				Name="VCPreLinkEventTool"
			/>
			<Tool
				Name="VCLinkerTool"
				AdditionalDependencies="FlightgearLib.lib Simgear.lib fnt.lib js.lib net.lib psl.lib puAux.lib pui.lib pw.lib sg.lib sl.lib ssg.lib ssgAux.lib ul.lib pthreadvc2.lib Alut.lib openal32.lib zlib.lib wsock32.lib advapi32.lib comdlg32.lib shell32.lib user32.lib"
				LinkIncremental="2"
				AdditionalLibraryDirectories="&quot;FG$(IntDir)&quot;;../../../plib/;&quot;../../../Simgear/Projects/VC8/$(IntDir)&quot;;&quot;../../../freeglut-2.4.0/$(IntDir)Static&quot;;&quot;../../../Pre-Built.2/lib&quot;;&quot;../../../zlib-1.2.3/projects/visualc6/win32_lib_asm_$(IntDir)&quot;;../../../al/lib"
				GenerateDebugInformation="true"
				SubSystem="2"
				OptimizeReferences="2"
				EnableCOMDATFolding="2"
				TargetMachine="1"
			/>
			<Tool
				Name="VCALinkTool"
			/>
			<Tool
				Name="VCManifestTool"
			/>
			<Tool
				Name="VCXDCMakeTool"
			/>
			<Tool
				Name="VCBscMakeTool"
			/>
			<Tool
				Name="VCFxCopTool"
			/>
			<Tool
				Name="VCAppVerifierTool"
			/>
			<Tool
				Name="VCWebDeploymentTool"
			/>
			<Tool
				Name="VCPostBuildEventTool"
			/>
		</Configuration>
	</Configurations>
	<References>
	</References>
	<Files>
		<Filter
			Name="Header Files"
			Filter="h;hpp;hxx;hm;inl;inc;xsd"
			UniqueIdentifier="{93995380-89BD-4b04-88EB-625FBE52EBFB}"
			>
			<File
				RelativePath="..\..\src\main\fg_commands.hxx"
				>
			</File>
			<File
				RelativePath="..\..\src\main\fg_init.hxx"
				>
			</File>
			<File
				RelativePath="..\..\src\main\fg_io.hxx"
				>
			</File>
			<File
				RelativePath="..\..\src\main\fg_os.hxx"
				>
			</File>
			<File
				RelativePath="..\..\src\main\fg_props.hxx"
				>
			</File>
			<File
				RelativePath="..\..\src\main\globals.hxx"
				>
			</File>
			<File
				RelativePath="..\..\src\main\logger.hxx"
				>
			</File>
			<File
				RelativePath="..\..\src\main\main.hxx"
				>
			</File>
			<File
				RelativePath="..\..\src\main\options.hxx"
				>
			</File>
			<File
				RelativePath="..\..\src\main\renderer.hxx"
				>
			</File>
			<File
				RelativePath="..\..\src\main\splash.hxx"
				>
			</File>
			<File
				RelativePath="..\..\src\main\util.hxx"
				>
			</File>
			<File
				RelativePath="..\..\src\main\viewer.hxx"
				>
			</File>
			<File
				RelativePath="..\..\src\main\viewmgr.hxx"
				>
			</File>
		</Filter>
		<Filter
			Name="Resource Files"
			Filter="rc;ico;cur;bmp;dlg;rc2;rct;bin;rgs;gif;jpg;jpeg;jpe;resx"
			UniqueIdentifier="{67DA6AB6-F800-4c08-8B7A-83BB121AAD01}"
			>
		</Filter>
		<Filter
			Name="Source Files"
			Filter="cpp;c;cc;cxx;def;odl;idl;hpj;bat;asm;asmx"
			UniqueIdentifier="{4FC737F1-C7A5-4376-A066-2A32D752A2FF}"
			>
			<File
				RelativePath="..\..\src\main\bootstrap.cxx"
				>
			</File>
			<File
				RelativePath="..\..\src\main\fg_commands.cxx"
				>
			</File>
			<File
				RelativePath="..\..\src\main\fg_init.cxx"
				>
			</File>
			<File
				RelativePath="..\..\src\main\fg_io.cxx"
				>
			</File>
			<File
				RelativePath="..\..\src\main\fg_os.cxx"
				>
			</File>
			<File
				RelativePath="..\..\src\main\fg_props.cxx"
				>
			</File>
			<File
				RelativePath="..\..\src\main\globals.cxx"
				>
			</File>
			<File
				RelativePath="..\..\src\main\logger.cxx"
				>
			</File>
			<File
				RelativePath="..\..\src\main\main.cxx"
				>
			</File>
			<File
				RelativePath="..\..\src\main\options.cxx"
				>
			</File>
			<File
				RelativePath="..\..\src\main\renderer.cxx"
				>
			</File>
			<File
				RelativePath="..\..\src\main\splash.cxx"
				>
			</File>
			<File
				RelativePath="..\..\src\main\util.cxx"
				>
			</File>
			<File
				RelativePath="..\..\src\main\viewer.cxx"
				>
			</File>
			<File
				RelativePath="..\..\src\main\viewmgr.cxx"
				>
			</File>
		</Filter>
	</Files>
	<Globals>
	</Globals>
</VisualStudioProject>
EOF

# read XML file
$data = $xml->XMLin($raw);
$data2 = $xml2->XMLin($raw);
# access XML data
prt( "\nOutput using (ForceArray => 1) ...\n" );
prt( Dumper($data) );
prt( "\nOutput NOT using (ForceArray => 1) ...\n" );
prt( Dumper($data2) );

$data3 = $xml->XMLin($raw2);
$data4 = $xml2->XMLin($raw2);
prt( "\nOutput using (ForceArray => 1) ...\n" );
prt( Dumper($data3) );
prt( "\nOutput NOT using (ForceArray => 1) ...\n" );
prt( Dumper($data4) );

$files1 = $data3->{$fl1};
$files2 = $data4->{$fl1};
prt( "\nOutput using (ForceArray => 1) ... using {$fl1}\n" );
prt( Dumper($files1) );
prt( "\nOutput NOT using (ForceArray => 1) ... using {$fl1}\n" );
prt( Dumper($files2) );

$files3 = $data3->{$fl1}->{$fl4};
$files4 = $data4->{$fl1}->{$fl4};
prt( "\nOutput using (ForceArray => 1) ... \$data3->{$fl1}->{$fl4}\n" );
prt( Dumper($files3) );
prt( "\nOutput NOT using (ForceArray => 1) ... \$data4->{$fl1}->{$fl4}\n" );
prt( Dumper($files4) );

#$files5 = $data3->{$fl1}->{$fl4}->{$fl2};
#$files6 = $data4->{$fl1}->{$fl4}->{$fl2};
#prt( "\nOutput using (ForceArray => 1) ... using {$fl1}->{$fl4}->{$fl2}\n" );
#prt( Dumper($files5) );
#prt( "\nOutput NOT using (ForceArray => 1) ... using {$fl1}->{$fl4}->{$fl2}\n" );
#prt( Dumper($files6) );

$cnt = 0;
#foreach my $lst (values %{$files4})
#{
#	$cnt++;
#}
#prt( "Got $cnt 'values' ...\n" );
$cnt = 0;
foreach my $lst (keys %{$files4})
{
	$cnt++;
	prt( "$cnt $lst\n" );
	#my $itm = ${%{$files4}}->{$lst};
	prt( "[".$files4{$lst}."]\n");
}
prt( "Got $cnt 'keys' ...\n" );

$raw3 = <<EOF;
<?xml version='1.0'?>
<mldata type="internal">
  <title>Mailing Lists Data</title>
  <list name="tech"><title>Technical</title>
    <member id="jdeere" admin="1"/>
    <member id="jsmith"/>
    <member id="jbrown"/>
  </list>
  <list name="biz"><title>Business and Managers</title>
    <member id="sadams" admin="1"/>
    <member id="jsmith"/>
    <member id="jdeere"/>
  </list>
  <user id="jdeere"><fullname>John Deere</fullname><email>jdeere@isp.com</email></user>
  <user id="jsmith"><fullname>John Smith</fullname><email>jsmith@isp.com</email></user>
  <user id="jbrown"><fullname>John Brown</fullname><email>jbrown678@aol.com</email></user>
  <user id="sadams"><fullname>Sam Adams</fullname><email>sam.ad@msn.com</email></user>
</mldata>
EOF

# load the lists document
#my $mldata = XMLin($raw3);
my $mldata = $xml2->XMLin($raw3);

prt( Dumper($mldata) );
#$VAR1 = {
#          'user' => {
#                      'sadams' => {
#                                    'email' => 'sam.ad.com',
#                                    'fullname' => 'Sam Adams'
#                                  },
#                      'jbrown' => {
#                                    'email' => 'jbrown678.com',
#                                    'fullname' => 'John Brown'
#                                  },
#                      'jdeere' => {
#                                    'email' => 'jdeere.com',
#                                    'fullname' => 'John Deere'
#                                  },
#                      'jsmith' => {
#                                    'email' => 'jsmith.com',
#                                    'fullname' => 'John Smith'
#                                  }
#                    },
#          'title' => 'Mailing Lists Data',
#          'type' => 'internal',
#          'list' => {
#                      'tech' => {
#                                  'member' => {
#                                                'jbrown' => {},
#                                                'jdeere' => {
#                                                              'admin' => '1'
#                                                            },
#                                                'jsmith' => {}
#                                              },
#                                  'title' => 'Technical'
#                                },
#                      'biz' => {
#                                 'member' => {
#                                               'sadams' => {
#                                                             'admin' => '1'
#                                                           },
#                                               'jdeere' => {},
#                                               'jsmith' => {}
#                                             },
#                                 'title' => 'Business and Managers'
#                               }
#                    }
#        };

# title and type are just fields of mldata
prt( "Title (Type) = $mldata->{title} ($mldata->{type})\n" );

# list and user info are references to the list and user information
prt( "Getting my \$lists=\$mldata->{list};\n" );
my $lists=$mldata->{list};
prt( "and my my \$users=\$mldata->{user};\n" );
my $users=$mldata->{user};

# each value of %$lists is a reference to the list data
foreach my $list (values %$lists)
{ # the list title is a field of $list
    prt( "list title is a field of \$list: $list->{title} List:\n" );
    # members is a hash containing members id
    my $members= $list->{member};

    foreach my $id (keys %$members)
    { # print a leading star for admins
        if( exists $members->{$id}->{admin})
          { prt( "* " ); }
        else
          { prt( "  " ); }
   
        prt( " id = [$id] = " );
        # print user info from the users data
        prt( "$users->{$id}->{fullname} $users->{$id}->{email}\n" );
    }
}

$raw4 = <<EOF;
<?xml version="1.0"?>
<camelids>
  <species name="Camelus dromedarius">
    <common-name>Dromedary, or Arabian Camel</common-name>
    <physical-characteristics>
      <mass>300 to 690 kg.</mass>
      <appearance>
        The dromedary camel is characterized by a long-curved 
        neck, deep-narrow chest, and a single hump.
        ...
      </appearance>
    </physical-characteristics>
    <natural-history>
       <food-habits>
         The dromedary camel is an herbivore.
         ...
       </food-habits>
       <reproduction>
         The dromedary camel has a lifespan of about 40-50 years
         ...
       </reproduction>
       <behavior>
         With the exception of rutting males, dromedaries show
         very little aggressive behavior.
         ...
       </behavior>
       <habitat>
         The camels prefer desert conditions characterized by a
         long dry season and a short rainy season.
         ...
       </habitat>
    </natural-history>
    <conservation status="no special status">
      <detail>
        Since the dromedary camel is domesticated, the camel has
        no special status in conservation.
      </detail>
    </conservation>
  </species>
</camelids>
EOF

my $doc = $xml2->XMLin($raw4);
prt( Dumper($doc) );
$cnt = 0;
foreach my $key (keys (%{$doc->{species}})){
	$cnt++;
	prt( "$cnt common name [" );
   prt( $doc->{species}->{$key}->{'common-name'} . '] key (' . $key . ') ' );
   #prt( $doc->{species}->{$key}->{conservation}->final . "\n" );
   prt( "\n" );
}

close_log($outfile,1);
