#!/usr/bin/perl
# NAME: xmlsax.pl
# AIM: Diagnose an error output
# "could not find ParserDetails.ini in C:/Perl/site/lib/XML/SAX"
# 28/02/2014 - from : http://johnbokma.com/perl/installing-xml-sax.html
# suggested running
# perl -MXML::SAX -e "XML::SAX->add_parser('XML::SAX::PurePerl')->save_parsers()"
# that created the ParserDetails.ini
# And the same site gave this program to enumerate the parser
use strict;
use warnings;
use XML::SAX;

for my $parser ( @{ XML::SAX->parsers } ) {

    print "$parser->{ Name }\n";

    my %features = %{ $parser->{ Features } };
    print "    $_ => $features{ $_ }\n"
        for sort keys %features;

    print "\n";
}

# from : http://www.perlmonks.org/?node_id=347307
# suggested ini contents
#[XML::SAX::PurePerl]
#http://xml.org/sax/features/namespaces = 1
#
#[XML::LibXML::SAX::Parser]
#http://xml.org/sax/features/namespaces = 1
#
#[XML::LibXML::SAX]
#http://xml.org/sax/features/namespaces = 1


# PROBLEM SOLVED


# eof
