#!/usr/bin/perl -w
# NAME: confscan.pl
# AIM: Scan of a GNU configure file
use strict;
use warnings;
use File::Basename;  # split path ($name,$dir,$ext) = fileparse($file [, qr/\.[^.]*/] )
use Cwd;
my $perl_dir = 'C:\GTools\perl';
unshift(@INC, $perl_dir);
require 'lib_confscan.pl' or die "Unable to load 'lib_confscan.pl'! Check \@INC content.\n";
require 'lib_utils.pl' or die "Unable to load 'lib_utils.pl'! Check \@INC content.\n";
# log file stuff
my ($LF);
my $pgmname = $0;
if ($pgmname =~ /(\\|\/)/) {
    my @tmpsp = split(/(\\|\/)/,$pgmname);
    $pgmname = $tmpsp[-1];
}
my $outfile = $perl_dir."\\temp.$pgmname.txt";
open_log($outfile);

# user variables
my $load_log = 0;
my $in_file = '';

### program variables
my @warnings = ();
my $cwd = cwd();
my $os = $^O;

### debug
my $debug_on = 0; # allow to run without a command
my $def_file = 'C:\Projects\libsigc\libsigc++-2.2.8\configure';
our $dbg_cs01 = 0; # show if, fi
our $dbg_cs02 = 0; # show else, elif
our $dbg_cs03 = 0; # show EVERY LINE
our $dbg_cs04 = 0; # show enter and exit case
our $dbg_cs05 = 0; # show macro accumulated
our $dbg_cs06 = 0; # show macro after sustitution, if change
our $dbg_cs07 = 0; # show macro split
our $dbg_cs08 = 0; # show line NOT USED
our $dbg_cs09 = 0; # show substitutions NOT found
our $dbg_cs10 = 0; # out a warning if out-of-order else or fi found

sub show_warnings($) {
    my $val = shift;
    if (@warnings) {
        my ($cnt,$itm);
        $cnt = scalar @warnings;
        prt( "\nGot $cnt WARNINGS...\n" );
        $cnt = 0;
        foreach $itm (@warnings) {
            $cnt++;
            prt("$cnt: $itm\n");
        }
        prt("\n");
    } else {
        prt( "\nNo warnings issued.\n\n" );
    }
}

sub pgm_exit($$) {
    my ($val,$msg) = @_;
    show_warnings($val);
    if (length($msg)) {
        $msg .= "\n" if (!($msg =~ /\n$/));
        prt($msg)
    }
    close_log($outfile,$load_log);
    exit($val);
}


sub prtw($) {
   my ($tx) = shift;
   $tx =~ s/\n$//;
   prt("$tx\n");
   push(@warnings,$tx);
}


sub get_params($) {
    my $inf = shift;
    my %subs_not_found = ();
    my %params = ();
    my $rparams = \%params;
    ${$rparams}{'CURR_IN_FILE'} = $inf;
    my $rsnf = \%subs_not_found;
    ${$rparams}{'CURR_SUBS_NOT_FOUND'} = $rsnf;
    return $rparams;
}

#########################################
### MAIN ###
parse_args(@ARGV);

my $rph = get_params($in_file);

process_in_file($rph);

show_macs($rph);

pgm_exit(0,"Normal exit(0)");
########################################
sub give_help {
    prt("$pgmname: version 0.0.1 2010-09-08\n");
    prt("Usage: $pgmname [options] in-file\n");
    prt("Options:\n");
    prt(" --help (-h or -?) = This help, and exit 0.\n");
}
sub need_arg {
    my ($arg,@av) = @_;
    pgm_exit(1,"ERROR: [$arg] must have following argument!\n") if (!@av);
}
sub parse_args {
    my (@av) = @_;
    while (@av) {
        my $arg = $av[0];
        if ($arg =~ /^-/) {
            my $sarg = substr($arg,1);
            $sarg = substr($sarg,1) while ($sarg =~ /^-/);
            if (($sarg =~ /^h/i)||($sarg eq '?')) {
                give_help();
                pgm_exit(0,"Help exit(0)");
            } else {
                pgm_exit(1,"ERROR: Invalid argument [$arg]! Try -?\n");
            }
        } else {
            $in_file = $arg;
            prt("Set input to [$in_file]\n");
        }
        shift @av;
    }
    if ((length($in_file) ==  0) && $debug_on) {
        $in_file = $def_file;
    }
    if (length($in_file) ==  0) {
        pgm_exit(1,"ERROR: No input files found in command!\n");
    }
    if (! -f $in_file) {
        pgm_exit(1,"ERROR: Unable to find file [$in_file]!\n");
    }

}

# eof - template.pl
