
// am2dsp.cxx

#include "am2dsp.hxx" // single include ...

string_list g_split_space( string & str );
//typedef struct tagAMLIB { ...
//}AMLIB, * PAMLIB;
static AMLIB sAM; // static, for building input

string base_path = "";

// for each of these, after the load ... full of info
string_list am_makefiles; // list of makefile.am's found
vAMLIBS  vam; // full final list of AM items

string proj_name; // this the the NAME of the 'solution', and 'project' ...
int g_overwrite = 0; // set ***OVERWRITE*** flag

size_t am_count = 0;
string_list direct_list;
string_list direct_list2;
size_t dirs_done = 0;
static char _s_buf[4096];

string src_path = "";
char * dot = ".";
char * ddot = "..";

char szopt1[] = "--src-path=";
char szopt2[] = "--out-file=";
char szopt3[] = "--proj-name="; // like MSVC7 'solution' name, can have many 'projects'
char szopt4[] = "--force"; // *** OVERWRITE *** output file, without asking!
char * opts[] = {
   szopt1,
   szopt2,
   szopt3,
   szopt4,
      0
};

size_t cfg_ln_cnt = 0; // = g_load_cfg_data( in.c_str(), cfg_list );
string_list cfg_list; // loaded from config file
string out_path = "";

void show_help( void ) {

   G_LOG( "--src-path=inpath Set the input source path ..." );
}

int parse_arg( char * arg )
{
   string s = arg;
   if( s.find( szopt1 ) == 0 ) {
      src_path = arg + strlen(szopt1);
      if( !src_path.size() )
         src_path = ".";
   } else if( s.find( szopt2 ) == 0 ) {
      out_path = arg + strlen(szopt2);
   } else if( s.find( szopt3 ) == 0 ) {
      proj_name = arg + strlen(szopt3);
   } else if( s.find( szopt4 ) == 0 ) {
      g_overwrite = 1; // set ***OVERWRITE*** flag
   } else {
      return 1;
   }


   return 0; // = success
}

int tot_makes = 0;
int tot_dirs = 0;
int tot_files = 0;

void clear_vam( PAMLIB pv )
{
   pv->lib_order = 0;
   pv->lib_done = 0;
   pv->lib_amin = ""; // set the AM name
   pv->lib_folder = ""; // set the path
   pv->lib_list.clear(); // remove SOURCES
   pv->lib_headers.clear(); // remove HEADERS
   pv->lib_subs.clear(); // remove any SUBDIRS
   pv->lib_lines.clear(); // remove LINES, from file load
   pv->lib_includedir.clear();
   pv->lib_pgm_list.clear();
   pv->lib_ulib = ""; // no 'unix' name yet, like libAbc.a
   pv->lib_short = ""; // just the libAbc
   pv->lib_short2 = ""; // just Abc
   pv->lib_src = "";
}

int process_a_directory( string dpath, ulDir * dir )
{
   ulDirEnt * entry = 0;
   int makes = 0;
   int dirs = 0;
   int files = 0;

   do {
      entry = ulReadDir(dir);
      if(entry) {
         char * fp = entry->d_name;
         if( strcmp(fp,dot) && strcmp(fp,ddot) ) {
            string in = dpath;
            in += "/";
            in += fp;
            if( entry->d_isdir ) {
                // not dot or cousin double dot, ever present ...
                direct_list.push_back(in); // keep the directories, for processing
                direct_list2.push_back(fp); // and short form
                dirs++;

            } else if( strcmpi( fp, "makefile.am" ) == 0 ) {

               if( am_makefiles.size() == 0 ) {
                  // *** IS FIRST MAKEFILE.AM ***
                  base_path = dpath; // establish the base path,
                  // so we can determine RELATIVE paths for the source
               }
               am_makefiles.push_back(in);
               am_count++;
               clear_vam( &sAM );
               sAM.lib_order = am_count;
               sAM.lib_amin = in; // set the AM name
               sAM.lib_folder = dpath; // set the path
               vam.push_back(sAM); // add to MAKEFILE.AM vector list
               makes++;

            } else {
               //struct stat filestat;
               //if ( stat(in.c_str(), &filestat) == 0 ) {
               if( strcmpi( fp, "am2dsp.cfg" ) == 0 ) {
                  cfg_ln_cnt = g_load_cfg_data( in.c_str(), &cfg_list );
               }

               files++;
            }
         }
      }
   } while ( entry != NULL );

   tot_dirs += dirs;
   tot_files += files;
   tot_makes += makes;

   if(makes) {
      G_LOG( "Found " << files << " files, " << dirs << " dirs, " <<
         makes << " makes, on " << dpath << ", total " << vam.size() );
   }
   return makes;
}

// int process_subdirs( string s, string_list & fl, size_t am_lev )
int process_subdirs( string s, size_t am_lev )
{
//   size_t bgn = fl.size();
   size_t bgn = vam[am_lev].lib_subs.size(); // get any previous FOLDERS given in AM file
   char * pbuf = _s_buf;
   strcpy(pbuf, s.c_str());
   char * cp = pbuf;
   cp += 7;
   while(*cp && (*cp <= ' ')) cp++;
   if(*cp == '=') {
      cp++;
      while(*cp) {
         while(*cp && (*cp <= ' ')) cp++;
         char * cpb = cp;
         char chr;
         while(*cp && (*cp > ' ')) cp++;
         chr = *cp;
         *cp = 0;
         string s2 = cpb;
         //fl.push_back(s2);
         vam[am_lev].lib_subs.push_back(s2); // store FOLDERS given in AM file
         if(chr) {
            cp++;
         }
      }
   }
//   return( fl.size() - bgn );
   return( vam[am_lev].lib_subs.size() - bgn );
}

string process_library( string s, int am_level )
{
   string s2 = "";
   char * pbuf = _s_buf;
   strcpy(pbuf, s.c_str());
   char * cp = pbuf;
   while(*cp && (*cp > ' ')) cp++; // eat 'libnm_SOURCES
   while(*cp && (*cp <= ' ')) cp++; // eat space
   if(*cp == '=') { // got to EQUAL sign
      cp++; // bump past
      if(*cp) { // and still data
         while(*cp && (*cp <= ' ')) cp++; // eat space
         char * cpb = cp; // set start of filename
         char chr;
         while(*cp && (*cp > ' ')) cp++;
         chr = *cp;
         *cp = 0;
         vam[am_level].lib_ulib = cpb; // keep 'unix' name, like libAbc.a
         char * p = strrchr(cpb,'.');
         if(p) {
            *p = 0;
            s2 = cpb; // get this 'lib???????' entry
            if( s2.find("lib") == 0 ) {
               s2.erase(0,3);
            }
            vam[am_level].lib_short = cpb; // keep short, like libAbc
            vam[am_level].lib_short2 = s2; // even shorter, like Abc
            *p = '_'; // change '.' to '_' for search
         }
         s2 = cpb;
         s2 += "_SOURCES";
         vam[am_level].lib_src = s2; // keep the 'search-for' library line
      }
   }
   return s2;
}

// int process_sources( string s, string_list & fl, int am_level)
int process_sources( string s, int am_level)
{
   string s2;
   size_t bgn = vam[am_level].lib_list.size(); // store 'source' file
   char * pbuf = _s_buf;
   strcpy(pbuf, s.c_str()); // get the file line string, to alter it ... split it ...
   char * cp = pbuf; // get a 'moving' pointer
   while(*cp && (*cp > ' ')) cp++; // get to end 'parameter', to ' =...'
   while(*cp && (*cp <= ' ')) cp++; // get over the space
   if(*cp == '=') { // did we reach an EQUAL
      cp++;
      while(*cp) {
         while(*cp && (*cp <= ' ')) cp++; // move to first 'sig' char
         char * cpb = cp; // keep this as 'beginning' ...
         char chr; // keep what we 'blot' out ...
         while(*cp && (*cp > ' ')) cp++; // move to end of first 'text'
         chr = *cp; // keep the end
         *cp = 0; // remove SPACE, set ZERO
         { // filter one - divert all HEADER files, to the HEADER list
            char * p = strrchr(cpb,'.');
            if(( p ) && ( p > cpb )) {
               p++;
               if( toupper(*p) == 'H' ) {
                  s2 = cpb;
                  vam[am_level].lib_headers.push_back(s2); // store 'header' file
                  *cpb = 0;
               }
            }
         }
         { // filter two
            // not really a filter - if we have this 'variable'
            // expand it
            if( *cpb == '$' ) {
               *cpb = 0; // ***TBD*** remove for now
            }
         }

         if( *cpb ) {
            s2 = cpb;
            vam[am_level].lib_list.push_back(s2); // store 'source' file
         }
         if(chr) { // if not reached ZERO
            cp++; // BUMP TO NEXT
         }
      } // loop while there are chars
   } // found an EQUAL size, after first 'token' ...

   return( vam[am_level].lib_list.size() - bgn );
}

int process_headers( string s, int am_level)
{
   int iret = 0;
   string s2;
   char * pbuf = _s_buf;
   strcpy(pbuf, s.c_str());
   char * cp = pbuf;
   while(*cp && (*cp > ' ')) cp++;
   while(*cp && (*cp <= ' ')) cp++;
   if(*cp == '=') {
      cp++;
      while(*cp) {
         while(*cp && (*cp <= ' ')) cp++;
         char * cpb = cp;
         char chr;
         while(*cp && (*cp > ' ')) cp++;
         chr = *cp;
         *cp = 0;
         { // filter like
            // not really a filter - if we have this 'variable'
            // expand it
            if( *cpb == '$' ) {
               *cpb = 0; // ***TBD*** remove for now
            }
         }

         if( *cpb ) {
            s2 = cpb;
            // fl.push_back(s2);
            vam[am_level].lib_headers.push_back(s2); // store 'header' file
            iret++;
         }
         if(chr) {
            cp++;
         }
      }
   }
   return iret;
}

static char * grm_loadfile(const char * pf, size_t * len, int am_lev )
{
   struct stat data;

   // cout << "Loading " << pf << " ..." << endl;
   G_LOG("");
   G_LOG( "Loading: " << (am_lev + 1) << " [" << pf << "] ..." );

   if(stat(pf, &data) != 0) {
      //cout << "Warning: File " << pf << " does not exist!" << endl;
      G_LOG( "Warning: File " << pf << " does not exist!" );
      return 0;
   }
   size_t imax = data.st_size;
   if( !imax ) {
      // cout << "Warning: File " << pf << " is null bytes!" << endl;
      G_LOG( "Warning: File " << pf << " is null bytes!" );
      return 0;
   }

   FILE * f = fopen(pf, "rb");
   if(!f) {
       G_LOG( "Warning: Can not open file " << pf << "!" );
       return 0;
   }

   char * pbuf = new char[imax+1];
   if( !pbuf ) {
      G_LOG( "Warning: Can not get memory for file " << pf << " size " << imax+1 << "!" );
      fclose(f);
   }

   *len = fread(pbuf, 1, imax, f);
   fclose(f);

   if(*len != imax) {
        // Shouldn't happen ...
        delete[] pbuf;
        G_LOG( "Warning: Can not load file " << pf << "!" );
        return 0;
   }


   pbuf[imax] = 0; // ensure zero terminated
   // G_LOG( "Read in " << imax << " bytes, into a buffer ..." );
   // G_LOG( "[" << pbuf << "]" );
   return pbuf;
}

void trim_in_buf( char * pb )
{
   size_t ilen = strlen(pb);
   size_t i, j, k;
   int c;
   i = j = k = 0;
   for( ; i < ilen; i++)
   {
      c = pb[i];
      if(c > ' ') { // sig char
         pb[k++] = (char)c; // add it
         j = 0; // allow another space
      } else {
         if(!j) { // if not put space
            pb[k++] = ' '; // add ONE(1) space ONLY
            j = ' '; // avoid more
         }
      }
   }
   pb[k] = 0; // zero terminate, potentaill shorter line
}


// size_t grm_load_lines( char * cp, size_t ilen, string_list * pv, size_t am_lev )
size_t grm_load_lines( char * cp, size_t ilen, size_t am_lev )
{
   size_t cnt = 0;
   size_t bgn_j = 0;
   size_t jsz;
   if(cp) {
      // G_LOG( "Loading file lines ... from " << ilen << " bytes ..." );
      int d = 0;
      int d2 = 0;
      int c2 = 0;
      size_t d2_pos;
      char * pbgn;
      //size_t k;
      bgn_j = 0;
      for(jsz = 0; jsz < ilen; jsz++) {
         int c = cp[jsz];
         if( c == '\t' ) {
            c = ' ';
            cp[jsz] = (char)c;
         } else if(( c == '\n' )||( c == '\r' )) {
            if( d >= ' ' ) {
               // at the end-of-line, or is it a 'continuation
               if( d2 == '\\') {
                  c2 = ' ';
                  cp[jsz] = (char)c2;
                  cp[d2_pos] = (char)c2;
               } else {
                  c2 = 0;
                  cp[jsz] = (char)c2;
                  char * cpb = &cp[bgn_j];
                  while( *cpb && ( *cpb <= ' ' ) ) cpb++;
                  if( *cpb && ( *cpb != '#' ) ) {
                     // not a comment line
                     trim_in_buf(cpb);
                     string s = cpb;
                     if(s.size()) {
                        //file_lines.push_back(s);
                        //pv->push_back(s);
                        vam[am_lev].lib_lines.push_back(s); // keep the file lines
                        cnt++;
                        G_LOG( "Line " << cnt << " [" << s << "]" );
                     }
                  }
               }
            } else {
               cp[jsz] = (char)c2;
            }
            if( c2 == 0 ) {
               bgn_j = jsz + 1;
               pbgn = &cp[bgn_j];
               if(*pbgn == 'S')
                  c2 = 0;
            }
         }
         d = c;
         if(c > ' ') {
            d2_pos = jsz;
            d2 = c; // keep last sig char
         }
      }

      delete[] cp;
   }
   return cnt;
}

string_list prg_list; // review these later
int load_make_files( size_t ibgn, size_t iend )
{
#define prg_list vam[cnt].lib_pgm_list
   //string_list fl;
   string_list sn;
   string lib_name = "";
   size_t imax = am_makefiles.size();
   if(iend && (iend < imax))
      imax = iend;
   // process makes ...
   for( size_t cnt = ibgn; cnt < imax; cnt++ ) {
//      string_list sl;
      size_t ilen2;
      string fs = am_makefiles[cnt];
      char * cp = grm_loadfile(fs.c_str(), &ilen2, cnt);
//      size_t ln_cnt = grm_load_lines( cp, ilen2, &sl, cnt );
      size_t ln_cnt = grm_load_lines( cp, ilen2, cnt );
      G_LOG( "Found " << ln_cnt << " lines in file ..." );
      sn.clear(); // remove old SOURCES
      //fl.clear();
      lib_name = "";
      for( size_t k = 0; k < ln_cnt; k++ ) {
         string s = vam[cnt].lib_lines[k]; // get the file line
//         string s = sl[k];
         size_t pos = s.find("="); // get the EQUAL sign position, if there is one
         //G_LOG( s );
         if( pos == -1 ) { // line WITHOUT an EQUAL sign
            // if with ':' then actions follow - should eat lines to next = or :
            // can be 'if', 'else' or 'endif
            G_LOG( "Line not processed [" << s << "], but kept ...");
            // vam[am_lev].lib_lines.push_back(s); // keep the file lines
         } else {
            if( s.find("SUBDIRS") == 0 ) {
               G_LOG( s );
               process_subdirs( s, cnt );
            } else if( s.find("includedir") == 0 ) {
               vam[cnt].lib_includedir.push_back( s.substr(pos+1) );
            } else if( s.find("lib_LIBRARIES") == 0 ) {
               lib_name = process_library( s, cnt );
            } else if( s.find("noinst_LIBRARIES") == 0 ) {
               lib_name = process_library( s, cnt );
            } else if( s.find("include_HEADERS") == 0 ) {
               process_headers( s, cnt );
            } else if( s.find("noinst_PROGRAMS") == 0 ) {
               prg_list = g_split_space( s.substr(pos+1) );
            } else {
               if( lib_name.size() && ( s.find(lib_name) == 0 ) ) {
                  //process_sources( s, sn, cnt );
                  process_sources( s, cnt );
               }
            }
         }
      }

      if( lib_name.size() ) {
         ostringstream str;
         G_LOG( "" );
         str << "Got lib " << lib_name << " ... ";
         // if( sn.size() ) {
            if( vam[cnt].lib_list.size() ) {
            str << " with sources ...";
         } else {
            str << " ** NO SOURCE ** ...";
         }
         G_LOG( str.str() );
         // if( sn.size() ) {
         if( vam[cnt].lib_list.size() ) {
            size_t imx = vam[cnt].lib_list.size(); // sn.size();
            size_t jj;
            string scs = "";
            for( jj = 0; jj < imx; jj++ ) {
               //scs += sn[jj];
               scs += vam[cnt].lib_list[jj];
               scs += " ";
            }
            G_LOG( "Sources [" << scs << "] cnt = " << imx );
            // now the HEADERS
            imx = vam[cnt].lib_headers.size();
            if( imx ) {
               scs = "";
               for( jj = 0; jj < imx; jj++ ) {
                  scs += vam[cnt].lib_headers[jj];
                  scs += " ";
               }
               G_LOG( "Headers [" << scs << "] cnt = " << imx );
            }
         }
      }
   }
   return 0;
}


int check_this_code()
{
   size_t cnt;
   ulDir * dir1;
   // ***ONLY*** process SUBDIRS, given in make file
   PAMLIB pl = &vam[0]; // first AM file
   size_t imax = pl->lib_subs.size();
   size_t imx2 = direct_list.size(); // get present MAX - processing will add more
   for( cnt = 0; cnt < imax; cnt++ ) {
      pl = &vam[0]; // first AM
      string s = pl->lib_subs[cnt];
      for( size_t cn2 = 0; cn2 < imx2; cn2++ ) {
         string np = direct_list2[cn2];
         if(( s == np ) || (strcmpi(s.c_str(),np.c_str()) == 0)) {
            // got our folder
            string new_path = direct_list[cn2];
            dir1 = ulOpenDir( new_path.c_str() ); // open the SOURCE
            if( dir1 == NULL ) {
               G_LOG( "ERROR: Not valid directory! [" << new_path << "] Check!" );
               return -1;
            }
            //G_LOG( "Processing " << new_path << " ..." );
            process_a_directory( new_path, dir1 );
            ulCloseDir( dir1 );
            dir1 = 0;
            break;

         }
      }
   }
   return 0;
}

int wait_4_key( int key )
{
   char ch;
   cin >> ch;
   if(( ch == tolower(key) ) || ( ch == toupper(key) ) ) {
         return 1;
   }

   return 0;

}


int main( int argc, char * * argv )
{
   char * pbuf = _s_buf; // general character buffer
   int i, c, doh;
   char * cp; // = argv[i];
   G_LOG( "Running " << argv[0] << " ..." );
   doh = 0;
   for( i = 1; i < argc; i++ ) {
      cp = argv[i];
Chk_Char:
      c = toupper(*cp);
      if(c == '?') doh = 1;
      if(c == 'H') doh = 1;
      if((c == '-')||(c == '/')) {
         cp++;
         goto Chk_Char;
      }
      if(doh) {
         show_help();
         return 0;
      }
   }

   for( i = 1; i < argc; i++ ) {
      cp = argv[i];
      if( parse_arg( cp ) ) {
         G_LOG( "Bad Argument [" << cp << " - correct and rerun ..." );
         return -1;
      }
   }

   if( !src_path.size() ) {
      src_path = "."; // set it to local
      G_LOG( "No --src-path=source option found, using '.', ie local folder ..." );
   }

   ulDir * dir1 = ulOpenDir( src_path.c_str() ); // open the SOURCE
   if( dir1 == NULL ) {
      G_LOG( "ERROR: Not valid directory! [" << src_path << "] Check!" );
      return -1;
   }

   am_makefiles.clear();   // clear the vector
   direct_list.clear();
   direct_list2.clear();

   G_LOG( "Processing " << src_path << " ..." );
   process_a_directory( src_path, dir1 ); // this first directory processing
   // *MUST* produce an makefile.am, WITH a 'SUBDIRS =' entry ...
   dirs_done = 0;
   ulCloseDir( dir1 );
   dir1 = 0;
   size_t cnt;

   if( !am_makefiles.size() ) {
      G_LOG( "ERROR: No makefile.am found at [" << src_path << "]! Check and re-run ..." );
      return -1;
   }

   if( !proj_name.size() ) { // this the the NAME of the 'solution', and 'project' ...
#ifdef SET_TEMP_TEST_DSP // for diag only
      proj_name = "TEMPDSPTEST";
      G_LOG( " No, like --proj-name=FlightGear option found. Using [" <<
         proj_name << "] as 'default', test, name ..." );
#endif // #ifdef SET_TEMP_TEST_DSP // for diag only
   }

   // loading the FIRST, primary project makefile.am ...
   load_make_files( 0, 1 ); // = am_makefiles.size() );

   // we COULD process ALL directories in this 'root'
   // or we could JUST process those from the AM file
   for( cnt = 0; cnt < direct_list.size(); cnt++ ) {
      string new_path = direct_list[cnt];
      //G_LOG("Processing folder: " << new_path << " ..." );
      dir1 = ulOpenDir( new_path.c_str() ); // open the SOURCE
      if( dir1 == NULL ) {
         G_LOG( "ERROR: Not valid directory! [" << new_path << "] Check!" );
         return -1;
      }
      //G_LOG( "Processing " << new_path << " ..." );
      process_a_directory( new_path, dir1 );
      ulCloseDir( dir1 );
      dir1 = 0;
   }

   G_LOG( "Processed " << tot_dirs << "dirs , " << tot_files << " files, to get " <<
      tot_makes << " makefile.am ..." );

   // now, process the 'collected' makefile.am
   load_make_files( 1, am_makefiles.size() );

//FILE * fp = fopen("c:\\FG099\\SimGear\\source\\test1.dsp", "wb");
   if( !out_path.size() ) {
//      out_path = base_path; // = dpath; // establish the base path,
//      out_path += "\\";
//      out_path += "SimGear.dsp";
      out_path = "test3.dsp";
      G_LOG("Advice: No outfile name given! No --out-file=outfile option found ...");
   }

#ifdef WIN32
   char * offset;
   GetFullPathName( out_path.c_str(), // LPCTSTR lpFileName,
         256, // DWORD nBufferLength,
         pbuf, // LPTSTR lpBuffer,
         &offset ); // LPTSTR* lpFilePart);
   out_path = pbuf;
#endif // !#ifdef WIN32

   G_LOG("Output file set to " << out_path << " ...");

   // out_dsp_file( "c:\\FG099\\SimGear\\source\\test1.dsp" );
   if( ulFileExists( out_path.c_str() ) ) {
      if( g_overwrite ) { // set ***OVERWRITE*** flag
         G_LOG( "Warning: OVERWRITING " << out_path << " file ... --force is on.");
      } else {
         G_LOG( MEOL" *** OVERWRITE *** OVERWRITE *** OVERWRITE *** " );
         G_LOG( "Warning: File " << out_path << " EXISTS! Overwrite?");
         G_LOG( "Enter Y, plus [Enter] key, to overwrite, else [Enter] ..." );
         if( wait_4_key( 'y' ) ) {
            G_LOG( "Got Yes, will overwrite ..." );
         } else {
            G_LOG( "Got No, will NOT overwrite ... discarding data ..." );
            return 1;
         }
      }
   }

   // ok, time to OUTPUT the DSP file ...
   out_dsp_file( (char *)out_path.c_str() ); // see amwrite.cxx

   return 0;
}


//vector<string> split_whitespace( const string& str, int maxsplit )
string_list g_split_space( string & str )
{
   string_list result;
   size_t ilen = str.length();
   size_t i = 0;
   size_t j = 0;
   while( i < ilen ) {
      while(( i < ilen) && (str[i] == ' ')) {
         i++;
		}
		j = i; // keep start of 'text' ...
      while((i < ilen) && !(str[i] == ' ')) {
         i++; // move toward the end ...
		}
      if( j < i )	{
         result.push_back( str.substr(j, (i-j)) );
		   while((i < ilen) && (str[i] == ' ')) {
            i++;
         }

      }

   }

   return result;
	
}

