
// amload.cxx
#include "am2dsp.hxx" // single include ...
extern void trim_in_buf( char * pb );

// Sample am2dsp.cfg file, in the root path of the project -
// SimGear ancestry
/* ^^^^^^^^
# default library runtime type
type = StaticLibrary,Multithreaded,
exclude_dir = threads
include_path = ..\..\AL\openal\include
define = NO_PTHREADS_DLL
# + Rule to create simgear_config.h
# not functional yet ...
   ^^^^^^^^ */
// FlightGear ancestry
/* ^^^^^^^^
type = ConsoleApplication,Multithreaded,Debug
exclude_dir = NetworkOLK
exclude_file = src\GUI\net_dlg.cxx
include_path = ..\SimGear\zlib-1.1.4
define = FGFS
#add_lib = glut32.lib
lib_path = ..\plib
#add_lib = ssg
#add_project = ..\SimGear\SimGear.dsp
# Rule to create config.h
add_source_file = SOURCE = .\src\Include\config.h-msvc6 ...
...
InputPath=.\src\Include\config.h-msvc6 ...
   ^^^^^^^^ */

string app_type; 
string_list inc_list; // include = ..\..\blah ...
string_list def_list; // define = HAVE_CONFIG_H
string_list exc_files;
string_list exc_dirs;
// if( s.find( "add_lib" ) == 0 ) {
string_list add_libs;
// if( s.find( "lib_path" ) == 0 ) {
string_list lib_paths;
// if( s.find( "add_source_file" ) == 0 ) {
string_list add_src_list;

void clear_cfg_data( void )
{
   app_type = "";
   inc_list.clear(); // include = ..\..\blah ...
   def_list.clear(); // define = HAVE_CONFIG_H
   exc_files.clear();
   exc_dirs.clear();
   // if( s.find( "add_lib" ) == 0 ) {
   add_libs.clear();
// if( s.find( "lib_path" ) == 0 ) {
   lib_paths.clear();
// if( s.find( "add_source_file" ) == 0 ) {
   add_src_list.clear();
}

size_t g_load_cfg_data(const char * pf, string_list * pv )
{
   struct stat data;
   size_t r_len;
   string s;
   string_list sl;

   // cout << "Loading " << pf << " ..." << endl;
   G_LOG("");
   G_LOG( "Loading: [" << pf << "] ... config file ..." );

   if(stat(pf, &data) != 0) {
      //cout << "Warning: File " << pf << " does not exist!" << endl;
      G_LOG( "Warning: File " << pf << " does not exist!" );
      return 0;
   }
   size_t ilen = data.st_size;
   if( !ilen ) {
      // cout << "Warning: File " << pf << " is null bytes!" << endl;
      G_LOG( "Warning: File " << pf << " is null bytes!" );
      return 0;
   }

   FILE * f = fopen(pf, "rb");
   if(!f) {
       G_LOG( "Warning: Can not open file " << pf << "!" );
       return 0;
   }

   char * pbuf = new char[ilen+16];
   if( !pbuf ) {
      G_LOG( "Warning: Can not get memory for file " << pf << " size " << (ilen+1) << "!" );
      fclose(f);
      return 0;
   }

   r_len = fread(pbuf, 1, ilen, f);
   fclose(f);

   if(r_len != ilen) {
        // Shouldn't happen ...
        delete[] pbuf;
        G_LOG( "Warning: Can not load file " << pf << "!" );
        return 0;
   }


   pbuf[ilen] = 0; // ensure zero terminated
   // G_LOG( "Read in " << imax << " bytes, into a buffer ..." );
   // G_LOG( "[" << pbuf << "]" );
   char * cp = pbuf;

// size_t grm_load_lines( char * cp, size_t ilen, string_list * pv ) {
   size_t cnt = 0;
   size_t bgn_j = 0;
   size_t jsz;
   if(cp) {
      // G_LOG( "Loading file lines ... from " << ilen << " bytes ..." );
      int d = 0;
      int d2 = 0;
      int c2 = 0;
      size_t d2_pos;
      char * pbgn;
      //size_t k;
      bgn_j = 0;
      for(jsz = 0; jsz < ilen; jsz++) {
         int c = cp[jsz];
         if( c == '\t' ) {
            c = ' ';
            cp[jsz] = (char)c;
         } else if(( c == '\n' )||( c == '\r' )) {
            if( d >= ' ' ) {
               // at the end-of-line, or is it a 'continuation
               if( d2 == '\\') {
                  c2 = ' ';
                  cp[jsz] = (char)c2;
                  cp[d2_pos] = (char)c2;
               } else {
                  c2 = 0;
                  cp[jsz] = (char)c2;
                  char * cpb = &cp[bgn_j];
                  while( *cpb && ( *cpb <= ' ' ) ) cpb++;
                  if( *cpb && ( *cpb != '#' ) ) {
                     // not a comment line
                     trim_in_buf(cpb);
                     s = cpb;
                     if(s.size()) {
                        //file_lines.push_back(s);
                        pv->push_back(s);
                        sl.push_back(s);
                        cnt++;
                        G_LOG( "Line " << cnt << "[" << s << "]" );
                     }
                  }
               }
            } else {
               cp[jsz] = (char)c2;
            }
            if( c2 == 0 ) {
               bgn_j = jsz + 1;
               pbgn = &cp[bgn_j];
               if(*pbgn == 'S')
                  c2 = 0;
            }
         }
         d = c;
         if(c > ' ') {
            d2_pos = jsz;
            d2 = c; // keep last sig char
         }
      }
                  char * cpb = &cp[bgn_j];
                  while( *cpb && ( *cpb <= ' ' ) ) cpb++;
                  if( *cpb && ( *cpb != '#' ) ) {
                     // not a comment line
                     trim_in_buf(cpb);
                     s = cpb;
                     if(s.size()) {
                        //file_lines.push_back(s);
                        pv->push_back(s);
                        sl.push_back(s);
                        cnt++;
                     }
                  }
      delete[] cp;
   }

   clear_cfg_data(); // clear, any previous data ...
   if(cnt) {
      size_t pos;
      string s2;
      // we have LINES to process
      for( size_t i = 0; i < cnt; i++ ) {
         int ok = 0;
         //s = pv[i]; // get the lind
         s = sl[i]; // get the line
         pos = s.find("="); // check for something = something
         if( pos != -1 ) { // we have an EQUAL sign
            s2 = s.substr((pos+1), (s.size() - (pos+1)));
            while( s2[0] == ' ' ) {
               s2 = s2.substr(1, (s.size() - 1));
            }
            if( s2.size() ) {
               // check for 'known' options
               if( s.find( "include_path" ) == 0 ) {
                  // got an include item
                  inc_list.push_back(s2); // include = ..\..\blah ...
                  ok = 1;
               } else if( s.find( "define" ) == 0 ) {
                  // got a define
                  def_list.push_back(s2); // define = HAVE_CONFIG_H
                  ok = 1;
               } else if( s.find( "type" ) == 0 ) {
                  // eg 'type = ConsoleApplication,Multithreaded,Debug'
                  app_type = s2; // set 'build' type string
                  ok = 1;
               } else if( s.find( "exclude_file" ) == 0 ) {
                  exc_files.push_back(s2);
                  ok = 1;
               } else if( s.find( "exclude_dir" ) == 0 ) {
                  exc_dirs.push_back(s2);
                  ok = 1;
               } else if( s.find( "add_lib" ) == 0 ) {
                  add_libs.push_back(s2);
                  ok = 1;
               } else if( s.find( "lib_path" ) == 0 ) {
                  lib_paths.push_back(s2);
                  ok = 1;
               } else if( s.find( "add_lib_path" ) == 0 ) {
                  lib_paths.push_back(s2);
                  ok = 1;
               } else if( s.find( "add_source_file" ) == 0 ) {
                  add_src_list.push_back(s2);
                  ok = 1;
               }
            }
         }
         if( !ok ) {
            G_LOG( "Warning: config line " << s << " ignored!" );
         }
      }
   }
   return cnt;
}

// eof - amload.cxx
