

// amwrite.cxx

#include "am2dsp.hxx"

#define  CHKMEM(a) if(!a) G_LOG("C:ERROR: No memory!")

fg2dsp sFGD;


void fix_win32( string & s )
{
   for( size_t i = 0; i < s.size(); i++ ) {
      if( s[i] == '/' ) { // back to WINDOWS, for windows DSP file
         s[i] = '\\';
      }
   }
}

string get_rel_dir( string folder )
{
   string s = folder;
   size_t bs = base_path.size();
   if( bs ) {
      size_t pos = s.find(base_path);
      if( pos == 0 ) {
         s.erase(0, base_path.size());
         string s2 = ".";
         s2 += s;
         s = s2;
      }
   }
   fix_win32(s);
   return s;
}

void clean_copy( char * pb, char * src )
{
   strcpy(pb, src);
   size_t ilen = strlen(pb);
   while(ilen) {
      ilen--;
      if(pb[ilen] > ' ')
         break;

      pb[ilen] = 0;
   }
}


string get_cfg_stg(char * p_rel_su2 )
{
   // ostringstream o;
   size_t mem = strlen(p_rel_su2) + 1;
   char * pb = new char[mem];
   if(!pb) G_LOG("C:ERROR: No memory!");
   clean_copy(pb, p_rel_su2); // CLEAR OFF END-OF-LINE - assumed ONE(1) line only
   string s = pb;
   delete pb;

   // process INCLUDE folders /I "some thing"
   size_t imax = inc_list.size(); // include = ..\..\blah ...
   size_t i;
   for(i = 0; i < imax; i++) {
      ostringstream o;
      //o.clear();
      //o.flush();
      o << "/I \"" << inc_list[i] << "\"";
      size_t pos = s.find( o.str() ); // do we already have this one
      if( pos == -1 ) {
         s += " ";
         s += o.str();
      }
   }
   imax = def_list.size(); // define = HAVE_CONFIG_H
   for(i = 0; i < imax; i++) {
      ostringstream o;
      o << "/D \"" << def_list[i] << "\"";
      size_t pos = s.find( o.str() ); // do we already have this one
      if( pos == -1 ) {
         s += " ";
         s += o.str();
      }
   }

   s += MEOL; // add back the end-of-line (for WINDOWS DSP generation = CR+LF)
   return s;
}

// compare service
static bool vam_nm_comp( const AMLIB & a, const AMLIB & b )
{
    return a.lib_short2 < b.lib_short2;
}

// either STATIC WIN32 LIBRARY DSP, of SimGear ancestry, or
// CONSOLE application DSP, of FligthGear ancestry ...
int Do_the_DSP( FILE * fp, size_t imakes, char * pbuf, string s_type )
{
   int iret = -1;
   size_t tot = 0;
//   size_t ilen, wtn;

   //fg2dsp sFGD;
   sFGD.init( proj_name, s_type, // load the 'static', app_type
      inc_list, // include = ..\..\blah ...
      def_list ); // define = HAVE_CONFIG_H

//   OUT1(zee_hdr); // can not manipulate string easily ...

   iret = sFGD.write_dsp( fp, vam, &tot );

//Do_CLOSE:

   if( iret ) {
      // some failure
      G_LOG( MEOL"ERROR: File Write Error, may be no DSP file,"MEOL
         "or incomplete. Check this LOG carefully, and re-run ..."
         " (" << tot << " bytes) to DSP file ..." );
   } else {
      // success ...
      G_LOG( MEOL"Written " << tot << " bytes, to DSP file ..." );
   }

   return iret;
}

#if 0    // code to be removed

int Do_Lib_DSP_WAS_OK( FILE * fp, size_t imakes, char * pbuf )
{
   string find = "SimGear";
   int iret = -1;
   size_t i, j;
      size_t ilen, wtn, tot, imx;
      tot = 0;
      OUT1(zee_hdr); // can not manipulate string easily ...
      OUT1( sFGD.exch_name(zee_hdr, proj_name, find).c_str() );
      OUT1(zee_typ); // can not manipulate string easily ...
      OUT1( sFGD.exch_name(zee_typ, proj_name, find).c_str() );
// } else if( s.find( "type" ) == 0 ) {
// // eg 'type = ConsoleApplication,Multithreaded,Debug'
//     app_type = s2; // set 'build' type string
//      OUT1( pfg2->sdsp_type.c_str() );

      OUT1(zee_msg);
      // setup can be ADJUSTED by am2dsp.cfg file
      //OUT1(zee_su);
      OUT1(zee_su1);
      OUT1(zee_su1r);
      OUT1(get_cfg_stg(zee_rel_su2).c_str());
      OUT1(zee_su31);
      OUT1(zee_su32);
      // OUT1(zee_dbg_su4);
      OUT1(get_cfg_stg(zee_dbg_su4).c_str());
      OUT1(zee_su5);

      OUT1(zee_bgn);

      if( tot ) {
         //tot += wtn;
         for( j = 0; j < imakes; j++ ) {
            PAMLIB pl = &vam[j];
            if(pl->lib_done)
               continue;

            pl->lib_done = 1;
            imx = pl->lib_list.size();
            if( imx ) {
               //string grp = pl->lib_short;
               string grp = pl->lib_short2;
               ilen = sprintf(pbuf,"# Begin Group \"Lib_%s\""MEOL, grp.c_str() ); // short lib name
               strcat(pbuf, MEOR"# PROP Default_Filter \"\""MEOL);
               ilen = strlen(pbuf);
               WRT(pbuf,ilen);
               // SOURCE=.\simgear\bucket\newbucket.cxx, etc ...
               for( i = 0; i < imx; i++ ) {
                  strcpy(pbuf, "# Begin Source File"MEOL MEOL );
                  ilen = strlen(pbuf);
                  WRT(pbuf,ilen);
                  ilen = sprintf(EndBuf(pbuf),"SOURCE=%s\\%s"MEOL MEOL,
                     get_rel_dir(pl->lib_folder).c_str(),
                     pl->lib_list[i].c_str() );
                  WRT(pbuf,ilen);
                  OUT1("!IF  \"$(CFG)\" == \"SimGear - Win32 Release\""MEOL MEOL);
                  ilen = sprintf(pbuf, "# PROP Intermediate_Dir \"Release\\Lib_%s\""MEOL MEOL, grp.c_str());
                  WRT(pbuf,ilen);
                  OUT1("!ELSEIF  \"$(CFG)\" == \"SimGear - Win32 Debug\"" MEOL MEOL);
                  ilen = sprintf(pbuf, "# PROP Intermediate_Dir \"Debug\\Lib_%s\""MEOL MEOL, grp.c_str());
                  WRT(pbuf,ilen);
                  OUT1("!ENDIF "MEOL);
                  OUT1("# End Source File"MEOL);
               }
               OUT1("# End Group"MEOL);
            }
         }

         OUT1("# Begin Source File"MEOL
               MEOL "SOURCE=.\\simgear\\simgear_config.h.vc5"MEOL
               "# End Source File"MEOL );
      }

      OUT1("# End Target"MEOL);
      OUT1("# End Project"MEOL);

      iret = 0;

Do_CLOSE:

      if( iret ) {
         // some failure
         G_LOG( MEOL"ERROR: File Write Error, may be no DSP file,"MEOL
            "or incomplete. Check this LOG carefully, and re-run ..."
            " (" << tot << " bytes) to DSP file ..." );
      } else {
         // success ...
         G_LOG( MEOL"Written " << tot << " bytes, to DSP file ..." );
      }

   return iret;
}

#endif // #if 0    // code to be removed

// start with a WIN32 CONSOLE APPLICATION DSP, of FlightGear ancestry
int Do_Con_DSP( FILE * fp, size_t imakes, char * pbuf, string s_type )
{
   int iret = -1;
   fg2dsp * pfg2 = 0;

//         size_t ilen, wtn, tot;
//         tot = 0;

         // assume FlightGear like ...
         pfg2 = new fg2dsp; // get the 'default' set of 'tools'
         //OUT1( pfg2->exch_name( pfg2->sdsp_hdr, proj_name, "FligthGear" ).c_str() ); // these could be 'fixed' strings
         //OUT1( pfg2->fix_type( pfg2->sdsp_type, proj_name, app_type).c_str() );

   iret = 0;
//Do_CLOSE:

//  G_LOG( "Written " << tot << " bytes, to DSP file ..." );

   return iret;
}

//FILE * fp = fopen("c:\\FG099\\SimGear\\source\\test1.dsp", "wb");
// int out_dsp_file( char * outp )
// time to OUTPUT the DSP file ...
int out_dsp_file( char * outp )
{
   char * pbuf = new char[4096];
   CHKMEM(pbuf);
   fg2dsp * pfg2 = 0; // new fg2dsp; // get the 'default' set of 'tools'
   int iret = -1;
   size_t imakes = vam.size();
   size_t j, i;
   G_LOG( "Summery: Got " << imakes << " makefile.am ... " );
   size_t ttl = 0;
   i = 0;
   for( j = 0; j < imakes; j++ ) {
      ttl += vam[j].lib_list.size();
      if( vam[j].lib_list.size() ) {
         i++;
      }
   }

   G_LOG( "Found " << i << " libraries, with " << ttl << " sources ... sorting ..." );

   sort( vam.begin(), vam.end(), vam_nm_comp );

   FILE * fp = fopen(outp, "wb");
   //FILE * fp = fopen("c:\\FG099\\SimGear\\source\\test1.dsp", "wb");
   //FILE * fp = fopen("test1.dsp", "wb");
   if( !fp ) {
      G_LOG( "ERROR: Unable to create " << outp << "! No folder? Check and retry ..." );
      return -1;
   }

   if(fp) {
      iret = Do_the_DSP(fp, imakes, pbuf, app_type); // assume SimGear like ...
      fclose(fp);
   }

   return iret;

}


// eof - amwrite.cxx
