
// fg_dsp.cxx

#include "am2dsp.hxx"

#define  EXPLODE  cerr << "Critical error" << endl; exit(-1)

#define  SD(a) a = p[i++]

fg2dsp::fg2dsp()
{

}
int fg2dsp::init( string proj_nm, string s_type,
                  string_list & incs, string_list & defs ) 
{
   int iret = 0; // success is ZERO!
   char * pb = dbg_buf;
   int   i;
   // if we 'find' "ConsoleApplication", then set CONSOLE, else set STATIC LIBRARY
   size_t itype = ((s_type.find("ConsoleApplication") == -1 ) ? FG_DSP_STATIC : FG_DSP_CONSOLE);
   // Each of these 'snippets' are paired into the following pointer array
   char * * p = &p_dsp_snippets[0]; // [ (MAX_DSP_TYPES * e_fg_dsp_MAX) ];
   prj_ance = ""; // name of 'project' in canned - fixed.cxx data
   switch(itype) {
      case FG_DSP_STATIC:
         prj_ance = DSP_STATIC_ANCE;
         break;
      case FG_DSP_CONSOLE:
         prj_ance = DSP_CONSOLE_ANCE;
         break;
   }
   prj_type = itype; // set in init(...)
   prj_NAME = proj_nm; // name of the project, set in init(...)
   prj_opts = s_type; // string of 'options', comma separated
   do_exch = 0; // no 'expensive' string EXCHANGE
   if( proj_nm.size() ) { // if given a NEW project name ...
      do_exch = ( prj_ance == proj_nm ) ? 0 : 1;
   }

   dsp_snips.clear(); // clear previous set of 'strings'
   // *** PROCESS ALL THE 'SNIPPETS' FROM THE DSP FILE
   // Some get 'special' treatment
   // ************************************************
   for( i = 0; i < e_fg_dsp_MAX; i++ ) {
      char * cp = p[ (i * MAX_DSP_TYPES) + itype ]; // get the snippet pointer
      //strcpy(pb,cp); // copy data
      //string s = pb; // put into a string
      string s = cp; // put into a string
      switch(i) {
         case e_fg_dsp_hdr: // 0 - needs NAME fix ...
            if( do_exch ) s = exch_name( s, prj_NAME, prj_ance );
            break;
         case e_fg_type:    // 1 - support the type = console, etc ... and DEFAULT
            if( do_exch ) s = exch_name( s, prj_NAME, prj_ance );
            s = fix_type( s, prj_NAME, prj_opts);
            break;
         case e_fg_dsp_msg: // 2 - needs NAME fix (sz_zee_msg) like "!MESSAGE This ..."MEOR etc ...
         case e_fg_dsp_b01_bgn: // "# Begin Project"MEOR
         case e_fg_dsp_b02_PROP: // NAME fix
            if( do_exch ) s = exch_name( s, prj_NAME, prj_ance );
            break;
         case e_fg_dsp_b03_CPP: // Release configuration
            s = adj_cpp_stg(s, incs, defs);
            break;
         case e_fg_dsp_b04_ASR: // like "# SUBTRACT CPP, ADD RSC, "BSC32=bscmake.exe"MEOR
         case e_fg_dsp_b05_LNK: // "# ADD LINK32 kernel32.lib
            break;
         case e_fg_dsp_b06_PROP: // like "# PROP Target_Dir \"\""MEOR
            if( do_exch ) s = exch_name( s, prj_NAME, prj_ance );
            break;
         case e_fg_dsp_b07_CPP: // Debug configuration
            s = adj_cpp_stg(s, incs, defs);
            break;
         case e_fg_dsp_b08_ASR: // like "LINK32=link.exe"MEOR
         case e_fg_dsp_b09_LNK: // Debug "# ADD LINK32 kernel32.lib ...
         case e_fg_dsp_b10_end: // MEOR "!ENDIF "MEOR MEOR
            break;
         case e_fg_btarg:       // NAME fix - "# Begin Target"MEOR MEOR "# Name \"FlightGear - Win32 Release\""MEOR
            if( do_exch ) s = exch_name( s, prj_NAME, prj_ance );
            break;

         // *** code filled values here - from makefile.am ***
         case e_fg_bgn_if: // sz_zee_bgn_if, sz_fg_bgn_if,
         case e_fg_is_els: // sz_zee_is_els, sz_fg_is_els,
         case e_fg_end_if:   // sz_zee_end_if, sz_fg_end_if,
            if( do_exch ) s = exch_name( s, prj_NAME, prj_ance );
            break;

         case e_fg_dsp_end: // "# End Target"MEOR "# End Project"MEOR = END OF DSP FILE
            break;

      }
      dsp_snips.push_back(s); // store the string in a simple vector list
   }
   return iret;
}

fg2dsp::~fg2dsp()
{

}

string fg2dsp::exch_name( string s, string nm, string old )
{
   string s1 = old; // "SimGear" or "FlightGear" defaults in 'fixed'
   string s2 = s;
   if( nm == s1 ) {
      return s2;
   }
   // else we have some processing to be done
   size_t sz = s1.size(); // length of FIND
   size_t pos = s2.find(s1);
   while( pos != -1 ) {
      // we have some 'exchange' to do
      size_t sz2 = s2.size(); // get WHOLE length
      string lf = "";
      if(pos)lf = s2.substr(0,pos);
      string rt = "";
      if( sz2 > (pos + sz) ) rt = s2.substr( (pos + sz) );
      s2 = lf + nm + rt;
      pos = s2.find(s1);
   }
   return s2;
}



string fg2dsp::fix_type( string s, string nm, string utyp )
{
   string s2 = s;
   // for FlightGear - CONSOLE application
   // type = ConsoleApplication,Multithreaded,Debug
   // char sz_fg_type[] = { // support the type = console, etc ... and DEFAULT
   //"# TARGTYPE \"Win32 (x86) Console Application\" 0x0103"MEOR
   // MEOR
   // "CFG=FlightGear - Win32 Debug"MEOR };
   // for SimGear
   // type = StaticLibrary,Multithreaded,(choose def. debug)
   // "# TARGTYPE \"Win32 (x86) Static Library\" 0x0104"MEOL MEOL
   // "CFG=SimGear - Win32 Debug"MEOL };
   return s2;
}

string fg2dsp::adj_cpp_stg(string s_in, string_list & incs, string_list & defs )
{
   size_t ilen = s_in.size();
   string s = s_in; // copy the string
   string deol = MEOL;
   size_t pos = s.find(deol); // get end-of-line
   if( pos != -1 ) {
      if(pos == (ilen - 2)) { // if at end-of-string - ie ONE LINE
         s = s.substr(0,pos);
      }
   }

   // process INCLUDE folders /I "some thing"
   // size_t imax = inc_list.size(); // include = ..\..\blah ...
   size_t imax = incs.size(); // include = ..\..\blah ...
   size_t i;
   for(i = 0; i < imax; i++) {
      ostringstream o;
      //o.clear();
      //o.flush();
      o << "/I \"" << incs[i] << "\"";
      size_t pos = s.find( o.str() ); // do we already have this one
      if( pos == -1 ) {
         s += " ";
         s += o.str();
      }
   }
   imax = defs.size(); // define = HAVE_CONFIG_H
   for(i = 0; i < imax; i++) {
      ostringstream o;
      o << "/D \"" << defs[i] << "\"";
      size_t pos = s.find( o.str() ); // do we already have this one
      if( pos == -1 ) {
         s += " ";
         s += o.str();
      }
   }

   s += MEOL; // add back the end-of-line (for WINDOWS DSP generation = CR+LF)
   return s;
}


int fg2dsp::write_dsp( FILE * fp, vAMLIBS & vams, size_t * psz )
{
   int iret = -1;
   size_t dsp_cnt;
   size_t i, wtn, j;
   size_t tot = 0;
   size_t imakes = vams.size();

   string bgn_if = dsp_snips[e_fg_bgn_if]; // "!IF  \"$(CFG)\" == \"SimGear - Win32 Release\""MEOL MEOL;
   string is_els = dsp_snips[e_fg_is_els]; // "!ELSEIF  \"$(CFG)\" == \"SimGear - Win32 Debug\""MEOL MEOL;
   string end_if = dsp_snips[e_fg_end_if]; // "!ENDIF "MEOL;

   // Write out the first blocks - name already fixed, and 'unique' processing, where reqd
   // up to, and including the begin of the targets ...
   for(dsp_cnt = 0; dsp_cnt <= e_fg_btarg; dsp_cnt++) {
      string s = dsp_snips[dsp_cnt];
      WRT((char *)s.c_str(), s.size());
   }

   size_t imx, ilen;
   char * pbuf = dbg_buf;
   // ***************************************************************************
         for( j = 0; j < imakes; j++ ) {
            PAMLIB pl = &vams[j];
            if(pl->lib_done)
               continue;

            pl->lib_done = 1;
            imx = pl->lib_list.size();
            if( imx ) {
               //string grp = pl->lib_short;
               string grp = pl->lib_short2;
               ilen = sprintf(pbuf,"# Begin Group \"Lib_%s\""MEOL, grp.c_str() ); // short lib name
               strcat(pbuf, MEOR"# PROP Default_Filter \"\""MEOL);
               ilen = strlen(pbuf);
               WRT(pbuf,ilen);
               // SOURCE=.\simgear\bucket\newbucket.cxx, etc ...
               for( i = 0; i < imx; i++ ) {
                  strcpy(pbuf, "# Begin Source File"MEOL MEOL );
                  ilen = strlen(pbuf);
                  WRT(pbuf,ilen);
                  ilen = sprintf(EndBuf(pbuf),"SOURCE=%s\\%s"MEOL MEOL,
                     get_rel_dir(pl->lib_folder).c_str(),
                     pl->lib_list[i].c_str() );
                  WRT(pbuf,ilen);
                  OUT1(bgn_if.c_str()); //OUT1("!IF  \"$(CFG)\" == \"SimGear - Win32 Release\""MEOL MEOL);
                  ilen = sprintf(pbuf, "# PROP Intermediate_Dir \"Release\\Lib_%s\""MEOL MEOL, grp.c_str());
                  WRT(pbuf,ilen);
                  OUT1(is_els.c_str()); // OUT1("!ELSEIF  \"$(CFG)\" == \"SimGear - Win32 Debug\"" MEOL MEOL);
                  ilen = sprintf(pbuf, "# PROP Intermediate_Dir \"Debug\\Lib_%s\""MEOL MEOL, grp.c_str());
                  WRT(pbuf,ilen);
                  OUT1(end_if.c_str()); // OUT1("!ENDIF "MEOL);
                  OUT1("# End Source File"MEOL);
               }
               OUT1("# End Group"MEOL);
            }
         }

         if( prj_type == FG_DSP_STATIC ) {

            OUT1("# Begin Source File"MEOL
               MEOL "SOURCE=.\\simgear\\simgear_config.h.vc5"MEOL
               "# End Source File"MEOL );
         }

   // ***************************************************************************

   // finally, process the end - should work ok ;=))
   for( dsp_cnt = e_fg_dsp_end ; dsp_cnt < e_fg_dsp_MAX; dsp_cnt++) {
      string s = dsp_snips[dsp_cnt];
      WRT((char *)s.c_str(), s.size());
   }

   iret = 0;

Do_CLOSE:

   *psz = tot;

   return iret;
}



// eof - fg_dsp.cxx

