

// fixed.hxx
#ifndef _fixed_hxx
#define _fixed_hxx

#include <string>

#define MEOL   "\r\n"

// This module contains the MSVC6 DSP for a static library, and a console application,
// so the support output type -
#define  MAX_DSP_TYPES     2     // need to build tables, etc

#define  FG_DSP_STATIC     0
#define  FG_DSP_CONSOLE    1

// Rather than trying to parse/ouput every line type in the DSP,
// some sample DSP files have been 'cut' into 'snippets'.
// This enumeration gives the current 'cut' list

enum fg_dsp_item {
   e_fg_dsp_hdr = 0, // 0 - needs NAME fix ...
   e_fg_type,    // 1 - support the type = console, etc ... and DEFAULT
   e_fg_dsp_msg, // 2 - needs NAME fix (sz_zee_msg) like "!MESSAGE This ..."MEOR etc ...
   e_fg_dsp_b01_bgn, // "# Begin Project"MEOR
   e_fg_dsp_b02_PROP, // NAME fix
   e_fg_dsp_b03_CPP, // 5 - Release configuration
   e_fg_dsp_b04_ASR, // like "# SUBTRACT CPP, ADD RSC, "BSC32=bscmake.exe"MEOR
   e_fg_dsp_b05_LNK, // "# ADD LINK32 kernel32.lib
   e_fg_dsp_b06_PROP, // like "# PROP Target_Dir \"\""MEOR
   e_fg_dsp_b07_CPP, // Debug configuration
   e_fg_dsp_b08_ASR, // 10 - like "LINK32=link.exe"MEOR
   e_fg_dsp_b09_LNK, // Debug "# ADD LINK32 kernel32.lib ...
   e_fg_dsp_b10_end, // MEOR "!ENDIF "MEOR MEOR
   e_fg_btarg,       // NAME fix - "# Begin Target"MEOR MEOR "# Name \"FlightGear - Win32 Release\""MEOR
// char sz_fg_bgroup_sampleonly as 'sample' of group, and sources
// "# Begin Group \"Lib_Aircraft\""MEOR
   e_fg_bgn_if,   // sz_zee_bgn_if, sz_fg_bgn_if,
   e_fg_is_els,   // sz_zee_is_els, sz_fg_is_els,
   e_fg_end_if,   // sz_zee_end_if, sz_fg_end_if,

// *** MUST GENERATE CODE FROM THE INFORMATION GATHERED FROM THE MAKEFILE.AM SEARCH ***
// =============== see code =================
   e_fg_dsp_end, // "# End Target"MEOR "# End Project"MEOR = END OF DSP FILE
   e_fg_dsp_MAX   // 15 - max. count of DSP 'snippets' used to build new ones
};

// Each of these 'snippets' are paired into the following pointer array
//extern char * p_dsp_snippets[ (MAX_DSP_TYPES * e_fg_dsp_MAX) ];
extern char * p_dsp_snippets[]; // [ (MAX_DSP_TYPES * e_fg_dsp_MAX) ]

// These 'canned' string contain their 'ancestry' name, like
#define  DSP_STATIC_ANCE   "SimGear"
#define  DSP_CONSOLE_ANCE  "FlightGear"

#if 0    // code to be removed
// extern char * pdsphd; // not used ... some error
// anyway; it is better to 'componetise' it a little
extern char * zee_hdr;
extern char * zee_typ;
extern char * zee_msg;
//extern char * zee_su;
extern char * zee_su1;
extern char * zee_su1r;
extern char * zee_rel_su2;
extern char * zee_su31;
extern char * zee_su32;
extern char * zee_dbg_su4;
extern char * zee_su5;

extern char * zee_bgn;

extern char * sg_dsp_items[];
extern char * fg_dsp_items_NOT_USED[e_fg_dsp_MAX];
#endif // #if 0    // code to be removed

#endif // #ifndef _fixed_hxx
// eof - fixed.hxx


