

// dc4wHelp.c
// this is public domain software - praise me, if ok, just don't blame me!
#include "dc4w.h"
#include "dc4wHelp.h"

extern   PVOID Add2StgList( PLE pH, LPTSTR lpb );
extern   PLE  GetSaveOpts( INT chr );

// see { szOpt, szIgnDT,  it_Bool,(LPTSTR)&gbIgnDT,         &gbChgIDT, 0, 0 }
BOOL  g_bWriteAZip = FALSE;   // to actuall WRITE zip
// -N
BOOL  g_bNoAZip = FALSE;
BOOL  g_bZipAll = FALSE;   // -NA to override the exclusions
/***************************************************************************
 * Function: dc4w_usage
 *
 * Purpose:
 *
 * Complain to command line users about poor syntax,
 * will ONE DAY be replaced by proper help file.
 */
static TCHAR sszUse3[] = "HELP ON SAVE COMMAND"MEOR;
static TCHAR sszUse1[] = "COMMAND LINE ERROR"MEOR;
static TCHAR sszUse2[] = "Brief usage is :-"MEOR
   APPNAME" LeftDir|File [RightDir|File]"MEOR
   "[-r[-|+]]=Recursive [-L]=Shallow [-N=No A.Zip]"MEOR
   "[-s[slrd][:outfile]]=Save File List"MEOR
   "[-d[slrd][:outfile]]=Write Difference File"MEOR
   "note: if outfile given file written and app exits"MEOR
   "[-x[-|+[nn]]]=Disable/Enable exclude list [num]"MEOR
   "[-xd:<dirs>|-xf:<files>]=Specific exclude items.";

VOID  DoMB( LPTSTR lpb )
{
   INT retval = MB(NULL,
         lpb,
         APPNAME,
         (MB_ICONSTOP|MB_OKCANCEL|MB_SYSTEMMODAL|MB_DEFBUTTON2));
      if( ( retval == IDCANCEL ) ||
         (  retval == (int)-1  ) )
      {
         exit(1);
      }
}

VOID dc4w_usage_save(LPTSTR pcmd)
{
   LPTSTR   p;
   LPTSTR   lpb = &gszTmpBuf[0];
   LPTSTR   lpe;
   PLE      ph,pn;
   DWORD    dwi,dwc;
   LPTSTR   cp;

   p = strchr(pcmd,'?');
   strcpy( lpb, sszUse1 );
   if(p)
      strcpy( lpb, sszUse3 );

   ph = GetSaveOpts( 0 );
   if(ph)
   {
      ListCount2(ph,&dwc);
      if(dwc)
      {
         dwi = 0;
         Traverse_List( ph, pn )
         {
            dwi++;   // space between
            cp = (LPTSTR)((PLE)pn + 1);
            dwi += strlen(cp);
         }
         if(dwi)
         {
            sprintf(EndBuf(lpb),MEOR"Cmd=%s"MEOR, pcmd );
            lpe = (LPTSTR)MALLOC( (strlen(lpb) + dwi + 256 + (dwc * 3) ) );
            if(lpe)
            {
               DWORD dwlen;
               strcpy(lpe, lpb);
               dwi = 0;
               dwlen = 0;
               Traverse_List( ph, pn )
               {
                  if(dwi)
                     strcat(lpe," ");
                  dwi++;   // space between
                  cp = (LPTSTR)((PLE)pn + 1);
                  //dwi += strlen(cp);
                  strcat(lpe,cp);
                  dwlen += strlen(cp) + 1;
                  if(dwlen > 65)
                  {
                     strcat(lpe,MEOR);
                     dwlen = 0;
                  }
               }
               if(dwlen)
                  strcat(lpe,MEOR);

               strcat(lpe, "Click OK to continue."MEOR
               "Click CANCEL to exit application" );

               DoMB( lpe );

               MFREE( lpe );

            }
         }
      }
   }
}



VOID dc4w_usage(LPTSTR msg)
{
   LPTSTR   lpb = &gszTmpBuf[0];
   LPTSTR   lpe;

   strcpy( lpb, sszUse1 );
   if( msg && *msg )
      strcat( lpb, msg );
   else
      strcat( lpb, "General Error"MEOR );
   EnsureCrLf(lpb);
   strcat( lpb, sszUse2 );
   EnsureCrLf(lpb);
   strcat( lpb, "Click OK to continue."MEOR
      "Click CANCEL to exit application" );
   //if (msg==NULL)
   //   msg = LoadRcString(IDS_USAGE_STR);
   //LoadString( g_hInst, IDS_DC4W_USAGE, szBuf, sizeof(szBuf));
   // MessageBox()
   lpe = 0;
   if( !g_lpAskMsg )
      lpe = (LPTSTR)MALLOC( (strlen(lpb) + 1));

   if(lpe)
   {
      strcpy(lpe,lpb);
      g_bAskCont = TRUE;   // set for timer to find
      g_lpAskMsg = lpe;
      g_bCmdError++;       // bump the COMMAND line errors
   }
   else
   {
      strcat(lpb,MEOR);
      strcat(lpb,"Second error!");
      DoMB(lpb);
   }
}

// helper services
INT   GetList( PLE pHead, LPTSTR cp )
{
   INT   c, d, k, l;
   LPTSTR   lpb = &gszTmpBuf[0];
   c = *cp;
   d = 0;
   k = 0;
   l = 0;
   while(c)
   {
      if( c == '"' )    // if a QUOTE
      {
         if( k && ( d == '"' ) )
         {
            lpb[k] = 0;
            if( Add2StgList( pHead, lpb ) )
               l++;
            else
            {
               l = 0;
               k = 0;
               break;
            }
            k = 0;
         }
         else if( ( k == 0 ) && ( d == 0 ) )
         {
            // start of quotes
            d = c;
         }
         else
         {
               l = 0;
               k = 0;
               break;
         }
      }
      else if( c == ';' )  // if a SEMI-COLON
      {
         if(k)
         {
            lpb[k] = 0;
            if( Add2StgList( pHead, lpb ) )
               l++;
            else
            {
               l = 0;
               k = 0;
               break;
            }
         }
         k = 0;
      }
      else
      {
         lpb[k++] = (TCHAR)c;
      }

      cp++;    // bump to next
      c = *cp; // and get char
   }
   if(k)
   {
      lpb[k] = 0;
      if( Add2StgList( pHead, lpb ) )
         l++;
      else
         l = 0;
   }

   if(l)
      return 0;   // SUCCESS
   else
      return 1;   // FAILED
}

//typedef struct tagPISTR {
//   HANDLE   hFile;
//   INT      iCnt;
//   LPTSTR   pBuf;
//   LPTSTR * pArgs;
//}PISTR, * PPISTR;
//#define  MXARGS   64    // should be ENOUGH

BOOL  Getpis( PPISTR ppis, LPTSTR lpf )
{
   BOOL     bRet = FALSE;
   LPTSTR   lptmp;

   ppis->iCnt  = 0;
   ppis->pBuf  = 0;
   ppis->pArgs = 0;
   // read this input file
   ppis->hFile = CreateFile( lpf,
            GENERIC_READ,
            FILE_SHARE_READ,
            0,
            OPEN_EXISTING,
            FILE_ATTRIBUTE_NORMAL,
            0 );
   if( VFH( ppis->hFile ) )
   {
      DWORD dws, dwh;
      dws = GetFileSize( ppis->hFile, &dwh );
      if( dws && !dwh )
      {
         LPTSTR   lpb;
         dwh = dws + (MXARGS * sizeof(LPVOID));
         if( lpb = LocalAlloc(LPTR,dwh) )
         {
            ppis->pBuf = lpb; // this is for freeing the pointer
            if( ( ReadFile( ppis->hFile, lpb, dws, &dwh, 0) ) &&
                ( dws == dwh ) )
            {
               LPTSTR * lpv;
               int      icnt;
               TCHAR    c, d;
               DWORD    dwi;

               lpv = (LPTSTR *) (LPTSTR) ( lpb + dws + 2 );
               icnt = 0;
               lpv[icnt++] = "dummy";
               // =======================================
               for( dwh = 0; dwh < dws; dwh++ )
               {
                  c = lpb[dwh];
                  if( c > ' ' )
                  {
                     if( c == ';' )
                     {
                        dwh++;
                        for( ; dwh < dws; dwh++ )
                        {
                           if( lpb[dwh] < ' ' )
                              break;
                        }
                     }
                     else
                     {
                        // begin of an ARGUMENT
                        lptmp = &lpb[dwh];
                        lpv[icnt] = lptmp; // &lpb[dwh];
                        d = *lptmp;    // get first char
                        c = d;
                        dwh++;
                        for( ; dwh < dws; dwh++ )
                        {
                           c = lpb[dwh];
                           if( c < ' ' )
                              break;
                           else if( ( d != '"' ) && // not "protect" by DOUBLE QUOTES
                              ( c == ';' ) ) // this is a comment tailing a command
                              break;
                        }
                        lpb[dwh] = 0;  // zero terminate the string
                        dwi = dwh - 1; // remove any trailing space
                        while(dwi)
                        {
                           if( lpb[dwi] > ' ' )
                              break;
                           lpb[dwi--] = 0;
                        }
                        // FIX20010329 - Ensure if the argument is "encased"
                        // in double quotes, remove them NOW (like command)
                        dwi = strlen(lptmp);    // get length of the command
                        if( ( dwi > 2      ) &&
                           ( d == '"' ) &&
                           ( lptmp[dwi-1] == '"' ) )
                        {
                           dwi--;
                           lptmp[dwi] = 0;   // kill trailing DOUBLE QUOTE
                           dwi--;
                           lptmp++;          // bump past leading DOUBLE QUOTE
                           lpv[icnt] = lptmp; // set this new pointer
                        }
                        if( dwi )
                        {
                           icnt++;  // bump the argument count
                        }
                        if( c >= ' ' )
                        {
                           // ensure we go to the end of the line
                           dwh++;   // get past the ZERO - FIX20020324
                           for( ; dwh < dws; dwh++ )
                           {
                              c = lpb[dwh];
                              if( c < ' ' )
                                 break;
                           }
                        }
                     }
                  }
               }  // for the length of the read in buffer
               // =======================================
               if( icnt > 1 )
               {
                  ppis->iCnt = icnt;
                  ppis->pArgs = lpv;
               }
               // note we quietly forget BLANK input files!!!
               bRet = TRUE;
            }
         }
      }
   }

   return bRet;
}


BOOL  ProcessInput( PTHREADARGS ta, LPTSTR lpf )
{
   BOOL     bRet = FALSE;  // assume FAIL for the moment
   PISTR    pis;
   PPISTR   ppis = &pis;

   ZeroMemory( ppis, sizeof(PISTR) );

   if( Getpis( ppis, lpf ) )
   {
      if( ( ppis->iCnt > 1 ) && ( ppis->pArgs ) )
         ProcessArgs( ta, ppis->iCnt, ppis->pArgs );
      // note we quietly forget BLANK input files!!!
      bRet = TRUE;
   }

   // clean up what needs to be cleaned
   if( ppis->pBuf )
      LocalFree(ppis->pBuf);

   if( VFH( ppis->hFile ) )
      CloseHandle( ppis->hFile );

   return bRet;
}


///////////////////////////////////////////////////////////////////////////////
// FUNCTION   : ProcessArgs
// Return type: VOID 
// Arguments  : PTHREADARGS ta
//            : int argc
//            : char * * argv
// Description: Physical decode of command arguments, with the results all
//              placed in the passed THREADARGS pointer.
// Arguments supported:
// @InputFile - Read and process an INPUT file, line by line, excluding ; comments
//
// FirstFile|Path - First file/path argument
//    if( ta->pFirst == NULL ) {
//            strcpy( ta->szFirst, argv[i] );
//            ta->pFirst = &ta->szFirst[0];
//
// SecondFile|Path - Second file/path argument
//    else if( ta->pSecond == NULL ) {
//            strcpy( ta->szSecond, argv[i] );
//            ta->pSecond = &ta->szSecond[0];
//
// -S[slrd][:outfile] - note: if outfile given file written and exit app.
//    where included are s = same, l = leftonly, r = rightonly, d = different
//    If NO INCLUDE then the DEFAULT is -
//               ta->saveopts = (INCLUDE_LEFTONLY) | (INCLUDE_ALLDIFF);
//
// -D[slrd][:outfile] - note: if outfile given file written and app exit
//    Write a DIFFERENCE file where included items are (lines that are)
//    s = same, l = leftonly, r = rightonly, d = different, m = moved
//    and other options -
//    n = line numbers, t = tags, a = append file, h = extra header info
//    If left ZERO the default is -
//    -dlrdmntah:<outfile>
//
// -N = g_bNoAZip = TRUE;
///////////////////////////////////////////////////////////////////////////////
VOID  ProcessArgs( PTHREADARGS ta, int argc, char * * argv )
{
   INT         i;
   LPTSTR      cp;
   INT         cmd, c;
   DWORD       dwo;
   BOOL        flg;

   for( i = 1; i < argc; i++ )
   {
      cp = argv[i];
      c = *cp;
      sprtf( "CMD: [%s]"MEOR, cp );
      /* is this an option ? */
      if( (c == '-') || (c == '/') )
      {
         cp++;
         cmd = toupper(*cp);
         c = cmd;
         switch( cmd )
         {
         case 'C':   // case flag
            cp++;
            flg = TRUE; // gbIgnCase = TRUE;
            if( *cp )
            {
               if(( *cp == '+' ) || ( *cp == '1' ) )
                  flg = TRUE; // gbIgnCase = TRUE;
               else if(( *cp == '-' ) || ( *cp == '0' ) )
                  flg = FALSE; // gbIgnCase = FALSE;
               else
               {
                  dc4w_usage(NULL);
                  return;
               }
            }
            ToggleBool( &gbIgnCase, &bChgIgC, flg );
            break;

         case 'D':   // write a DIFFERENCE file
            cp++;
            if( *cp != ':' )
            {
               while( *cp )
               {
                  c = toupper(*cp);
                  switch( c )
                  {
                  case 'S':
                     ta->diffopts |= INCLUDE_SAME;
                     break;
                  case 'L':
                     ta->diffopts |= INCLUDE_LEFTONLY;
                     break;
                  case 'R':
                     ta->diffopts |= INCLUDE_RIGHTONLY;
                     break;
                  case 'D':
//                     ta->diffopts |= INCLUDE_DIFFER;
                     ta->diffopts |= INCLUDE_ALLDIFF; // younger and older
                     break;
                  case 'M':
                     ta->diffopts |= INC_ALLMOVE;
                     break;
                  case 'N':
                     ta->diffopts |= INCLUDE_LINENUMS;
                     break;
                  case 'T':
                     ta->diffopts |= INCLUDE_TAGS;
                     break;
                  case 'A':
                     ta->diffopts |= APPEND_FILE;
                     break;
                  case 'H':
                     ta->diffopts |= INCLUDE_HEADER;
                     break;
                  default:
                     dc4w_usage(NULL);
                     return;
                  }

                  cp++;
                  if( *cp == ':' )
                     break;
               }
            }
            if( *cp == ':' )
            {
               cp++;
               if( *cp )
               {
                  ta->pDiffList = &ta->szDiffList[0];
                  strcpy( ta->pDiffList, cp );
               }
            }

            break;

         case 'E':   // -E no expand if only 1 in wd_initial
            g_bNoExp = TRUE;
            cp++;
            if( *cp == '+' )
               g_bNoExp = FALSE;
            else if( *cp == '-' )
               g_bNoExp = TRUE;
            break;

         case 'L':
            ta->fShall = TRUE;
            break;

         case 'N':
            g_bNoAZip = TRUE;
            cp++;
            if(*cp)
            {
               c = toupper(*cp);
               if( c == 'A' )
               {
                  g_bNoAZip = FALSE;
                  g_bZipAll = TRUE;
               }
               else
               {
                  dc4w_usage( "ERROR: Switch -N only takes A (for ALL)!" );
               }
            }
            break;

         case 'R':    // Recursive
         //case 'T':
            cp++;
            if( *cp )
            {
               if( *cp == '+' )
               {
                  ta->fDeep  = TRUE;
                  ta->fShall = FALSE;
               }
               else if( *cp == '-' )
               {
                  ta->fDeep = FALSE;
                  ta->fShall = TRUE;
               }
               else if( ( cmd == 'R' ) && ( toupper( *cp ) == 'E' ) )
                  ta->fReverse = TRUE;
               else
                  dc4w_usage( "ERROR: Switch -R only takes + or -!" );
            }
            else
               ta->fDeep = TRUE;
            break;

         case 'S':   // Save a FILE LIST
            /* read letters for the save option: s,l,r,d */
            // -s[slrd][:outfile]   // note: if outfile given
            // then application will EXIT after doing the output.
            cp++;
            if( *cp != ':' )
            {
               // collect options - Each letter is bits
               while( *cp )
               {
                  c = toupper(*cp);
                  dwo = GetSaveBits( c ); // see BIT2STG sSaveOpts[] = { in dc4wUtil.c
                  if(dwo)
                  {
                     //case 'S': ta->saveopts |= INCLUDE_SAME;
                     //case 'L': ta->saveopts |= INCLUDE_LEFTONLY;
                     //case 'R': ta->saveopts |= INCLUDE_RIGHTONLY;
                     //case 'D': ta->saveopts |= INCLUDE_ALLDIFF;
                     if(cp[1] == '-')
                     {
                        cp++;
                        ta->saveopts &= ~(dwo);
                     }
                     else
                        ta->saveopts |= dwo;

                     // special case
                     if(dwo & FULL_NAMES)
                     {
                        if( ISNUM(cp[1]) )
                        {
                           cp++;
                           c = *cp;
                           if( ( c == '1' ) || ( c == '2' ) || ( c == '3' ) )
                           {
                              if(c == '1')
                                 dwo = FLEFT_NAME;
                              else if(c == '2')
                                 dwo = FRIGHT_NAME;
                              else
                                 dwo = COMBINED_NAME;
                              ta->saveopts |= dwo;
                           }
                           else
                           {
                              dc4w_usage(NULL);
                              return;
                           }
                        }
                        else
                        {
                           ta->saveopts |= FLEFT_NAME;
                        }
                     }
                  }
                  else
                  {
                     char * pcmd = argv[i];
                     dc4w_usage_save( pcmd );
                     return;
                  }

                  cp++;    // bump to NEXT
                  if( *cp == ':' )  // reached OUPUT file
                     break;
               }
            }

            // if there IS an OUPUT file
            if( *cp == ':' )
            {
               cp++;
               if( *cp )
               {
                  // make sure we have some of
                  // say (INCLUDE_LEFTONLY | INCLUDE_ALLDIFF | INCLUDE_HEADER);
                  // upper bits are ALL options, and diff is now 2 (newer|older)
                  if( ta->saveopts == 0 )
                  {
                     ta->saveopts = INC_ALLXSM;
                  }
                  else if(( ta->saveopts & INC_OUTLINE) == 0 )
                  {
                     ta->saveopts = (INCLUDE_ALLDIFF | INC_ALLONLY);
                  }
                  ta->pSaveList = &ta->szSaveList[0];
                  strcpy( ta->pSaveList, cp );  // NOTE: setting this causes prog. to exit
               }
            }
            break;

         case 'T':
            cp++;
            cmd = toupper(*cp);
            flg = FALSE;
            if(( cmd == 0 ) || ( cmd == 'E' ) || ( cmd == '+' )) {
               flg = TRUE; //  TRUE;
            } else if(( cmd == 'O' )||( cmd == '-' )) {
               flg = FALSE;   // FALSE;
            } else {
               dc4w_usage( "ERROR: T switch is -T[E|+] only!" );
            }
            ToggleBool( &gbIgnDT, &gbChgIDT, flg );
            break;
         case 'X':   // EXCLUDE D=Directories F=Files, or -X+11 to exclude List11 [Exclude]
            // note: -x+0 is an error, since default is ZERO = First of list = List1= in INI
            cp++; // bump to next
            cmd = toupper(*cp);  // get after the -X
            if( (cmd == '-') || (cmd == '+') )  // got MINUS or PLUS
            {
               if( cmd == '-' )
               {
                  // -x- DISABLES EXCLUDES
                  gbExclude = FALSE;   // disable GLOBAL EXCLUDE list
               }
               else
               {
                  gbExclude = TRUE;
                  cp++;
                  if( *cp )
                  {
                     if( !ISNUM(*cp) )
                        goto Bad_XP;

                     c = atoi( cp );   // get number
                     if( c && ( c <= MXXLSTS ) )
                        giCurXSel = c;
                     else
                        goto Bad_XP;
                  }
               }
               break;
            }
            cp++; // bump to next
            c = *cp; // must be a colon
            cp++; // bump to next - first dir or file name (can be in " ")

            if( ( *cp ) && ( c == ':' ) &&
                ( ( cmd == 'D' ) || ( cmd == 'F' ) ) )
            {
               if( cmd == 'D' )
                  c = GetList( &gsXDirsList, cp );
               else
                  c = GetList( &gsXFileList, cp );
            }
            else
            {
               c = '1';
            }

            if( c )  // if an ERROR
            {
Bad_XP:  // a BAD -x parameter
               dc4w_usage( "ERROR: Switch -x is -x-, -x+[nn], -xf:<file[s]> or -xd:<dir[s]>!" );
            }
            break;

#ifdef   GMUZ
         case 'Z':   // one of the COMPARES is a ZIP file
            cp++; // bump to next
            if(( dir_isvalidfile(cp) ) &&
               ( IsValidZip(cp)      ) )
            {
               if( ta->pFirst == NULL )
               {
                  strcpy( ta->szFirst, cp );
                  ta->pFirst = &ta->szFirst[0];
                  ta->dwFlag |= tf_LeftisZip;
               }
               else if( ta->pSecond == NULL )
               {
                  strcpy( ta->szSecond, cp );
                  ta->pSecond = &ta->szSecond[0];
                  ta->dwFlag |= tf_RightisZip;
               }
               else
               {
                  dc4w_usage(NULL);
                  return;
               }
            }
            else
            {
               dc4w_usage(NULL);
               return;
            }
            break;
#endif   // GMUZ

         default:
            dc4w_usage(NULL);
            return;
         }
      }
      else if( c == '@' )
      {
         // an INPUT file
         cp++;
         if( !ProcessInput( ta, cp ) )
         {
            dc4w_usage(NULL);
            return;
         }
      }
      else
      {
         if( ta->pFirst == NULL )
         {
            strcpy( ta->szFirst, argv[i] );
            ta->pFirst = &ta->szFirst[0];
         }
         else if( ta->pSecond == NULL )
         {
            strcpy( ta->szSecond, argv[i] );
            ta->pSecond = &ta->szSecond[0];
         }
         else
         {
            dc4w_usage(NULL);
            return;
         }
      }
   }
}


// eof - dc4wHelp.c
