

// dc4wMenu.c
// this is public domain software - praise me, if ok, just don't blame me!
#include "dc4w.h"

#define   ADD_EXCLUDE_FILE // if selected, offer to exclude it from LIST

#undef   ADDVIEWUPDATE2    // this is an UNFINISHED quick update without review
#undef   DONEUPDCHK2       // this was supposed to be a FAST one file update (L->R)

// if BUSY (on thread working or in dialog asking)
extern   BOOL     gfBusy;  // only add ABORT to context menu
// verify that the SELECTED item (ie in expanded mode or outline with one selected)
extern   BOOL  CopyOneIsOK( PCFDLGSTR  pcfds );
extern   BOOL  DeleteOneIsOK( PCFDLGSTR pcfds );
extern   INT      giSelection;    // = -1 if NONE, or is selected row in table
extern   DWORD       g_dwviewedcnt;
// helper services, like c = GetList( &gsXFileList, cp );
extern INT GetList( PLE pHead, LPTSTR cp );

// forward references
VOID  SetUpdateLabel(LPTSTR lpb, PCFDLGSTR pcfds);
VOID  SetDeleteLabel(LPTSTR lpb, PCFDLGSTR pcfds);
DWORD GetCopiableCount( VOID );
DWORD GetListableCount( VOID );
DWORD GetOutlineCount( VOID );


#define  AM(a,b)  AppendMenu(hMenu,uFlags,a,b)

// data
CC    g_sListCnt;
CC    g_sOutCnt;

//        POPUP "&List View Control"
//        BEGIN
//            MENUITEM "&Off",                        IDM_LISTVIEWOFF
//         CMI( IDM_LISTVIEWOFF, g_hListView );
//         if(g_hListView)
//         {
//            MENUITEM "&50%",                        IDM_LISTVIEW50
//            MENUITEM "&100%",                       IDM_LISTVIEW100
BOOL  g_bIn5050 = TRUE;

// There are some interesting posibilities concerning the current file list on view
// - Could be ONLY left
// - or ONLY right
// - or ONLY left and ONLY right
// else mixed display
//
///////////////////////////////////////////////////////////////////////////////
// FUNCTION   : tb_WM_RBUTTONDOWN
// Return type: BOOL 
// Arguments  : HWND hwnd
//            : WPARAM wParam
//            : LPARAM lParam
// Description: Put up a context menu
//              
// NOTE: This appears to also send a WM_INITMENUPOPUP, perhaps when
// the 'command' is also in the main MENU (IDR_MENU1)!!!
//
// some list statisics
//   DWORD    dwTLeft;    // total in left
//   DWORD    dwTRite;    // total in right
//   DWORD    dwSame;     // total the same
//   DWORD    dwDiff;     // total different
//   DWORD    dwNewer;    // diff AND NEWER == POSSIBLE UPDATE!!!
//   DWORD    dwLeft;     // total left only
//   DWORD    dwRite;     // total right only
//   DWORD    dwUnk;      // this should be ZERO
// BUT NOTE the above are being ABANDONED in favour of
// g_ListTotal - total in 'combined' file list
// g_LeftCnt   - total in left tree
// g_RightCnt  - Total in right tree
// g_SameCnt   - if folders are equal these 4 totals would be the SAME

// g_NewerCnt  - if date newer - ie ready for update
// g_OlderCnt  - Maybe destination ALSO modified
// g_LeftOnly  - files ONLY in left tree
// g_RightOnly - files ONLY in right tree
//
//       if( !gbDelOn )
///////////////////////////////////////////////////////////////////////////////
//BOOL  tb_WM_RBUTTONDOWN( HWND hwnd, lpTable ptab, WPARAM wParam, LPARAM lParam )
//BOOL  tb_WM_RBUTTONDOWN( HWND hwnd, PVOID ptab_NU, WPARAM wParam, LPARAM lParam )
BOOL  tb_WM_RBUTTONDOWN( HWND hwnd, WPARAM wParam, LPARAM lParam )
{
   POINT pnt;
   HMENU hMenu;
   HWND  hWnd = hwndClient;   // get PARENT handle

   pnt.x = LOWORD(lParam);
   pnt.y = HIWORD(lParam);
   //ClientToScreen(hWnd, &pnt);
   //ClientToScreen(hwnd, &pnt);
   hMenu = CreatePopupMenu(); // create a POPUP Menu
   if(hMenu)  
   {
      UINT        uFlags, uOpts;
      INT         iCnt  = 0;
      PCFDLGSTR   pcfds = &g_sCFDLGSTR;
      DWORD       dwosv = pcfds->dwCpyOpts;
      LPTSTR      lpb   = &gszTmpBuf[0];
      BOOL        bZip;
      INT         itot = view_gettotcount(current_view);
      INT         icnt = view_getrowcount(current_view);
      INT         icnt2;   // actionable items per present options
      INT         state;   // = compitem_getstate(ci);
      DWORD       dwFlag;
      COMPITEM    ci = view_getitem( current_view, giSelection );
      DIRITEM     diritem = 0;
      PCPYTST     pct = &pcfds->cf_sDeleTest;

      //LRESULT  lr;
      //RECT     rc;
      sprtf( "CONTEXT MENU: Right button down at %d,%d"MEOR,
         GET_X_LPARAM(lParam),
         GET_Y_LPARAM(lParam) );
      uOpts = TPM_LEFTALIGN | TPM_TOPALIGN;
      // uOpts = TPM_CENTERALIGN | TPM_VCENTERALIGN; // options
      // we COULD fiddle with these position options, but it seems the
      // windows UI already does some of this so forget it for now ...
      // GetClientRect(hwnd, &rc);
     	// Add the cut, copy, paste verbs enabled or disable accordingly

      uFlags = MF_STRING | MF_BYCOMMAND;

      if( gfBusy )
      {
         if( AppendMenu(hMenu, uFlags, IDM_ABORT, "ABORT!" ) )
            iCnt++;
         goto Add_Sep;
      }

      // if a ZIP then some things are NOT possible
      // like update / copy *** TBD *** extract the file data, and do the COPY
      // if it is FROM the ZIP to the RIGHT (real) folder
      bZip = view_haszip(current_view);
      state = compitem_getstate(ci);
      pcfds->cf_sCopyTest.ct_iState = state; // get the ci state
      pcfds->cf_sDeleTest.ct_iState = state;
      dwFlag = compitem_getflag(ci);   // and the file compare flags

      //pcfds->cf_sCPYTST.ct_iState = view_getstate(current_view, giSelection);
      if( view_isexpanded(current_view) )
      {
         // NOTE: Since the selection is EXPANDED,
         // then giSelection will/could be -1 !!!
         DWORD    dwc = view_haschange( current_view, TRUE );
         //state = compitem_getstate(ci);
         //pcfds->cf_sCopyTest.ct_iState = state; // get the ci state
         //pcfds->cf_sDeleTest.ct_iState = state;
         //dwFlag = compitem_getflag(ci);   // and the file compare flags
         if(dwc)
         {
            //sprintf(lpb, "Write Changes...(%d)", dwc );
            //sprintf(lpb, "File Changes...(%d)", dwc );
            sprintf(lpb, "Write Differences (%d)...", dwc );
            if( AppendMenu(hMenu, uFlags, IDM_WRITEDIFF, lpb ) )
               iCnt++;
         }
         //else
         //{
         //   if( AppendMenu(hMenu, uFlags, IDM_WRITEDIFF, "Write Changes..." ) )
         //      iCnt++;
         //}

         if( !bZip ) // if we are NOT a ZIP compare
         {
            // and we are viewing the 'difference' between the two files, and
            // the next 'likely' action is to immediately UPDATE this 'pair'
            // if it is left only, then offer to "Copy [filename] Left Only"
            // if it is right only, then offer to "Delete [filename] Right Only"
            // if it is newer, offer "Update [filename] with Newer"
            // if it is OLDER, offer "OVERWRITE [filename] with Older"
            // if it is the SAME, then offer nothing here
            pcfds->cf_sCopyTest.ct_szSTitle[0] = 0;
//            pcfds->dwCpyOpts = COPY_FROMLEFT|INCLUDE_LEFTONLY|INCLUDE_DIFFER|INCLUDE_SAME;
//            pcfds->dwCpyOpts = INCLUDE_LEFTONLY|INCLUDE_DIFFER|INCLUDE_SAME;
            pcfds->dwCpyOpts = outline_include;
            if(( state != STATE_SAME  ) &&
               ( CopyOneIsOK( pcfds ) ) ) // in expanded the compitem is already set - selected
            {
               // offer to COPY or DELETE
               SetUpdateLabel(lpb, pcfds);
               if( AppendMenu(hMenu, uFlags, IDM_UPDFILE, lpb) )
                  iCnt++;
            }
   
            //pcfds->cf_sDeleTest.ct_szSTitle[0] = 0;
            //if( DeleteOneIsOK( pcfds ) )
            //{
            //   SetDeleteLabel(lpb, pcfds);
            //   if( AppendMenu(hMenu, uFlags, IDM_DELETEFILE, lpb) )
            //      iCnt++;
            //}
            pcfds->dwCpyOpts = dwosv;

            if( view_getrowcount(current_view) > 1 )
            {
               if( AppendMenu(hMenu, uFlags, IDM_VIEW_NEXT, "Next Compare" ) )
                  iCnt++;
            }

            if( AM( IDM_OUTLINE, "To Outline" ) )
               iCnt++;

            if( AppendMenu(hMenu, uFlags, IDM_COPYFILES, "Copy Files..." ) )
               iCnt++;
         }
         else  // IT IS ZIP
         {
            if( view_getrowcount(current_view) > 1 )
            {
               if( AppendMenu(hMenu, uFlags, IDM_VIEW_NEXT, "Next Compare" ) )
                  iCnt++;
            }
            if( AM( IDM_OUTLINE, "To Outline" ) )
               iCnt++;
         }

         //if( AM( IDM_OUTLINE, "To Outline" ) )
         //   iCnt++;

      }
      else if( current_view ) // NOT Expanded = Outline file list view
      {
         // *** OUTLINE = List of files is on VIEW ***
         // ******************************************
         //COMPITEM ci = view_getitem( current_view, giSelection );
         //state = compitem_getstate(ci);
         //dwFlag = compitem_getflag(ci);   // and the file compare flags

//         INT itot = view_gettotcount(current_view);
         if(itot == 0)
            goto Add_Sep;  // nothing to do here

         //if( AppendMenu(hMenu, uFlags, IDM_SAVELIST, "Save List..." ) )
         icnt2 = GetListableCount();
         if( g_bListSave == 0 )
         {
            lpb = GetStgBuf();
            if( icnt2 )
               sprintf( lpb, "Write List (%d of %d) ...", icnt2, itot );
            else
               sprintf( lpb, "Write List File (%d)...", itot );
            if( AppendMenu(hMenu, uFlags, IDM_SAVELIST, lpb) )
               iCnt++;
         }

         // *** TBD *** do NOT add this if all that remains in the compare
         // lists (left and/or right) only left or right
         if( AppendMenu(hMenu, uFlags, IDM_WRITEDIFF, "Write Difference File..." ) )
            iCnt++;

         if( !bZip ) // ZIP functionality severely limited at present, so
         {
            GetOutlineCount();   // get counts for current view

            icnt2 = GetCopiableCount();
//            if( AppendMenu(hMenu, uFlags, IDM_COPYFILES, "Copy Files..." ) )
            lpb = GetStgBuf();

            //sprtf( "Presently %d of %d on view (%d only)."MEOR,
            //   g_sOutCnt.cnt2,
            //   g_sOutCnt.cnt1,
            //   g_sOutCnt.cnt3 );
            icnt2 = g_sOutCnt.cnt2; // get the SET on view = outline_include
            if( itot && icnt2 )
            {
               *lpb = 0;
               //sprintf(lpb, "Update L->R (%d of %d)", icnt2, itot );
               if(( g_sOutCnt.cnt2 == g_sOutCnt.cnt3   ) &&  // ONLY left/right only on display
                  ( ( ( g_sOutCnt.cnt2 == g_dwLeft ) ||
                      ( g_sOutCnt.cnt2 == g_dwRite ) ) ) )
               {
                  sprintf(lpb, "Update %d per View!", icnt2 );
                  if( g_sOutCnt.cnt2 == g_dwLeft )
                  {
                     //sprintf(lpb, "Update %d per View!", icnt2 );
                  } //else if( ( gbDelOn ) && (g_sOutCnt.cnt2 == g_dwRite) )
                  else if( g_sOutCnt.cnt2 == g_dwRite )
                  {
                     if( gbDelOn )
                     {
                        sprintf(lpb, "Delete %d per View!", icnt2 );
                        if( g_sZipArgs.bZipOk ) // TRUE if return is WAIT_OBJECT_0
                           strcat(lpb, " (ZipOk)");

                        if( AppendMenu(hMenu, uFlags, IDM_DELETEFILE, lpb) )
                           iCnt++;
                     }
                     else
                     {
                        strcpy(lpb, "Enable DELETE function!");
                        if( AppendMenu(hMenu, uFlags, IDM_ENABLEDELETE, lpb) )
                           iCnt++;
                     }

                     *lpb = 0;   // addition already done, so clear buffer
                  }
               }
               else
               {
#ifdef   ADDVIEWUPDATE2
                  sprintf(lpb, "Update per View! (%d of %d)", icnt2, itot );
#endif   // #ifdef   ADDVIEWUPDATE2
               }

               if( *lpb )
               {
                  if( AppendMenu(hMenu, uFlags, IDM_FILECOPY, lpb ) )
                     iCnt++;
               }
            }

            if( giSelection != pcfds->cf_iSelected )
               chkme( "WARNING: A global pair is out of sync!"MEOR );

#ifdef   DONEUPDCHK2
            // this was supposed to be a FAST one file update (L->R)
            // or perhaps later *** TBD *** a quick DELETE of an orphaned files
            // especially if it belongs to one of the exclude sets.
            // Also *** TBD *** add EXCLUDE directories which does work, I think
            // from the command line but no dialog yet

            if( pcfds->cf_iSelected != -1 )
            {
               pcfds->cf_sCopyTest.ct_szSTitle[0] = 0;
//               pcfds->dwCpyOpts = COPY_FROMLEFT|INCLUDE_LEFTONLY|INCLUDE_DIFFER|INCLUDE_SAME;
               pcfds->dwCpyOpts = INCLUDE_LEFTONLY|INCLUDE_DIFFER|INCLUDE_SAME;
               if( CopyOneIsOK( pcfds ) )
               {
                  SetUpdateLabel(lpb, pcfds);
                  if( AppendMenu(hMenu, uFlags, IDM_UPDFILE, lpb) )
                     iCnt++;
               }
      
               pcfds->cf_sDeleTest.ct_szSTitle[0] = 0;
               if( DeleteOneIsOK( pcfds ) )
               {
                  SetDeleteLabel(lpb, pcfds);
                  //if( AppendMenu(hMenu, uFlags, IDM_DELETEFILE, lpb) )
                  if( AppendMenu(hMenu, uFlags, IDM_DELETEONE, lpb) )
                     iCnt++;
               }
               pcfds->dwCpyOpts = dwosv;
            }

#endif   // #ifdef   DONEUPDCHK2

            // if a SELECTION, and is RIGHT ONLY
            // =========================================
            if( ci && ( state == STATE_FILERIGHTONLY ) )
            {
               // candidate for a SINGLE delete
               diritem = file_getdiritem(compitem_getrightfile(ci));
               if(( diritem ) &&
                  ( dir_deletetest( pct, diritem ) ) )
               {
                  // part of test fills in -
                  // SplitFN( NULL, &pct->ct_szSTitle[0], pfn ); // and get JUST the file
                  if( gbDelOn )
                  {
                     SetDeleteLabel(lpb, pcfds);
                     if( AM( IDM_DELETEONE, lpb ) )
                        iCnt++;
                  }
                  else
                  {
                     strcpy(lpb, "Enable DELETE function!");
                     if( AM( IDM_ENABLEDELETE, lpb) )
                           iCnt++;
                  }
               }
            }     // end if a SELECTION, and is RIGHT ONLY
            // =========================================


            // This is the standard copy files dialog
            // **************************************
            sprintf(lpb, "Copy Files (%d of %d)...", icnt, itot );
            if( AppendMenu(hMenu, uFlags, IDM_COPYFILES, lpb ) )
               iCnt++;
            // **************************************

         }  // if NOT bZip

         // this is also 'supposed' to work with ZIP files
         // but failed on last try ...
         if( ( current_view != NULL ) && ( giSelection >= 0 ) )
         {
            sprintf(lpb, "Expand Selection %d", (giSelection + 1) );
            if( AM( IDM_EXPAND, lpb ) )
               iCnt++;
         }
         // **********************************************

#ifdef   ADD_EXCLUDE_FILE
            if( giSelection != -1 ) {
               // have a SELECTION
               if(ci) {
                  DIRITEM diritem;  // = file_getdiritem(compitem_getleftfile(ci));
                  if( state == STATE_FILERIGHTONLY )
                     diritem = file_getdiritem(compitem_getrightfile(ci));
                  else
                     diritem = file_getdiritem(compitem_getleftfile(ci));

                  if(diritem) {
                     // we have our FILE names
                     //char * relname  = dir_getrelname(diritem);
                     //char * cp = relname;
                     //if(*cp=='.')   cp++;
                     //if(*cp=='\\')  cp++;
                     char * cp = dir_getnameptr(diritem);

                     sprintf(lpb, "Exclude [%s]", cp);

                     if( AM( IDM_EXCLUDE, lpb ) )
                        iCnt++;

                     //dir_freerelname( diritem, relname );
                  }
               }  // got the COMPITEM of the SELECTION

            }
#endif   // ADD_EXCLUDE_FILE

      }

Add_Sep:

      if(iCnt)
         AppendMenu(hMenu, MF_SEPARATOR, 0, 0 );

//      AM( IDM_DIR,   "Compare Directories ...");
      AM( IDM_DIR,   "Change Directories ...");
      AM( IDM_FILE,  "Compare TWO Files ..."       );

//      AppendMenu(hMenu, MF_SEPARATOR, 0, 0    );
//      AM( IDM_PRINT, "Print..."               );

      AppendMenu(hMenu, MF_SEPARATOR, 0, 0    );
      AM( IDM_EXIT,  "Exit!"                  );

      SBSetTimedTxt( "Context Menu: Choose item from the CONTEXT MENU!", 15, FALSE );

      // TrackPopupMenu()
      TrackPopupMenu( hMenu,         // handle to shortcut menu
         uOpts,   // TPM_CENTERALIGN | TPM_VCENTERALIGN, // options
         pnt.x,   // horizontal position
         pnt.y,   // vertical position
         0,       // reserved, must be zero
         hWnd,    // handle to owner window
         0 );     // ignored

      SBSetTimedTxt( "Destroying the CONTEXT MENU!", 2, FALSE );

      DestroyMenu(hMenu);

      // sprtf( "CONTEXT MENU: Destroyed."MEOR );

   }
   else
   {
      chkme( "WARNING: CreatePopupMenu() FAILED!!!"MEOR );
   }

   return TRUE;
}

// utility functions
VOID  AppendSStateShort(LPTSTR lpb, INT iState )
{
   if( iState == STATE_FILELEFTONLY )
      strcat(lpb, " LO");
   else if( iState == STATE_FILERIGHTONLY )
      strcat(lpb, " RO");
   else if( iState == STATE_DIFFER )
      strcat(lpb, " DF");
   else if( iState == STATE_SAME )
      strcat(lpb, " SM");
   else
      strcat(lpb, " ??");
}

VOID  AppendSState(LPTSTR lpb, INT iState )
{
   if( iState == STATE_FILELEFTONLY )
      strcat(lpb, " Left Only");
   else if( iState == STATE_FILERIGHTONLY )
      strcat(lpb, " Right Only");
   else if( iState == STATE_DIFFER )
      strcat(lpb, " Different");
   else if( iState == STATE_SAME )
      strcat(lpb, " Same");
   else
      strcat(lpb, " ??");
}

VOID  AppendStateFlag(LPTSTR lpb, INT iState, DWORD dwFlag )
{
   if( iState == STATE_FILELEFTONLY )
      strcat(lpb, " Left Only");
   else if( iState == STATE_FILERIGHTONLY )
      strcat(lpb, " Right Only");
   else if( iState == STATE_DIFFER )
   {
      //strcat(lpb, " Different");
      if( dwFlag & TT_OLDER )
         strcat(lpb, " Older!");
      else
         strcat(lpb, " Newer.");
   }
   else if( iState == STATE_SAME )
      strcat(lpb, " Same");
   else
      strcat(lpb, " ??");
}

VOID  SetUpdateLabel(LPTSTR lpb, PCFDLGSTR pcfds)
{
   LPTSTR   lpf = &pcfds->cf_sCopyTest.ct_szSTitle[0];
   if( *lpf )
   {
//            pct->ct_ci      = ci;
//            pct->ct_iState  = compitem_getstate(ci);    // state of the entry
//            pct->ct_dwFlag  = compitem_getflag(ci);
      INT state = pcfds->cf_sCopyTest.ct_iState;
      DWORD dwFlag = pcfds->cf_sCopyTest.ct_dwFlag;   // get the FLAG
      //sprintf(lpb, "Update [%s]", lpf );
      *lpb = 0;
      switch(state)
      {
      case STATE_SAME:
         strcat(lpb, "Change ");
         break;
      case STATE_DIFFER:
         if( dwFlag & TT_OLDER )
            strcat(lpb, "OVERWRITE ");
         else
            strcat(lpb, "Update ");
         break;
      case STATE_FILELEFTONLY:
         strcat(lpb, "Copy ");
         break;
      case STATE_FILERIGHTONLY:
         strcat(lpb, "DELETE ");
         break;
      }

      sprintf(EndBuf(lpb), "[%s]", lpf );

      //AppendSState(lpb, state );
      AppendStateFlag(lpb, state, dwFlag );

   }
   else
   {
      strcpy(lpb, "Update File?");
   }
}

VOID  SetDeleteLabel(LPTSTR lpb, PCFDLGSTR pcfds)
{
   LPTSTR   lpf = &pcfds->cf_sDeleTest.ct_szSTitle[0];
   if( *lpf )
   {
      INT state = pcfds->cf_sDeleTest.ct_iState;
      sprintf(lpb, "Delete [%s]", lpf );
      AppendSState(lpb, state );
   }
   else
   {
      strcpy(lpb, "Delete File?");
   }
}


DWORD GetOutlineCount( VOID )
{
//   CC       scc;
//   PCC      pcc = &scc;
   PCC      pcc = &g_sOutCnt;
   ZeroMemory( pcc, sizeof(CC) );
   pcc->bUseOpt = TRUE;
   pcc->dwopts  = outline_include;
   complist_countlistable( pcc );
   return( pcc->cnt2 );
}

// *** TBD *** These do NOT look correct CHECK
DWORD GetListableCount( VOID )
{
//   CC       scc;
//   PCC      pcc = &scc;
   PCC      pcc = &g_sListCnt;
   ZeroMemory( pcc, sizeof(CC) );
   pcc->bUseOpt = TRUE;
   //pcc->dwopts  = gdwFileOpts;
   //pcc->dwopts = GetFileOpts();
   pcc->dwopts  = outline_include;
   complist_countlistable( pcc );
   return( pcc->cnt2 );
}

DWORD GetCopiableCount( VOID )
{
   CC       scc;
   PCC      pcc = &scc;
   DWORD    dwo = gdwFileOpts;
   ZeroMemory( pcc, sizeof(CC) );
   pcc->bUseOpt = TRUE;
   //pcc->dwopts  = gdwFileOpts;
   //pcc->dwopts = GetFileOpts();
   pcc->dwopts  = outline_include;
   complist_countcopiable( pcc );
   return( pcc->cnt2 );
}

#define  MENU_FILE      0
#define  MENU_EDIT      1
#define  MENU_VIEW      2
#define  MENU_EXPAND    3
#define  MENU_OPTIONS   4
#define  MENU_ABOUT     5

//IDR_MAINMENU MENU DISCARDABLE 
//BEGIN
//    POPUP "&File"
//    BEGIN
//        MENUITEM "Compare &Directories...",     IDM_DIR
//        MENUITEM "&Next in List",               IDM_NEXTINLIST
//        MENUITEM "Select TWO &Files ...",       IDM_FILE
//        MENUITEM SEPARATOR
//        MENUITEM "&Abort",                      IDM_ABORT
//        MENUITEM SEPARATOR
//        MENUITEM "&Save File List...",          IDM_SAVELIST
//        MENUITEM "&Write Difference...",        IDM_WRITEDIFF
//        MENUITEM "C&opy Files...",              IDM_COPYFILES
//        MENUITEM "&Update Now\tAlt+U",          IDM_FILECOPY
//        MENUITEM SEPARATOR
//        MENUITEM "&Print",                      IDM_PRINT
//        MENUITEM SEPARATOR
//        MENUITEM "E&xit",                       IDM_EXIT
//    END
//    POPUP "&Edit"
//    BEGIN
//        MENUITEM "&Copy\tCtrl+C",               IDM_EDITCOPY, GRAYED
//        MENUITEM SEPARATOR
//        MENUITEM "Edit &Left File",             IDM_EDITLEFT
//        MENUITEM "Edit &Right File",            IDM_EDITRIGHT
//        MENUITEM "Edit &Composite File",        IDM_EDITCOMP
//        MENUITEM SEPARATOR
//        MENUITEM "&Set Editor...",              IDM_SETEDIT
//        MENUITEM "&Edit Exclude List ...",      IDM_EDITEXCLUDE
//    END
//    POPUP "&View"
//    BEGIN
//        MENUITEM "&Outline",                    IDM_OUTLINE
//        MENUITEM "&Expand",                     IDM_EXPAND
//        MENUITEM SEPARATOR
//        MENUITEM "Show &Picture Bar\tAlt+P",    IDM_PICTURE
//        MENUITEM "Bottom Status Bar",           IDM_ADDSTATUS
//        MENUITEM SEPARATOR
//        MENUITEM "&Previous Change\tF3",        IDM_FPCHANGE
//        MENUITEM "&Next Change\tF4",            IDM_FCHANGE
//        MENUITEM SEPARATOR
//        MENUITEM "Expand Next &File\tF5",       IDM_VIEW_NEXT
//        MENUITEM "&Reverse L/R",                IDM_REVERSE
//        MENUITEM "R&efresh Display",            IDM_REFRESH
//        MENUITEM "&Use Exclude List",           IDM_USEEXCLUDE
//        POPUP "&List View Control"
//        BEGIN
//            MENUITEM "&Off",                        IDM_LISTVIEWOFF
//            MENUITEM "&50%",                        IDM_LISTVIEW50
//            MENUITEM "&100%",                       IDM_LISTVIEW100
//        END
//    END
//    POPUP "Ex&panded"
//    BEGIN
//        MENUITEM "Le&ft File Only\tAlt+L",      IDM_LONLY
//        MENUITEM "Rig&ht File Only\tAlt+R",     IDM_RONLY
//        MENUITEM "B&oth Files\tAlt+B",          IDM_BOTHFILES
//        MENUITEM SEPARATOR
//        MENUITEM "&Left Line Numbers",          IDM_LNRS
//        MENUITEM "&Right Line Numbers",         IDM_RNRS
//        MENUITEM "Add Line &Numbers",           IDM_NONRS
//        MENUITEM SEPARATOR
//        MENUITEM "Show E&qual Lines",           IDM_SHOWSAME
//        MENUITEM "Show &Moved Lines",           IDM_SHOWMOVE
//        MENUITEM "Add &Tag",                    IDM_SHOWTAG
//        MENUITEM SEPARATOR
//        MENUITEM "Ignore &Blanks",              IDM_IGNBLANKS
//        MENUITEM "Ignore EOL",                  IDM_IGNOREEOL
//        MENUITEM "Ignore &Case",                IDM_IGNCASE
//    END
//    POPUP "&Outline"
//    BEGIN
//        POPUP "File List &Options"
//        BEGIN
//            MENUITEM "Show &Identical\tCtrl+I",     IDM_INCSAME
//            MENUITEM "Show &Left-Only Files\tCtrl+L", IDM_INCLEFT
//            MENUITEM "Show &Right-Only Files\tCtrl+R", IDM_INCRIGHT
//            MENUITEM "Show All &Different",         IDM_DIFFALL
//            MENUITEM "Show &Newer Files\tCtrl+N",   IDM_NEWER
//            MENUITEM "Show &Older Files\tCtrl+O",   IDM_OLDER
//            MENUITEM SEPARATOR
//            MENUITEM "Clear Viewed Flag",           IDM_CLEARVIEWED, GRAYED
//        END
//        MENUITEM SEPARATOR
//        MENUITEM "&Full File Compare",          IDM_OPTEXACT
//        MENUITEM "Ignore &Blanks",              IDM_IGNBLANKS
//        MENUITEM "&Ignore File Times",          IDM_OPTIGNOREDT, GRAYED
//        MENUITEM SEPARATOR
//        MENUITEM "Re&cursive",                  IDM_RECURSIVE
//        MENUITEM "E&xclude per List",           IDM_OPTEXCLUDE
//        MENUITEM "Exclude &File",               IDM_EXCLUDE
//        MENUITEM SEPARATOR
//        MENUITEM "Sh&ow Row Numbers",           IDM_OPTADDROW, CHECKED
//        MENUITEM "&Warn on Next Find\tCtrl+W",  IDM_WARNING
//        MENUITEM "Show &Tool Tip",              IDM_SHOWTOOLTIP
//        MENUITEM "&Show Copy Dialog",           IDM_SHOWCOPY
//        MENUITEM "&Preferences...",             IDM_PREFERENCES
//        MENUITEM "&Enable *** DELETE ***",      IDM_ENABLEDELETE
//    END
//    POPUP "&Help"
//    BEGIN
//        MENUITEM "&About...Ctrl+H",             IDM_ABOUT
//    END
//END


BOOL  IsViewExpBoth( VOID )
{
   BOOL  bRet = FALSE;
   if( ( view_isexpanded( current_view ) ) &&
       ( expand_mode == IDM_BOTHFILES    ) )
   {
      bRet = TRUE;
   }
   return bRet;
}


///////////////////////////////////////////////////////////////////////////////
// FUNCTION   : IsViewExpFile
// Return type: BOOL 
// Argument   : VOID
// Description: 
//              
// NOTE: The function complist_isfiles( cl ) only advise IF the original entry
// were both files, rather than directories!
///////////////////////////////////////////////////////////////////////////////
BOOL  IsViewExpFile( VOID )
{
   BOOL  bRet = FALSE;
   COMPLIST cl = view_getcomplist( current_view );
   if( ( cl              ) &&
       ( IsViewExpBoth() ) &&
       ( view_haschange( current_view, FALSE ) ) )
   {
      bRet = TRUE;
   }
   return bRet;
}

typedef struct tagCMD2STG {
   LPTSTR   pstg;
   UINT     uid;
}CMD2STG, * PCMD2STG;

CMD2STG  sCmd2Stg[] = {
//IDR_MENU1 MENU DISCARDABLE 
//BEGIN
//    POPUP "&File"
//    BEGIN
   { "Compare &Directories...",     IDM_DIR },
   { "&Next in List",               IDM_NEXTINLIST },
   { "Select TWO &Files ...",       IDM_FILE },
//   { SEPARATOR
   { "&Abort",                      IDM_ABORT },
//   { SEPARATOR
   { "&Save File List...",          IDM_SAVELIST },
   { "&Write Difference...",        IDM_WRITEDIFF },
   { "C&opy Files...",              IDM_COPYFILES },
   { "&Update Now\tAlt+U",          IDM_FILECOPY },
//   { SEPARATOR
   { "&Print",                      IDM_PRINT },
//   { SEPARATOR
   { "E&xit",                       IDM_EXIT },
//    END
//    POPUP "&Edit"
//    BEGIN
   { "Edit &Left File",             IDM_EDITLEFT },
   { "Edit &Right File",            IDM_EDITRIGHT },
   { "Edit &Composite File",        IDM_EDITCOMP },
//   { SEPARATOR
   { "&Set Editor...",              IDM_SETEDIT },
   { "&Edit Exclude List ...",      IDM_EDITEXCLUDE },
//    END
//    POPUP "&View"
//    BEGIN
   { "&Outline",                    IDM_OUTLINE },
   { "&Expand",                     IDM_EXPAND },
//   { SEPARATOR
   { "Show &Picture Bar\tAlt+P",    IDM_PICTURE },
   { "Bottom Status Bar",           IDM_ADDSTATUS },
//   { SEPARATOR
   { "&Previous Change\tF3",        IDM_FPCHANGE },
   { "&Next Change\tF4",            IDM_FCHANGE },
//   { SEPARATOR
   { "Expand Next &File\tF5",       IDM_VIEW_NEXT },
   { "&Reverse L/R",                IDM_REVERSE },
   { "R&efresh Display",            IDM_REFRESH },
//        POPUP "&List View Control"
//        BEGIN
   { "&Off",                        IDM_LISTVIEWOFF },
   { "&50%",                        IDM_LISTVIEW50  },
   { "&100%",                       IDM_LISTVIEW100 },
//        END
//    END
//    POPUP "Ex&pand"
//    BEGIN
   { "Le&ft File Only\tAlt+L",      IDM_LONLY },
   { "Rig&ht File Only\tAlt+R",     IDM_RONLY },
   { "B&oth Files\tAlt+B",          IDM_BOTHFILES },
//   { SEPARATOR
   { "&Left Line Numbers",          IDM_LNRS },
   { "&Right Line Numbers",         IDM_RNRS },
   { "&No Line Numbers",            IDM_NONRS },

   { "Show E&qal Line",             IDM_SHOWSAME },
   { "Show &Moved Lines",           IDM_SHOWMOVE },
   { "Add &Tags",                   IDM_SHOWTAG  },

   { "Ignore &Blanks",              IDM_IGNBLANKS },
   { "Ignore EOL",                  IDM_IGNOREEOL },
   { "Ignore &Case",                IDM_IGNCASE   },
//    END
//    POPUP "&Options"
//    BEGIN
   { "Show &Identical Files\tCtrl+I", IDM_INCSAME },
   { "Show &Left-Only Files\tCtrl+L", IDM_INCLEFT },
   { "Show &Right-Only Files\tCtrl+R", IDM_INCRIGHT },
   { "Show All &Different",         IDM_DIFFALL },
   { "Show &Newer Files\tCtrl+N",   IDM_NEWER },
   { "Show &Older Files\tCtrl+O",   IDM_OLDER },
//   { SEPARATOR
   { "&Full File Compare",          IDM_OPTEXACT },
   { "Ignore &Blanks",              IDM_IGNBLANKS },
   { "&Ignore File Time",           IDM_OPTIGNOREDT },
//   { SEPARATOR
   { "Re&cursive",                  IDM_RECURSIVE },
   { "E&xclude per List",           IDM_OPTEXCLUDE },
//   { SEPARATOR
   { "Sh&ow Row Numbers",           IDM_OPTADDROW  },
   { "&Warn on Next Find\tCtrl+W",  IDM_WARNING  },
   { "Show &Tool Tip",              IDM_SHOWTOOLTIP  },
   { "&Show Copy Dialog",           IDM_SHOWCOPY  },
   { "&Preferences...",             IDM_PREFERENCES  },
   { "&Enable *** DELETE ***",      IDM_ENABLEDELETE },
//    END
//    POPUP "&Help"
//    BEGIN
   { "&About...Ctrl+H",             IDM_ABOUT },
//    END
//END
   // *** last record ***
   { 0, 0 }
};

LPTSTR   Cmd2Stg( UINT uid )
{
   PCMD2STG pc = &sCmd2Stg[0];
   while( pc->pstg )
   {
      if( pc->uid == uid )
         break;
      pc++;
   }
   return pc->pstg;
}

#undef  ADDMENUMOD

BOOL  g_bDbgPOP = FALSE;

#define  mf_Enab     (MF_BYCOMMAND | MF_ENABLED)
#define  mf_Disab    (MF_BYCOMMAND | MF_DISABLED | MF_GRAYED)
#define  EMI(a,b) EnableMenuItem(hMenu, a, ((b) ? mf_Enab : mf_Disab))
#define  CMI(a,b) CheckMenuItem(hMenu,  a, ((b) ? MF_CHECKED : MF_UNCHECKED) )
#define  IsExpanded     view_isexpanded( current_view )

BOOL  HaveGotUpdate( VOID )
{
   INT      icnt = view_getrowcount(current_view);
   INT      itot = view_gettotcount(current_view);
   if( icnt && itot )
      return TRUE;

   return FALSE;

}

BOOL  Got_Sel_File( LPTSTR lpb )
{
   extern BOOL  Get_Sel_File_Stg( LPTSTR lpb, COMPITEM ci );
   COMPITEM    ci = view_getitem( current_view, giSelection );
   if(ci) {
      // get CURRENT SELECTION
      if( Get_Sel_File_Stg( lpb, ci ) ) {
         return TRUE;
      }
   }
   return FALSE;
}


long  Do_WM_INITMENUPOPUP( HWND hWnd, WPARAM wParam, LPARAM lParam )
{
   long     lRet = 0;
   HMENU    hMenu = (HMENU)wParam;
   DWORD    dwPos = LOWORD(lParam);
   BOOL     bSys  = HIWORD(lParam);
   COMPLIST cl = 0;
   DWORD    dwo = outline_include;
   //UINT  ui1, ui2, ui3;
   LPTSTR   lps;
   LPTSTR   lpb  = &gszTmpBuf[0];
   BOOL     bEnab;
   LPTSTR   lpb2 = &gszTmpBuf2[0];

   if( bSys )
   {
      // is the windows (system) menu
      lRet = 1;   // use default processing
   }
   else
   {
      // it is MY menu
      if( g_bDbgPOP )
      {
         sprtf( "Do_WM_INITMENUPOPUP: For Pos=%d (%s)."MEOR,
            dwPos,
            ( (dwPos == MENU_FILE) ? "MENU_FILE" :
            (dwPos == MENU_EDIT) ? "MENU_EDIT" :
            (dwPos == MENU_VIEW) ? "MENU_VIEW" :
            (dwPos == MENU_EXPAND) ? "MENU_EXPAND" :
            (dwPos == MENU_OPTIONS) ? "MENU_OPTIONS" :
            (dwPos == MENU_ABOUT) ? "MENU_ABOUT" :
            "MENU_UNKNOWN" ) );
      }
      switch( dwPos )
      {
      case MENU_FILE:
         {
            BOOL  bZip = view_haszip(current_view);
            cl = view_getcomplist(current_view);
            if( current_view && cl )
               bSys = TRUE;
            else
               bSys = FALSE;
            EMI( IDM_SAVELIST, bSys );
            if( bZip )
            {
               // *** TBD *** Expand zip data to a file in an indicated directory
               // Compress to zip, and ADD update into zip *** TBD ***
               EMI( IDM_COPYFILES, FALSE );
               EMI( IDM_FILECOPY,  FALSE );  // immediate no dialog update
            }
            else  // NOT ZIP - we can do a LOTS
            {
               EMI( IDM_COPYFILES, bSys );
#ifdef   ADDMENUMOD
               if(bSys)
               {
                  lps = "C&opy Files...";
                  if( ( IsExpanded ) && ( gszLeftName[0] ) )
                  {
                     // LPTSTR   lpb  = &gszTmpBuf[0];
                     // LPTSTR   lpb2 = &gszTmpBuf2[0];
                     *lpb2 = 0;
                     compitem_retrelname( lpb2, ci );
                     if( ( lpb2[0] == '.' ) && ( lpb2[1] == '\\' ) )
                     {
                        strcpy( lpb, &gszLeftName[0] );
                        strcat( lpb, &lpb2[1]        );
                        if( dir_isvalidfile(lpb) )
                        {
                           sprintf(lpb, "C&opy %s", &lpb2[2]);
                           lps = lpb;
                        }
                     }
                  }
                  ModifyMenu( hMenu,           // handle to menu
                     IDM_COPYFILES,    // menu item to modify
                     (MF_BYCOMMAND | MF_STRING),     // options
                     IDM_COPYFILES,    // identifier, menu, or submenu
                     lps );   // menu item content
               }
#endif   //#ifdef   ADDMENUMOD
               EMI( IDM_FILECOPY, HaveGotUpdate() );  // if we have file count(s)
               // this depends on the left and right list of files,
               // but also on which 'display/view' options are on
            }
            EMI( IDM_WRITEDIFF, (bSys && view_haschange( current_view, FALSE )) );
         }
         break;

      case MENU_EDIT:
         break;

      case MENU_VIEW:
         if( !current_view )
         {
            // both are invalid
            EMI( IDM_OUTLINE, FALSE);
            EMI( IDM_EXPAND,  FALSE);
            EMI( IDM_FPCHANGE, FALSE);
            EMI( IDM_FCHANGE, FALSE);
            EMI( IDM_VIEW_NEXT, FALSE);
         }
         else if( view_isexpanded(current_view) )
         {
            // back to outline is ok
            EMI( IDM_OUTLINE, TRUE );
            EMI( IDM_EXPAND,  FALSE);
            EMI( IDM_FPCHANGE, TRUE);
            EMI( IDM_FCHANGE,  TRUE);
            EMI( IDM_VIEW_NEXT, TRUE);
         }
         else  // it is NOT expanded
         {
            EMI( IDM_OUTLINE, FALSE);  // so no to outline
            if( giSelection < 0 )        // and can only expand if a selection
               EMI( IDM_EXPAND,  FALSE );
            else
               EMI( IDM_EXPAND,  TRUE );
            EMI( IDM_FPCHANGE, FALSE);
            EMI( IDM_FCHANGE, FALSE);
            EMI( IDM_VIEW_NEXT, FALSE);
         }

         //CMI( IDM_ADDSTATUS, gbAddS );
         CMI( IDM_ADDSTATUS, ( !g_sSB.sb_bHidden ) );
//        MENUITEM "&Use Exclude List",
         CMI( IDM_USEEXCLUDE, gbExclude );   // Exclude per one of the lists

         CMI( IDM_OPTALTDISPLAY, gbSimple ); // check, if using alternate display info

//        POPUP "&List View Control"
//        BEGIN
//            MENUITEM "&Off",                        IDM_LISTVIEWOFF
         if(g_hListView)
            lps = "&On. To Hide";   // menu item content
         else
            lps = "&Off. To Show";

         ModifyMenu( hMenu,           // handle to menu
                     IDM_LISTVIEWOFF,    // menu item to modify
                     (MF_BYCOMMAND | MF_STRING),     // options
                     IDM_LISTVIEWOFF,    // identifier, menu, or submenu
                     lps );   // menu item content
         CMI( IDM_LISTVIEWOFF, g_hListView );
         if(g_hListView)
         {
//            MENUITEM "&50%",                        IDM_LISTVIEW50
//            MENUITEM "&100%",                       IDM_LISTVIEW100
            if( g_bIn5050 )
            {
               EMI(IDM_LISTVIEW50, FALSE );
               EMI(IDM_LISTVIEW100, TRUE );
            }
            else
            {
               EMI(IDM_LISTVIEW50, TRUE  );
               EMI(IDM_LISTVIEW100, FALSE);
            }
//        END
         }
         else
         {
            EMI(IDM_LISTVIEW50, FALSE );
            EMI(IDM_LISTVIEW100, FALSE);
         }
         break;
      case MENU_EXPAND:

         // could switch(expand_mode) { case IDM_LONLY:
         // but maybe -
         CMI( IDM_LONLY,     FALSE );
         CMI( IDM_RONLY,     FALSE );
         CMI( IDM_BOTHFILES, FALSE );
         CMI( expand_mode,   TRUE  );

//   { "&Left Line Numbers",          IDM_LNRS },
//   { "&Right Line Numbers",         IDM_RNRS },
//   { "&No Line Numbers",            IDM_NONRS },
//   case IDM_NONRS: // this is a display toggle
//TCHAR szShwNums[] = "ShowLineNumbers";
//         CMI( IDM_NONRS, gbShowNums );
         CMI( IDM_NONRS, ( gdwDiffOpts & INCLUDE_LINENUMS ) );

         CMI( IDM_LNRS,  ( !gbUseRight ) );
         CMI( IDM_RNRS,     gbUseRight   );
//TCHAR szUseRt[] = "UseRightNumbers"; // just the source of the number - if abv ON
// #define  gbUseRight     sFW.fw_bUseRight

         CMI( IDM_SHOWSAME, ( gdwDiffOpts & INCLUDE_SAME ) );  // include / exclude SAME
         CMI( IDM_SHOWMOVE, ( gdwDiffOpts & INC_ALLMOVE  ) );  // include / exclude MOVED
         CMI( IDM_SHOWTAG,  ( gdwDiffOpts & INCLUDE_TAGS ) );  // include 'tag' text
         // so can not have  if( !( gdwDiffOpts & INCLUDE_TAGS ) ) cell++; // no tags
         if( gdwDiffOpts & INCLUDE_LINENUMS )   // we have LINE NUMBERS
            EMI( IDM_SHOWTAG, FALSE);
         else
            EMI( IDM_SHOWTAG, TRUE);

         // NOTE: both these effect the hash code generated for a string
         // which is the fast primary compare of two lines from two folders
         // If these match, then the program STILL does a TCHAR by TCHAR
         // compare of the left file line, and right file line ...
         // *** TBD *** not here, but must gather line comare stats, and
         // present information to viewer of the compare. green on bits that match
         // =============== ******** ===========
         CMI( IDM_IGNBLANKS, ignore_blanks );
         CMI( IDM_IGNOREEOL, gbIgnEOL      );
         CMI( IDM_IGNCASE,   gbIgnCase     );

         break;

      case MENU_OPTIONS:
         // *** TBD ** This should depend on whether the display is OUTLINE
         // then these are correct ... but should be show line options
         // when the view is expanded. The missing stuff is
         // implemented very by Beyond Compare well in their 'expanded' mode.
         // *** TBD *** to be able to hide/display line(s) in expanded mode
//    POPUP "&Options"
//    BEGIN
//        MENUITEM "Show &Identical Files\tCtrl+I", IDM_INCSAME
         CMI( IDM_INCSAME,   (dwo & INCLUDE_SAME)      );
//        MENUITEM "Show &Left-Only Files\tCtrl+L", IDM_INCLEFT
         CMI( IDM_INCLEFT,   (dwo & INCLUDE_LEFTONLY)  );
//        MENUITEM "Show &Right-Only Files\tCtrl+R", IDM_INCRIGHT
         CMI( IDM_INCRIGHT,  (dwo & INCLUDE_RIGHTONLY) );
//        MENUITEM "Show All &Different",         IDM_DIFFALL
         // CMI( IDM_INCDIFFER, (dwo & INCLUDE_DIFFER)    );
//         CMI( IDM_DIFFALL,   ((dwo & (INCLUDE_NEWER|INCLUDE_OLDER)) == (INCLUDE_NEWER|INCLUDE_OLDER)) );
         CMI( IDM_DIFFALL,   ShowingAll(dwo) );

//        MENUITEM "Show &Newer Files\tCtrl+N",   IDM_NEWER
//        MENUITEM "Show &Older Files\tCtrl+O",   IDM_OLDER
         CMI( IDM_NEWER,     (dwo & INCLUDE_NEWER)     );
         CMI( IDM_OLDER,     (dwo & INCLUDE_OLDER)     );
//        MENUITEM SEPARATOR
//        MENUITEM "&Full File Compare",          IDM_OPTEXACT
         CMI( IDM_OPTEXACT,   gbExact  );

         //CMI( IDM_OPTADDROW,  gbAddRow );
         CMI( IDM_OPTADDROW,
            ((gdwFileOpts & INCLUDE_LINENUMS) ? TRUE : FALSE) );

//        MENUITEM "Ignore &Blanks",              IDM_IGNBLANKS
         CMI( IDM_IGNBLANKS,  ignore_blanks );
         CMI( IDM_OPTIGNOREDT,   gbIgnDT );
//        MENUITEM SEPARATOR
//        MENUITEM "Re&cursive",                  IDM_RECURSIVE
         CMI( IDM_RECURSIVE,  gbRecur );
//        MENUITEM "E&xclude per List",           IDM_OPTEXCLUDE
         CMI( IDM_OPTEXCLUDE, gbExclude );
//        MENUITEM "Exclude &File",               IDM_EXCLUDE
         *lpb = 0;
         bEnab = Got_Sel_File( lpb );
         if(bEnab) {
            //lps = "Exclude &File [%s]";   // menu item content
            strcpy(lpb2,"Exclude &File ");
            sprintf(EndBuf(lpb2),"[%s]",lpb);
            lps = lpb2;
         } else {
            lps = "Exclude &File Off";
         }

         ModifyMenu( hMenu,           // handle to menu
                     IDM_EXCLUDE,    // menu item to modify
                     (MF_BYCOMMAND | MF_STRING),     // options
                     IDM_EXCLUDE,    // identifier, menu, or submenu
                     lps );   // menu item content
         EMI( IDM_EXCLUDE, bEnab );  

//        MENUITEM SEPARATOR
//        MENUITEM "&Warn on Next Find\tCtrl+W",  IDM_WARNING
         CMI( IDM_WARNING,    gbWarn );
//        MENUITEM "Show &Tool Tip",              IDM_SHOWTOOLTIP
//    END
         if( g_hwndTT )
         {
            CMI( IDM_SHOWTOOLTIP, !gbNoTT );
         }
         else
         {
            EMI( IDM_SHOWTOOLTIP, FALSE );
         }

         if( g_dwviewedcnt )
            EMI( IDM_CLEARVIEWED, TRUE );
         else
            EMI( IDM_CLEARVIEWED, FALSE);


//        MENUITEM "&Show Copy Dialog",           IDM_SHOWCOPY
//        MENUITEM "&Preferences...",             IDM_PREFERENCES

//        MENUITEM "&Enable *** DELETE ***",      IDM_ENABLEDELETE
         if( gbDelOn )
            lps = "On. &Disable Delete";   // menu item content
         else
            lps = "&Enable *** DELETE ***";
         ModifyMenu( hMenu,           // handle to menu
                     IDM_ENABLEDELETE,    // menu item to modify
                     (MF_BYCOMMAND | MF_STRING),     // options
                     IDM_ENABLEDELETE,    // identifier, menu, or submenu
                     lps );   // menu item content
         CMI( IDM_ENABLEDELETE, gbDelOn );   // check

         break;

      case MENU_ABOUT:
         break;

      }
   }

   return lRet;
}


// eof - dc4wMenu.c

