// dircmp.cpp : Defines the entry point for the console application.
//

#include "dircmp.h"

#define  ISNUM(a) (( a >= '0' )&&( a <= '9' ))

int   g_do_modify[2]    = { 0, 0 }; // modify to READ/WRITE before delete
int   g_add_base = 0;
int   g_recursive = 1;

#define  _DEF_NET_FOLDER "\\Dell02\\Public\\SAVES"
#define  _DEF_LOCAL_FOLDER "D:\\SAVES"

#define  _DEF_NET_FOLDER2 "\\\\Dell02\\docs\\backup"
#define  _DEF_LOCAL_FOLDER2 "D:\\SAVES\\docs\\backup"

// set some defaults
char * pNetFolder1 = _DEF_NET_FOLDER;
char * pLocalFolder1 = _DEF_LOCAL_FOLDER;
char * pNetFolder2 = _DEF_NET_FOLDER2;
char * pLocalFolder2 = _DEF_LOCAL_FOLDER2;


typedef PMYLIST (*ADD2LIST)( char * );

void Process_Directory( char * pfolder, ADD2LIST add2dir, ADD2LIST add2fil )
{
   MyDirEnt * de;
   MyDir * pdir;
   PMYLIST  pml;
   char * nxt = (char *)malloc( MY_NAME_MAX );

   CHKMEM(nxt);
   pdir = MyOpenDir(pfolder);
   if(pdir) {
      sprtf( "Directory %s is open ...\n", pfolder );
      de = MyReadDir( pdir );
      while(de) {
         *nxt = 0;
         if((strcmp(de->de_name,".")  == 0)||
            (strcmp(de->de_name,"..") == 0))
         {
            // ignore dot and double dot
         }
         else
         {
            if( de->de_isdir )
            {
               if( g_add_base ) {
                  strcpy( nxt, pfolder );
                  strcat( nxt, MY_SLASH);
               }
               strcat( nxt, de->de_name);
               if(add2dir) {
                  pml = add2dir(nxt);
                  if(pml)
                  {
                     pml->isdir = 1;
                     pml->obj_size = de->de_size;
                     pml->time = de->de_time;
                  }
               }
            }
            else
            {
               // is a FILE
               if( g_add_base ) {
                  strcpy( nxt, pfolder );
                  strcat( nxt, MY_SLASH);
               }
               strcat( nxt, de->de_name);
               if( add2fil ) {
                  pml = add2fil(nxt);
                  if(pml)
                  {
                     pml->isdir = 0;
                     pml->obj_size = de->de_size;
                     pml->time = de->de_time;
                  }
               }
            }
         }
         de = MyReadDir( pdir );
      }

      MyCloseDir(pdir);

   } else {
      sprtf( "ERROR: Unable to open %s ...\n", pfolder );
   }

   free(nxt);

}

void test_open( char * pfolder1, char * pfolder2 )
{
   //char * pfolder1 = DEF_NET_FOLDER;
   ADD2LIST add2dir1 = add_2_paths1;
   ADD2LIST add2fil1 = add_2_files1;
   //char * pfolder2 = DEF_LOCAL_FOLDER;
   ADD2LIST add2dir2 = add_2_paths2;
   ADD2LIST add2fil2 = add_2_files2;

   //if( MyDirExists( pfolder1 ) ) {
   //} else {
   //   printf( "ERROR: Directory %s DOES NOT EXIST!\n", pfolder1 );
   //}
   Process_Directory( pfolder1, add2dir1, add2fil1 );
   Process_Directory( pfolder2, add2dir2, add2fil2 );

}

void test_open_backup( char * pfolder1, char * pfolder2 )
{
   //char * pfolder1 = _DEF_NET_FOLDER2;
   ADD2LIST add2dir1 = add_2_paths1;
   ADD2LIST add2fil1 = add_2_files1;
   //char * pfolder2 = _DEF_LOCAL_FOLDER2;
   ADD2LIST add2dir2 = add_2_paths2;
   ADD2LIST add2fil2 = add_2_files2;

   //if( MyDirExists( pfolder1 ) ) {
   //} else {
   //   printf( "ERROR: Directory %s DOES NOT EXIST!\n", pfolder1 );
   //}
   Process_Directory( pfolder1, add2dir1, add2fil1 );
   Process_Directory( pfolder2, add2dir2, add2fil2 );

}


int is_same_file( PMYLIST pml1, PMYLIST pml2 )
{
   if(pml1 && pml2) {
      if( stricmp( pml1->obj_name, pml2->obj_name ) == 0 )
      {
         return 1;
      }
   }
   return 0;
}

void compare_lists( char * pFrom )
{
   PMYLIST head1 = g_pFILES1;
   PMYLIST head2 = g_pFILES2;
   int cnt1 = get_list_count( head1 );
   int cnt2 = get_list_count( head2 );
   int i,j;
   if((cnt1 == 0)||(cnt2 == 0))
      return;
   char * nxt = (char *)malloc( MY_NAME_MAX );
   CHKMEM(nxt);

   for(i = 0; i < cnt1; i++)
   {
      PMYLIST pml1 = get_list_item( head1, i );
      if(pml1) {
         for(j = 0; j < cnt2; j++)
         {
            PMYLIST pml2 = get_list_item( head2, j );
            if( is_same_file( pml1, pml2 ) )
            {
               break;
            }
         }
         if( j >= cnt2 ) {
            // NOT FOUND
            *nxt = 0;
            get_file_stg( nxt, pml1, 0 );
            sprtf( "copy %s"MY_SLASH"%s"MEOR, pFrom, nxt );
         }
      }
   }
   free(nxt);
}

void give_help( _TCHAR * name )
{
   sprtf("IR - Compare Directories - 2009-01-22\n");
   sprtf("Usage:\n");
   sprtf("%s [Options] Left-Directory Right-Directory\n");
   sprtf("Options:\n");
   sprtf(" -? (-h) - This brief help\n");
   sprtf(" -v[n]   - Set verbosity level. (def=%d)\n", g_verbal );
   sprtf("The default action, with no input, is to compare\n" );
   sprtf("%s, with\n", pNetFolder1 );
   sprtf("%s, and\n", pLocalFolder1 );
   sprtf("%s, with\n", pNetFolder2 );
   sprtf("%s, and\n", pLocalFolder2 );
   exit(0);
}

void scan_for_verb(int argc, _TCHAR* argv[])
{
   int   i;
   for( i = 1; i < argc; i++ ) {
      _TCHAR * arg = argv[i];
      _TCHAR c = toupper(*arg);
      if(( c == '-' )||( c == '/' )) {
         c = toupper(arg[1]);
         if( c == 'V' ) {
            g_verbal = 1;
            if(arg[2]) {
               if(ISNUM(arg[2])) {
                  g_verbal = atoi(&arg[2]);
               } else {
                  sprtf("ERROR: -v not followed by number! (%s)\n", arg );
                  exit(1);
               }
            }
         }
      }
   }
}

int _tmain(int argc, _TCHAR* argv[])
{
   int   i, cnt;
   cnt = 0;
   scan_for_verb( argc, argv );
   for( i = 1; i < argc; i++ ) {
      _TCHAR * arg = argv[i];
      _TCHAR c = toupper(*arg);
      if(( c == '-' )||( c == '/' )) {
         c = toupper(arg[1]);
         switch(c)
         {
         case '?':
         case 'H':
            give_help( argv[0] );
            break;
         case 'V':
            // process
            break;
         default:
            sprtf("ERROR: Only options is -? or -h! Unknown %s\n", arg );
            exit(1);
            break;
         }
      } else {
         switch(cnt)
         {
         case 0:
            pNetFolder1 = strdup(arg);
            break;
         case 1:
            pLocalFolder1 = strdup(arg);
            break;
         default:
            sprtf("ERROR: Only two folders allowed! Aborting!!\n" );
            exit(1);
            break;
         }
         cnt++;
      }
   }

   if( cnt && (cnt != 2) ) {
      sprtf( "ERROR: Must give a 'left' and 'right' directory to compare!\n" );
      exit(1);
   }

   sprtf( "Running %s...\n", argv[0] );

   init_list_set();  // ensure all LIST are NULL

   test_open( pNetFolder1, pLocalFolder1 );
   show_lists(1);
   compare_lists( pNetFolder1 );

   if( cnt == 0 )
   {
      kill_lists();

      test_open_backup( pNetFolder2, pLocalFolder2 );
      show_lists(1);
      compare_lists( pNetFolder2 );
   }

   kill_lists();


	return 0;
}

