
// dirlist.c - list handling ...

#include "dircmp.h"

#define  MY_PATHS_1   0

#define  MX_LISTS    8
PMYLIST g_pLists[MX_LISTS];


//PMYLIST  g_pPATHS1 = 0;
PMYLIST  g_pFILES1 = 0;
PMYLIST  g_pPATHS2 = 0;
PMYLIST  g_pFILES2 = 0;

static TCHAR _s_buf1[1024];


void kill_a_list( PMYLIST * phead )
{
   if(phead)
   {
      PMYLIST pn = *phead;
      PMYLIST head;
      while(pn) {
         head = pn;     // will FREE this entry
         pn = pn->pnext; // get next
         free(head); // free last
      }
      *phead = 0;
   }
}

#ifdef _MSC_VER
// dwFileAttributes 
// File attributes of the file found.
// This member can be one or more of the following values. Attribute Meaning 
typedef struct tagFILEATTS {
   DWORD att;
   TCHAR * desc;
   TCHAR * sdesc;
} FILEATTS, * PFILEATTS;

FILEATTS fileatts[] = {
   { FILE_ATTRIBUTE_ARCHIVE, "The file or directory is an archive file or directory. Applications use this attribute to mark files for backup or removal.", "A" },
   { FILE_ATTRIBUTE_COMPRESSED, "The file or directory is compressed. For a file, this means that all of the data in the file is compressed. For a directory, this means that compression is the default for newly created files and subdirectories.", "C" },
   { FILE_ATTRIBUTE_DIRECTORY, "The handle identifies a directory.", "D" },
   { FILE_ATTRIBUTE_ENCRYPTED, "The file or directory is encrypted. For a file, this means that all data in the file is encrypted. For a directory, this means that encryption is the default for newly created files and subdirectories.", "E" },
   { FILE_ATTRIBUTE_HIDDEN, "The file or directory is hidden. It is not included in an ordinary directory listing.", "H" },
   { FILE_ATTRIBUTE_NORMAL, "The file or directory has no other attributes set. This attribute is valid only if used alone.", "N" },
   { FILE_ATTRIBUTE_OFFLINE, "The file data is not immediately available. This attribute indicates that the file data has been physically moved to offline storage. This attribute is used by Remote Storage, the hierarchical storage management software. Applications should not arbitrarily change this attribute.", "O" },
   { FILE_ATTRIBUTE_READONLY, "The file or directory is read-only. Applications can read the file but cannot write to it or delete it. In the case of a directory, applications cannot delete it.", "R" },
   { FILE_ATTRIBUTE_REPARSE_POINT, "The file or directory has an associated reparse point.", "P" },
   { FILE_ATTRIBUTE_SPARSE_FILE, "The file is a sparse file.", "F" },
   { FILE_ATTRIBUTE_SYSTEM, "The file or directory is part of the operating system or is used exclusively by the operating system.", "S" },
   { FILE_ATTRIBUTE_TEMPORARY, "The file is being used for temporary storage. File systems attempt to keep all of the data in memory for quicker access, rather than flushing it back to mass storage. A temporary file should be deleted by the application as soon as it is no longer needed.", "T" },
   { 0, 0, 0 } // final entry
};
void Append_Attributes( PTSTR ps, PMYLIST pn )
{
   PFILEATTS pfa = &fileatts[0];
   while( pfa->sdesc ) {
      if( pfa->att == pn->attrib )
         strcat( ps, pfa->sdesc );
      else if( pn->attrib & pfa->att )
         strcat( ps, pfa->sdesc );
      pfa++;
   }
}

#endif   // _MSC_VER

#define  DEF_LENGTH  10

void get_file_stg( PTSTR ps, PMYLIST pn, int type )
{
   size_t len;
   strcpy(ps, pn->obj_name);
   if( type )
   {
      while( strlen(ps) < MX_FILE_NM )
         strcat(ps," ");
      if( pn->isdir ) {
         strcat( ps, " <DIR>" );
      } else {
         size_t   size = pn->obj_size;
         len = DEF_LENGTH;
         if( size < 10 )
            len = DEF_LENGTH;
         else if( size < 100 )
            len = DEF_LENGTH-1;
         else if( size < 1000 )
            len = DEF_LENGTH-2;
         else if( size < 10000 )
            len = DEF_LENGTH-3;
         else if( size < 100000 )
            len = DEF_LENGTH-4;
         else if( size < 1000000 )
            len = DEF_LENGTH-5;
         else if( size < 10000000 )
            len = DEF_LENGTH-6;
         else if( size < 100000000 )
            len = DEF_LENGTH-7;
         else if( size < 1000000000 )
            len = DEF_LENGTH-8;
         else
            len = DEF_LENGTH-9;
         while( len-- )
            strcat(ps," ");
         sprintf(EndBuf(ps), " %lu", size);
         while( strlen(ps) < MX_FILE_SZ )
            strcat(ps," ");
         sprintf(EndBuf(ps), " %s", ctime( &pn->time ) );
         len = (long)strlen(ps);
         while( len-- ) {
            if( ps[len] > ' ' )
               break;
            ps[len] = 0;
         }
#ifdef _MSC_VER
         //  tdir->td_curr.de_att = tdir->td_data.dwFileAttributes; // attributes of found item
         if(VERB9) {
            strcat( ps, " " );
            Append_Attributes( ps, pn );
         }
#endif // _MSC_VER
      }
   }
}

TCHAR * get_k_num( long byts )
{
   static TCHAR _s_kbuf[264];
   TCHAR * pb = _s_kbuf;
   if( byts < 1024 ) {
      sprintf(pb, "%d bytes", byts);
   } else if( byts < 1024*1024 ) {
      double ks = ((double)byts / 1024.0);
      sprintf(pb, "%0.2f KB", ks);
   } else if( byts < 1024*1024*1024 ) {
      double ms = ((double)byts / (1024.0*1024.0));
      sprintf(pb, "%0.2f MB", ms);
   } else {
      double gs = ((double)byts / (1024.0*1024.0*1024.0));
      sprintf(pb, "%0.2f GB", gs);
   }
   return pb;
}

TCHAR * get_k_num64( ULARGE_INTEGER uli )
{
   static TCHAR _s_kbuf64[264];
   TCHAR * pb = _s_kbuf64;
   double byts = ((double)uli.HighPart * 4294967296.0);
   byts += uli.LowPart;
   if( byts < 1024 ) {
      sprintf(pb, "%f bytes", byts);
   } else if( byts < 1024*1024 ) {
      double ks = ((double)byts / 1024.0);
      sprintf(pb, "%0.2f KB", ks);
   } else if( byts < 1024*1024*1024 ) {
      double ms = ((double)byts / (1024.0*1024.0));
      sprintf(pb, "%0.2f MB", ms);
   } else {
      double gs = ((double)byts / (1024.0*1024.0*1024.0));
      sprintf(pb, "%0.2f GB", gs);
   }
   return pb;
}

int show_list_files( int type, size_t * ptot, PMYLIST phead )
{
   PTSTR    ps = _s_buf1;
   PMYLIST  pn;
   int fcnt = get_list_count(phead);
   size_t byttot = 0;
   if( fcnt ) {
      sprtf( "Got %d files, as follows ..."MEOR, fcnt );
   } else {
      sprtf( "No files found to delete ..."MEOR );
   }

   for( pn = phead; pn != 0; pn = pn->pnext ) {
      byttot += pn->obj_size;
      get_file_stg( ps, pn, type );
      strcat(ps,MEOR);
      sprtf(ps);
   }

   if(ptot)
      *ptot = byttot;

   return fcnt;

}

int show_file_list1( int type, size_t * ptot )
{
   return show_list_files( type, ptot, g_pFILES1 );
}

int show_list_dir( int type, long * ptot, PMYLIST phead )
{
   PTSTR    ps = _s_buf1;
   PMYLIST  pn;
   int dcnt = get_list_count(phead);
   long dirtot = 0;

   if( dcnt ) {
      sprtf( "Got %d directories, as follows ..."MEOR,
               dcnt );
   } else {
       sprtf( "No directories found to delete ..."MEOR );
   }

   for( pn = phead; pn != 0; pn = pn->pnext ) {
      dirtot += ASSUME_FOLDER_SIZE;
      get_file_stg( ps, pn, type );
      strcat(ps,MEOR);
      sprtf(ps);
   }

   if( ptot )
      *ptot = dirtot;

   return dcnt;
}

#if 0
int show_dir_list1_OK( int type, long * ptot )
{
   return show_list_dir( type, ptot, g_pPATHS1 );
}
#endif // 0

int show_file_list2( int type, size_t * ptot )
{
   return show_list_files( type, ptot, g_pFILES2 );
}
int show_dir_list2( int type, long * ptot )
{
   return show_list_dir( type, ptot, g_pPATHS2 );
}


PMYLIST get_list_last( PMYLIST head )
{
   PMYLIST  pn;
   if( head ) {
      pn = head->pnext;
      while(pn) {
         head = pn; // keep last
         pn = pn->pnext;
      }
   }
   return head;
}

int get_list_count( PMYLIST head )
{
   int   icnt = 0;
   PMYLIST  pn;
   if( head ) {
      icnt++;
      pn = head->pnext;
      while(pn) {
         icnt++;
         pn = pn->pnext;
      }
   }
   return icnt;
}

PMYLIST  get_list_item( PMYLIST head, int item )
{
   int   icnt = 0;
   PMYLIST  pn;
   if( head ) {
      if( icnt == item ) {
         return head;
      }
      icnt++;
      pn = head->pnext;
      while(pn) {
         if( icnt == item ) {
            return pn;
         }
         icnt++;
         pn = pn->pnext;
      }
   }
   return NULL;   // failed to get a list item
}

PMYLIST get_list_before( PMYLIST head, PMYLIST nxt )
{
   PMYLIST  pn;
   if( head == nxt )
      return NULL;
   if( head ) {
      pn = head->pnext;
      if( pn == nxt )
         return head;

      while(pn) {
         head = pn; // keep last
         pn = pn->pnext;
         if( pn == nxt )
            return head;
      }
   }
   return NULL;
}

void  add_2_end( PMYLIST head, PMYLIST nxt, char * lname )
{
   PMYLIST  pn;
   int   i = 0;
   if( head ) {
      pn = head->pnext;
      i = 1;
      while(pn) {
         head = pn; // keep last
         pn = pn->pnext;
         i++;
      }
      if(VERB9) {
         sprtf("Added [%s] as the LAST item in %s (%d)."MEOR,
         nxt->obj_name,
         (lname ? lname : "unknown"),
         (i+1) );
      }
      head->pnext = nxt;
   }
}

PMYLIST  add_2_list( PMYLIST * pList, char * path, char * lname )
{
   PMYLIST head = *pList;
   size_t   len = strlen(path);
   size_t   siz = sizeof(MYLIST) + len;
   PMYLIST nxt = (PMYLIST)malloc( siz );
   CHKMEM(nxt);
   ZeroMemory( nxt, siz );
   //nxt->done = 0;
   //nxt->pnext = 0;
   nxt->name_len = len + 1;
   strcpy(nxt->obj_name, path);
   if( head ) {
      add_2_end( head, nxt, lname );
   } else {
      *pList = nxt;
      if(VERB9) {
         sprtf("Added [%s] as the FIRST item in %s (1)."MEOR, path,
         (lname ? lname : "unknown") );
      }
   }
   return nxt; // return the structure ...
}

PMYLIST  add_2_list_if_new( PMYLIST * pList, char * path, char * lname )
{
   PMYLIST head = *pList;
   PMYLIST  pn = 0;
   traverse_my_list( head, pn )
   {
      if( pn ) {
         if( strcmp( pn->obj_name, path ) == 0 ) {
            return pn;
         }
      } else
         break;
   }
   return( add_2_list( pList, path, lname ) );
}

// FIX20070815 - check if in LIST
PMYLIST  is_in_list( PMYLIST * pList, char * path, char * lname )
{
   PMYLIST head = *pList;
   PMYLIST  pn = 0;
   traverse_my_list( head, pn )
   {
      if( pn ) {
         if( strcmp( pn->obj_name, path ) == 0 ) {
            return pn;
         }
      } else
         break;
   }
   return NULL;
}

#if 0
PMYLIST  add_2_paths1( char * path )
{
   return( add_2_list( &g_pPATHS1, path, "PATHS" ) );
}
#endif // 0

PMYLIST  add_2_files1( char * path )
{
   return( add_2_list( &g_pFILES1, path, "FILES" ) );
}
PMYLIST  add_2_paths2( char * path )
{
   return( add_2_list( &g_pPATHS2, path, "PATHS" ) );
}
PMYLIST  add_2_files2( char * path )
{
   return( add_2_list( &g_pFILES2, path, "FILES" ) );
}

void init_list_set( void )
{
   int i;
   for( i = 0; i < MX_LISTS; i++ )
      g_pLists[i] = NULL;
}

void kill_list_set( void )
{
   int i;
   for( i = 0; i < MX_LISTS; i++ )
      kill_a_list( &g_pLists[i] );
}

PMYLIST get_list_num( int i )
{
   if(( i >= 0 )&&
      ( i < MX_LISTS ))
      return g_pLists[i];

   return NULL;
}

void kill_lists( void )
{
   //kill_a_list( &g_pPATHS1 );
   kill_list_set();
   kill_a_list( &g_pFILES1 );
   kill_a_list( &g_pPATHS2 );
   kill_a_list( &g_pFILES2 );
#ifdef  MULTI_DIRECTORIES
   kill_a_list( &g_pINDIR );
#endif   // #ifdef  MULTI_DIRECTORIES
}

int show_dir_list1( int type, long * ptot )
{
   return show_list_dir( type, ptot, get_list_num(MY_PATHS_1) );
}

PMYLIST  add_2_paths1( char * path )
{
   PMYLIST pl = get_list_num(MY_PATHS_1);
   add_2_list( &pl, path, "PATHS" );
   return pl;
}

void show_lists( int type )
{
   size_t byttot = 0;
   long dirtot = 0;
   int fcnt = show_file_list1( type, &byttot );
   int dcnt = show_dir_list1( type, &dirtot );
   sprtf( "Summery1: %d dirs, %d files, approx. %s ..."MEOR, dcnt, fcnt,
      get_k_num( (long)(byttot + dirtot) ) );
   byttot = dirtot = 0;
   fcnt = show_file_list2( type, &byttot );
   dcnt = show_dir_list2( type, &dirtot );
   sprtf( "Summery2: %d dirs, %d files, approx. %s ..."MEOR, dcnt, fcnt,
      get_k_num( (long)(byttot + dirtot) ) );

}

// eof - dirlist.c
