// dirlist.h - command line handling ...
#ifndef __dirlist_h__
#define __dirlist_h__

// manifest constants
#define  MX_FILE_NM     42
#define  MX_FILE_SZ     52
#define  ASSUME_FOLDER_SIZE   256   // this varies, depending on file system used

struct _MYLIST;
typedef struct _MYLIST MYLIST;
typedef MYLIST * PMYLIST;
struct _MYLIST {
   PMYLIST pnext; // pointer to NEXT, if any
   int     done;  // done this folder
   int     isdir; // is a directory
   time_t  time;  // time
#ifdef   _MSC_VER
   DWORD    attrib;
   DWORD bSectorsPerCluster, bBytesPerSector, bNumberOfFreeClusters, bTotalNumberOfClusters;
   ULARGE_INTEGER bFreeBytesAvailable, bTotalNumberOfBytes, bTotalNumberOfFreeBytes;
   int      bshwn;
#endif // _MSC_VER
   size_t   obj_size;   // size
   void *   obj_data;   // data, if loaded
   size_t   name_len;   // length of name buffer following
   char     obj_name[1]; // buffer for full item name
};

#define  traverse_my_list(ph, pn) for( pn = ph; pn != 0; pn = pn->pnext )

// FIX20070815 - check if in LIST
extern PMYLIST  is_in_list( PMYLIST * pList, char * path, char * lname );
extern PMYLIST  add_2_list_if_new( PMYLIST * pList, char * path, char * lname );
extern PMYLIST  g_pPATHS1, g_pFILES1;
extern PMYLIST  g_pPATHS2, g_pFILES2;
extern void kill_lists( void );
extern void show_lists( int type );
extern void get_file_stg( PTSTR ps, PMYLIST pn, int type );
extern PMYLIST get_list_last( PMYLIST head );
extern int get_list_count( PMYLIST head );
extern PMYLIST get_list_before( PMYLIST head, PMYLIST nxt );
extern void  add_2_end( PMYLIST head, PMYLIST nxt, char * lname );
extern PMYLIST  add_2_list( PMYLIST * pList, char * path, char * lname );
extern PMYLIST  add_2_paths1( char * path );
extern PMYLIST  add_2_files1( char * path );
extern PMYLIST  add_2_paths2( char * path );
extern PMYLIST  add_2_files2( char * path );
extern TCHAR * get_k_num( long byts );
extern PMYLIST  get_list_item( PMYLIST head, int item );
extern TCHAR * get_k_num64( ULARGE_INTEGER uli );
extern void kill_a_list( PMYLIST * phead );

#endif // #ifndef __dirlist_h__
// eof - dirlist.h
