// dirset.cxx
// Implementation file

#include "dircmp.h"
#include "dirset.hxx"

bool DirSet::Load( std::string dir )
{
   bool bret = false;
   string   ffname;
   MyDir * md = MyOpenDir( (char *)dir.c_str() );
   dirs.clear();
   files.clear();
   if(md) {
      MyDirEnt * de;
      while( (de = MyReadDir( md )) != NULL ) {
         ffname = dir;
         ffname += MY_SLASH;
         ffname += de->de_name;
         if( de->de_isdir ) {
            ffname = dir;
            ffname += MY_SLASH;
            ffname += de->de_name;
            dirs.push_back(ffname);
         } else {
            PFE pfe = new FE;
            pfe->file = ffname;
            pfe->size = de->de_size;
            pfe->time = de->de_time;
            files.push_back(pfe);
         }
      }
      MyCloseDir( md );
      if( DirCount() || FileCount() ) {
         bret = true;
         name = dir;
      }
   }

   return bret;
}


DirSet::DirSet()
{
   name = "";
   dirs.clear();
   files.clear();
}

DirSet::~DirSet()
{
   dirs.clear();
   files.clear();
}

// eof - dirset.cxx
