// dirset.hxx
// Class file
#ifndef _dirset_HXX_
#define _dirset_HXX_

#include <string>
#include <vector>
#include <iostream>

using namespace std;

typedef struct tagFE {
   string file;
   size_t size;
   time_t time;
}FE, * PFE;

class DirSet {

public:
   typedef vector<string> dir_vector;
   typedef vector<PFE> file_vector;
   typedef dir_vector::iterator dir_iterator;
   typedef file_vector::iterator file_iterator;

   DirSet();
   ~DirSet();


   string name;
   bool Load( std::string dir );
   dir_vector dirs;
   dir_iterator idirs;
   file_vector files;
   file_iterator ifiles;

   size_t DirCount(void) { return dirs.size(); }
   size_t FileCount(void) { return files.size(); }

};



#endif _dirset_HXX_
// eof - dirset.hxx

