// dirg.cxx : Defines the entry point for the console application.
//

#include "dirg.hxx"
#include <fstream>

int verbose = 1;
string src_path = "";
string g_runtime; // runtime folder - where files are written

int get_stg( string & s, char * parg, char * pdef )
{
   s = parg;
   if( !s.size() )
      s = pdef;
   return 0;
}

int get_int( int * pi, char * parg )
{
   int i = *pi;
   *pi = atoi(parg);
   return 0;
}

char * szopt1 = {"--src-path="};
char * szopt2 = {"-v"};

int parse_arg( char * arg )
{
   string s = arg;
   if( s.find( szopt1 ) == 0 ) {
      return( get_stg(src_path, arg + strlen(szopt1), "." ) );
   } else if( s.find( szopt2 ) == 0 ) {
      return( get_int(&verbose, arg + strlen(szopt2) ) );
   }
   return 1;
}

#ifndef VFH
#define VFH(a) ( a && ( a != INVALID_HANDLE_VALUE ) )
#endif // #ifndef VFH

typedef vector<dir1 *> vDIRLST;
typedef vDIRLST::iterator DirLst_it;

vDIRLST g_Folders; // list of directories
dir1 * get_new_dir( void )
{
   dir1 * nd = new dir1;
   g_Folders.push_back(nd);
   return nd;
}
void end_dir_list( void )
{
   DirLst_it it = g_Folders.begin();
   while( it != g_Folders.end() )
   {
      delete (*it); // release our pointer
      it++;
   }
}

// dir1 * p_dir = 0;

dir1 * do_folder( string & inp, string & s, int flg )
{
   ostringstream oss;
   dir1 * p_dir = 0;
//   g_sActFolder = s;
//   g_sInpFolder = inp;
   oss << "Processing folder [" << s << "] ...";
   if( inp != s ) {
      oss << " from [" << inp << "] ...";
   }
   G_LOG( oss.str() );
   ulDir * pdir1 = ulOpenDir( s.c_str() ); // open the SOURCE
   if( pdir1 == NULL ) {
      G_LOG( "ERROR: Not valid directory! [" << s << "] Check!" );
      return 0; // *** NO DIRECOTRY ***
   }
   ulCloseDir( pdir1 );

      // avoid this FOLDER
   // p_dir = new dir1(s);
   p_dir = get_new_dir();
   p_dir->load(s, flg); // load the directory

   return p_dir;
}

string htm_file;

void out_htm_file( string & htm, int flag )
{
   string fdr;
   dir1 * p_dir = 0;
   int i = 0;
   int flg = 0;
   string tit = "Folder List";
   ofstream ofs( htm.c_str() ); // = "tempdirg.htm" );
   if (ofs) {
      ostringstream oss;
      DirLst_it it = g_Folders.begin();

      while( it != g_Folders.end() )
      {
         p_dir = (*it); // get our pointer
         fdr = p_dir->m_folder;
         if( i == 0 ) {
            //p_dir->add_h_head( oss, tit, fdr, flag );
            sDirgHTML.add_h_head( oss, tit, fdr, flag );
         }
         if( flag & f_not_name ) {
            // p_dir->add_h_table( oss, tit, fdr, flag, p_dir->subs_list );
            sDirgHTML.add_h_table( oss, tit, fdr, flag, p_dir->subs_list );
         } else {
            //p_dir->add_h_tables( oss, tit, fdr, flag, p_dir->m_vDirs );
            sDirgHTML.add_h_tables( oss, tit, fdr, flag, p_dir->m_vDirs );
         }
         //p_dir->add_graph( oss, tit, fdr, flag, p_dir->m_vDirs );
         it++;
         i++;
      }
      if(p_dir)
         sDirgHTML.add_graph( oss, tit, fdr, flag, p_dir->m_vDirs );


      if(p_dir) {
          sDirgHTML.add_h_tail( oss, tit, fdr, flag );
      }

      ofs << oss.str(); // write string to file

      ofs.close();
   }
}

int my_flag = f_default;
int main(int argc, char * argv[])
{
   size_t i, sz;
   size_t mx = argc;
   string s;
   double dd = 9223372036854775807.0;
   dir1 * p_dir = 0;

   INIT_DIRG(g_runtime); // any init required
   htm_file = g_runtime;
   htm_file += "\\tempdirg.htm";

   for( i = 1; i < mx; i++ ) {
      if( parse_arg( argv[i] ) ) {
         s = argv[i];
         dir_list.push_back(s);
      }
   }
   sz = dir_list.size();
   if( !sz )
      dir_list.push_back(".");

   sz = dir_list.size();
   for( i = 0; i < sz; i++ ) {
      s = rel_2_full( dir_list[i] );
      p_dir = do_folder( dir_list[i], s, my_flag );
      if( ! p_dir ) {
         G_LOG( "Directory " << dir_list[i] << " FAILED! (" << s << ")" );
      } else if ( p_dir && ( i == 0 ) ) {
         // only output the FIRST!!!
#if 0 // test code
          ofstream ofs( htm_file.c_str() ); // = "tempdirg.htm" );
          if (ofs) {
             //ofs << p_dir->get_html( "Folder List", dir_list[i], 0 );
             ofs << p_dir->get_html( "Folder List", s, 0 );
             ofs.close();
          }
#endif // #if 0 // test code
      }
   }

   if( p_dir ) { // at least ONE 'loaded' directory
      out_htm_file( htm_file, my_flag ); // = f_default
   }


#if   0 // code not now used
   G_LOG( "From " << (int)sz << " directories, got " << tot_dirs << " folders, and " <<
      tot_files << " files. " );
   G_LOG( "Totals, " <<
      bytes_2_ks1(g_dByteCount) << ", " << bytes_2_ks1(g_dAdjByteCount) << ", " <<
      get_nice_number(g_dByteCount) << ", " <<
      get_nice_number(g_dAdjByteCount) );
#endif // #if   0 // code not now used

   dbg_close();
   //system( dbg_filenm ); // open the output

   if( p_dir ) { // at least ONE 'loaded' directory
      system( htm_file.c_str() ); // "tempdirg.htm"
   }
   end_dir_list();
	return 0;
}

