
// dirg1.cxx
#include "dirg.hxx"
// #include "dirg1.hxx"

// sort compare services
static bool vdir_nm_comp( const DIRSTR & a, const DIRSTR & b ) {
    return a.d_name < b.d_name;
}

static bool vdir_sz_comp( const DIRSTR & a, const DIRSTR & b ) {
    return a.d_total < b.d_total;
}

dir1::dir1( void )
{
   pgex = 0;
   m_dBC = 0.0;
   m_dAdjBC = 0.0;
   m_tot_dirs = 0;
   m_tot_files = 0;
}

dir1::~dir1( void )
{
   subs.clear();
}

int dir1::load( string d, int flag )
{
   m_folder = d;
   m_flag = flag;
   BytPerSec = 512; // NTFS default!
   dBgnBC = m_dBC = dBgnAdjBC = m_dAdjBC = 0.0;
   dTotSize = 0.0; // (double)ulTotalBytes.QuadPart;
   dTotFree = 0.0; // (double)ulFreeBytes.QuadPart;
   size_t pos = d.find(':'); // do we have a drive
   m_drv = ""; // assume NO DRIVE
   m_fldr = d;
   if( pos != string::npos ) { // *** GOT COLON ***
      m_drv = d.substr(0, (pos + 1)); // get drive, plus colon
      m_drv += "\\"; // add trailing backslash
      m_fldr = d.substr((pos + 1));
      const char * pd = m_drv.c_str();
      bGotDFS = GetDiskFreeSpace( pd, // address of root path
            &SecPerClus,	// address of sectors per cluster
            &BytPerSec,	// address of bytes per sector
            &NumFreeClus,	// address of number of free clusters
            &TotClust );	// address of total number of clusters
      load_service(); // load the DLL service
      if( pgex ) {
         bGotDF = (*pgex) ( pd, &ulFreeToCall,
            &ulTotalBytes, &ulFreeBytes );
      }
      if( bGotDFS ) {
         if(( pgex   ) &&
            ( bGotDF ) ) {
            dTotSize = (double)ulTotalBytes.QuadPart;
            dTotFree = (double)ulFreeBytes.QuadPart;
         } else {
            dTotSize = ( (double)SecPerClus *
               (double)BytPerSec *
               (double)TotClust );
			   dTotFree = ( (double)SecPerClus *
               (double)BytPerSec *
               (double)NumFreeClus );
         }
      }
   } // got a drive

   m_is_root = ( (m_fldr == "\\") ? 1 : 0 );

   process_a_folder( m_folder, 0 );

   sort( m_vDirs.begin(), m_vDirs.end(), vdir_sz_comp );

   G_LOG( "Totals, " <<
      sDirgHTML.b2ks1(m_dBC) << ", " << sDirgHTML.b2ks1(m_dAdjBC) << ", " <<
      sDirgHTML.get_nn(m_tot_dirs) << ", " <<
      sDirgHTML.get_nn(m_tot_files) << ", " <<
      sDirgHTML.get_nn(m_dBC) << ", " <<
      sDirgHTML.get_nn(m_dAdjBC) );
   //G_LOG( "Totals, " <<
   //   sDirgHTML.b2ks1(m_dBC) << ", " << sDirgHTML.b2ks1(m_dAdjBC) << ", " <<
   //   sDirgHTML.get_cn(m_dBC) << ", " <<
   //   sDirgHTML.get_cn(m_dAdjBC) );
#ifdef WIN32
   // double dTotSize, dTotFree;
   G_LOG( m_drv << ", " <<
      sDirgHTML.b2ks1(dTotSize) << ", " << sDirgHTML.b2ks1(dTotFree) << ", " <<
      sDirgHTML.get_cn(SecPerClus) << // address of sectors per cluster
      "," <<
      sDirgHTML.get_cn(BytPerSec) );	// address of bytes per sector
#endif // #ifdef WIN32

   return( m_tot_dirs + m_tot_files );

}

void fold2dir( DIRSTR & d, Folder1 & f )
{
   d.d_name = f.f_name;
   d.d_path = f.f_path;
   d.d_total = f.f_total;
   d.d_adjtot = f.f_adjtot;
   d.d_totdirs = f.f_totdirs;
   d.d_totfiles = f.f_totfiles;
}


int dir1::process_a_folder( string fdr, int level )
{
#ifdef ADD_V_FILES
   static FILE1 sfile1;
#endif // #ifdef ADD_V_FILES
   //static Folder1 m_fold;
   WIN32_FIND_DATA wfd;
   string s = fdr;
   size_t ssz = s.size();
   if( ssz && ( s.substr((ssz - 1),1) != "\\" ) ) {
      s += "\\";
   }
   s += "*.*"; // make global wild card

   HANDLE hFind = FindFirstFile( s.c_str(), &wfd );
   int dirs = 0;
   int files = 0;
   size_t bgncnt = subs.size();
   size_t endcnt;
   double bperc = (double)get_bpc();
   double dBC = 0.0;
   double dAdjBC = 0.0;
   double d1, d2;
   if( level == 1 ) {
      // we have enter a DIRECTORY / FOLDER - keep stats ...
      dBgnBC = m_dBC;
      dBgnAdjBC = m_dAdjBC;
      iBgnFC = m_tot_files;
      iBgnDC = m_tot_dirs;
   }
   if( hFind ) {
      size_t fc = 0; // just to establish a jump 'island' for the 'Do_Next' label!!!
      do {
         char * fp = &wfd.cFileName[0];
         if( strcmp(fp,".") && strcmp(fp,"..") ) {
            string in = fdr;
            in += "\\";
            in += fp;
            if( wfd.dwFileAttributes & FILE_ATTRIBUTE_DIRECTORY ) {
               // got directory
               if((level == 0) && m_is_root &&
                  (strcmp(fp,"System Volume Information") == 0) ) {
                  // do NOT keep this
                  goto Do_Next;
               } else {
                  subs.push_back(in); // keep the directories, for processing
                  dirs++;
                  d1 = bperc;
                  d2 = bperc;
#ifdef ADD_V_FILES
                  sfile1.f_path = in; // store path\file
                  sfile1.f_size = d1; // size
                  sfile1.f_attr = wfd.dwFileAttributes; // attribute
                  m_vFiles.push_back(sfile1); // store in simple vector list
#endif // #ifdef ADD_V_FILES
               }
            } else {
               // got file 
               ULARGE_INTEGER  ul;
               ul.HighPart = wfd.nFileSizeHigh;
               ul.LowPart = wfd.nFileSizeLow;
               d1 = (double)ul.QuadPart;
               DWORD lg = (DWORD)(d1 / bperc);
               if ( (double)lg != d1 )
                  lg++;
               d2 = (double)lg * bperc;
               //file_list.push_back(in); // keep the files, for processing
               //file_list2.push_back(fp); // and short form
               files++;
#ifdef ADD_V_FILES
               sfile1.f_path = in; // store path\file
               sfile1.f_size = d1; // size
               sfile1.f_attr = wfd.dwFileAttributes; // attribute
               m_vFiles.push_back(sfile1); // store in simple vector list
#endif // #ifdef ADD_V_FILES
            }
            dBC += d1;
            dAdjBC += d2;
         }
Do_Next:
         fc++;
      } while( FindNextFile( hFind, &wfd ) );
      FindClose(hFind);
   } else {
      G_LOG( "ERROR: Not valid directory! [" << fdr << "] Check!" );
      return -1;
   }

   m_tot_dirs += dirs;
   m_tot_files += files;
   m_dBC += dBC;
   m_dAdjBC += dAdjBC;
   string cnt1 = sDirgHTML.b2ks1(dBC);
   string cnt2 = sDirgHTML.b2ks1(dAdjBC);
   if( level == 0 ) {
      // root of chosen directory
      m_fold.f_path = fdr;
      m_fold.f_name = sub_cf(fdr);
      m_fold.f_total = dBC; // get byte count of folder
      m_fold.f_adjtot = dAdjBC;
      m_fold.f_totdirs = dirs;
      m_fold.f_totfiles = files;
      subs_map[ m_fold.f_name ] = m_fold; // set this folder
      subs_list.push_back( &subs_map[m_fold.f_name] );
      fold2dir( m_ds, m_fold );
      m_vDirs.push_back(m_ds); // store whole
      G_LOG( sub_cf(fdr) << ", " <<
         sDirgHTML.b2ks1(dBC) << ", " << sDirgHTML.b2ks1(dAdjBC) <<
         ", " << dirs << ", " << files );
   }

   endcnt = subs.size();
   for( size_t i = bgncnt; i < endcnt; i++ ) {
      process_a_folder( subs[i], (level + 1) );
   }

   if( level == 1 ) {
      // we have entered a DIRECTORY / FOLDER - keep stats ...
      dEndBC = m_dBC - dBgnBC;
      dEndAdjBC = m_dAdjBC - dBgnAdjBC;
      m_fold.f_path = fdr;
      m_fold.f_name = sub_cf(fdr);
      m_fold.f_total = dEndBC; // get byte count of folder
      m_fold.f_adjtot = dEndAdjBC;
      m_fold.f_totdirs = m_tot_dirs - iBgnDC;
      m_fold.f_totfiles = m_tot_files - iBgnFC;
      subs_map[ m_fold.f_name ] = m_fold; // set this folder
      subs_list.push_back( &subs_map[m_fold.f_name] );
      fold2dir( m_ds, m_fold );
      m_vDirs.push_back(m_ds); // store whole
      if( VERB3 ) {
         G_LOG( "Sub-total, " <<
            sDirgHTML.b2ks1(dEndBC) << ", " << sDirgHTML.b2ks1(dEndAdjBC) <<
            "," << sDirgHTML.get_nn(m_fold.f_totdirs) <<
            "," << sDirgHTML.get_nn(m_fold.f_totfiles) );
      } else {
         G_LOG( sub_cf(fdr) << ", " <<
            sDirgHTML.b2ks1(dEndBC) << ", " << sDirgHTML.b2ks1(dEndAdjBC) <<
            "," << sDirgHTML.get_nn(m_fold.f_totdirs) <<
            "," << sDirgHTML.get_nn(m_fold.f_totfiles) );
      }
   }

   return( (int)(m_tot_dirs + m_tot_files) );
}


size_t dir1::get_bpc( void ) // get_bytes_per_cluster( void )
{
   size_t dwi = BytPerSec;
   if( dwi < 512 ) {
      dwi = 1024;
   }
   return dwi;
}

string dir1::sub_cf( string s ) // sub_curr_fold
{
   string nf = s;
   size_t sz = m_folder.size();
   if( sz ) {
      if( m_folder == s ) {
         nf = ".";
      } else {
         size_t pos = nf.find(m_folder);
         if(pos == 0) {
            if( s.size() > sz )
               sz++;
            nf = s.substr( sz );
         }
      }
   }
   return nf;
}



#ifdef WIN32
// TCHAR g_szDiskEx[] = DEF_GDISKEX;
// pGDFSEX pgex = 0;

void dir1::load_service( void )
{
   if( !pgex ) {
      //strcpy(g_szDiskEx, DEF_GDISKEX);
      HMODULE ghLib = LoadLibraryEx( "KERNEL32.DLL",  // points to name of executable module 
                     NULL,                   // reserved, must be NULL
                     0 );   // DWORD dwFlags = entry-point execution flag 
      if( ghLib ) {
         pgex = (pGDFSEX)GetProcAddress( ghLib, DEF_GDISKEX ); // g_szDiskEx ); // "GetDiskFreeSpaceExA"
         //FreeLibrary( ghLib ); // will be freed, when we exit ...
      }
   }
}
#endif // WIN32

// eof - dirg1.cxx
