
// dirg1.hxx
#ifndef _dirg1_HXX
#define _dirg1_HXX
#include "dirgvers.hxx"
#include "dirg.hxx"

#define  MEOS  "\n"     // end of line for text stream

#ifdef   WIN32
typedef BOOL (STDAPICALLTYPE * pGDFSEX) ( LPCTSTR lpDir,
                        PULARGE_INTEGER lpFreeToC,
                        PULARGE_INTEGER lpTotalBytes, 
                        PULARGE_INTEGER lpFreeBytes );
#ifdef UNICODE
#define DEF_GDISKEX      "GetDiskFreeSpaceExW"
#else // #ifdef UNICODE
#define DEF_GDISKEX      "GetDiskFreeSpaceExA"
#endif // #ifdef UNICODE  y/n

#endif // WIN32

#define  f_no_est    0x00000001  // do not add estimates
#define  f_no_dir    0x00000002  // do not add dir count
#define  f_no_files  0x00000004  // do not add file count
#define  f_no_disk   0x00000008  // do not add disk row
#define  f_no_para   0x00000010  // do not add paragraph around tables
#define  f_not_name  0x00000020  // do not output in name order

#define f_col5_r 0x08000000
#define f_col4_r 0x10000000
#define f_col3_r 0x20000000
#define f_col2_r 0x40000000
#define f_col1_r 0x80000000

#define f_col_all (f_col1_r |f_col2_r | f_col3_r | f_col4_r | f_col5_r)
#define f_col_def (f_col2_r | f_col3_r | f_col4_r | f_col5_r)

#define f_default f_col_def

class Folder1
{
public:
   Folder1() {};
   ~Folder1() {};
   string f_path;
   string f_name;
   double f_total;
   double f_adjtot;
   int f_totfiles;
   int f_totdirs;
};

typedef map < string, Folder1 > Folder_map;
typedef Folder_map::iterator Folder_map_it;
typedef Folder_map::const_iterator cFolder_map_it;
typedef vector < Folder1 * > Folder_list;

typedef struct tagDIRSTR {
   string d_path;
   string d_name;
   double d_total;
   double d_adjtot;
   int d_totfiles;
   int d_totdirs;
}DIRSTR, * PDIRSTR;

typedef vector<DIRSTR> vDIRSTR; // set of DIRSTR structures

#ifdef ADD_V_FILES

typedef struct tagFILE1 {
   string f_path;
   double f_size;
   size_t f_attr;
}FILE1, * PFILE1;

typedef vector<FILE1> vFILES; // set of files
#endif // #ifdef ADD_V_FILES

class dir1
{
   DIRSTR m_ds; // used to build
   Folder1 m_fold;
   string_list m_cols; // set up columns
   int totd, totf;
   int m_flag; // copy of flag from user, set during load ...
   string m_fldr; // passed into at LOAD
   int m_is_root; // checked during LOAD

public:
   //dir1( string d );
   dir1();
   ~dir1();
   int load( string d, int flg );
   string m_folder;
   string_list subs;
   Folder_map subs_map;
   Folder_list subs_list;
   vDIRSTR m_vDirs;
#ifdef ADD_V_FILES
   vFILES m_vFiles;
#endif // #ifdef ADD_V_FILES
   // double m_tota, m_totb;
#ifdef WIN32
   int bGotDFS;
   DWORD SecPerClus,	// address of sectors per cluster
      BytPerSec,	// address of bytes per sector
      NumFreeClus,	// address of number of free clusters
      TotClust; 	// address of total number of clusters
   int bGotDF;
   ULARGE_INTEGER ulFreeToCall, ulTotalBytes, ulFreeBytes;
   double dTotSize, dTotFree;
   size_t get_bpc( void ); // get_bytes_per_cluster( void )
#endif // WIN32
   int process_a_folder( string fdr, int level );
   double m_dBC, m_dAdjBC; // total of BYTES
   double dBgnBC, dBgnAdjBC, dEndBC, dEndAdjBC;
   int iBgnFC; // = m_tot_files;
   int iBgnDC; // = m_tot_dirs;
   int m_tot_files, m_tot_dirs;
   string m_drv; // drive designator, like c:\ ...
#ifdef WIN32
   //TCHAR g_szDiskEx[264]; // = DEF_GDISKEX;
   pGDFSEX pgex; // after load
   void load_service( void );
#endif // #ifdef WIN32
   string sub_cf( string s ); // sub_curr_fold

};

#endif // #ifndef _dirg1_HXX
// eof - dirg1.hxx

