
// dirghtml.cxx

#include "dirg.hxx"

dirghtml sDirgHTML;

// out a HTML graph
// "<td width=500>
//<p><img src=pol2.jpg width='"+(kbps4/500)*100+"' height=15>
// </p></td></tr>";
#define LL  "c:/HOMEPAGE/P26/"

char g_coll[] = LL"poll.jpg"; // blue

char g_col1[] = LL"pol1.jpg"; // blue
char g_col2[] = LL"pol2.jpg"; // brown
char g_col3[] = LL"pol3.jpg"; // green
char g_col4[] = LL"pol4.jpg"; // red
char g_col5[] = LL"pol5.jpg"; // light blue = aqua
char g_col6[] = LL"pol6.jpg"; // yellow
char g_col7[] = LL"pol7.jpg"; // mauve (0xff00dd)

char * img_src[] = { g_col1, g_col2, g_col3, g_col4, g_col5, g_col6, g_col7 };
int img_cnt = (sizeof(img_src) / sizeof(char *)); // = 5;
int curr_img = 0;

void dirghtml::add_graph( ostringstream & oss, string & tit, string & hd, int flag, vDIRSTR & fl )
{
   string s;
   size_t i;
   if( totb <= 0 )
      return;

   oss << "<p>"MEOS ;
   // s += b2ks1(totb);
   // oss << "<TABLE class=sbfixed border=\"1\" width=\"600\">"MEOS;
   oss << "<TABLE class=sbfixed border=\"1\" width=\"" <<
      m_tab_width << "\">"MEOS;

   for( i = 0; i < fl.size(); i++ )
   {
      PDIRSTR pf = &fl[i];
      double pct = pf->d_total / totb;
      double wid = pct * m_tab_width; // 600;
      char * pimg;
      curr_img++;
      if(curr_img >= img_cnt)
         curr_img = 0;
      pimg = img_src[curr_img];
      // oss << " <tr><td width=\"600\">"MEOS ;
      oss << " <tr><td width=\"" <<
         m_tab_width << "\">"MEOS ;
//<p><img src=pol2.jpg width='"+(kbps4/500)*100+"' height=15>
      s = "<p><img src=";
      s += pimg; // like pol2.jpg
      s += " width=\"";
      s += get_nn(wid); // +(kbps4/500)*100+"' height=15>
      s += "\" height=\"15\">";
      s += " ";
      s += pf->d_name;
      if( pct < 0.01 ) {
         s += " &lt;1%";
      } else {
         long lg = (long)(pct * 1000.0);
         s += " ";
         s += get_nn( lg / 10.0 );
         s += "%";
      }
      s += "</p>";
      oss << s;
      oss << " </td></tr>"MEOS ;
   }

   oss << "</TABLE>"MEOS;
   oss << "</p>"MEOS ;
}

dirghtml::dirghtml( void )
{
   totb = 0.0;
   m_dn_tots = 0;
#ifdef   WIN32
   pgex = 0; // load_GDFSX_service() = load KERNEL32.DLL/GetFreeDiskSpace[A|W]
#endif // WIN32
   m_dn_drv = 0;
   m_tab_width = 600; // set DEFAULT graph width
}

dirghtml::~dirghtml( void )
{

}

// utility funcions
string dirghtml::get_cn( double number ) {
   ostringstream oss;
   long lg = (long)number;
   // oss << ios_base std::ios. ios_base::fmtflags::dec;
   //oss << ios::dec << ios::fixed;
   //oss << ios::fixed;
   //oss << number; // number = '' + number
   oss << lg; // number = '' + number
   string s = oss.str();
   size_t sz = s.length();
   sz = s.size();
   if( sz > 3 ) { // if MORE THAN 3
       size_t mod = s.size() % 3;
       string rs = (( mod > 0 ) ? s.substr( 0, mod ) : "" );
       size_t mx = (int)( sz / 3 );
       for ( size_t i = 0 ; i < mx ; i++ ) {
          if((mod == 0) && (i == 0)){
             rs += s.substr( 0, 3);
          } else {
             rs += ",";
             //rs += s.substr( mod+3*i, mod+3*i+3);
             rs += s.substr( (mod + (3 * i)), 3 );
          }
       }
       return rs;
    }
    else return s; // = oss.str();
}

string dirghtml::get_nn(double d) // get_nice_number
{
   ostringstream oss;
   long lg, huns, mils;
   if( d < 0.0 ) {
      double dd = d * -1.0;
      oss << "-";
      oss << get_nn(dd);
      return oss.str();
   }

   if( d < 1000.0 ) {
      oss << d;
   } else if ( d < 1000000.0 ) {

      lg = (long)( d / 1000.0 );
      huns = (long)( d - ((double)lg * 1000.0));
      oss << lg << ",";
      if( huns < 10 )
         oss << "00" << huns;
      else if ( huns < 100 )
         oss << "0" << huns;
      else
         oss << huns;

   } else {
      mils = (long)( d / 1000000.0 );
      double d2 = ( d - ((double)mils * 1000000.0) ); // get thousands
      lg = (long)( d2 / 1000.0 );
      huns = (long)( d2 - ((double)lg * 1000.0));
      oss << mils;
      
      oss << ",";
      if( lg < 10 )
         oss << "00" << lg;
      else if ( lg < 100 )
         oss << "0" << lg;
      else
         oss << lg;

      oss << ",";
      if( huns < 10 )
         oss << "00" << huns;
      else if ( huns < 100 )
         oss << "0" << huns;
      else
         oss << huns;

   }
   return oss.str();
}

void dirghtml::add_h_totals( ostringstream & oss, string & tit, string & hd, int flag, size_t i )
{
   string s;
   m_cols.clear();
   // oss << "<b>Total " << (int)i << "</b>"MEOS;
   s = "<b>Total ";
   s += get_nn(i); // fl.size());
   s += "</b>";
   m_cols.push_back(s);
   //oss << "<b>" << b2ks1(totb) << "</b>"MEOS;
   s = "<b>";
   s += b2ks1(totb);
   s += "</b>";
   m_cols.push_back(s);
   //   oss << "<b>" << b2ks1(tota) << "</b>"MEOS;
   s = "<b>";
   s += b2ks1(tota);
   s += "</b>";
   m_cols.push_back(s);
   //   oss << "<b>" << get_nn(totd) << "</b>"MEOS;
   s = "<b>";
   s += get_nn(totd);
   s += "</b>";
   m_cols.push_back(s);
   //   oss << "<b>" << get_nn(totf) << "</b>"MEOS;
   s = "<b>";
   s += get_nn(totf);
   s += "</b>";
   m_cols.push_back(s);
   add_tab_row( oss, m_cols, flag );
}

void dirghtml::set_h_total( ostringstream & oss, string tit, string hd, int flag, Folder_list & fl )
{
   size_t i;
   // process the accumulated records
   tota = 0.0;
   totb = 0.0;
   totd = 0;
   totf = 0;
   for( i = 0; i < fl.size(); i++ )
   {
      Folder1 * pf = fl[i]; // extract our pointer
      totb += pf->f_total;
      tota += pf->f_adjtot;
      totd += pf->f_totdirs;
      totf += pf->f_totfiles;
   }

   m_dn_tots = 1;

}
void dirghtml::set_h_totals( ostringstream & oss, string & tit, string & hd, int flag, vDIRSTR & fl )
{
   size_t i;
   // process the accumulated records
   tota = 0.0;
   totb = 0.0;
   totd = 0;
   totf = 0;
   for( i = 0; i < fl.size(); i++ )
   {
      PDIRSTR pf = &fl[i];
      totb += pf->d_total;
      tota += pf->d_adjtot;
      totd += pf->d_totdirs;
      totf += pf->d_totfiles;
   }

   m_dn_tots = 1;

}

void dirghtml::add_h_disk( ostringstream & oss, string & tit, string & hd, int flag, size_t i )
{
   init_drive_row( hd );
   m_cols.clear();

   m_cols.push_back(m_drv);
   m_cols.push_back( b2ks1(dTotSize) );
   m_cols.push_back( b2ks1(dTotFree) );
   m_cols.push_back( get_nn(SecPerClus) ); // address of sectors per cluster
   m_cols.push_back( get_nn(BytPerSec) );	 // address of bytes per sector

   add_tab_row( oss, m_cols, flag );
}

void dirghtml::add_h_tables( ostringstream & oss, string & tit, string & hd, int flag, vDIRSTR & fl )
{
   size_t i;
   string s;
   if( ! ( flag & f_no_para ) ) {
      oss << "<p>"MEOS ;
   }

   if( !m_dn_tots ) set_h_totals( oss, tit, hd, flag, fl ); // get the TOTAL of the LIST

   add_table_1( oss, tit, hd, flag );

   oss << "<TABLE class=sbfixed border=\"1\">"MEOS;

   set_col_titles();
   int flg = flag & ~(f_col_all);
   add_tab_row( oss, m_cols, flg ); // add column headers, all LEFT aligned

   //for( i = 0; i < subs_list.size(); i++ )
   for( i = 0; i < fl.size(); i++ )
   {
      //Folder1 * pf = subs_list[i];
      // Folder1 * pf = fl[i];
      PDIRSTR pf = &fl[i];
      set_m_cols( pf->d_name,
         b2ks1(pf->d_total),
         b2ks1(pf->d_adjtot),
         get_nn(pf->d_totdirs),
         get_nn(pf->d_totfiles) );
      add_tab_row( oss, m_cols, flag );
   }

   add_h_totals( oss, tit, hd, flag, i );
   
   if( !( flag & f_no_disk ) ) {
      // add the DISK information ROW
      // m_drv = "??"; // DRIVE
      add_h_disk( oss, tit, hd, flag, fl.size() );
   }

   oss << "</TABLE>"MEOS;

   if( ! ( flag & f_no_para ) ) {
      oss << "</p>"MEOS ;
   }

}

void dirghtml::add_table_1( ostringstream & oss, string & tit, string & hd, int flag )
{
   oss << "<TABLE class=sbfixed border=\"0\" width=\"100%\">"MEOS;
   oss << " <TR>"MEOS;
   oss << "  <TD>"MEOS;
   oss << "<b>Folder: " << hd << "</b>"MEOS;
   oss << "  </TD>";
   oss << " </TABLE>";
}

void dirghtml::set_col_titles( void )
{
   string s;
   m_cols.clear();
   s = "<b>Folder</b>";
   m_cols.push_back(s);
   s = "<b>Bytes</b>";
   m_cols.push_back(s);
   s = "<b>Estimate</b>";
   m_cols.push_back(s);
   s = "<b>Dirs</b>";
   m_cols.push_back(s);
   s = "<b>Files</b>";
   m_cols.push_back(s);
}

void dirghtml::add_tab_row( ostringstream & oss, string_list & cols, int flag )
{
   size_t sz = cols.size(); // get columns
   string td = "  <TD>"MEOS;
   string tdr = "  <TD align=\"right\">"MEOS;
   string ntd = "  </TD>"MEOS;

   oss << " <TR>"MEOS;
   if( flag & f_col1_r )
      oss << tdr;
   else
      oss << td;
   if( sz > 0)
      oss << cols[0] << MEOS;
   oss << ntd;

   //oss << "  <TD>"MEOS;
   if( flag & f_col2_r )
      oss << tdr;
   else
      oss << td;
   if( sz > 1 )
      oss << cols[1] << MEOS;
   oss << ntd;

   if( !( flag & f_no_est ) && ( sz > 2 ) ) {
      if( flag & f_col3_r )
         oss << tdr;
      else
         oss << td;
      oss << cols[2] << MEOS;
      oss << ntd;
   }
   if( !( flag & f_no_dir ) && ( sz > 3 ) ) {
      if( flag & f_col3_r )
         oss << tdr;
      else
         oss << td;
      oss << cols[3] << MEOS;
      oss << ntd;
   }

   if( !( flag & f_no_files ) && ( sz > 4 )  ) {
      if( flag & f_col4_r )
         oss << tdr;
      else
         oss << td;
      oss << cols[4] << MEOS;
      oss << ntd;
   }

   oss << " </TR>"MEOS;
}

void dirghtml::set_m_cols( string & s1, // pf->d_name,
                       string & s2, // b2ks1(pf->d_total),
                       string & s3, // b2ks1(pf->d_adjtot),
                       string & s4, // get_nn(pf->d_totdirs),
                       string & s5 ) //get_nn(pf->d_totfiles) );
{
#define SMC(a) s = a; m_cols.push_back(s)
   string s;
   m_cols.clear();
   s = s1;
   m_cols.push_back(s);
   SMC(s2);
   SMC(s3);
   SMC(s4);
   SMC(s5);
}

string dirghtml::b2ks1(double d) // b2ks1(double d)
{
   ostringstream oss;
   double kss;
   long lg;
   double ks = d / 1024.0; // get Ks
   double divs = 1.0;
   string s = "KB";
   if( ks < 1000.0 ) {
      //divs = 1.0;
      //s = "KB";
   } else if ( ks < 1000000 ) {
      divs = 1000.0;
      s = "MB";
   } else if ( ks < 1000000000.0 ) {
      divs = 1000000.0;
      s = "GB";
   } else {
      divs = 1000000000.0;
      s = "TB";
   }
   kss = ks / divs;
   kss += 0.05;
   kss *= 10;
   lg = (long)kss;
   oss << ((double)lg / 10) << " " << s;
   return oss.str();
}

#ifdef WIN32
// pGDFSEX pgex = 0;

void dirghtml::load_GDFSX_service( void )
{
   if( !pgex ) {
      //strcpy(g_szDiskEx, DEF_GDISKEX);
      HMODULE ghLib = LoadLibraryEx( "KERNEL32.DLL",  // points to name of executable module 
                     NULL,                   // reserved, must be NULL
                     0 );   // DWORD dwFlags = entry-point execution flag 
      if( ghLib ) {
         pgex = (pGDFSEX)GetProcAddress( ghLib, DEF_GFDISKEX ); // g_szDiskEx ); // "GetDiskFreeSpaceExA"
         //FreeLibrary( ghLib ); // will be freed, when we exit ...
      }
   }
}
#endif // WIN32

void dirghtml::init_drive_row( string & d )
{
   BytPerSec = 512; // NTFS default!
   dTotSize = 0.0; // (double)ulTotalBytes.QuadPart;
   dTotFree = 0.0; // (double)ulFreeBytes.QuadPart;
   size_t pos = d.find(':'); // do we have a drive
   m_drv = ""; // assume NO DRIVE
   m_fldr = d;
   if( pos != string::npos ) { // *** GOT COLON ***
      m_drv = d.substr(0, (pos + 1)); // get drive, plus colon
      m_drv += "\\"; // add trailing backslash
      m_fldr = d.substr((pos + 1));
      const char * pd = m_drv.c_str();
      bGotDFS = GetDiskFreeSpace( pd, // address of root path
            &SecPerClus,	// address of sectors per cluster
            &BytPerSec,	// address of bytes per sector
            &NumFreeClus,	// address of number of free clusters
            &TotClust );	// address of total number of clusters
      load_GDFSX_service(); // load the DLL service
      if( pgex ) {
         bGotDF = (*pgex) ( pd, &ulFreeToCall,
            &ulTotalBytes, &ulFreeBytes );
      }
      if( bGotDFS ) {
         if(( pgex   ) &&
            ( bGotDF ) ) {
            dTotSize = (double)ulTotalBytes.QuadPart;
            dTotFree = (double)ulFreeBytes.QuadPart;
         } else {
            dTotSize = ( (double)SecPerClus *
               (double)BytPerSec *
               (double)TotClust );
			   dTotFree = ( (double)SecPerClus *
               (double)BytPerSec *
               (double)NumFreeClus );
         }
      }
   } // got a drive

   m_is_root = ( (m_fldr == "\\") ? 1 : 0 );

}

void dirghtml::add_h_head( ostringstream & os, string tit, string hd, int flag )
{
   os << "<HTML>"MEOS;
   os << "<!-- title " << tit << " heading " << hd << " -->"MEOS;
   os << "<HEAD>"MEOS;
   os << "<title>" << tit << " : " << hd << "</title>"MEOS;
   os << "<STYLE>"MEOS;
   os << "BODY.blueform"MEOS;
   os << "{"MEOS;
   os << "    BORDER-RIGHT: #4169e1 double;"MEOS;
   os << "    PADDING-RIGHT: 2px;"MEOS;
   os << "    BORDER-TOP: #4169e1 double;"MEOS;
   os << "    PADDING-LEFT: 2px;"MEOS;
   os << "    PADDING-BOTTOM: 2px;"MEOS;
   os << "    MARGIN: 3px;"MEOS;
   os << "    BORDER-LEFT: #4169e1 double;"MEOS;
   os << "    PADDING-TOP: 2px;"MEOS;
   os << "    BORDER-BOTTOM: #4169e1 double;"MEOS;
   os << "    BACKGROUND-COLOR: #add8e6"MEOS;
   os << "}"MEOS;
   os << ".sbfixed"MEOS;
   os << "{"MEOS;
   os << "    COLOR: #00008b;"MEOS;
   os << "    FONT-FAMILY: 'Courier New';"MEOS;
   os << "    BACKGROUND-COLOR: #afeeee"MEOS;
   os << "}"MEOS;
   os << "</STYLE>"MEOS;
   os << "</HEAD>"MEOS;
   os << "<body class=\"blueform\">"MEOS;
   os << MEOS;
   os << "<h1 align=\"center\">" << tit << "</h1>"MEOS;
   os << MEOS;
   os << "<p align=\"center\">"MEOS;
   os << "<a href=\"#\" onClick=\"history.go(-1)\">Back</a>"MEOS;
   os << "</p>"MEOS;
}

void dirghtml::add_h_tail( ostringstream & os, string tit, string hd, int flag )
{
   os << "<p align=\"center\">"MEOS;
   os << "<font face=\"arial\" size=\"-1\"><a href=\"javascript:self.close();\"><b>close window"MEOS;
   os << "</b></a></font></p>"MEOS;
   os << "</body>"MEOS;
   os << "</HTML>"MEOS;
}

void dirghtml::add_h_table( ostringstream & oss, string tit, string hd, int flag, Folder_list & fl )
{
   string s;
   size_t i;

   if( !m_dn_tots ) set_h_total( oss, tit, hd, flag, fl ); // get the TOTAL of the LIST

   if( ! ( flag & f_no_para ) ) {
      oss << "<p>"MEOS ;
   }

   add_table_1( oss, tit, hd, flag );

   oss << "<TABLE class=sbfixed border=\"1\">"MEOS;

   set_col_titles();
   int flg = flag & ~(f_col_all);
   add_tab_row( oss, m_cols, flg ); // all to the left for header text

   //for( i = 0; i < subs_list.size(); i++ )
   for( i = 0; i < fl.size(); i++ )
   {
      //Folder1 * pf = subs_list[i];
      Folder1 * pf = fl[i];
      set_m_cols( pf->f_name,
         b2ks1(pf->f_total),
         b2ks1(pf->f_adjtot),
         get_nn(pf->f_totdirs),
         get_nn(pf->f_totfiles) );
      add_tab_row( oss, m_cols, flag );
   }

   add_h_totals( oss, tit, hd, flag, i );

   if( !( flag & f_no_disk ) ) {
      // add the DISK information ROW
      // m_drv = "??"; // DRIVE
      add_h_disk( oss, tit, hd, flag, fl.size() );
   }

   oss << "</TABLE>"MEOS;

   if( ! ( flag & f_no_para ) ) {
      oss << "</p>"MEOS ;
   }

}


// eof - dirghtml.cxx
