
// dirghtml.hxx
#ifndef _dirghtml_HXX
#define _dirghtml_HXX
#include "dirg.hxx"
//#include "dirg1.hxx" // keep a directory search
#ifdef   WIN32
typedef BOOL (STDAPICALLTYPE * PGDFSEX) ( LPCTSTR lpDir,
                        PULARGE_INTEGER lpFreeToC,
                        PULARGE_INTEGER lpTotalBytes, 
                        PULARGE_INTEGER lpFreeBytes );
#ifdef UNICODE
#define DEF_GFDISKEX      "GetDiskFreeSpaceExW"
#else // #ifdef UNICODE
#define DEF_GFDISKEX      "GetDiskFreeSpaceExA"
#endif // #ifdef UNICODE  y/n

#endif // WIN32

class dirghtml
{
   string_list m_cols; // set up columns
   double tota, totb; // byte counts
   int totd, totf; // dirctory and folder counts
#ifdef   WIN32
   PGDFSEX pgex;
   void load_GDFSX_service( void ); //load KERNEL32.DLL/GetFreeDiskSpace[A|W]
#endif // WIN32
   DWORD SecPerClus,	// address of sectors per cluster
         BytPerSec,	// address of bytes per sector
         NumFreeClus,	// address of number of free clusters
         TotClust;	// address of total number of clusters
   double dTotSize, dTotFree;
   string m_drv, m_fldr, m_is_root;
   void init_drive_row( string & d );
   int bGotDFS, bGotDF; // = (*pgex) ( pd,
   ULARGE_INTEGER ulFreeToCall, ulTotalBytes, ulFreeBytes;
   int m_dn_tots, m_dn_drv;
public:
   dirghtml();
   ~dirghtml();
   int m_tab_width; // default = 600;

   void add_h_table( ostringstream & oss, string tit, string hd, int flag,
      Folder_list & fl );
   void add_h_tail( ostringstream & os, string tit, string hd, int flag );
   void add_h_head( ostringstream & os, string tit, string hd, int flag );
   void add_graph( ostringstream & oss, string & tit, string & hd, int flag,
      vDIRSTR & fl );
   void add_h_tables( ostringstream & oss, string & tit, string & hd, int flag,
      vDIRSTR & fl );
   void add_table_1( ostringstream & oss, string & tit, string & hd, int flag );
   void set_col_titles( void );
   void add_tab_row( ostringstream & oss, string_list & cols, int flag );
   void set_m_cols( string & s1, // pf->d_name,
                       string & s2, // b2ks1(pf->d_total),
                       string & s3, // b2ks1(pf->d_adjtot),
                       string & s4, // get_nn(pf->d_totdirs),
                       string & s5 ); //get_nn(pf->d_totfiles) );
   void set_h_total( ostringstream & oss, string tit, string hd, int flag,
      Folder_list & fl );
   void add_h_totals( ostringstream & oss, string & tit, string & hd, int flag,
      size_t i );
   void set_h_totals( ostringstream & oss, string & tit, string & hd, int flag,
      vDIRSTR & fl );
   void add_h_disk( ostringstream & oss, string & tit, string & hd, int flag,
      size_t i );

   string get_nn(double d); // get_nice_number
   string get_cn( double number ); // double 2 decimal number, with commas = get_cn()

   string b2ks1(double d); // b2ks1(double d)

};

extern dirghtml sDirgHTML; // global instance of HTML generator

#endif // #ifndef _dirghtml_HXX
// dirghtml.hxx

