
// dirgplib.cxx : cross platform PLIB implemetation.
//
#include "dirg.hxx"
#include <sys/types.h>
#include <sys/stat.h>

int tot_dirs = 0;
int tot_files = 0;
string_list dir_list;
string_list direct_list;
string_list direct_list2;
string_list file_list;
string_list file_list2;
char * dot = ".";
char * ddot = "..";

double tot_byts = 0.0;
double tot_abyt = 0.0;

int tot1_dirs = 0;
int tot1_files = 0;
double tot1_byts = 0.0;
double tot1_abyt = 0.0;

Folder_map g_subs_map;
Folder_list g_subs_list;
vDIRSTR g_vDirs;

int process_a_directory_PLIB( string dpath, int level )
{
   // must add 'stat' to get size ...
   ulDir * dir = ulOpenDir( dpath.c_str() ); // open the SOURCE
   if( dir == NULL ) {
      G_LOG( "ERROR: Not valid directory! [" << dpath << "] Check!" );
      return -1;
   }

   ulDirEnt * entry = 0;
   int dirs = 0;
   int files = 0;
   double totbyts = 0.0;

   size_t bgncnt = direct_list.size();
   size_t endcnt;
   if( level == 1 ) {
      // processing FOLDERS in the root

   }
   do {
      entry = ulReadDir(dir);
      if(entry) {
         char * fp = entry->d_name;
         if( strcmp(fp,dot) && strcmp(fp,ddot) ) {
            string in = dpath;
            in += "\\";
            in += fp;
            if( entry->d_isdir ) {
                // not dot or cousin double dot, ever present ...
                direct_list.push_back(in); // keep the directories, for processing
                direct_list2.push_back(fp); // and short form
                dirs++;
            } else {
               struct __stat64 st;
               int result = _stat64( in.c_str(), &st );
               if(result) {
                  totbyts += st.st_size;
                  file_list.push_back(in); // keep the directories, for processing
                  file_list2.push_back(fp); // and short form
                  files++;
               }
            }
         }
      }
   } while ( entry != NULL );

   tot_dirs += dirs;
   tot_files += files;

   G_LOG( "From folder [" << dpath << "], got " << dirs << " folders, and " <<
      files << " files. (" << (level + 1) << ")" );

   endcnt = direct_list.size();
   for( size_t i = bgncnt; i < endcnt; i++ ) {
      process_a_directory_PLIB( direct_list[i], (level + 1) );
   }

   return dirs;
}

// eof - dirgplib.cxx
