

// fa4Find.c

#include "fa4.h"

extern DWORD g_dwFinds, dwFind1, g_dwItems, dwLnBgn, dwLastLn, g_dwTotFinds;
extern void	ShowFNS( WS );
extern void	Move2Find( WS, LPTSTR lpd, LPTSTR pFind );
extern void	ShowFinding( WS, DWORD dwItems );
// ENGLISH
extern char szEVLabel[]; // = "Volume in drive ";	// C is IPNS-EAST
extern char szESerial[]; // = "Volume Serial Number is "; // 359A-0A25
extern char szEDirect[]; // = "Directory of "; // C:\GEOFF
// FRENCH
extern char szFVLabel[]; // = "Le volume dans le lecteur ";	// L est HDD4
extern char szFDirect[]; // = "Rpertoire de "; // L:\DISNEY
extern int iLen_ok( int i );
extern int IsEDirect2( LPSTR lpv, DWORD ins );
extern int IsFDirect2( LPSTR lpv, DWORD ins );
extern BOOL	FullComp( WS,
				 LPTSTR lpf, DWORD dwoff, DWORD dwmax,
				 LPTSTR lpc, DWORD flen, PDWORD pdw );
extern void	ShowLine( WS,
				 DWORD dwoff,
				 DWORD dwmax,
				 PDWORD pdw,
				 PDWORD pln );
extern void	ShowFind1( WS, DWORD dwFind1, LPSTR lpf );
extern void	prt5( LPSTR lps ); // output if VERB5
//extern VOID OutGFName( WS );


#define	MXLPS	10
DWORD	   lpoff[MXLPS+2];      // keep a set of PREVIOUS line offsets

#define	IncLine	\
{\
	for( is = 0; is < MXLPS; is++ )\
		lpoff[is+1] = lpoff[is];\
	lpoff[0] = dwi;\
	dwl++;\
	gdwLnInFile++;\
	gdwTotLines++;\
}


PMWL g_pActWorkList = 0;

void	ShowALLFinds( WS, DWORD dwFinds, DWORD dwItems, LPSTR lpd )
{
	LPSTR	lpf;
	if( !gfDoneFile ) {
		sprintf( lpVerb, "%s"PRTTERM, glpActive );
		prt( lpVerb );
		gfDoneFile = TRUE;
	}
	if( dwItems == 0 ) {
		sprintf( lpVerb,
			"WARNING: No items to FIND! (Internal ERROR)"PRTTERM );
	} else {
		if( dwFinds ) {
			if( dwItems == 1 ) {
				if( dwFinds == 1 )
					lpf = "Found \"%s\" in [%s] 1 time!"PRTTERM;
				else
					lpf = "Found \"%s\" in [%s] %u times!"PRTTERM;

				sprintf( lpVerb,
					lpf,	// like "Found \"%s\" in [%s] 1 time!",
					lpd,
					ShortName( glpActive, glpTmp, W.ws_dwMxFilNm ),
					dwFinds );
			} else {
				lpf = "Found %u items in [%s] %u times!"PRTTERM;
				if( dwFinds == 1 )
					lpf = "Found %u items in [%s] 1 time!PRTTERM";

				sprintf( lpVerb,
					lpf,	// like "Found %u items in [%s] %u times!",
					dwItems,
					ShortName( glpActive, glpTmp, W.ws_dwMxFilNm ),
					dwFinds );
			}
		} else {
			if( dwItems == 1 ) {
				sprintf( lpVerb, "NO Finds of \"%s\" in [%s]!"PRTTERM,
					lpd,
					ShortName( glpActive, glpTmp, W.ws_dwMxFilNm ) );
			} else {
				sprintf( lpVerb, "NO Finds of %u items in [%s]!"PRTTERM,
					dwItems,
					ShortName( glpActive, glpTmp, W.ws_dwMxFilNm ) );
			}
		}
	}

	prt( lpVerb );
}

void	ShowFinds( WS, DWORD dwFinds, DWORD dwItems, LPSTR lpd )
{
	LPSTR	lpf;
	if( !gfDoneFile ) {
		sprintf( lpVerb, "%s"PRTTERM, glpActive );
		prt5( lpVerb );
		if( VERB5 )
			gfDoneFile = TRUE;
	}
	if( dwItems == 0 ) {
		sprintf( lpVerb,
			"WARNING: No items to FIND! (Internal ERROR)"PRTTERM );
	} else {
		if( dwFinds ) {
			if( dwItems == 1 ) {

				if( dwFinds == 1 )
					lpf = "Found \"%s\" in [%s] 1 time!"PRTTERM;
				else
					lpf = "Found \"%s\" in [%s] %u times!"PRTTERM;

				sprintf( lpVerb,
					lpf,	// like "Found \"%s\" in [%s] 1 time!",
					lpd,
					ShortName( glpActive, glpTmp, W.ws_dwMxFilNm ),
					dwFinds );
			} else {
				lpf = "Found %u items in [%s] %u times!"PRTTERM;
				if( dwFinds == 1 )
					lpf = "Found %u items in [%s] 1 time!PRTTERM";

				sprintf( lpVerb,
					lpf,	// like "Found %u items in [%s] %u times!",
					dwItems,
					ShortName( glpActive, glpTmp, W.ws_dwMxFilNm ),
					dwFinds );
			}
		} else {
			if( dwItems == 1 ) {
				sprintf( lpVerb, "NO Finds of \"%s\" in [%s]!"PRTTERM,
					lpd,
					ShortName( glpActive, glpTmp, W.ws_dwMxFilNm ) );
			} else {
				sprintf( lpVerb, "NO Finds of %u items in [%s]!"PRTTERM,
					dwItems,
					ShortName( glpActive, glpTmp, W.ws_dwMxFilNm ) );
			}
		}
	}
	prt5( lpVerb );
}



void Add2gsFileList( WS )
{
   PBY_HANDLE_FILE_INFORMATION phi = &gsFileInf;
   if( VERB4 )
   {
      // FIX20010319 -v4 adds date order of finds at end
      PMWL  pmwl = (PMWL)MALLOC(LPTR, sizeof(MWL));
      if(pmwl)
      {
         g_pActWorkList = pmwl;
         pmwl->wl_dwRank = 0;
         strcpy( &pmwl->wl_cName[0], glpActive );
         pmwl->wl_DateTime = phi->ftLastWriteTime;
         pmwl->wl_dwFound = g_dwFinds; // get the finds in this file
         pmwl->wl_dwItems = g_dwItems; // count of items being found
         InsertTailList( &gsFileList, (PLE)pmwl );
      }
   }
}

///////////////////////////////////////////////////////////////////////////////
// FUNCTION   : DoLineChk
// Return type: void 
// Arguments  : WS
//            : LPSTR lpb
//            : DWORD dwLnBgn
//            : DWORD dwi
// Description: I can see I am looking for "Directory of "; like C:\GEOFF
//              or the french equivalent, but WHY beats me now.
// FIX20050121 - If finding a file name in a directory list, it would be good
// if, when found, the DIRECTORY NAME is also output ...
// char	szEDirect[] = "Directory of "; // C:\GEOFF
// FRENCH
// char	szFVLabel[] = "Le volume dans le lecteur ";	// L est HDD4
// char	szFDirect[] = "Rpertoire de "; // L:\DISNEY

///////////////////////////////////////////////////////////////////////////////
void	DoLineChk( WS, LPSTR lpb, DWORD dwLnBgn, DWORD dwi )
{
	int i, j, k, c, d;
	if(( lpb ) &&
		( dwi > dwLnBgn ) )
	{
		DWORD	iLen = (dwi - dwLnBgn); // get length of line
      PSTR	lpd  = &lpb[dwLnBgn]; // pointer to beginning
      //extern int iLen_ok( int i );
      if( iLen_ok( iLen ) ) {
		//if(( iLen > (sizeof(szEDirect)-1) ) ||
		//	( iLen > (sizeof(szFDirect)-1) ) ) 	{
         k = 0;
         while( iLen && (*lpd <= ' ') ) {
            lpd++;
            iLen--;
            k++;
         }
         // at least it has the length
         c = *lpd;
         i = j = d = 0;
         if( c == szEDirect[0] ) {
            i = IsEDirect2( lpd, iLen );
            j = i;
            d = szEDirect[0];
         } else if( c == szFDirect[0] ) {
            j = IsFDirect2( lpd, iLen );
            i = j;
            d = szFDirect[0];
         }
		   //if( ( ( iLen > (sizeof(szEDirect)-1) ) && ( i ) ) ||
			//   ( ( iLen > (sizeof(szFDirect)-1) ) && ( j ) ) )
		   if( i  || j ) {
            // got a match ...
			   LPSTR	lpdir;
			   if( (DWORD)i < iLen ) {
				   lpdir = &lpb[dwLnBgn + i + k];
				   k = (iLen + k) - i;
				   for( j = 0; j < k; j++ )
				   {
					   if( lpdir[j] < ' ' ) {
						   break;
					   }
					   gcDirBuf[j] = lpdir[j];
					   if( j > 260 )
						   break;
				   }
				   gcDirBuf[j] = 0;
				   i = strlen( &gcDirBuf[0] ); 
				   if(i)
				   {
					   if( gcDirBuf[i-1] != '\\' )
					   {
						   strcat( gcDirBuf, "\\" );
						   i++;
					   }
				   }
				   giDirLen = i; // set the LENGTH of the string copied
			   }
		   }
      }
	}
}


///////////////////////////////////////////////////////////////////////////////
// FUNCTION   : ShowFLines
// Return type: VOID 
// Argument   : PLE ph == = &g_sLines;
// Description: Output the actual FINDS, but take into account any
//              TYPE and numbering during the output
// Called if( g_dwFCnt > 1 ) { ShowFLines( &g_sLines ); }
///////////////////////////////////////////////////////////////////////////////
VOID  ShowFLines( PLE ph )  // = &g_sLines;
{
   PLE   pn, pn1;
   PFLINE pl, pl1;
   DWORD dwt;
   DWORD dwc = 0;
   Traverse_List(ph,pn)
   {
      pl = (PFLINE)pn;
      dwt = pl->dwTyp; // if we have a TYPE (1=same file, 2=same file and line)
      if(dwt)   
      {
         switch(dwt)
         {
         case '1':   // can ONLY output if other types found in same FILE
            Traverse_List(ph, pn1)
            {
               if( pn != pn1 )
               {
                  pl1 = (PFLINE)pn1;
                  if(( pl1->dwTyp ) && // also has to have a TYPE
                     ( pl->pFind != pl1->pFind ) ) // and is a DIFFERENT find object
                  {
                     if( pl->dwOrd == pl1->dwOrd )    // if in the SAME file
                     {
                        pl->dwTyp = 0;
                        dwc++;
                        if( pl->dwNum != pl1->dwNum ) // if NOT the SAME line
                        {
                           pl1->dwTyp = 0;
                           dwc++;
                        }
                     }
                  }
               }
            }
            break;
         case '2':   // can ONLY output if other types found in same file AND line
            Traverse_List(ph, pn1)
            {
               if( pn != pn1 )
               {
                  pl1 = (PFLINE)pn1;
                  if(( pl1->dwTyp == '2' ) && // also has to have a TYPE
                     ( pl->pFind != pl1->pFind ) ) // and is a DIFFERENT find object
                  {
                     if(( pl->dwOrd == pl1->dwOrd ) &&   // if in the SAME file
                        ( pl->dwNum == pl1->dwNum ) )    // and on the SAME line
                     {
                        pl->dwTyp = 0;
                        //pl1->dwTyp = 0;
                        dwc++;
                     }
                  }
               }
            }
            break;
         default:    // unknown TYPE
            pl->dwTyp = 0;
            dwc++;
            prt( "WARNING: Appear to have an UNKNONW type!"MEOR );
            break;
         }
      }
      else
         dwc++;
   }

   if(dwc)
   {
      Traverse_List(ph,pn)
      {
         pl = (PFLINE)pn;
         if( pl->dwTyp == 0 )
            prt( &pl->cLine[0] );
      }
      dwc = 0;
   }
   FreeLList(ph,pn);
}

// #endif   // #ifdef   USEFINDLIST // = PVERS "V4.0.16" // FIX20010703 - order FIND strings
// #ifdef   USEFINDLIST    // = FIX20010703
void Find_Skip( WS, DWORD dwfs, PTSTR lpc, char c, DWORD flen, PTSTR lpd, BOOL fBin );

DWORD g_dwMaxFnds = 0;
DWORD g_dwFndFlg;
DWORD g_dwThisFnd;
///////////////////////////////////////////////////////////////////////////////
// FUNCTION   : Find_In_Gen
// Return type: void 
// Arguments  : WS
//            : LPSTR lpInF
// Description: This is where it ALL happens. The file has been mapped
//              and we process the buffer char by char looking for the
// first find char.
///////////////////////////////////////////////////////////////////////////////
void	Find_In_Gen( WS, LPSTR lpInF )
{
	DWORD	   dwi, dwfs, dwl;
	LPTSTR	pFind;            // pointer to string to FIND
   LPTSTR   lpc, lpd;
	DWORD    flen, is;
	char	   c, d, pd;
//	DWORD	   dwFinds, dwFind1, dwItems;
//	DWORD	   lpoff[MXLPS+2];      // keep a set of PREVIOUS line offsets
//	BOOL	fPar;
	BOOL	   fBin;
//	DWORD	   dwLastLn, dwLnBgn;
   BOOL     bIgC = g_bIgComm;    // extract the FLAG
   PLE      phf = &g_sFind;        // get list of FIND strings
   PLE      pn;
   PFLINE   pl;

	g_dwFinds = 0;
	dwFind1 = 0;
	g_dwItems = 0;
	// Got file MEMORY MAPPED
	// ======================
	if( ( W.ws_FileType & FT_BIN ) || ( gfBinary ) )
		fBin = TRUE;
	else
		fBin = FALSE;
//	fPar = gfParity;
	dwfs = gdwActLen;
	W.ws_dwTotal += dwfs;

	if( VERB6 )
      ShowFNS( pWS );

	gfDoneFile = FALSE;		// reset DONE FILE
   g_dwFileNum++;          // bump the file number

// ADDCVSDATE
   if( g_bCVSDate ) {
      PLE ph1 = &g_sCVSLines;
      KillLList(ph1);
   }

	//pFind = glpFindMem;	// get the FIND strings memory buffer
	//lpd = &gszFindStgs[0];  // = W.ws_szFindStgs
	lpd = &g_szCurrFind[0];  // = GW.ws_szCurrFind

   // FIX20050304 = g_bDoAllin1 -F:1 all finds in one file g_dwFCnt = count on list
   g_dwFndFlg = 0; // up to 32 bits

	//while( ( flen = strlen( pFind ) ) > 0 )  // while there are FIND string(s)
   Traverse_List( phf, pn ) // for EACH of the FIND strings, search this FILE
	{
      g_dwThisFnd = (1 << g_dwItems);
		// count of items to search for
		g_dwItems++;
		dwFind1 = 0;
      //pFind  = (LPTSTR)pn;
      //pFind += sizeof(LIST_ENTRY);
      pl = (PFLINE)pn;
      g_psActFind = pl; // set current active FIND structure
      pFind = &pl->cLine[0];

      flen = strlen(pFind);
		Move2Find( pWS, lpd, pFind );
		W.ws_lpCurrFind = pFind;   // original string
		W.ws_dwCurrFLen = flen;    // length of FIND string
		W.ws_lpCurFind  = lpd;     // copy of FIND string (with CASE fixed)
		W.ws_dwCurFLen  = strlen( lpd );
		c = *lpd;	// Get first character from COPY of find string
		ShowFinding( pWS, g_dwItems );
		lpc = (LPSTR)glpMapView;
		dwl = 0;
		gdwLnInFile = 0;
		pd = 0;

		for( is = 0; is < MXLPS; is++ )
			lpoff[is] = 0; // start with NO previous line offsets

		// Process the file
      // ******************************
		dwLnBgn = 0;
      // FIX20010413 -I+ = Skip C/C++ comments in g_bIgComm
      if( bIgC ) {
         Find_Skip( pWS, dwfs, lpc, c, flen, lpd, fBin );
      } else { // !bIgC
         // simple scan through the buffer
   		for( dwi = 0; dwi < dwfs; dwi++ )
   		{
   			d = (*GetChr) ( &lpc[dwi] );  // call indirectly to GetChr (W.GETCHR) function
   			if( pd == 0x0a )
   			{
   				dwLastLn = dwLnBgn;
   				if(( gfDirLst ) && (( dwi - dwLnBgn) > 2 ) ) {
   					DoLineChk( pWS, lpc, dwLnBgn, dwi );
   				}
   				dwLnBgn  = dwi;
   			}
   
            // if we match with character one
   			if( c == d )
   			{
   				// if GOT the first char, do a FULL COMPARE
   				if( FullComp( pWS, lpc, dwi, dwfs, lpd, flen, &dwl ) )
   				{
                  // output a line, passing offsets to previous lines as well
                  g_dwFndFlg |= g_dwThisFnd; // up to 32 bits // = (1 << g_dwItems);
   					ShowLine( pWS, dwi, dwfs, &lpoff[0], &dwl );
   					if( fBin ) { // if BINARY, just bump past the FOUND
   						dwi += W.ws_dwCurFLen;
   					} else { // if TEXT, move to END OF LINE
   						dwi++;
   						for( ; dwi < dwfs; dwi++ )
   						{
   							d = lpc[dwi];
                        // FIX20010328 Fix for UNIX file searching
   							//if( d == 0x0d )
   							if( ( d == 0x0a ) || ( d == 0x0d ) )
                           break;
   						}
   					}
   					g_dwFinds++;
   					dwFind1++;
   				}
   			}
            // FIX20010328 Fix for UNIX file searching
   			//if( d == 0x0d )
   			if( d == 0x0a )
   			{
               // =========================================================
   				IncLine;	// dwl++; yes, but it also backs-up
               // the offsets of previous lines. Sort of HISTORY in lpoff[]
   			}
   			pd = d;
   		} // for( dwi = 0; dwi < dwfs; dwi++ ) loop through the buffer
      }  // ignore comment or not
      // ******************************

		if( VERBM ) ShowFind1( pWS, dwFind1, pFind );
		//pFind += (flen + 1); // up to NEXT find string, if more than one

		// Processing MULTIPLE finds with
	} // Traverse_List( phf, pn ) // for EACH of the FIND strings, search this FILE
   // was while( flen = strlen( pFind ) )

// ADDCVSDATE
   if( g_bCVSDate )  // ( !VERB4     ) )
   {
      PLE      ph = &g_sCVSLines;
      LPTSTR   lpt = &g_szTmpBuf[0];
      DWORD    dwc;
      if( IsListEmpty(ph) ) {
         if( VERB5 ) {
            sprintf(lpt, "No valid entries in %s!", lpInF );
            prt(lpt);
         }
      } else {
         PLE pn = ph->Flink;
         PCVSLN pcvs = (PCVSLN)pn;
         PLE   pn2;
         PCVSLN pcvs2;
         LONG     lg;
         ListCount2(ph, &dwc);   // get COUNT in this LIST
         RemoveEntryList(pn);    // extract this entry from the list

         ph = &g_sEntries;       // get the ENTRIES list
         Traverse_List(ph, pn2)  // traverse it
         {
            pcvs2 = (PCVSLN)pn2; // re-cast pointer
            lg = CompareFileTime(
                     &pcvs->sFT, // first file time
                     &pcvs2->sFT ); // second file time
                  // Value Meaning 
                  // -1 First file time is less than second file time.
                  // 0  First file time is equal to second file time. 
                  // 1  First file time is greater than second file time.
            if( lg > 0 ) {
               InsertBefore(pn2,pn);
               pn = 0;
               break;
            }
         }
         if(pn) {
            InsertTailList(ph,pn);
         }

         if( VERB4 ) {
            if( !gfDoneFile ) {
               PLE   pf = pcvs->psName;
               if(pf) {
                  LPTSTR   _lpf = (LPTSTR)pf;
                  _lpf += sizeof(LIST_ENTRY);
                  strcpy(lpt, _lpf);
                  strcat(lpt,MEOR);
                  prt(lpt);
               }
      			gfDoneFile = TRUE;
            }
            strcpy(lpt, &pcvs->szFile[0]);
            strcat(lpt, " ");
            AppendDateTime( lpt, &pcvs->sSysTm );
            sprintf(EndBuf(lpt), " (LATEST of %d entries)", dwc );
            strcat(lpt, MEOR);
            prt(lpt);
         }
      }
   }

// #ifdef   USEFINDLIST // = PVERS "V4.0.16" // FIX20010703 - order FIND strings
   if( g_dwFCnt > 1 ) {
      ShowFLines( &g_sLines );
   }

// #endif   // #ifdef   USEFINDLIST // = PVERS "V4.0.16" // FIX20010703 - order FIND strings
   // FIX20050304 = g_bDoAllin1 -F:1 all finds in one file g_dwFCnt = count on list
   dwi = 0; // no post find output
   if( g_dwFinds ) {
      dwi = 1; // SET post find output
      if( g_bDoAllin1 && ( g_dwFCnt > 1 ) ) {
         if( g_dwFndFlg == g_dwFMax ) { // up to 32 bits // = (1 << g_dwItems)
            g_dwMaxFnds++; // bump 'maximum' find ie all finds found in this file
         } else { // *NOT* a max find
            dwi = 0;
         }
      }
   }

   g_dwTotFinds += g_dwFinds;
   //if(dwi)
   //   ShowALLFinds( pWS, g_dwFinds, g_dwItems, lpd );
   //else
   ShowFinds( pWS, g_dwFinds, g_dwItems, lpd ); // only if VERB5

   if( dwi ) {
      // OutGFName( pWS );
      Add2gsFileList( pWS ); // keep files with desired finds ...
   }

   UNREFERENCED_PARAMETER(lpInF);

}

// *******************************************
void Find_Skip( WS, DWORD dwfs, PTSTR lpc, char c, DWORD flen, PTSTR lpd, BOOL fBin )
{
   DWORD dwi, is, dwl;
   char  d, pd;
   pd = 0;
   dwl = 0;
   		for( dwi = 0; dwi < dwfs; dwi++ )
   		{
   			d = (*GetChr) ( &lpc[dwi] );  // call indirectly to GetChr (W.GETCHR) function
            if( (  d == '*' ) &&
                ( pd == '/' ) )
            {
               // entered a C/C++ comment field - go until the END
               // began with /* and end with */
               dwi++;   // bump to NEXT
               for( ; dwi < dwfs; dwi++ )
               {
                  d = lpc[dwi];  // extract a char
                  if( ( d == '/' ) &&
                     ( pd == '*' ) )
                  {
                     d = 0;   // make sure NO first match below
                     break;   // few, end of comment
                  }
         			if( d == 0x0a )
         			{
         				IncLine;	// dwl++;
         			}
                  pd = d;
               }
            }
            else if( ( d == '/' ) &&
               ( pd == '/' ) )
            {
               // entered a single line comment field - go to end of line
					dwi++;
					for( ; dwi < dwfs; dwi++ )
					{
						d = lpc[dwi];
                  // FIX20010328 Fix for UNIX file searching
						if( ( d == 0x0a ) || ( d == 0x0d ) )
                     break;
					}
            }
            else if( pd == 0x0a )
   			{
   				dwLastLn = dwLnBgn;
   				if(( gfDirLst ) && (( dwi - dwLnBgn ) > 2) ) {
                  // we have a -D - search a DIRECTORY listing
   					DoLineChk( pWS, lpc, dwLnBgn, dwi );
   				}
   				dwLnBgn  = dwi;
   			}
   
            // if we match with character one
            // ******************************
   			if( c == d )
   			{
   				// if GOT the first char, do a FULL COMPARE
   				if( FullComp( pWS, lpc, dwi, dwfs, lpd, flen, &dwl ) )
   				{
                  // output a line, passing offsets to previous lines as well
   					ShowLine( pWS, dwi, dwfs, &lpoff[0], &dwl );
   					if( fBin )
   					{
   						// if BINARY, just bump past the FOUND
   						dwi += W.ws_dwCurFLen;
   					}
   					else
   					{
   						// if TEXT, move to END OF LINE
   						dwi++;
   						for( ; dwi < dwfs; dwi++ )
   						{
   							d = lpc[dwi];
                        // FIX20010328 Fix for UNIX file searching
   							//if( d == 0x0d )
   							if( ( d == 0x0a ) || ( d == 0x0d ) )
                           break;
   						}
   					}
   					g_dwFinds++;
   					dwFind1++;
   				}
   			}
            // FIX20010328 Fix for UNIX file searching
   			//if( d == 0x0d )
   			if( d == 0x0a )
   			{
   				IncLine;	// dwl++;
   			}
   			pd = d;
   		}


}

// *******************************************
// eof - Fa4Find.c
