
// Fa4Help.c

#include	"Fa4.h"
extern   void	OutHeader( WS );
extern   void  boi( LPTSTR lps );
extern   void  outvals( void );
extern   BOOL	OpenReadFile( LPSTR lpf, HANDLE * ph );
extern	void	EnableDiagFile( void );
extern   DWORD	GetFileLen( HANDLE hf );
extern   void	Error_Exit( WS, int val );

#define	Err_Exit( a )	Error_Exit( pWS, a )

//Informatique Rouge *** FIND ALL UTILITY ***  28 October, 1996
//Purpose:  To locate specific text in a file or group of files.
//Useage:   FA4 Arg1 Arg2 [/Switches]
//Where:    Arg1 = "Find Text" or *"text" 1* or @ItemFile.
//          Arg2 = [[D:\]Path\]File(s) or @FileList.
//          The @Input files = Set of Space/Line delimited items.
//Switches: Each preceeded by / or - and separated by space.
//          B    - Force binary file search.
//          c    - cASE tOGGLE - Be case SenSiTive.
//          D    - directory list file
//          F    - Finds
//          I    - Include comments, and display null finds.
//          M    - Makefile processing
//          N    - Line numbering on finds.
//          P    - Ignore Parity for compare (8th bit stripped).
//          V[n] - Toggle verbosity (Def=V2).
//          W    - Only whole words (Including things like :WHOLE_).
//          CCmd - Add "Cmd" text to front of a line of a find.
//          Cmd text must be delimited with " " if it contains spaces.
//Note:     V0=Finds, V1=Files, V2=Finds & Files, V9=ALL ON.
//                                                    Happy searching...
#define	TAILSTG	"                                                    Happy searching..."

void	Usage( WS, UINT Err )
{
	OutHeader( pWS );
	prt( "Purpose:  To locate specific text in a file or group of files."PRTTERM );
	prt( "Usage:    FA4 Arg1 Arg2 [-Switches]"PRTTERM );
	prt( "Where:    Arg1 = \"Find Text\" or +\"text\" 1+ or @FindItems."PRTTERM );
	//prt( "          Note 'C' runtime requires \\\" to include \"in command!"PRTTERM );
	prt( "          Arg2 = [[D:\\]Path\\]File(s) or @FileList."PRTTERM );
	prt( "          The @Input files are interpreted as a set of line delimited items."PRTTERM );
	prt( "Switches: Each preceeded by / or - , space separated, case ignored."PRTTERM );
#ifdef   FIX20000902 // FIX input files in input file and add -8
	prt( "      -8       = Ouput file name in DOS format."PRTTERM );
#endif   // FIX20000902 // FIX input files in input file and add -8
	prt( "      -B[n:n]  = Force binary file output. [Back:Forward] (def=40:40)"PRTTERM );
#ifdef   ADDFCOUNT   // FIX20010824 - Minimum FIND count before OUTPUT
	prt( "      -c[nn]   = cASE tOGGLE - Be case SenSiTive. (Cnn=Find Minimum)"PRTTERM );
#else // !ADDFCOUNT   // FIX20010824 - Minimum FIND count before OUTPUT
	prt( "      -c       = cASE tOGGLE - Be case SenSiTive."PRTTERM );
#endif   // ADDFCOUNT y/n   // FIX20010824 - Minimum FIND count before OUTPUT
#ifdef		ADDDIRLST	// Special for Directory Listing
	prt( "      -D[L]    = Directory Listing Search. (L=list output)"PRTTERM );
#endif	// ADDDIRLST
#ifdef		ADDERRLST	// Special for Directory Listing
	prt( "      -Ennnnn  = Find WIN32 Error or closest.(Try ALL)."PRTTERM );
#endif	// ADDERRLST
//	prt( "      -F\"text\" = Find text. Can be multiple items. (-F:M for make files)"PRTTERM );
	prt( "      -F\"text\" = Find multiple items. (-F:1 = all in one file)"PRTTERM );
#ifdef	ADDINHIB
//	prt( "      -I       = Try to inhibit comment processing."PRTTERM );
//	prt( "      -I       = Inhibit space / tab in finding text."PRTTERM );	// gfSpacey = TRUE
//	prt( "      -I:\"test\"= Inhibit finds with this text in line."PRTTERM );
// "2001 April 13"	// FIX20010413 - add -I+ inhibit find in C/C++ comments
	prt( "      -I:\"text\"= Inhibit finds with this text. (-I+ for C/C++ comments)"PRTTERM );
#endif	// ADDINHIB
#ifdef   ADDLOPTION
   prt( "      -L[nn|F] = Output Additional [nn=lines|F=Complete function] after find."PRTTERM );
#endif   // ADDLOPTION
   prt( "      -M[2]    = Process as a MAKE file. Same as -F:M. 2 expands $(mac)."PRTTERM );
	prt( "      -N       = Line numbering on finds."PRTTERM );
#ifdef	ADDOUTFIL
	prt( "      -OOutFile= Add all output to a file."PRTTERM );
#endif	// ADDOUTFIL
	prt( "      -P       = Ignore Parity for compare. (8th bit stripped)."PRTTERM );
#ifdef	ADDRECUR
	prt( "      -R       = Recursive into sub directories."PRTTERM );
#endif	// ADDRECUR
	prt( "      -Vn      = Verbosity level and type. (Def=V2)."PRTTERM );
// FIX20010413    // add a -w2 meaning MUST be space before and after WHOLE
	prt( "      -W       = Only whole words (Includes like :WHOLE_. -W2 for spaces)."PRTTERM );
	prt( "      -X       = Exclude file list, as @InputFile or list separated by ;."PRTTERM );
//	prt( "Notes on Verbosity: -V0 = No output. Errorlevel gives the find count."PRTTERM );
//	prt( " V1 = Show File Name only, and only when Find(s)."PRTTERM );
//	prt( " V2 = Show File Name AND line(s) with find(s). (Default)"PRTTERM );
//	prt( " V3++ Increasing verbality, up to -V9 Maximum Verbality. ie Very Noisy!"PRTTERM );
// FIX20010413    // add a -w2 meaning MUST be space before and after WHOLE
// and maybe -IC to inhibit finds in C/C++ comment lines
	prt( "Notes:  Errorlevel gives the find count. -IC inhibit finds in C/C++ comments."PRTTERM );
	prt( "Output: V0=None, V1=Files, V2=Finds & Files(def), up to V9=ALL ON."PRTTERM );
// FIX20010319 -v4 adds date order of finds at end - See VERB4
   prt( "Note -V3 adds date and time after find file, and -V4 add a list at end."PRTTERM );
// === the last line ===   
//#define	TAILSTG	"                                                    Happy searching..."
//#ifdef	FA4DBG
	{
		BOOL bCrLf = GetEnsureCrLf();
		SetEnsureCrLf( FALSE );
		prt( TAILSTG );
		SetEnsureCrLf( bCrLf );
	}
//#else	/* !FA4DBG */
//	prt( TAILSTG );
//#endif	/* DBG or not */

   UNREFERENCED_PARAMETER(Err);

	Pgm_Exit( pWS );
}



///////////////////////////////////////////////////////////////////////////////
// FUNCTION   : Add2CmdBuf
// Return type: VOID 
// Arguments  : WS
//            : LPTSTR cp
//            : INT j
// Description: Simply ADD a command argument to the command
//              buffer ....
///////////////////////////////////////////////////////////////////////////////
VOID  Add2CmdBuf( WS, LPTSTR cp, INT j )
{
   if( ( j + gdwCmdLen ) < MXCMDBUF )
	{
		if( gdwCmdLen )
      {
         if( ( gdwCmdLn + j ) > MX1LINE )
         {
            gdwCmdLn = 0;
            strcat( &gszCmdBuf[0], MEOR );
         }
         else
            strcat( &gszCmdBuf[0], " " );
      }
		strcat( &gszCmdBuf[0], cp );
		gdwCmdLen = strlen( &gszCmdBuf[0] );
      gdwCmdLn += j;
	}
	else
   {
      if( ( gdwCmdLen + 4 ) < MXCMDBUF )
	   {
		   lstrcat( &gszCmdBuf[0], "+++" );
		   gdwCmdLen = lstrlen( &gszCmdBuf[0] );
	   }
      gdwCmdLen = MXCMDBUF;
   }
}

// =======================================
// void	OutCmds( WS )
//
// Show the COMMANDS on the command line
//
// =======================================
void	OutCmds( WS )
{
	if( !gbDoneCmds )
	{
		gbDoneCmds = TRUE;
		boi(0);
		boi( "Commands: " );
		if( gdwCmdLen )
		{
			boi( &gszCmdBuf[0] );
		}
		else
		{
			boi( "<none>" );
		}
		boi( PRTTERM );
		boi(0);
	}
}

///////////////////////////////////////////////////////////////////////////////
// FUNCTION   : Check4Help
// Return type: void 
// Arguments  : WS
//            : int argc
//            : char * * argp
// Description: This seaches the command arguments for
//              one of -? -h or -H
///////////////////////////////////////////////////////////////////////////////
void	Check4Help( WS, int argc, char * * argp )
{
	int	i;
	char * cp;
	char	c;
	if( argc > 1 )
	{
		for( i = 1; i < argc; i++ )
		{
         c = 0;
         cp = argp[i];
         if(cp)
            c = *cp;
         if(c)
			{
				if( ( c == '-' ) || ( c == '/' ) )
				{
					cp++;
					c = *cp; 
					if(c)
					{
						if( ( c == '?' ) || ( c == 'h' ) || ( c == 'H' ) )
						{
                     // FIX20010330 - Also OUPUT the commands, at least in this set
                     for( i = 1; i < argc; i++ )
                     {
                        cp = argp[i];
                        Add2CmdBuf( pWS, cp, (INT)strlen(cp) );
                     }
                     OutCmds( pWS );
							Usage( pWS, 0 );	// NEVER RETURN!!!
						}	// got a HELP request
					}	// and a char following switch
				}	// if it is a switch
			}	// got pointer AND character
		}	// for( i = 1; i < argc; i++ )
	}	// more than 1 argc
}

#ifdef		ADDERRLST	// Special for Directory Listing
//				case 'E':	// WIN32 Error.
void	GetErrNum( WS, char * lpIn )
{
	int		i, j, k;
	char	c;
	long	lg;
	char *	cp;

   j = 0;
   cp = lpIn;
   if(cp)
      j = lstrlen(cp);
   if(j)
	{
		lg = 0;
		k = 0;
		c = (char)toupper(*cp);
		if( ( c == 'A' ) &&
			( j >  2   ) &&
			( ( cp[1] == 'l' ) || ( cp[1] == 'L' ) ) &&
			( ( cp[2] == 'l' ) || ( cp[2] == 'L' ) ) )
		{
			outvals();
			return;
		}

		if( ( j > 2 ) &&
			( cp[0] == '0' ) &&
			( ( cp[1] == 'x' ) || ( cp[1] == 'X' ) ) )
		{
			// assume HEX
			j  -= 2;
			cp += 2;
			for( i = 0; i < j; i++ )
			{
				c = (char)toupper(cp[i]);
				if( ( c >= '0' ) && ( c <= '9' ) )
				{
					lg = ( lg * 16 ) + ( c - '0' );
					k++;
				}
				else if( ( c >= 'A' ) && ( c <= 'F' ) )
				{
					lg = ( lg * 16 ) + ( c - ('0'+7) );
					k++;
				}
				else
				{
					if( k )
						break;
				}

			}
		}
		else
		{
			// assume DECIMAL
			for( i = 0; i < j; i++ )
			{
				c = cp[i];
				if( ( c >= '0' ) && ( c <= '9' ) )
				{
					lg = ( lg * 10 ) + ( c - '0' );
					k++;
				}
				else
				{
					if( k )
						break;
				}
			}
		}
		if( k )
		{
			glFindErr = lg;
			gbFindErr = TRUE;
		}
	}
}

#endif	// ADDERRLST

BOOL	IsBgnType( char c )
{
	BOOL	flg = FALSE;
   // FIX20001022    // fix find of "'@'"!!!
   // remove the '\'' from this list
	//	( c == '\'' ) ||
	if( ( c == '"' ) ||
		( c == '+' ) )
	{
		flg = TRUE;
	}
	return flg;
}


/* ============================================================
 * void	Add2Finds( WS, LPSTR lps, BOOL bFSwitch )
 * case 'F':
 * Present begin/end type characters are only " or +
 * So I can use -F:M as a special MAKEFILE switch
 *
 * If bFSwitch is TRUE this is a FIND using -F"abc"
 * We are already pointing to the "abc"
 * If bFSwitch is FALSE,
 * it is an 'unswitched' argument on the command line
 *
 * FIX20050304 - Add -F:1 = all finds before file display
 *
 */
//#define  ISNUM(a)    ( ( a >= '0' ) && ( a <= '9' ) )

BOOL  Add2Finds( WS, LPSTR lps, BOOL bFSwitch )
{
   BOOL  bRet = TRUE;   // assume ok
	char	c, d;
	LPSTR	cp;
   INT   ilen;
#ifdef   USEFINDLIST    // FIX20010703
   DWORD    dwn = 0;
   DWORD    dwo = 0;
#endif   // #ifdef   USEFINDLIST    // FIX20010703

   c = 0;
   cp = lps;
   ilen = 0;
   if(cp) {
      c = *cp;
      ilen = strlen(cp);
   }

   // FIX20050304 - Add -F:1 = all finds before file display
   // 1 - Handle -F:1 = all finds in file before display
   if( ( bFSwitch ) &&
       ( c == ':' ) ) {
      cp++;
      c = (char)toupper(*cp);
      if( c == '1' ) {
         g_bDoAllin1 = 1;
      } else {
         bRet = FALSE;  // flag an error
      }
      return bRet;
   }


#if 0  // code to REMOVE

   // 1 - Handle -F:M switch
   if( ( bFSwitch ) &&
       ( c == ':' ) )
   {
      cp++;
      c = (char)toupper(*cp);
      if( c == 'M' )    // also same as -M switch
      {
// switch -F:M
//#define  g_bDoMake      GW.ws_bDoMake  // obey makefile continuation char on output
         g_bDoMake = TRUE;
         // maybe later
         cp++;
         if( *cp )
         {
            if( *cp == '2' )
               g_bDoMake2 = TRUE;
            else
               bRet = FALSE;  // flag error
         }
      }
      else
         bRet = FALSE;  // flag an error

      return bRet;
   }
#endif // #if 0  // code to REMOVE

#ifdef   USEFINDLIST    // FIX20010703
   if(( bFSwitch  ) &&
      ( ilen >= 5 ) )
   {
      // 2 - Handle -F1|2:nn:"abc"
      if(( ( c == '1' ) || ( c == '2' ) ) &&
         ( cp[1] == ':' ) && ( cp[2] ) )
      {
         cp += 2;
         dwn = (DWORD)c;
         c = *cp;
         while( c && (c != ':') )
         {
            if( ISNUM(c) )
            {
               dwo = ((dwo * 10) + (c - '0'));
            }
            else
               return FALSE;
            cp++;
            c = *cp;
         }
         if( c == ':' )
         {
            cp++;
            c = *cp;    // get the FIRST letter of the FIND string
         }
         else
            return FALSE;
      }
   }
#endif   // #ifdef   USEFINDLIST    // FIX20010703

   if(c)
	{
#ifdef   USEFINDLIST    // FIX20010703
      LPTSTR   lpb = &g_szTmpBuf[0];   // accumulate into a temp buffer
      INT      ilen = 0;               // keeping the LENGTH
      LPTSTR   lps;
#endif   // USEFINDLIST
      // check if a BEGIN character
      // WAS '"' | '\'' | '+' !!!
      // BUT that excludes using "'@'" as the FIND part
      // FIX20001022    // fix find of "'@'"!!!
		if( IsBgnType( c ) )    // presently only '"' | '+' !!!
		{
			d = c;	// MAYBE Beginning character
		}
		else
		{
			d = 0;   // NOTE: WIN32 command line STRIP the double quotes also
#ifdef   USEFINDLIST    // FIX20010703
         lpb[ilen++] = c;
//#endif   // USEFINDLIST
#else    // !USEFINDLIST

			if( gnFindLen < (MXFNDSTGS - 2) )
			{
				gszFindStgs[gnFindLen++] = c; // put this first char into find string
			}
			else
			{
				lstrcat( glpError, "ERROR: Find string appears too long!"PRTTERM );
            //bRet = FALSE;   error line already ADDED so no need to flag this
				return bRet;
			}
#endif   // USEFINDLIST y/n
		}

		cp++;	// Bump past beginning
      // IFF from the command line with double quotes stripped, and there was only
      // ONE character, then we are DONE
		while( ( c = *cp++ ) > 0 )
		{
			if( d )
			{
				// It commenced with a double quote or a plus
				// This BEGIN character must be excluded from
				// the end of the argument.
				if( c == d )
				{
					// Do NOT add this char
					break;
				}
			}
			else	// NO BEGIN CHAR
			{
				// FIX981029
				// NOTE: 'C' runtime has already REMOVED
				// any QUOTES around the argument, so
				// we should CONTINUE until the argument ends,
				// and NOT
				//if( c <= ' ' )
				//{
				//	c = 0;
				//	break;
				//}
			}
#ifdef   USEFINDLIST
         lpb[ilen++] = c;
         if(ilen >= MXONEFIND)
         {
				strcat( glpError, "ERROR: Find string appears too long!"PRTTERM );
            //bRet = FALSE;   error line already ADDED so no need to flag this
				break;
         }
//#endif   // USEFINDLIST
#else    // !USEFINDLIST
			if( gnFindLen < (MXFNDSTGS - 2) )
			{
				gszFindStgs[gnFindLen++] = c; // = W.ws_szFindStgs
			}
			else
			{
				lstrcat( glpError, "ERROR: Find string appears too long!"PRTTERM );
            //bRet = FALSE;   error line already ADDED so no need to flag this
				break;
			}
#endif   // USEFINDLIST y/n
		}

#ifdef   USEFINDLIST    // FIX20010703
      if(ilen)
      {
         PLE   ph = &g_sFind; // ADD To FIND LIST
         PLE   pn;
         PFLINE pl;

         lpb[ilen] = 0;    // zero terminate string
         //pn = MALLOC( LPTR, (sizeof(LIST_ENTRY) + ilen + 1) );
         pn = MALLOC( LPTR, (sizeof(FLINE) + ilen) );
         if(pn)
         {
            //LPTSTR   lps = (LPTSTR)pn;
            //lps += sizeof(LIST_ENTRY);
            pl = (PFLINE)pn;
            pl->dwTyp = dwn;     // set TYPE (1=same file, 2=same file and line)
            pl->dwTN  = dwo;     // set NUMBER to match with other find string nums
            lps = &pl->cLine[0];
            strcpy( lps, lpb );
            InsertTailList(ph,pn);
            g_dwFCnt++; // store a FIND on the list
   			if( giFirst == 0 )   // ONE DAY THIS ALSO NEEDS TO GO AWAY!!!
	   			giFirst++;
         }
         else
         {
				strcat( glpError, "ERROR: Find string memory FAILED!"PRTTERM );
            bRet = FALSE;  // flag an error
         }
      }
      else
      {
         //sprtf( "WARNING: No find string found!!!"MEOR );
      }
//#endif   // USEFINDLIST
#else    // !USEFINDLIST
		if( gnFindLen )
		{
         // NOTE: Double ZERO terminate FIND strings
			if( gszFindStgs[gnFindLen-1] != 0 )
				gszFindStgs[gnFindLen++] = 0;
			gszFindStgs[gnFindLen]   = 0;
         // ========================================
			if( giFirst == 0 )
				giFirst++;
		}
#endif   // USEFINDLIST y/n
	}
   return bRet;
}

BOOL	GetFSize( LPGFS lpgfs )
{
	BOOL	flg = FALSE;
	if( ( lpgfs ) &&
		( VH(lpgfs->fs_hHnd) ) )
	{
		lpgfs->fs_dwLow = GetFileSize( lpgfs->fs_hHnd, &lpgfs->fs_dwHigh );
		if( ( lpgfs->fs_dwLow ) ||
			( lpgfs->fs_dwHigh ) )
		{
			flg = TRUE;
		}
	}
	return flg;
}


BOOL	Open4Read( LPGFS lpgfs )
{
	BOOL	flg = FALSE;
	if( ( lpgfs ) &&
		( OpenReadFile( &lpgfs->fs_szNm[0], &lpgfs->fs_hHnd ) ) &&
		( VH( lpgfs->fs_hHnd ) ) &&
		( GetFSize( lpgfs ) ) )
	{
		flg = TRUE;
	}
	if( ( !flg ) &&
		( lpgfs ) )
	{
		if( VH( lpgfs->fs_hHnd  ) )
			CloseHandle( lpgfs->fs_hHnd );
		lpgfs->fs_hHnd = INVALID_HANDLE_VALUE;
	}
	return flg;
}


// 	BOOL	ws_fSpacey;	// g(W.ws_)fSpacey -I Exclude spaces / tabs in text compare - June 2000
#define	MXSTKBUF		64

//#ifdef	ADDINHIB
LPGFS GetNxtGFS( WS )
{
   LPGFS	lpgfs;
   lpgfs = &gsGFS[gdwGFCnt];
   gdwGFCnt++;
   if( gdwGFCnt >= MXINPFS )
      gdwGFCnt = 0;
   return lpgfs;
}

BOOL	CloseARead( LPGFS lpgfs )
{
	BOOL	flg = FALSE;
	if( lpgfs )
	{
		if( VH( lpgfs->fs_hHnd ) )
		{
			CloseHandle( lpgfs->fs_hHnd );
			flg = TRUE;
		}
		lpgfs->fs_hHnd = 0;
	}
	return flg;
}


//				case 'I':
//#define		fInhibit	W.ws_fInhibit
//#define		giInhibCnt	W.ws_iInhibCnt
//#define		giInhibSiz	W.ws_iInhibSiz
//#define		glpInhib	W.ws_lpInhib
BOOL	GetIFile( WS, char * psw )
{
	BOOL	flg = FALSE;
	char *	cp;

	cp = psw; 
	if(cp)
	{
		LPGFS	lpgfs = GetNxtGFS(pWS); // get one of a rotating set of MXINPFS ...
		lstrcpy( &lpgfs->fs_szNm[0], cp );
		if( Open4Read( lpgfs ) )
		{
			if( lpgfs->fs_dwHigh )
			{
				CloseARead( lpgfs );
				lstrcat( glpError, "ERROR: File TOO large!"PRTTERM );
			}
			else if( ( lpgfs->fs_lpV = LocalAlloc( LPTR,
				( lpgfs->fs_dwLow + 16 ) ) ) != 0 )
			{
				lpgfs->fs_dwRd = 0;
				if( ( ReadFile( lpgfs->fs_hHnd,
								lpgfs->fs_lpV,
								lpgfs->fs_dwLow,
								&lpgfs->fs_dwRd,
								NULL ) ) &&
					( lpgfs->fs_dwRd == lpgfs->fs_dwLow ) )
				{
					LPSTR	lpb;
					DWORD	dwi;
					char	c;

					lpb = lpgfs->fs_lpV;
					for( dwi = 0; dwi < lpgfs->fs_dwLow; dwi++ )
					{
						c = lpb[dwi];	// get char
					}

				}
				else
				{
					lstrcat( glpError, "ERROR: Read file failed!"PRTTERM );
				}
				LocalFree( lpgfs->fs_lpV );
				lpgfs->fs_lpV = 0;
				CloseARead( lpgfs );
			}
			else
			{
				CloseARead( lpgfs );
				lstrcat( glpError, "ERROR: Allocate memory failed!"PRTTERM );
			}
		}
		else
		{
			sprintf( EndBuf(glpError),
				"ERROR: Unable to OPEN input [%s] file!"PRTTERM,
				cp );
		}
	}
	return flg;
}

BOOL	GetI22( WS, char * pchrs, int len )
{
	BOOL	flg = FALSE;
	int		i, j, k, l;
	char *	cp;
	char	c;
	cp = pchrs;
	i = len;
	if( ( pWS ) &&
		( cp ) &&
		( i ) )
	{
		l = 0;
		if( *cp == 0x22 )
		{
			l++;
			cp++;
			i--;
		}
		k = giInhibCnt;
		for( j = 0; j < i; j++ )
		{
			c = cp[j];
			if( c == 0x22 )
			{
				j++;
				break;
			}
			glpInhib[k++] = c;
		}
		if( k )
		{
			glpInhib[k++] = 0;
			glpInhib[k]   = 0;
			giInhibCnt = k;
			fInhibit = TRUE;
	//if !GetInhibs( pWS, cp ) )
	//	SetInvSwitch( pWS, cp );
			flg = TRUE;
			while( (j+3) < i )
			{
				if( ( cp[j] == ';' ) &&
					( cp[j+1] == 0x22 ) &&
					( cp[j+2] != 0x22 ) )
				{
					j += 2;
					for( ; j < i; j++ )
					{
						c = cp[j];
						if( c == 0x22 )
						{
							j++;
							break;
						}
						glpInhib[k++] = c;
					}
					glpInhib[k++] = 0;
					glpInhib[k]   = 0;
					giInhibCnt = k;
				}
				else
				{
					break;
				}
			}
		}
	}
	return flg;
}

BOOL	GetI( WS, char * pchrs, int len )
{
	BOOL	flg = FALSE;
	int		i, j, k;
	char *	cp;
	char	c;

   i  = len;
	cp = pchrs;
	if( ( pWS ) &&
		( cp ) &&
		( i ) )
	{
		// get previous input point
		k = giInhibCnt;
		for( j = 0; j < i; j++ )
		{
			c = cp[j];
			if( c == ';' )
			{
				break;
			}
			glpInhib[k++] = c;
		}
		if( k )
		{
			glpInhib[k++] = 0;
			glpInhib[k]   = 0;
			giInhibCnt = k;
			fInhibit = TRUE;
	//if !GetInhibs( pWS, cp ) )
	//	SetInvSwitch( pWS, cp );
			flg = TRUE;
			while( j < i )
			{
				if( cp[j] == ';' )
				{
					j++;
					for( ; j < i; j++ )
					{
						c = cp[j];
						if( c == ';' )
						{
							break;
						}
						glpInhib[k++] = c;
					}
					glpInhib[k++] = 0;
					glpInhib[k]   = 0;
					giInhibCnt = k;
				}
				else
				{
					break;
				}
			}
		}
	}
	return flg;
}


///////////////////////////////////////////////////////////////////////////////
// FUNCTION   : GetInhibs
// Return type: BOOL 
// Arguments  : WS
//            : char * psw
// Description: case 'I': Get the INHIBIT string
//              
// "2001 April 13"	// FIX20010413 - add -I+ inhibit find in C/C++ comments
///////////////////////////////////////////////////////////////////////////////
BOOL	GetInhibs( WS, char * psw )
{
	BOOL	flg = FALSE;      // set FAIL for now
	char	buf[MXSTKBUF];
	char *	cp;
	char	c;
	int	i, j;

	cp = psw; 
	if(cp)
	{
		i = strlen(cp);
		// we have a pointer and length
		if( i < (MXSTKBUF - 1) )
		{
			strcpy(buf,cp);	// make COPY of input string
			while( ( i ) &&
				( buf[i-1] <= ' ' ) )
			{
				i--;
				buf[i] = 0;
			}
			if( i )
			{
				j = 0;
				while( j < i )
				{
					// see what we got - or FALL through to bigger function below more likely ...
					j++;
				}
			}
		}

		if( i == 0 )
		{
			{
				// we had the NEW switch -I = just ignore space/tabs in finding compare
				flg = TRUE;
				gfSpacey = TRUE;	// -I Exclude spaces / tabs in text compare - June 2000
				return flg;
			}
		}

		while( ( *cp ) && ( *cp != ':' ) )
		{
			if( toupper(*cp) == 'C' )
				gbCaseInhib = TRUE;
         else if( *cp == '+' )
            g_bIgComm = TRUE;
         else
            return flg;    // whatever this is it is NOT valid
			cp++;
		}
      if( *cp == 0 )
      {
         return TRUE;
      }
		if( *cp == ':' )
		{
			cp++;
			c = *cp; 
			if(c)
			{
				if( c == '@' )
				{
					cp++;
					flg = GetIFile( pWS, cp );
				}
				else
				{
					// not an input file
					int		i;
					i = lstrlen( cp ); 
					if(i)
					{
						if( glpInhib == 0 )
						{
							giInhibCnt = 0;
							giInhibSiz = i+16;
							glpInhib = LocalAlloc( LPTR, (i+16) ); 
							if(glpInhib)
							{
								if( *cp == 0x22 )
									flg = GetI22( pWS, cp, i );
								else
									flg = GetI( pWS, cp, i );
							}
						}
						else
						{
							// this is an ADDITION
							LPSTR lpnew, lpold, lpbgn;
							int		j, k;

                     lpnew = 0;
                     lpold = glpInhib;
                     if(lpold)
                        lpnew = LocalAlloc( LPTR, (giInhibSiz + i + 16) );
                     if(lpnew)
							{
								giInhibSiz += (i + 16);
								lpbgn = lpnew;
								k = 0;
								while( ( j = lstrlen(lpold) ) > 0 )
								{
									lstrcpy(lpnew, lpold);
									lpold += (j + 1);
									lpnew += (j + 1);
									k     += (j + 1);
								}
								*lpnew = 0;
								lpold = glpInhib; 
								if(lpold)
									LocalFree(lpold);
								glpInhib   = lpbgn;
								giInhibCnt = k;
								if( *cp == 0x22 )
									flg = GetI22( pWS, cp, i );
								else
									flg = GetI( pWS, cp, i );
							}
						}
					}
				}
			}
		}
	}

	return flg;
}

///////////////////////////////////////////////////////////////////////////////
// FUNCTION   : DoReadBuf
// Return type: void 
// Arguments  : LPWORKSTR pWS
//            : UINT level
//            : LPGFS lpgfs
// Description: Read the data in the buffer seeking COMMANDS.
//              Skip all after ";" until END OF LINE
// FIX20010319 When adding -v4 adds date order of finds at end (VERB4) also
// fixed the skipping to ignore TAB characters ("\t") 09 hex!!!
// note: MXARGS is the allocated MAXIMUM
///////////////////////////////////////////////////////////////////////////////
void	DoReadBuf( LPWORKSTR pWS, UINT level, LPGFS	lpgfs )
{
	LPSTR	   lpb;
   LPSTR    ptmp;
	DWORD	   dwi, dwl;
	char	   c, cc, dd;
	LPSTR *  lpa;
	int		ic;

	lpb = lpgfs->fs_lpV;
	lpa = (LPSTR *)&lpb[lpgfs->fs_dwLow];  // get AFTER file read size
	ic = 0;
	lpa[ic++] = "FA4";   // add first dummy argument = 1 of MXARGS
	for( dwi = 0; dwi < lpgfs->fs_dwLow; dwi++ )
	{
		c = lpb[dwi];	// get char
		if( c > ' ' )
		{
			if( c == ';' ) 
			{
				// skip commented lines
				dwi++;	// to next
				for( ; dwi < lpgfs->fs_dwLow; dwi++ )
				{
               c = lpb[dwi];  // NOTE: Also skip TABS
					if( ( c < ' ' ) && ( c != '\t' ) )
					{
                  // at END OF LINE
						break;
					}
				}
			}
			else
			{
            ptmp = &lpb[dwi];
				lpa[ic++] = &lpb[dwi];  // set argument pointer
            if( c == '"' )
               dd = c;
            else
               dd = 0;	// begin NOT in quotes
				dwi++;      // bump PAST first char
				for( ; dwi < lpgfs->fs_dwLow; dwi++ )
				{
//					if( lpb[dwi] <= ' ' )
//					if( lpb[dwi] < ' ' )
					cc = lpb[dwi];	// get character
					if( ( cc < ' '  ) &&
						( cc != '\t' ) )
					{
						// out of here to CLOSE command line item
                  // but first, clean TAIL
						lpb[dwi] = 0;
						dwl = dwi;
                  while(dwl--)
                  {
                     if( lpb[dwl] > ' ' )
                     {
                        dwl++;   // back up to COUNT
                        break;   // and add argument
                     }
                     lpb[dwl] = 0;
                  }
						break;
					}
					else
					{
						if( cc == ';' ) // got message comment indicator
						{
							// and NOT within QUOTE marks
							if( dd == 0 )
							{
								// then EXIT here
								// but first, clean TAIL
								lpb[dwi] = 0;
								dwl = dwi;
								while( ( dwl ) &&
									( lpb[dwl-1] <= ' ' ) )
								{
									dwl--;
								}
								lpb[dwl] = 0;

								// and throw away the COMMENT section
								dwi++;	// to next
								for( ; dwi < lpgfs->fs_dwLow; dwi++ )
								{
									cc = lpb[dwi];
									if( ( cc < ' '  ) &&
										( cc != '\t' ) )
									{
										break;
									}
								}

								// ok, now out of here
								break;	// have established a COMMAND in the buffer
							}
						}  // if a "comment" character
					}

					if( cc == '"' )
					{
						if( dd )
							dd = 0;
						else
							dd = cc;
					}

				}
				lpb[dwi] = 0;
			}
		}
      if( ic > (MXARGS - 1) )
      {
         strcat( glpError, "ERROR: Exceeded maximum ARGUMENTS!"PRTTERM );
         break;
      }
	}

	if( ic > 1 )
	{
		lpa[ic] = 0;
		ProcessArgs( pWS, ic, lpa, (level+1) );
	}
	else
	{
		// no arguments
		// this could be an ERROR
      // but return quietly, for now ...
	}

}



//#endif	// ADDINHIB
///////////////////////////////////////////////////////////////////////////////
// FUNCTION   : DoAnINP
// Return type: void 
// Arguments  : WS
//            : LPTSTR cp
//            : int level
// Description: 
//              
///////////////////////////////////////////////////////////////////////////////
void  DoAnINP( WS, LPTSTR cp, int level )
{
					LPGFS	lpgfs = GetNxtGFS(pWS);
//					cp++;
					strcpy( &lpgfs->fs_szNm[0], cp );
					if( Open4Read( lpgfs ) )
					{
						if( lpgfs->fs_dwHigh )
						{
							CloseARead( lpgfs );
							strcat( glpError, "ERROR: File TOO large!"PRTTERM );
						}
						else if( ( lpgfs->fs_lpV = LocalAlloc( LPTR,
							( lpgfs->fs_dwLow + (MXARGS * sizeof(LPTSTR)) ) ) ) != 0 )
						{
							lpgfs->fs_dwRd = 0;
							if( ( ReadFile( lpgfs->fs_hHnd,
										lpgfs->fs_lpV,
										lpgfs->fs_dwLow,
										&lpgfs->fs_dwRd,
										NULL ) ) &&
								( lpgfs->fs_dwRd == lpgfs->fs_dwLow ) )
							{
//#ifdef	USERDBUF
								DoReadBuf( pWS, level, lpgfs );
//#endif	/* USERDBUF */
							}
							else
							{
								strcat( glpError, "ERROR: Read file failed!"PRTTERM );
							}
							LocalFree( lpgfs->fs_lpV );
							lpgfs->fs_lpV = 0;
							CloseARead( lpgfs );
						}
						else
						{
							CloseARead( lpgfs );
							strcat( glpError, "ERROR: Allocate memory failed!"PRTTERM );
						}
					}
					else
					{
						sprintf( EndBuf(glpError),
							"ERROR: Unable to OPEN input [%s] file!"PRTTERM,
							cp );
					}
}

void	SetInvSwitch( WS, char * psw )
{
	char * cp;

	cp = psw;
	if( ( pWS ) &&
		( cp ) )
	{
		cp--;
		cp--;
		sprintf( EndBuf(glpError),
				"ERROR: Invalid switch! [%s]"PRTTERM,
				cp );
	}
}


int	MoveFileName( WS, LPSTR lpdest, LPSTR lpsrc )
{
	LPSTR	lps;
	int		i, j, k;
	char	c;

	j = k = 0;
	lps = lpsrc;
   if(lps)
      j = strlen(lps);
	if( lpdest && j )
	{
		*lpdest = 0;
		if( *lps == '"' )
		{
			lps++;
			j = lstrlen(lps);
			for( i = 0; i < j; i++ )
			{
				c = lps[i];
				if( c == '"' )
					break;
				lpdest[i] = c;
			}
			lpdest[i] = 0;
		}
		else
		{
			lstrcpy( lpdest, lpsrc );
		}
		k = lstrlen(lpdest);
	}
   UNREFERENCED_PARAMETER(pWS);
	return k;
}

BOOL	LoadFile2( WS, LPLFSTR lpLF, BOOL fExit )
{
	LPSTR lpFN;
	HANDLE * phFile;
	LPDWORD lpDW, lpRD;
	LPSTR *	lpBuf;
	BOOL	flg;

	flg = FALSE;
	if( lpLF )
	{
		lpFN = &lpLF->lf_szNm[0];
		if( *lpFN )
		{
			phFile = &lpLF->lf_hHnd;
			lpDW   = &lpLF->lf_dwSz;
			lpRD   = &lpLF->lf_dwRd;
			lpBuf  = &lpLF->lf_lpBuf;  // pointer to BUFFER
			if( VERB6 )
			{
				boi(0);
				sprintf( lpVerb, 
					"Openning [%s] ... ",
					lpFN );
				boi( lpVerb );
			}
			if( OpenReadFile( lpFN, phFile ) )
			{
				if( VERB6 )
				{
					sprintf( lpVerb, "FH=%x ... ", *phFile );
					boi( lpVerb );
				}
				*lpDW = GetFileLen( *phFile ); // get LENGTH of INPUT file
				if(*lpDW)
				{
					if( VERB6 )
					{
						sprintf( lpVerb,
							"Len.=%u ... ",
							*lpDW );
						boi( lpVerb );
					}
					*lpBuf = LocalAlloc( LPTR, (*lpDW + 16) ); // allocate for INPUT file
					if(*lpBuf)
					{
						if( VERB6 )
							boi( "Reading..." );
						// Read DATA into buffer
						if( ( ReadFile( *phFile, // handle of file to read
								*lpBuf,	// pointer to buffer that receives data
								*lpDW,	// DWORD number of bytes to read
								lpRD,	// LPDWORD pointer to number of bytes read
								NULL ) ) &&	// pointer to structure for data
							( *lpRD == *lpDW ) )
						{
							if( VERB6 )
							{
								//prt( "OK"PRTTERM );
								boi( "OK"PRTTERM );
								boi(0);
							}
							flg = TRUE;
						}
						else
						{
							sprintf( EndBuf(glpError),
								"\r\nERROR: Unable to READ file [%s]!"PRTTERM,
								lpFN );
						}
					}
					else
					{
						sprintf( EndBuf(glpError),
							"\r\nERROR: Allocation of %u bytes FAILED!"PRTTERM,
							*lpDW );
					}
				}
				else
				{
					sprintf( EndBuf(glpError),
						"\r\nERROR: File [%s] is NULL!"PRTTERM,
						lpFN );
				}
			}
			else
			{
				sprintf( EndBuf(glpError),
					"\r\nERROR: Unable to OPEN file [%s]!"PRTTERM,
					lpFN );
			}
		}
		else
		{
			lstrcat( glpError,
				"\r\nERROR: Bad internal parameters!"PRTTERM );
		}
	}
	else
	{
		lstrcat( glpError,
			"\r\nERROR: Bad internal parameters!"PRTTERM );
	}
	if( ( fExit ) &&
		( *glpError ) )
	{
		Err_Exit( -1 );
	}
	return( flg );
}


//typedef	struct {
//	TCHAR	lf_szNm[MAX_PATH];
//	HANDLE	lf_hHnd;
//	DWORD	lf_dwSz;
//	DWORD	lf_dwRd;
//	LPSTR	lf_lpBuf;
//}LFSTR;
//typedef LFSTR FAR * LPLFSTR;

BOOL	KillFile2( WS, LPLFSTR lpLF )
{
	BOOL	flg = FALSE;
	LPSTR	lpFN;
	if( lpLF )
	{
		lpFN = &lpLF->lf_szNm[0];
		if( VH( lpLF->lf_hHnd ) )
		{
			CloseHandle( lpLF->lf_hHnd );
			flg++;
		}
		lpLF->lf_hHnd = 0;
		if( lpLF->lf_lpBuf )
		{
			LocalFree( lpLF->lf_lpBuf );
			flg++;
		}
		lpLF->lf_lpBuf = 0;
	}
   UNREFERENCED_PARAMETER(pWS);
	return flg;
}


void	Add2Files( WS, LPSTR lps ) // PLE ph = &g_sFileList, count in g_nFileCnt
{
   static TCHAR _s_addfil_buf[264];
	PTSTR	cp = _s_addfil_buf;
	char	c;
   int ilen = 0;
	if(lps) {
      strcpy(cp,lps);
      // FIX20041210 - remove any "..." from the file name
      if( *lps == '"' ) {
         strcpy(cp, &lps[1]);
         ilen = strlen(cp); // get the count
         if((ilen) && (cp[ilen-1] == '"')) {
            ilen--;
            cp[ilen] = 0;
         }
      }
      ilen = strlen(cp);
   }

   if(ilen) {

#ifdef   USEFINDLIST    // above change to FIND list = FIX20010703
      PLE   ph = &g_sFileList;   // count in g_nFileCnt
      PLE   pn = MALLOC( LPTR, (sizeof(MFILE) + strlen(cp)) );
      if(pn)
      {
         PMFILE    pf = (PMFILE)pn;
         LPTSTR    ps = &pf->cFile[0];
         pf->dwNum = 0;
         strcpy( ps, cp );
         InsertTailList(ph,pn);
         g_nFileCnt++;           // count of files in LIST
      }
      else
      {
         strcat( glpError,
            "ERROR: File Name MEMORY FAILED!"PRTTERM );
      }
#endif   // #ifdef   USEFINDLIST    // above change to FIND list = FIX20010703

		while( ( c = *cp++ ) > 0 )
		{
			if( gnFileLen < (MXFILSTGS - 2) )
			{
				gszFileMask[gnFileLen++] = c;
			}
			else
			{
				lstrcat( glpError,
					"ERROR: File Name strings appears too long!"PRTTERM );
				break;
			}
		}
		if( gnFileLen )
		{
			if( gszFileMask[gnFileLen-1] != 0 )
				gszFileMask[gnFileLen++] = 0;
			gszFileMask[gnFileLen]   = 0;
		}
	}
}

typedef unsigned int uint;

VOID Do_B_Switch( WS, PTSTR pcmd ) {
   int err = 0; // no error yet
   PTSTR cp = pcmd;
   gfBinary = TRUE;
   if( *cp ) { // may have back/forward numbers
      if( ISNUM(*cp) ) {
         uint n1 = (uint)atoi(cp); // get first num
         if(n1 > 0) {
            W.ws_dwBackup = n1;
         }
         while( *cp && (ISNUM(*cp) ) ){ cp++; }
         if(*cp) {
            if(*cp == ':') {
               cp++;
               if(ISNUM(*cp)) {
                  n1 = (uint)atoi(cp); // get second num
                  if(n1 > 0) {
                     W.ws_dwForward = n1;
                  }
               } else {
                  err = 1;
               }
            } else {
               err = 1;
            }
         }
      } else {
         err = 1;
      }
      if(err) {
         sprintf( EndBuf(&g_cErrBuf[0]), "ERROR: Invalid -B switch! [%s]"MEOR,
            (pcmd - 2) );
      }
   }
}

VOID  Do_C_Switch( WS, LPTSTR cp )
{
#ifdef   ADDFCOUNT   // FIX20010824 - Minimum FIND count before OUTPUT
   if( ISNUM( *cp ) )   // if it starts with a NUMBER
   {
      DWORD    dwi = ( *cp - '0' );
      LPTSTR   bcp = cp;
      cp++;
      while( ISNUM(*cp) )
      {
         dwi = ((dwi * 10) + (*cp - '0'));
         cp++;
      }
      if( dwi && ( *cp == 0 ) )
      {
         g_dwMinCnt = dwi; // set the minimum FIND counter
      }
      else
      {
   		sprintf( EndBuf(glpError),
				"ERROR: Invalid -C switch! [%s]! Only -C, Cnn (min=1) or -cvs!!"PRTTERM,
				bcp );
      }
      return;
   }
#endif   // ADDFCOUNT   // FIX20010824 - Minimum FIND count before OUTPUT

#ifdef   ADDCVSDATE
   if( *cp )
   {
      if(( toupper(cp[0]) == 'V' ) &&
         ( toupper(cp[1]) == 'S' ) )
      {
         g_bCVSDate = TRUE;
      }
      else
      {
   		sprintf( EndBuf(glpError),
				"ERROR: Invalid -C switch! [%s]! Only -C, Cnn or -cvs!!"PRTTERM,
				cp );
      }
   }
   else
   {
	   gfCase = TRUE;
   }
#else    // !ADDCVSDATE
	gfCase = TRUE;
#endif   // ADDCVSDATE y/n
}

int   gbDirList = 0;
#ifdef ADD_DIRLIST_SORT2
int   gbOrdList = 0;
#endif // #ifdef ADD_DIRLIST_SORT2

VOID  Do_D_Switch( WS, PTSTR cp )
{
   int c = toupper(*cp);
   int bad = 0;
   if(c) { // check the command
      do {
         switch(c)
         {
         case 'L':
            gbDirList = 1;
            bad = 0;
            break;
#ifdef ADD_DIRLIST_SORT2
         case 'O':
            gbOrdList = 1;
            bad = 0;
            break;
#endif // #ifdef ADD_DIRLIST_SORT2
         default:
            bad = 1;
            break;
         }

         if(bad) {
   		   sprintf( EndBuf(glpError),
				   "ERROR: Invalid -D switch! [%s]! Only -D[LO], for listing, order!"PRTTERM,
				   cp );
            return;
         }
         cp++; // bump to next letter
         c = toupper(*cp); // get next

      } while ( c );
   }

   gfDirLst = TRUE;
}

#ifdef   ADDLOPTION
//#define  g_bGotLOpt     GW.ws_bGotLOpt    // FIX20011011 - Add -L[nn|F] option
//#define  g_bGotLFunc    GW.ws_bGotLFunc
//#define  g_dwLOptLen    GW.ws_dwLOptLen
//            case 'L':
//               g_bGotLOpt = TRUE;
//   				cp++;		// already bumped past the M
//               if(*cp)
VOID  GetLOpt( LPTSTR cp )
{
//   						sprintf( EndBuf(glpError),
//	   						"ERROR: Invalid -M2 switch! [%s]"PRTTERM,
//		   					cp );
   if( toupper(*cp) == 'F' )
   {
      g_bGotLFunc = TRUE;
   }
   else
   {
      DWORD    dwi = 0;
      if( sscanf(cp, "%u", &dwi) == 1 )
      {
         g_dwLOptLen = dwi;
      }
      else
      {
         sprintf( EndBuf(&g_cErrBuf[0]), "ERROR: Invalid -L switch! [%s]"MEOR,
            (cp - 2) );
      }
   }
}

#endif   // ADDLOPTION

///////////////////////////////////////////////////////////////////////////////
// FUNCTION   : ProcessArgs
// Return type: BOOL 
// Arguments  : LPWORKSTR pWS
//            : int argc
//            : char **argp
//            : UINT level
// Description: COMMAND LINE PROCESSING
//              
///////////////////////////////////////////////////////////////////////////////
BOOL	ProcessArgs( LPWORKSTR pWS, int argc, char **argp, UINT level )
{
	static BOOL	   bHadErr = FALSE;
	int		i, j, k;
	char *	cp;
	char		c;
	DWORD	   dwi, dwj, dwk;
#ifndef	USERDBUF
	char		cc, dd;
	DWORD	   dwl;
#endif	/* !USERDBUF */
	LPTSTR	lpb;
	BOOL	   fOK;

	if( argc > 1 )
	{
		Check4Help( pWS, argc, argp );
		fOK = TRUE;
		for( i = 1; i < argc; i++ )
		{
			cp = argp[i];
			if( cp == 0 )
				continue;
			c = *cp;
			if( c == 0 )
				continue;
			j = strlen(cp);
			// Keep a COPY of the command
         Add2CmdBuf( pWS, cp, j );
			if( ( c == '-' ) || ( c == '/' ) )
			{
				// Got a SWITCH
				// ============
				cp++;		// Bump past switch
				c = (char)toupper( *cp++ );	// Get next and bump
				switch( c )
				{

#ifdef   FIX20000902 // FIX input files in input file and add -8
            case '8':
               gbDOSNm = TRUE;
               break;

#endif // FIX20000902 // FIX input files in input file and add -8

				case '?':
					Usage( pWS, 0 );
					break;

				case 'B':
               Do_B_Switch( pWS, cp );
					break;

				case 'C':
               Do_C_Switch( pWS, cp );
					break;

#ifdef		ADDDIRLST	// Special for Directory Listing
				case 'D':	// Directory Listing Search.
					//gfDirLst = TRUE;
               Do_D_Switch( pWS, cp );
					break;
#endif	// ADDDIRLST

#ifdef		ADDERRLST	// Special for Directory Listing
				case 'E':	// WIN32 Error.
					GetErrNum( pWS, cp );
					break;
#endif	// ADDERRLST

				case 'F':
					if( !Add2Finds( pWS, cp, TRUE ) )
               {
						cp -= 2; // back up to beginning of switch
						sprintf( EndBuf(glpError),
							"ERROR: Invalid FIND switch! [%s]"PRTTERM,
							cp );
               }
					break;

				case 'H':
					Usage( pWS, 0 );
					break;

#ifdef	ADDINHIB
				case 'I':
					//fInhibit = TRUE;
					if( !GetInhibs( pWS, cp ) )
						SetInvSwitch( pWS, cp );
					break;
#endif	// ADDINHIB
#ifdef   ADDLOPTION
//#define  g_bGotLOpt     GW.ws_bGotLOpt    // FIX20011011 - Add -L[nn|F] option
//#define  g_bGotLFunc    GW.ws_bGotLFunc
//#define  g_dwLOptLen    GW.ws_dwLOptLen
            case 'L':
               g_bGotLOpt = TRUE;
//   				cp++;		// already bumped past the M
               if(*cp)
                  GetLOpt(cp);
               break;
#endif   // ADDLOPTION
            case 'M':   // just like -F:M switch
               g_bDoMake = TRUE;
//   				cp++;		// already bumped past the M
               if( *cp )
               {
                  if( *cp == '2' )
                     g_bDoMake2 = TRUE;
                  else
                  {
                     cp -= 2;
   						sprintf( EndBuf(glpError),
	   						"ERROR: Invalid -M2 switch! [%s]"PRTTERM,
		   					cp );
                  }
               }
               break;

				case 'N':
					gfNumber = TRUE;
					break;

#ifdef	ADDOUTFIL
				case 'O':
					if( !MoveFileName( pWS, glpOutFile, cp ) )
					{
						cp--;
						cp--;
						sprintf( EndBuf(glpError),
							"ERROR: Invalid switch! [%s]"PRTTERM,
							cp );
					}
					break;
#endif	// ADDOUTFIL

				case 'P':
					gfParity = TRUE;
					break;

#ifdef	ADDRECUR
				case 'R':
					gfRecursive = TRUE;
					break;
#endif	// ADDRECUR

				case 'V':
// FIX20010319 -v4 adds date order of finds at end
					k = 1;
					if( *cp )
					{
						k = 0;
						while( ( c = *cp++ ) != 0 )
						{
							if( ( c >= '0' ) && ( c <= '9' ) )
							{
								k = ( k * 10 ) + ( c - '0' );
							}
							else
							{
								lstrcat( glpError, "ERROR: Invalid -V[n] switch!"PRTTERM );
								break;
							}
						}
					}
					gfVerbose = k;
					if( VERB6 )
						EnableDiagFile();

					break;

				case 'W':
					gfWhole = TRUE;
               // FIX20010413 - add -w2 for space whole
               if( *cp )
               {
                  if( *cp == '2' )
                  {
                     g_fWhole2 = TRUE;
                  }
                  else
                  {
							strcat( glpError, "ERROR: Invalid -W[2] switch!"PRTTERM );
							break;
                  }
               }
					break;

				case 'X':	// Exclude list, either ; separate list, or @input file
					fOK = TRUE;
					if( c == '@' )
					{
						// we have an INPUT file list of EXCLUDES
						cp++;
						strcpy( &gslfExclude.lf_szNm[0], cp );
						gslfExclude.lf_dwSz = 0;
                  lpb = 0;
						if( LoadFile2( pWS, &gslfExclude, FALSE ) )
                     lpb = gslfExclude.lf_lpBuf;
                  if(lpb)
						{
							dwj = gslfExclude.lf_dwSz; 
							if(dwj)
							{
								dwk = 0;    // remove all extranious data
								for( dwi = 0; dwi < dwj; dwi++ )
								{
									c = lpb[dwi];  // get file character
									if( c > ' ' )
									{
										lpb[dwk++] = c;   // save to new location
										dwi++;   // bump to next and process until end
										for( ; dwi < dwj; dwi++ )
										{
											c = lpb[dwi];
											if( c < ' ' )
											{
												lpb[dwk++] = 0;   // zero terminate
												break;
											}
										}
										lpb[dwk] = 0;  // double zero terminate
									}
								}
								lpb[dwk] = 0;  // ensure last is double zero terminated
							}
						}
						else
						{
							// FAILED
							KillFile2( pWS, &gslfExclude );
							sprintf( EndBuf(glpError),
								"ERROR: Unable to OPEN input [%s] file!"PRTTERM,
								cp );
						}
					}
					else
					{
						// assume a ; separted list
						dwj = strlen( cp );
						for( dwi = 0; dwi < dwj; dwi++ )
						{
							c = cp[dwi];
							if( ( c > ' ' ) &&
								( c != ';' ) )
							{
								if( gnExclLen < MXFILSTGS )
								{
									gszExclude[gnExclLen++] = c;
									dwi++;
									for( ; dwi < dwj; dwi++ )
									{
										c = cp[dwi];
										if( c == ';' )
										{
											gszExclude[gnExclLen++] = 0;
											break;
										}
										else if( gnExclLen < MXFILSTGS )
										{
											gszExclude[gnExclLen++] = c;
										}
										else
										{
											fOK = FALSE;
											break;
										}
									}
									if( c != ';' )
										gszExclude[gnExclLen++] = 0;
								}
								else
								{
									fOK = FALSE;
								}
								if( !fOK )
								{
									strcat( glpError, "ERROR: Exclude Name strings appears too long!"PRTTERM
										"Suggest the list be placed in a file, say FileList,"PRTTERM
										"and then use -x@FileList."PRTTERM );
									break;
								}
							}
							gszExclude[gnExclLen] = 0;
							gszExclude[gnExclLen+1] = 0;
						}
					}
					break;

				default:
					strcat( glpError, "ERROR: Unknown switch!"PRTTERM );
					break;

				}
			}
			else if( c == '@' )
			{
				// *** FIRSTS *** INPUT file command ...
				if( giFirst == 0 )
				{
#ifdef   FIX20000902 // FIX input files in input file and add -8
               cp++;
               DoAnINP( pWS, cp, level );
#else // !FIX20000902 // FIX input files in input file and add -8
					LPGFS	lpgfs = GetNxtGFS(pWS);
					cp++;
					strcpy( &lpgfs->fs_szNm[0], cp );
					if( Open4Read( lpgfs ) )
					{
						if( lpgfs->fs_dwHigh )
						{
							CloseARead( lpgfs );
							strcat( glpError, "ERROR: File TOO large!"PRTTERM );
						}
						else if( lpgfs->fs_lpV = LocalAlloc( LPTR,
							( lpgfs->fs_dwLow + (MXARGS * sizeof(LPTSTR)) ) ) )
						{
							lpgfs->fs_dwRd = 0;
							if( ( ReadFile( lpgfs->fs_hHnd,
										lpgfs->fs_lpV,
										lpgfs->fs_dwLow,
										&lpgfs->fs_dwRd,
										NULL ) ) &&
								( lpgfs->fs_dwRd == lpgfs->fs_dwLow ) )
							{
//#ifdef	USERDBUF
								DoReadBuf( pWS, level, lpgfs );
//#endif	/* USERDBUF */
							}
							else
							{
								lstrcat( glpError, "ERROR: Read file failed!"PRTTERM );
							}
							LocalFree( lpgfs->fs_lpV );
							lpgfs->fs_lpV = 0;
							CloseARead( lpgfs );
						}
						else
						{
							CloseARead( lpgfs );
							lstrcat( glpError, "ERROR: Allocate memory failed!"PRTTERM );
						}
					}
					else
					{
						sprintf( EndBuf(glpError),
							"ERROR: Unable to OPEN input [%s] file!"PRTTERM,
							cp );
					}
#endif // FIX20000902 y/n // FIX input files in input file and add -8
				}
				else if( giFirst == 1 )
				{
               // we already have our FIRST "find" argument
					giFirst++;  // bump again
//#ifdef   FIX20000902 // FIX input files in input file and add -8
//               cp++;
//               DoAnINP( pWS, cp, level );
//#else // !FIX20000902 // FIX input files in input file and add -8
					Add2Files( pWS, cp ); // PLE ph = &g_sFileList, count in g_nFileCnt
//#endif   // FIX20000902
				}
				else
				{
					strcat( glpError,
						"ERROR: Critical Error on Command Line!"PRTTERM
						"There appears to be more than two unswitched arguments."PRTTERM );
				}
			}
			else	// NO SWITCH and NO '@'
			{
				if( giFirst == 0 )
				{
					// First NON-SWITCHED
					// is ASSUMED to be the FIND
					giFirst++;
					Add2Finds( pWS, cp, FALSE );
				}
				else if( giFirst == 1 )
				{
					giFirst++;
					// Second NON-SWITCHED
					// is ASSUMED to be the FILE(S)
               // ****************************
					Add2Files( pWS, cp ); // PLE ph = &g_sFileList, count in g_nFileCnt
               // ****************************
				}
				else
				{
					strcat( glpError,
						"ERROR: Critical Error on Command Line!"PRTTERM
						"There appears to be more than TWO (2) unswitched arguments."PRTTERM
						"Use repeated -FText for multiple find strings."PRTTERM );
				}
			}

         if( *glpError )
         {
            bHadErr = TRUE;
            break;
         }
		}	// for argc count
	}

	return bHadErr;
}



// Fa4Help.c
