
// Fa4Wild.c
// handle wild card file name input ...

#include "fa4.h"

DWORD g_dwFoundFileCnt = 0;
DWORD g_dwFoundDirsCnt = 0;
ULARGE_INTEGER g_ulTotalBytes = {0};
ULARGE_INTEGER g_ulTotalBRej  = {0};
DWORD g_dwFoundRejCnt = 0;
#define g_dwFoundMatchCnt ( g_dwFoundFileCnt - g_dwFoundRejCnt ) // difference

#ifdef   ADD_REGEX
static char wildpath[264];
static char wildname[264];
static char wildregex[264];
static int got_wild_fn = 0;
static char temppath[264];
int   char_is_special( int c )
{
   switch(c)
   {
   case '+':
   case '?':
   case '.':
   case '*':
   case '^':
   case '$':
   case '(':
   case ')':
   case '[':
   case ']':
   case '{':
   case '}':
   case '|':
   case '\\':
      return 1;
   }
   return 0;
}

// FIX20070120 - special ENDING '.*' case - quite frequent
void wildtoregex( char * filename )
{
   size_t len = strlen(filename);
   size_t in = 0;
   size_t i;
   int   c, d = 0;
   for( i = 0; i < len; i++ )
   {
      c = filename[i];
      if( c == '*' ) {
         wildregex[in++] = '.';  // find any character
         wildregex[in++] = '*';  // zero, or more times
      } else if( c == '?' ) {
         wildregex[in++] = '.';  // find any character
         wildregex[in++] = '{';
         wildregex[in++] = '1';  // exactly ONE time
         wildregex[in++] = '}';
      } else if( char_is_special(c) ) {
         if(( c == '.' ) && ((len - i) == 2) && (filename[i+1] == '*')) {
            // FIX20070120 - have a dot - '.*'
            wildregex[in] = 0;
            strcat(wildregex, "((\\..*)|$)");
            in = strlen(wildregex);
            i++;
         } else {
            wildregex[in++] = '\\'; // escape
            wildregex[in++] = (char)c;  // the dot, or ...
         }
      } else {
         if(in == 0) {  // if FIRST char is NORMAL char
            wildregex[in++] = '^'; // then FILENAME regex MUST start with this char
         }
         wildregex[in++] = filename[i];
         if((i + 1) >= len) { // if LAST char is NORMAL
            wildregex[in++] = '$';  // then FILENAME regex MUST end with this char
         }
      }
      d = c;
   }
   wildregex[in] = 0;
   if(in)
      got_wild_fn = 1; // set we have a WILD filename
}

void setdospath( char * pathname )
{
   size_t len = strlen(pathname);
   size_t i;
   for( i = 0; i < len; i++ )
   {
      if(pathname[i] == '/')
         pathname[i] = '\\';
   }
}

int gotwildchar( char * filename )
{
   int   iswild = 0;
   size_t len = strlen(filename);
   size_t i;
   for( i = 0; i < len; i++ ) {
      int   c = filename[i];
      if(( c == '?' ) || ( c == '*' )) {
         iswild = 1;
         break;
      }
   }
   return iswild;
}

int iswild( char * filename )
{
   int   iswild = gotwildchar(filename);
   got_wild_fn = 0;
   if(iswild) {
      char * r;
      strcpy(temppath,filename);
      setdospath(temppath);
      r = strrchr( temppath, '\\' );
      if(r) {
         *r = 0;
         strcpy(wildpath, temppath);
         r++;
         strcpy(wildname, r);
      } else {
         strcpy(wildpath,".");
         strcpy(wildname, filename);
      }
      iswild = gotwildchar(wildname);
      if(iswild) {
         wildtoregex( wildname );   // CONVERT TO REGEX
      }
   }
   return iswild;
}
#endif   // #ifdef   ADD_REGEX


BOOL	MatchFiles2( LPSTR lp1, LPSTR lp2 )
{
   BOOL  bRet = MatchFiles( lp1, lp2 );
#ifdef   ADD_REGEX
   if( iswild( lp1 ) ) {
      char * error = 0;
      int errptr = 0;
      int res;
      pcre * pre;
      if(GVERB9) sprtf( "Compiling regex [%s] to check [%s] ...\n", wildregex, lp2 );
      pre = pcre_compile(wildregex, PCRE_CASELESS, &error, &errptr, gp_pcre_tables );
      if(pre) {
         res = pcre_exec( pre, 0, lp2, strlen(lp2), 0, 0, &gi_pcre_offsets[0], PCRE_MAX_OFFSETS );
         if(GVERB9) {
            sprtf( "pcre_exec returned %d (%s)...(MatchFiles=%s)\n", res,
               (res >= 0) ? "Ok" : "No",
               (bRet ? "Ok" : "No") );
         }
         if( res >= 0 ) {
            if( !bRet ) {
               // have NOT got the regex right for this ... so
               if(( strcmpi( lp1, "*.c*" ) == 0 )||
                  ( strcmpi( lp1, "*.h*" ) == 0 ) ) {
                  PTSTR p = strrchr( lp2, '.' );
                  if(p) {
                     res = pcre_exec( pre, 0, p, strlen(p), 0, 0, &gi_pcre_offsets[0], PCRE_MAX_OFFSETS );
                     if( res < 0 )
                        goto Free_PRE;
                  }
               }
               sprtf( "WARNING: previous is NO, REGEXE is YES [%s] [%s] CHECK wild %s [%s]? ..."MEOR,
                  lp1, lp2, wildname, wildregex );
            }
         } else {
            if( bRet ) {
               sprtf( "WARNING: previous is YES, REGEXE is NO [%s] [%s] CHECK wild %s [%s]? ..."MEOR,
                  lp1, lp2, wildname, wildregex );
            }
         }
Free_PRE:
         pcre_free(pre);
      }
   }
#endif   // ADD_REGEX
   return bRet;
}


//#define CHKMEM(a) if( !a ) { prt("C:ERROR: MEMORY FAILED!"MEOR ); exit(-1); }
//DWORD g_dwFoundFileCnt = 0;
//DWORD g_dwFoundDirsCnt = 0;
//DWORD g_dwFoundRejCnt = 0;
static	WIN32_FIND_DATA	_s_fd;
// +++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
//	void	Process_Wilds( WS, LPSTR lpwild )
//
//	PURPOSE:
//		Process a WILD CARD item (off the list)
//
// +++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
void	Process_Wilds( WS, LPSTR lpwild )
{
    LPSTR lpd, lpf, lpmask, lpfil;
	HANDLE hFind;
	// WIN32_FIND_DATA	_s_fd;
    WIN32_FIND_DATA * pfd = &_s_fd;
    ULARGE_INTEGER ul1;
    DWORD dircount = 0;
    DWORD filcount = 0;
	//lpd = &gszFolder[0];
	// lpf = &szDir2[0];
 	lpf = LocalAlloc( LPTR, (3*(MAX_PATH+32)) ); // FIX20050212 - fix -r switch
    CHKMEM(lpf);
    lpd = &lpf[(MAX_PATH+32)];
	//lpmask = &gszFileMask[0];
    lpmask = &lpd[(MAX_PATH+32)];

	SplitFN( lpd, lpf, lpwild );
	strcpy( lpmask, lpd );
	strcat( lpmask, "*.*" );

	lpfil = glpActive;	// Get the BUFFER for the file name
    pfd->cAlternateFileName[0] = 0;
    if( VERB9 ) {
        sprintf( lpVerb, "NOTE: Find using [%s]"MEOR, lpmask );
        prt(lpVerb);
    }
	hFind = FindFirstFile( lpmask, pfd );
    if( VFH( hFind ) ) { // hFind != INVALID_HANDLE_VALUE ) ) // (HANDLE)-1 ) )
        do {  // got a FIND FIRST
            ul1.HighPart = pfd->nFileSizeHigh;
            ul1.LowPart  = pfd->nFileSizeLow;
		    if( !(pfd->dwFileAttributes & FILE_ATTRIBUTE_DIRECTORY ) ) {
                filcount++;
                g_dwFoundFileCnt++;
			       strcpy( lpfil, lpd );
			       strcat( lpfil, &pfd->cFileName[0] );
                if( VERB9 ) {
                    sprintf( lpVerb, " Checking %s ..."PRTTERM, pfd->cFileName );
                    prt( lpVerb );
                }
                if( MatchFiles2( lpf, &pfd->cFileName[0] ) ) {
                   // defined g_dwFoundMatchCnt = (total - unmatched)
                   g_ulTotalBytes.QuadPart += ul1.QuadPart;
				       // strcpy( lpfil, lpd );
				       // strcat( lpfil, &pfd->cFileName[0] );
				       gfDoneFile = FALSE;		// reset DONE FILE name
                   // Process a FILE, after MAPPING, for the FIND STRING(s)
				       Find_In_File( pWS );
                } else {
                    g_dwFoundRejCnt++;
                    g_ulTotalBRej.QuadPart += ul1.QuadPart;
                    if( VERB9 ) {
                        sprintf( lpVerb, 
                            " REJECT %u by MatchFiles %s ..."PRTTERM,
                            g_dwFoundRejCnt,
                            pfd->cFileName );
                        prt( lpVerb );
                    }
                }
            } else {
                // is a DIRECTORY - forget DOT and DOUBLE DOT
                PTSTR lpn = pfd->cFileName;
                if( strcmp(lpn,".") && strcmp(lpn,"..") ) {
                    dircount++;
                }
            }
        } while( FindNextFile( hFind, pfd ) );
        FindClose( hFind );
        if( VERB9 ) {
            sprintf( lpVerb, "Found %u file%s, and %u folder%s"MEOR,
                filcount,
                ((filcount == 1) ? "" : "s"),
                dircount,
                ((dircount == 1) ? "" : "s") );
            prt(lpVerb);
        }
    } else {
        if( VERB9 ) {
            sprintf( lpVerb, " None found %s ..."PRTTERM, lpwild );
            prt( lpVerb );
        }
    }
    LocalFree(lpf); // toss the MEMORY
}

// eof - Fa4Wild.c
