// load-scene.hxx
#ifndef _load_scene_hxx_
#define _load_scene_hxx_

#include <simgear/compiler.h>
#include <simgear/io/sg_binobj.hxx>
#include "poly-map.hxx"

typedef struct tagTGObject
{
   string name;
   //TextureList textures;
   bool shared;
   double lon;
   double lat;
   double height;
   double heading;
   bool agl;
   bool selected;
}TGObject, * PTGObject;

typedef vector<Point3D> vec_pt3d;
typedef vec_pt3d::iterator iter_pt3d;
typedef vector<vec_pt3d> vvec_pt3d;

class TGTileLoad 
{
public:
   // Constructor
   TGTileLoad() { };

   TGTileLoad( SGBucket& b, string & base_path_in );

   // Destructor
   ~TGTileLoad();

    // this tile's official location in the world
    SGBucket tile_bucket;
    std::string base_path;
    std::string tileFileName;

    vector<SGBinObject> vec_bin_objs;
    vector<string> vec_bin_types;
    vector<string> vec_bin_files;

    vector<TGObject> vec_tg_objs;
    vector<string> vec_obj_types;

    //typedef vector<Point3D> tile_point_list;
    //typedef tile_point_list::iterator tile_point_list_iterator;
    //tile_point_list point_list;
    vvec_pt3d  m_vv_pt3d;
    vector<string> vec_pt3_name;

    bool is_valid;
    bool loadSTGfile(void);
};

extern void load_scenery_tile( string path, SGBucket & b );

extern vec_pt3d * get_first_wgs84_nodes( void );
extern vec_pt3d * get_next_wgs84_nodes( void );
extern vec_pt3d * get_first_normal_nodes( void );
extern vec_pt3d * get_next_normal_nodes( void );
// and the map obj, which has the palette loaded (hopefully)
extern bool is_mapobj_palette_loaded(void);
extern MapMaker & get_map_obj(void);
extern const float *get_map_palette_color_ptr( std::string & mats );

#endif // #ifndef _load_scene_hxx_
// eof - load-scene.hxx
