// poly-btg.cxx

// btg_load.cxx
// attempt to analyse a BTG file
// poly-btg.cxx

// btg_load.cxx
// attempt to analyse a BTG file
#ifdef POLY_VIEW
#ifdef   __cplusplus
extern "C" {
#endif
extern int _cdecl sprtf( char * pf, ... );
#ifdef   __cplusplus
}
#endif
#else
#define TEST
#endif

#ifdef HAVE_CONFIG_H
#include <config.h>
#endif
#include <sys/types.h>
#include <sys/stat.h>
#include <memory.h>
#include <stdio.h>
#include <string>

#include <simgear/compiler.h>
#include <simgear/math/sg_geodesy.hxx> // geo_inverse_wgs_84
#include <simgear/sg_inlines.h>               // min()
#include <simgear/misc/sg_path.hxx>
#include <simgear/io/sg_binobj.hxx>
#ifdef TEST
 #include <Palette.hxx>
 #include "btg_load.hxx"
#ifdef USE_GL_LIB
#define m_glColor4fv glColor4fv
#define m_glBegin glBegin
#define m_glEnd glEnd
#define m_glNormal3fv glNormal3fv
#define m_glVertex3fv glVertex3fv
#else
void m_glColor4fv( const float * v);
void m_glBegin( int type );
void m_glNormal3fv( const float * v );
void m_glVertex2f( float v1, float v2 );
void m_glVertex2fv( const float * v );
void m_glVertex3fv( const float * v );
void m_glEnd(void);
#endif
#else
#include "poly-pal.hxx" // was <Palette.hxx>
#include "poly-mygl.hxx"
#include "poly-btg.hxx"
#include "load-btg.hxx"
#include "poly-load.hxx"    // for VERB5
#endif

#ifndef GL_TRIANGLES
#define GL_QUADS                          0x0007
#define GL_TRIANGLES                      0x0004
#define GL_TRIANGLE_FAN                   0x0006
/* FrontFaceDirection */
#define GL_CW                             0x0900
#define GL_CCW                            0x0901
#endif

#ifndef ATLAS_ASSERT
#define ATLAS_ASSERT
#endif
#ifndef ATLAS_EXIT
#define ATLAS_EXIT  btg_pgm_exit
#endif

using namespace std;
//#define prt printf
#define prt sprtf

static int add_extra_dbg_wgs84 = 0; // output FULL wgs84 (and if VERB5)
static int use_new_process = 1; // use the re-written BTG loader

int main_window = 0;
int graphs_window = 0;

static char * in_file = NULL;
static char * def_file = "C:\\FG\\Cullam\\Scenery-1.0.1\\Terrain\\w060n40\\w053n47\\2089569.btg.gz";
static char * pgm_name = NULL;
static char * pal_dir = "C:\\FG\\27\\Atlas\\src\\data";
static char * def_pal = "default.ap";

// Current palette.
//static Palette *palette = NULL;
static Palette *_palette = NULL;
static bool _discreteContours = false;

// center of current loaded BTG file
//const SGVec3<double>& gbs_p;
SGVec3d gbs_p;
SGGeod  center_geod;
std::string current_material;

//////////////////////////////////////////////////////////////////////
// Local variables used for gathering statistics
//////////////////////////////////////////////////////////////////////
static int triangles = 0;
static int quads = 0;
static int triCount = 0;
static int fanCount = 0;
static int stripCount = 0;
static int cTriCount = 0;
static int cFanCount = 0;
static int cStripCount = 0;
static int pureTriCount = 0;
static int pureFanCount = 0;
static int pureStripCount = 0;
static int triFanTris = 0;
static int pureTriFanTris = 0;
static int triFanPureLengthCount = 0;
static int triFanPureLengths = 0;


static void btg_pgm_exit(int val)
{
    exit(val);
}

#ifdef _MSC_VER
#define M_ISDIR _S_IFDIR
#else
#define M_ISDIR __S_IFDIR
#endif

static int is_file_or_directory( string cur_item )
{
   struct stat buf;
   if( stat( cur_item.c_str(), &buf ) == 0 ) {
      if ( buf.st_mode & M_ISDIR )
         return 1; // is directory
      else
         return 2; // is file
   }
   return 0;
}

SGBinObject _chunk;
vector<float *> _vertices, _normals;
vector<float> _elevations;
unsigned int _size = 0;        // Size of subbucket (approximately) in bytes.
bool     _loaded = false;
double _maxElevation = 0.0;
double _minElevation = 0.0;

static float * current_color  = NULL;
static void my_glColor4fv(const float *rgba)
{
    current_color = (float *)rgba;
    m_glColor4fv(rgba);
}
void my_glBegin(int type)
{
#ifdef POLY_VIEW
    m_set_act_material( current_material, "poly-btg:my_glBegin" );
#endif
    m_glBegin( type );
}
void my_glEnd(void)
{
    m_glEnd();
}
void my_glNormal3fv( const sgVec3 pf )
{
    float v[4];
    v[0] = pf[0];
    v[1] = pf[1];
    v[2] = pf[2];
    v[3] = 0.0;
    m_glNormal3fv((const float *)&v);
}

void my_glVertex3fv( const sgVec3 pf )
{
    //vertices[vertexIndices[i]]);
    SGVec3d p;
    for (int i = 0; i < 3; ++i)
        p.data()[i] = pf[i];
    SGGeod g = SGGeod::fromCart(p);
    float v[4];
    v[0] = g.getLongitudeDeg(); // pf[0];
    v[1] = g.getLatitudeDeg();  // pf[1];
    v[2] = g.getElevationM();  // pf[2];
    v[3] = 0.0;
    m_glVertex3fv( (const float *)&v );
}
void my_glFrontFace(int type)
{

}
static void setColor(const float *rgba)
{
    my_glColor4fv(rgba);
}

static void btg_drawQuad(const sgVec3 *p, const sgVec3 *normals)
{
    quads++;
    my_glBegin(GL_QUADS);
#ifndef ROTATE_NORMALS
    my_glNormal3fv(normals[0]); my_glVertex3fv(p[0]);
    my_glNormal3fv(normals[1]); my_glVertex3fv(p[1]);
    my_glNormal3fv(normals[2]); my_glVertex3fv(p[2]);
    my_glNormal3fv(normals[3]); my_glVertex3fv(p[3]);
#else
    sgVec3 newNormal;
    for (int i = 0; i < 4; i++) {
        rotate(newNormal, normals[i], p[i]);
        my_glNormal3fv(newNormal); my_glVertex3fv(p[i]);
    }
#endif // ROTATE_NORMALS
    my_glEnd();
}

static void btg_drawQuad(const sgVec3 *p, const sgVec3 *normals, const sgVec4 *color)
{
    quads++;
    my_glBegin(GL_QUADS);
#ifndef ROTATE_NORMALS
    my_glColor4fv(color[0]); my_glNormal3fv(normals[0]); my_glVertex3fv(p[0]);
    my_glColor4fv(color[1]); my_glNormal3fv(normals[1]); my_glVertex3fv(p[1]);
    my_glColor4fv(color[2]); my_glNormal3fv(normals[2]); my_glVertex3fv(p[2]);
    my_glColor4fv(color[3]); my_glNormal3fv(normals[3]); my_glVertex3fv(p[3]);
#else
    sgVec3 newNormal;
    for (int i = 0; i < 4; i++) {
        rotate(newNormal, normals[i], p[i]);
        my_glColor4fv(color[i]); my_glNormal3fv(newNormal); my_glVertex3fv(p[i]);
    }
#endif // ROTATE_NORMALS
    my_glEnd();
}

static void btg_drawTriangle(const sgVec3 *p, const sgVec3 *normals)
{
    triangles++;
    my_glBegin(GL_TRIANGLES);
#ifndef ROTATE_NORMALS
    my_glNormal3fv(normals[0]); my_glVertex3fv(p[0]);
    my_glNormal3fv(normals[1]); my_glVertex3fv(p[1]);
    my_glNormal3fv(normals[2]); my_glVertex3fv(p[2]);
#else
    sgVec3 newNormal;
    for (int i = 0; i < 3; i++) {
        rotate(newNormal, normals[i], p[i]);
        my_glNormal3fv(newNormal); my_glVertex3fv(p[i]);
    }
#endif // ROTATE_NORMALS
    my_glEnd();
}

static void btg_drawTriangle(const sgVec3 *p, const sgVec3 *normals, 
                         const sgVec4 *color) 
{
    triangles++;
    my_glBegin(GL_TRIANGLES);
#ifndef ROTATE_NORMALS
    my_glColor4fv(color[0]); my_glNormal3fv(normals[0]); my_glVertex3fv(p[0]);
    my_glColor4fv(color[1]); my_glNormal3fv(normals[1]); my_glVertex3fv(p[1]);
    my_glColor4fv(color[2]); my_glNormal3fv(normals[2]); my_glVertex3fv(p[2]);
#else
    sgVec3 newNormal;
    for (int i = 0; i < 3; i++) {
        rotate(newNormal, normals[i], p[i]);
        my_glColor4fv(color[i]); my_glNormal3fv(newNormal); my_glVertex3fv(p[i]);
    }
#endif // ROTATE_NORMALS
    my_glEnd();
}

static void btg_drawTriangle(const float* p0, const float* p1, const float* p2, 
                         const float* n0, const float* n1, const float* n2)
{
    triangles++;
    my_glBegin(GL_TRIANGLES);
#ifndef ROTATE_NORMALS
    my_glNormal3fv(n0); my_glVertex3fv(p0);
    my_glNormal3fv(n1); my_glVertex3fv(p1);
    my_glNormal3fv(n2); my_glVertex3fv(p2);
#else
    sgVec3 newNormal;
    rotate(newNormal, n0, p0);
    my_glNormal3fv(newNormal); my_glVertex3fv(p0);
    rotate(newNormal, n1, p1);
    my_glNormal3fv(newNormal); my_glVertex3fv(p1);
    rotate(newNormal, n2, p2);
    my_glNormal3fv(newNormal); my_glVertex3fv(p2);
#endif // ROTATE_NORMALS
    my_glEnd();
}

// A helper function for _drawElevationTri.  Draws a figure (which may
// be a triangle, quadrilateral, or pentagon).  The number of vertices
// and normals is given by 'vertices'.  The 'ts' array gives the
// vertices, 'nrms' the normals, and 'ps' the scaled map coordinates.
//
// We can assume that the vertices are given from top to bottom, and
// that they move around the perimeter of the figure in the correct
// order.  As well, we only need to guarantee that the last two
// points, which form the bottom of the figure, remain unchanged - the
// calling function doesn't care about the "upper" points.  (This is a
// *very* specialized routine).
static void btg__drawElevationSlice(int vertices, bool discrete, int k,
                                 sgVec3 *nrms, sgVec3 *ps, float *es)
{
    sgVec4 color[5];

    if (!discrete) {
        for (int i = 0; i < vertices; i++) {
            _palette->smoothColour((int)es[i], color[i]);
        }
    }

//     // EYE - draw it as a polygon, ignore smoothing.  This is simpler,
//     // but doesn't seem to improve performance much.
//     glBegin(GL_POLYGON);
//     setColor(palette[elev_colindex[k]]);
//     for (int i = 0; i < vertices; i++) {
//         glNormal3fv(nrms[i]); glVertex3fv(ps[i]);
//     }
//     glEnd();
//     return;

    // Draw the figure.
    if (vertices == 3) {
        // Triangle
        if (discrete) {
            setColor(_palette->contourAtIndex(k).colour);
            btg_drawTriangle(ps, nrms);
        } else {
            btg_drawTriangle(ps, nrms, color);
        }
    } else if (vertices == 4) {
        // Quadrilateral.
        if (discrete) {
            setColor(_palette->contourAtIndex(k).colour);
            btg_drawQuad(ps, nrms);
        } else {
            btg_drawQuad(ps, nrms, color);
        }
    } else {
        // Pentagon.  Draw it as a quadrilateral and a triangle.  The
        // quadralateral consists of the first 4 points, and the
        // triangle consists of the remaining two *and* the first one.
        // To draw the triangle, then, we copy the last two points
        // over the second and third points (this is okay, because
        // they won't be used again), and draw a triangle consisting
        // of the first 3 points.
        if (discrete) {
            setColor(_palette->contourAtIndex(k).colour);
            btg_drawQuad(ps, nrms);
        } else {
            btg_drawQuad(ps, nrms, color);
        }

        sgCopyVec3(nrms[1], nrms[3]);
        sgCopyVec3(ps[1], ps[3]);

        sgCopyVec3(nrms[2], nrms[4]);
        sgCopyVec3(ps[2], ps[4]);

        if (discrete) {
            btg_drawTriangle(ps, nrms);
        } else {
            sgCopyVec4(color[1], color[3]);
            sgCopyVec4(color[2], color[4]);
            btg_drawTriangle(ps, nrms, color);
        }
    }
}

// A helper function for _drawElevationTri.  Given an upper and a
// lower vertex defining an edge, and an elevation at which to slice
// the edge, creates a new point at that slice.  The new point is
// added to the nrms and ps arrays at the index 'dest'.  We also put
// the elevation into es.
//
// EYE - Why pass 'dest' - I should really just pass the vertex,
// normal, and point to be set.
static void btg__createSubPoint(float *topVert, float *bottomVert,
                             float *topNorm, float *bottomNorm,
                             float topE, float bottomE,
                             int dest, double elevation,
                             sgVec3 *nrms, sgVec3 *ps, float *es)
{
    sgVec3 newPoint, newNorm;
    double scaling = 
        (elevation - bottomE) / (topE - bottomE);
    // EYE - make this more general
    const double epsilon = 1e-5;
    ATLAS_ASSERT((scaling <= 1.0 + epsilon) && (-epsilon <= scaling));

    sgSubVec3(newPoint, topVert, bottomVert);
    sgScaleVec3(newPoint, scaling);
    sgAddVec3(newPoint, bottomVert);
    sgSubVec3(newNorm, topNorm, bottomNorm);
    sgScaleVec3(newNorm, scaling);
    sgAddVec3(newNorm, bottomNorm);

    sgCopyVec3(nrms[dest], newNorm);
    sgCopyVec3(ps[dest], newPoint);
    es[dest] = elevation;
}

#ifdef ROTATE_NORMALS
// "Fixes" normals when in a flat projection.  A normal perpendicular
// to the earth's surface at a point is transformed into <0, 0, 1>.
//
// to = fixed normal
// from = original normal
// by = vertex (which must be <lon, lat, ignored>)
static void rotate(sgVec3 to, const sgVec3 from, const sgVec3 by)
{
//     static int count = 0;
    float lon = by[0];
    float lat = by[1];

    sgMat4 z, x, mat;
    sgVec3 axis;

    // We want to unrotate by longitude (around the z axis).
    sgSetVec3(axis, 0.0, 0.0, 1.0);
    sgMakeRotMat4(z, -(90.0 + lon), axis);

    // And unrotate by latitude (around the x axis).
    sgSetVec3(axis, 1.0, 0.0, 0.0);
    sgMakeRotMat4(x, lat - 90.0, axis);

    // Create final matrix, and rotate normal.
    sgMultMat4(mat, z, x);
    sgXformVec3(to, from, mat);

//     count++;
//     if (count < 10) {
//         printf("<%f, %f, %f> => <%f, %f, %f>\n",
//                from[0], from[1], from[2], to[0], to[1], to[2]);
//     }
}
#endif // ROTATE_NORMALS

//static void drawTriangle(const sgVec3 *p, const sgVec3 *normals)
//{
//    triangles++;
//    my_glBegin(GL_TRIANGLES);
//#ifndef ROTATE_NORMALS
//    my_glNormal3fv(normals[0]); glVertex3fv(p[0]);
//    my_glNormal3fv(normals[1]); glVertex3fv(p[1]);
//    my_glNormal3fv(normals[2]); glVertex3fv(p[2]);
//#else
//    sgVec3 newNormal;
//    for (int i = 0; i < 3; i++) {
//        rotate(newNormal, normals[i], p[i]);
//        my_glNormal3fv(newNormal); glVertex3fv(p[i]);
//    }
//#endif // ROTATE_NORMALS
//    my_glEnd();
//}

//static void drawTriangle(const sgVec3 *p, const sgVec3 *normals, 
//                         const sgVec4 *color) 
//{
//    triangles++;
//    my_glBegin(GL_TRIANGLES);
//#ifndef ROTATE_NORMALS
//    my_glColor4fv(color[0]); glNormal3fv(normals[0]); glVertex3fv(p[0]);
//    my_glColor4fv(color[1]); glNormal3fv(normals[1]); glVertex3fv(p[1]);
//    my_glColor4fv(color[2]); glNormal3fv(normals[2]); glVertex3fv(p[2]);
//#else
//    sgVec3 newNormal;
//    for (int i = 0; i < 3; i++) {
//        rotate(newNormal, normals[i], p[i]);
//        my_glColor4fv(color[i]); glNormal3fv(newNormal); glVertex3fv(p[i]);
//    }
//#endif // ROTATE_NORMALS
//    my_glEnd();
//}

//static void drawTriangle(const float* p0, const float* p1, const float* p2, 
//                         const float* n0, const float* n1, const float* n2)
//{
//    triangles++;
//    my_glBegin(GL_TRIANGLES);
//#ifndef ROTATE_NORMALS
//    my_glNormal3fv(n0); glVertex3fv(p0);
//    my_glNormal3fv(n1); glVertex3fv(p1);
//    my_glNormal3fv(n2); glVertex3fv(p2);
//#else
//    sgVec3 newNormal;
//    rotate(newNormal, n0, p0);
//    my_glNormal3fv(newNormal); glVertex3fv(p0);
//    rotate(newNormal, n1, p1);
//    my_glNormal3fv(newNormal); glVertex3fv(p1);
//    rotate(newNormal, n2, p2);
//    my_glNormal3fv(newNormal); glVertex3fv(p2);
//#endif // ROTATE_NORMALS
//    my_glEnd();
//}

static void btg_drawTriangle(const float* p0, const float* p1, const float* p2, 
                         const float* n0, const float* n1, const float* n2,
                         const float* c0, const float* c1, const float* c2) 
{
    triangles++;
    my_glBegin(GL_TRIANGLES);
#ifndef ROTATE_NORMALS
    my_glColor4fv(c0); my_glNormal3fv(n0); my_glVertex3fv(p0);
    my_glColor4fv(c1); my_glNormal3fv(n1); my_glVertex3fv(p1);
    my_glColor4fv(c2); my_glNormal3fv(n2); my_glVertex3fv(p2);
#else
    sgVec3 newNormal;
    rotate(newNormal, n0, p0);
    my_glColor4fv(c0); my_glNormal3fv(newNormal); my_glVertex3fv(p0);
    rotate(newNormal, n1, p1);
    my_glColor4fv(c1); my_glNormal3fv(newNormal); my_glVertex3fv(p1);
    rotate(newNormal, n2, p2);
    my_glColor4fv(c2); my_glNormal3fv(newNormal); my_glVertex3fv(p2);
#endif // ROTATE_NORMALS
    my_glEnd();
}

// Draws the given triangle, coloured according to its elevation.  If
// the triangle spans more than one elevation level, and so needs more
// than one colour, it is sliced and diced, so that each part occupies
// only one level.  The triangle slices are temporary - no changes are
// made to the _vertices and _normals vectors.
//void Subbucket::_drawElevationTri(int vert0, int vert1, int vert2,
void btg_drawElevationTri(int vert0, int vert1, int vert2,
                                  int norm0, int norm1, int norm2)
{
    unsigned int index[3];
    index[0] = _palette->contourIndex(_elevations[vert0]);
    index[1] = _palette->contourIndex(_elevations[vert1]);
    index[2] = _palette->contourIndex(_elevations[vert2]);

    // Triangle lies within one elevation level.  Draw it in one
    // colour.
    if ((index[0] == index[1]) && (index[1] == index[2])) {
        if (!_discreteContours) {
            sgVec4 color[3];
            _palette->smoothColour(_elevations[vert0], color[0]);
            _palette->smoothColour(_elevations[vert1], color[1]);
            _palette->smoothColour(_elevations[vert2], color[2]);

            btg_drawTriangle(_vertices[vert0], _vertices[vert1], _vertices[vert2], 
                         _normals[norm0], _normals[norm1], _normals[norm2],
                         color[0], color[1], color[2]);
        } else {
            setColor(_palette->contour(_elevations[vert0]).colour);
            btg_drawTriangle(_vertices[vert0], _vertices[vert1], _vertices[vert2], 
                         _normals[norm0], _normals[norm1], _normals[norm2]);
        }

        return;
    }

    // Triangle spans more than one level.  Drats.  Do a quick sort on
    // the vertices, so that vert0 points to the top vertex, vert1,
    // the middle, and vert2 the bottom.
    //
    // Note that when we swap vertices, we change the triangle's
    // winding.  We have backface culling turned on, so we need to
    // ensure that we know how the front face is wound.  We assume
    // that the triangle comes in specified in a counterclockwise
    // direction, and that GL_FRONT_FACE is counterclockwise by
    // default.
    bool clockwise = false;
    if (index[0] < index[1]) {
        swap(vert0, vert1);
        swap(norm0, norm1);
        swap(index[0], index[1]);
        clockwise = !clockwise;
    }
    if (index[0] < index[2]) {
        swap(vert0, vert2);
        swap(norm0, norm2);
        swap(index[0], index[2]);
        clockwise = !clockwise;
    }
    if (index[1] < index[2]) {
        swap(vert1, vert2);
        swap(norm1, norm2);
        swap(index[1], index[2]);
        clockwise = !clockwise;
    }
    ATLAS_ASSERT(index[0] >= index[1]);
    ATLAS_ASSERT(index[1] >= index[2]);

    // If the font face of the triangle is now clockwise, tell OpenGL.
    if (clockwise) {
        my_glFrontFace(GL_CW);
    }

    // Now begin slicing the lines leading away from vert0 to vert1
    // and vert2.  Slicing a triangle creates new triangles, new
    // quadrilaterals, and even new pentagons.  Because the triangle
    // lies in a plane (by definition), we are assured that the new
    // figures are also planar.
    //
    // After each bit is sliced off the top, it is drawn and then
    // discarded.  The process is then repeated on the remaining
    // figure, until there's nothing left.
    //
    // This can be illustrated with the power of ASCII graphics.  If
    // we have to make two cuts of the triangle ABC, we'll create 4
    // new points, D, E, F, and G.  This creates 3 figures: ADE,
    // EDBFG, and GFC.
    //
    //        A               A                   
    //       /|              /|                   
    //      / |             / |                   
    //  -->/  |            D--E     D--E      D--E
    //    /   |           /   |    /   |     /   |
    //   B    |          B    |   B    |    B    |
    //    \   |           \   |    \   |     \   |
    //     \  |            \  |     \  |      \  |
    //   -->\ |          -->\ |   -->\ |       F-G       F-G
    //       \|              \|       \|        \|        \|
    //        C               C        C         C         C

    unsigned int k, vertices;
    sgVec3 nrms[5];
    sgVec3 ps[5];
    float es[5];

    // Slicing creates new vertices and normals, so we need to keep
    // track of actual points, not just their indices as before.  The
    // array 'nrms' keeps the norms of the current figure, and 'ps'
    // the scaled points.  At most we can generate a pentagon, so each
    // array has 5 points.  The current number of points is given by
    // 'vertices'.
    //
    // In the example above, the arrays will contain data for ADE,
    // then DEBFG, and finally GFC.  Note that points are given in a
    // counter-clockwise direction (as illustrated here).  This means
    // that that when a bottom line (eg, DE in ADE) becomes a top line
    // (ED in EDBFG), we reverse its order.
    sgCopyVec3(nrms[0], _normals[norm0]);
    sgCopyVec3(ps[0], _vertices[vert0]);
    es[0] = _elevations[vert0];
    vertices = 1;

    for (k = index[0]; k > index[1]; k--) {
        // Make a cut and draw the resulting figure.
        double elevation = _palette->contourAtIndex(k).elevation;

        // Cut along the short line (vert0 to vert1), and put the
        // resulting normal, point, and elevation into nrms, ps, and
        // es.
        btg__createSubPoint(_vertices[vert0], _vertices[vert1], 
                         _normals[norm0], _normals[norm1], 
                         _elevations[vert0], _elevations[vert1],
                         vertices++, elevation, nrms, ps, es);
        // Ditto for the long line (vert0 to vert2).
        btg__createSubPoint(_vertices[vert0], _vertices[vert2], 
                         _normals[norm0], _normals[norm2], 
                         _elevations[vert0], _elevations[vert2],
                         vertices++, elevation, nrms, ps, es);

        // Now draw the resulting figure.
        btg__drawElevationSlice(vertices, _discreteContours, k, nrms, ps, es);

        // We're ready to move down and make the next slice.  The two
        // points we just created will now be the top of the next
        // slice.  We need to reverse the order of the points.
        sgCopyVec3(nrms[0], nrms[vertices - 1]);
        sgCopyVec3(ps[0], ps[vertices - 1]);
        es[0] = es[vertices - 1];

        sgCopyVec3(nrms[1], nrms[vertices - 2]);
        sgCopyVec3(ps[1], ps[vertices - 2]);
        es[1] = es[vertices - 2];

        vertices = 2;
    }

    // Add the middle vertex.
    sgCopyVec3(nrms[vertices], _normals[norm1]);
    sgCopyVec3(ps[vertices], _vertices[vert1]);
    es[vertices] = _elevations[vert1];
    vertices++;
    ATLAS_ASSERT(vertices <= 5);

    for (; k > index[2]; k--) {
        // Make a cut and draw the resulting figure.
        double elevation = _palette->contourAtIndex(k).elevation;

        // Get the point along the short line.
        btg__createSubPoint(_vertices[vert1], _vertices[vert2], 
                         _normals[norm1], _normals[norm2], 
                         _elevations[vert1], _elevations[vert2],
                         vertices++, elevation, nrms, ps, es);
        // Get the point along the long line.
        btg__createSubPoint(_vertices[vert0], _vertices[vert2], 
                         _normals[norm0], _normals[norm2], 
                         _elevations[vert0], _elevations[vert2],
                         vertices++, elevation, nrms, ps, es);

        btg__drawElevationSlice(vertices, _discreteContours, k, nrms, ps, es);

        // The bottom will be the next top.
        sgCopyVec3(nrms[0], nrms[vertices - 1]);
        sgCopyVec3(ps[0], ps[vertices - 1]);
        es[0] = es[vertices - 1];

        sgCopyVec3(nrms[1], nrms[vertices - 2]);
        sgCopyVec3(ps[1], ps[vertices - 2]);
        es[1] = es[vertices - 2];
        
        vertices = 2;
    }

    // Add the final vertex and draw the last figure.
    sgCopyVec3(nrms[vertices], _normals[norm2]);
    sgCopyVec3(ps[vertices], _vertices[vert2]);
    es[vertices] = _elevations[vert2];
    vertices++;
    ATLAS_ASSERT(vertices <= 5);

    btg__drawElevationSlice(vertices, _discreteContours, k, nrms, ps, es);

    // Restore counterclockwise winding.
    if (clockwise) {
        my_glFrontFace(GL_CCW);
    }
}

// Draws a single triangle defined by the given vertices and normals
// (which are indexes into the _vertices and _normals vectors).  If
// the triangle defines an "elevation triangle" (a triangle that
// should be coloured according to its elevation), then it's passed on
// to _drawElevationTri.
//void Subbucket::_drawTri(int vert0, int vert1, int vert2,
void btg_drawTri(int vert0, int vert1, int vert2,
                         int norm0, int norm1, int norm2,
                         const float *col)
{
    // Elevation triangles get special treatment.
    if (col == NULL) {
        btg_drawElevationTri(vert0, vert1, vert2, norm0, norm1, norm2);
        return;
    }

    // Non-elevation triangles are coloured according to col.
    setColor(col);
    btg_drawTriangle(_vertices[vert0], _vertices[vert1], _vertices[vert2], 
                 _normals[norm0], _normals[norm1], _normals[norm2]);
}


static void btg_drawTriangleFan(const int_list &vertexIndices, 
                            const int_list &normalIndices,
                            vector<float *> &vertices, 
                            vector<float *> &normals)
{
    cFanCount++;
    my_glBegin(GL_TRIANGLE_FAN);
    {
        for (unsigned int i = 0; i < vertexIndices.size(); i++) {
#ifndef ROTATE_NORMALS
            // EYE - note that we only need one set of indices!  Why?
            // This only seems to be true for fans, but this should be
            // checked further.
            ATLAS_ASSERT(normalIndices[i] == vertexIndices[i]);
            my_glNormal3fv(normals[normalIndices[i]]);
            my_glVertex3fv(vertices[vertexIndices[i]]);
#else
            sgVec3 newNormal;
            rotate(newNormal, normals[normalIndices[i]], 
                   vertices[vertexIndices[i]]);
            my_glNormal3fv(newNormal);
            my_glVertex3fv(vertices[vertexIndices[i]]);
#endif // ROTATE_NORMALS
        }
    }
    my_glEnd();
}

//////////////////////////////////////////////////////////////////////
// Triangle routines
//////////////////////////////////////////////////////////////////////
//void Subbucket::_drawTristrip(const int_list &vertex_indices, 
void btg_drawTristrip(const int_list &vertex_indices, 
                              const int_list &normal_indices,
                              const float *col) 
{
    unsigned int i;
    int vert0, vert1, vert2;
    int norm0, norm1, norm2;
    prt("%s: vertex_indices %u, normal_indices %u\n", __FUNCTION__,
        vertex_indices.size(), normal_indices.size() );

    vert0 = vertex_indices[0];
    norm0 = normal_indices[0];
    vert1 = vertex_indices[1];
    norm1 = normal_indices[1];
    for (i = 2; i < vertex_indices.size(); i++) {
        vert2 = vertex_indices[i];
        norm2 = normal_indices[i];

        btg_drawTri(vert0, vert1, vert2, norm0, norm1, norm2, col);

        vert1 = vert0;
        norm1 = norm0;
        vert0 = vert2;
        norm0 = norm2;
    }
    return;

//     // Not cutting the fan/strip into triangles saves a lot of
//     // drawing.  For example, with w002n51, we have these numbers:
//     //
//     // tris: 190, fans: 17588, strips: 85
//     //
//     // If we subdivide everything we have this many calls to
//     // drawTriangle and drawQuad:
//     // 
//     // triangles: 57843, quads: 8134

//     // If we don't subdivide fans:
//     // 
//     // triangles: 4812, quads: 229
//     //
//     // And if we further don't subdivide strips:
//     //
//     // triangles: 3234, quads: 0
//     //
//     // And, of course, if we do the same for tris:
//     //
//     // triangles: 0, quads: 0

//     // If we look at how many structures are "pure" (don't cross a
//     // contour), and are flat coloured (ie, not an elevation), we get:
//     //
//     // tris: 190 (0 flat coloured, 189 pure, 1 impure)
//     // strips: 85 (0 flat coloured, 72 pure, 13 impure)
//     // fans: 17588 (8841 flat coloured, 6168 pure, 2579 impure)

//     // If we only pass on "impure" structures, we get:
//     //
//     // Pass on fans:
//     //
//     // triangles: 12312, quads: 7905
//     //
//     // Pass on fans and tris:
//     //
//     // triangles: 12348, quads: 7905
//     //
//     // Pass on fans, tris, and strips:
//     //
//     // triangles: 12610, quads: 8134

//     // The 2579 impure fans consist of 12262 individual triangles,
//     // 5054 of which are themselves pure.  The average "run length"
//     // (number of pure triangles in the fan before an impure triangle)
//     // is 2.26.
//     //
//     // Interestingly, these 7208 (12262 - 5054) impure triangles, when
//     // subdivided, create 12312 triangles and 7905 quads.

//     // If we try to draw the pure runs in the impure fans, we get:
//     //
//     // triangles: 7556, quads: 6397,
//     //
//     // nearly cutting the number of triangles in half (although at the
//     // expense of drawing some rather tiny fans).  The performance
//     // gain is difficult to judge, so not huge.

//     // Set colour to the colour of the first vertex.
//     if (col == NULL) {
//         setColor(_palette->contour(_elevations[vertex_indices[0]]).colour);
//         // Check to see if they actually all are at the same
//         // elevation.
//         unsigned int index = 
//             _palette->contourIndex(_elevations[vertex_indices[0]]);
//         unsigned int i;
//         for (i = 1; i < vertex_indices.size(); i++) {
//             if (_palette->contourIndex(_elevations[vertex_indices[i]]) != 
//                 index) {
//                 break;
//             }
//         }
//         if (i == vertex_indices.size()) {
//             pureStripCount++;
//         } else {
//             unsigned int i;
//             int vert0, vert1, vert2;
//             int norm0, norm1, norm2;

//             vert0 = vertex_indices[0];
//             norm0 = normal_indices[0];
//             vert1 = vertex_indices[1];
//             norm1 = normal_indices[1];
//             for (i = 2; i < vertex_indices.size(); i++) {
//                 vert2 = vertex_indices[i];
//                 norm2 = normal_indices[i];

//                 _drawTri(vert0, vert1, vert2, norm0, norm1, norm2, col);

//                 vert1 = vert0;
//                 norm1 = norm0;
//                 vert0 = vert2;
//                 norm0 = norm2;
//             }
//             return;
//         }
//     } else {
//         cStripCount++;
//         setColor(col);
//     }

//     glBegin(GL_TRIANGLE_STRIP);
//     for (unsigned int i = 0; i < vertex_indices.size(); i++) {
//         glNormal3fv(_normals[normal_indices[i]]);
//         glVertex3fv(_vertices[vertex_indices[i]]);
//     }
//     glEnd();

}

//void Subbucket::_drawTris(const int_list &vertex_indices, 
void btg_drawTris(const int_list &vertex_indices, 
                          const int_list &normal_indices, 
                          const float *col) 
{
    unsigned int i;
    int vert0, vert1, vert2;
    int norm0, norm1, norm2;

    prt("%s: vertex_indices %u, normal_indices %u\n", __FUNCTION__,
        vertex_indices.size(), normal_indices.size() );
    // EYE - can we assume indices.size() is divisible by 3?
    ATLAS_ASSERT((vertex_indices.size() % 3) == 0);
    for (i = 0; i < vertex_indices.size(); i += 3) {
        vert0 = vertex_indices[i];
        norm0 = normal_indices[i];
        vert1 = vertex_indices[i + 1];
        norm1 = normal_indices[i + 1];
        vert2 = vertex_indices[i + 2];
        norm2 = normal_indices[i + 2];

        btg_drawTri(vert0, vert1, vert2, norm0, norm1, norm2, col);
    }
    return;

//     if (col == NULL) {
//         setColor(_palette->contour(_elevations[vertex_indices[0]]).colour);
//         // Check to see if they actually all are at the same
//         // elevation.
//         unsigned int index = 
//             _palette->contourIndex(_elevations[vertex_indices[0]]);
//         unsigned int i;
//         for (i = 1; i < vertex_indices.size(); i++) {
//             if (_palette->contourIndex(_elevations[vertex_indices[i]]) 
//                 != index) {
//                 break;
//             }
//         }
//         if (i == vertex_indices.size()) {
//             pureTriCount++;
//         } else {
//             // EYE - and if smoothing is on?
//             // Breaks a contour.  Subdivide it into triangles.
//             unsigned int i;
//             int vert0, vert1, vert2;
//             int norm0, norm1, norm2;

//             // EYE - can we assume indices.size() is divisible by 3?
//             ATLAS_ASSERT((vertex_indices.size() % 3) == 0);
//             for (i = 0; i < vertex_indices.size(); i += 3) {
//                 vert0 = vertex_indices[i];
//                 norm0 = normal_indices[i];
//                 vert1 = vertex_indices[i + 1];
//                 norm1 = normal_indices[i + 1];
//                 vert2 = vertex_indices[i + 2];
//                 norm2 = normal_indices[i + 2];

//                 _drawTri(vert0, vert1, vert2, norm0, norm1, norm2, col);
//             }
//             return;
//         }
//     } else {
//         cTriCount++;
//         setColor(col);
//     }

//     glBegin(GL_TRIANGLES);
//     for (unsigned int i = 0; i < vertex_indices.size(); i++) {
//         glNormal3fv(_normals[normal_indices[i]]);
//         glVertex3fv(_vertices[vertex_indices[i]]);
//     }
//     glEnd();
}

//void Subbucket::_drawTrifan(const int_list &vertex_indices, 
void btg_drawTrifan(const int_list &vertex_indices, 
                            const int_list &normal_indices, 
                            const float *col)
{
    prt("%s: vertex_indices %u, normal_indices %u\n", __FUNCTION__,
        vertex_indices.size(), normal_indices.size() );
    if (col != NULL) {
        // If this is a material-coloured object, just draw it.

        // EYE - we should really impose an ordering on materials.
        // For example, cities should be drawn *under* roads,
        // railways, rivers, etc.  I should check to see if sets of
        // objects cover each other (as opposed to being inlaid into a
        // single grid).  I really should add:
        // (a) point, line, flat-coloured, and smooth-coloured rendering
        // (b) toggle "layers" (materials)
        setColor(col);
        btg_drawTriangleFan(vertex_indices, normal_indices, _vertices, _normals);
    } else {
        // Elevation coloured.
        unsigned int i;
        int cvert, vert1, vert2;
        int cnorm, norm1, norm2;

        cvert = vertex_indices[0];
        cnorm = normal_indices[0];
        vert1 = vertex_indices[1];
        norm1 = normal_indices[1];
        for (i = 2; i < vertex_indices.size(); i++) {
            vert2 = vertex_indices[i];
            norm2 = normal_indices[i];

            btg_drawTri(cvert, vert1, vert2, cnorm, norm1, norm2, col);

            vert1 = vert2;
            norm1 = norm2;
        }
    }

//     // This is an elevation object.  If all the vertices in the object
//     // are in the same elevation band, then we don't have to worry
//     // about splitting it.
//     int index = elev2colour(e[vertex_indices[0]]);
//     int i;

//     for (i = 1; i < vertex_indices.size(); i++) {
//         if (elev2colour(e[vertex_indices[i]]) != index) {
//             break;
//         }
//     }

//     if (i == vertex_indices.size()) {
//         // Everything is at the same elevation.
//         setColor(palette[index]);
//         // EYE - need to do something else if smoothing is on.
//         drawTriangleFan(vertex_indices, normal_indices, v, n);

//         return;
//     }

//     // EYE - and if smoothing is on?
//     // Breaks a contour.  Subdivide it into triangles.
//     int length;
//     int cvert, vert1, vert2;
//     int cnorm, norm1, norm2;

//     length = 0;

//     cvert = vertex_indices[0];
//     cnorm = normal_indices[0];
//     vert1 = vertex_indices[1];
//     norm1 = normal_indices[1];
//     for (i = 2; i < vertex_indices.size(); i++) {
//         vert2 = vertex_indices[i];
//         norm2 = normal_indices[i];

//         triFanTris++;
//         if ((elev2colour(e[vert1]) == index) && 
//             (elev2colour(e[vert2]) == index)) {
//             pureTriFanTris++;
//             length++;
//         } else {
//             // Did we get a run?
//             if (length > 0) {
//                 // Draw section of fan.  

//                 // EYE - the setColor() command must come
//                 // outside of the glBegin()!.  Why?  A: I
//                 // don't know, but changing setColor() fixed
//                 // things.
//                 glBegin(GL_TRIANGLE_FAN);
//                 setColor(palette[index]);
//                 glNormal3fv(n[cnorm]);
//                 glVertex3fv(v[cvert]);

//                 for (int j = i - length - 1; j < i; j++) {
//                     glNormal3fv(n[normal_indices[j]]);
//                     glVertex3fv(v[vertex_indices[j]]);
//                 }
//                 glEnd();

//                 triFanPureLengthCount++;
//                 triFanPureLengths += length;
//                 length = 0;
//             }
//             // And draw the triangle that broke the run.
//             draw_a_tri(cvert, vert1, vert2, cnorm, norm1, norm2, 
//                        v, n, e, col);
//         }
//         //                 draw_a_tri(cvert, vert1, vert2, cnorm, norm1, norm2, 
//         //                            v, n, e, col);

//         vert1 = vert2;
//         norm1 = norm2;
//     }
//     // If we had a run at the end, draw that too.
//     if (length > 0) {
//         // Draw section of fan.

//         glBegin(GL_TRIANGLE_FAN);
//         setColor(palette[index]);
//         glNormal3fv(n[cnorm]);
//         glVertex3fv(v[cvert]);

//         for (int j = i - length - 1; j < i; j++) {
//             glNormal3fv(n[normal_indices[j]]);
//             glVertex3fv(v[vertex_indices[j]]);
//         }
//         glEnd();

//         triFanPureLengthCount++;
//         triFanPureLengths += length;
//         length = 0;
//     }

//     return;
}

void unload_btg_tile(void)
{
    for (unsigned int i = 0; i < _vertices.size(); i++) {
        delete []_vertices[i];
    }
    _vertices.clear();

    for (unsigned int i = 0; i < _normals.size(); i++) {
        delete []_normals[i];
    }
    _normals.clear();

    _elevations.clear();

    _size = 0;
    _loaded = false;
}

bool load_tile( string & _path )
{
    unload_btg_tile();
    //ATLAS_ASSERT(_size == 0);
    if (!_chunk.read_bin(_path.c_str())) {
        // EYE - throw an error?
        return false;
    }

    // A chunk contains a bunch of points in 3D cartesian space, where
    // the origin is at the centre of the earth, the X axis goes
    // through 0 degrees latitude, 0 degrees longitude (near Africa),
    // the Y axis goes through 0 degrees latitude, 90 degrees west
    // latitude (in the Indian Ocean), and the Z axis goes through the
    // north pole.  Units are metres.  See:
    //
    // http://www.flightgear.org/Docs/Scenery/CoordinateSystem/CoordinateSystem.html
    //
    // for more.

    // Each chunk has a reference point, given by get_gbs_center().
    // All points within the chunk are relative to the reference
    // point.  Therefore, to place points in absolute 3D space, we
    // need to add the reference point to all points.
    //const SGVec3<double>& gbs_p = _chunk.get_gbs_center2();
    gbs_p = _chunk.get_gbs_center2();
    center_geod = SGGeod::fromCart(gbs_p);
    prt("Center x,y,z = %g,%g,%g lat=%g lon=%g elev=%g feet\n", gbs_p.x(), gbs_p.y(), gbs_p.z(),
        center_geod.getLongitudeDeg(), center_geod.getLatitudeDeg(),
        center_geod.getElevationFt());

    // Get all the points.
    const vector<SGVec3<double> >& wgs84_nodes = _chunk.get_wgs84_nodes();
    prt("btg processing wgs84 nodes %u...\n", wgs84_nodes.size() );
    for (unsigned int i = 0; i < wgs84_nodes.size(); i++) {
        // Make the point absolute.
        SGVec3<double> node = wgs84_nodes[i] + gbs_p;
        float *nv = new sgVec3;        // EYE - change to double?
        
        // Calculate lat, lon, elevation.
        SGGeod geod = SGGeod::fromCart(node);

        // Now convert the point using the given projection.
        //if (projection == Bucket::CARTESIAN) {
            // This is a true 3D rendering.
            sgSetVec3(nv, node[0], node[1], node[2]);
        //} else if (projection == Bucket::RECTANGULAR) {
            // This is a flat projection.  X and Y are determined by
            // longitude and latitude, respectively.  We don't care
            // about Z, so set it to 0.0.  The colour will be
            // determined separately, and the shading will be
            // determined by the vertex normals.
        //    sgSetVec3(nv, geod.getLongitudeDeg(), geod.getLatitudeDeg(), 0.0);
        //}
            if (add_extra_dbg_wgs84 && VERB5) {
                prt("[V5]:poly-btg:%d: wgs84 node: %.6f,%.6f (xyz=%.6f,%.6f,%.6f\n",
                    (i + 1),
                    geod.getLongitudeDeg(), geod.getLatitudeDeg(),
                    node[0], node[1], node[2] );
            }
        _vertices.push_back(nv);

        // Save our elevation.  This value is used to do elevation
        // colouring.
        _elevations.push_back(geod.getElevationM());
    }

    // same as above for normals
    const vector<SGVec3<float> >& m_norms = _chunk.get_normals();
    prt("Processing %u norms...\n", m_norms.size() );
    for (unsigned int i = 0; i < m_norms.size(); i++) {
        const SGVec3<float>& normal = m_norms[i];
        // Make a new normal
        float *nn = new sgVec3;
    
        sgSetVec3(nn, normal[0], normal[1], normal[2]);
        _normals.push_back(nn);
    }

//     if (wgs84_nodes.size() != m_norms.size()) {
//         printf("loadChunk: %d vertices, %d normals\n", 
//                wgs84_nodes.size(), m_norms.size());
//     }

    // Find the highest point in the chunk and set _maxElevation.
    // EYE - magic number!
    _maxElevation = -1e6;
    _minElevation = 1e6;
    prt("btg processing elevations %u...\n", _elevations.size() );
    for (unsigned int i = 0; i < _elevations.size(); i++) {
        if (_elevations[i] > _maxElevation) {
            _maxElevation = _elevations[i];
        }
        if (_elevations[i] < _minElevation) {
            _minElevation = _elevations[i];
        }

    }
    _maxElevation *= SG_METER_TO_FEET;
    _minElevation *= SG_METER_TO_FEET;
    prt("poly-btg: Got elevation max %g, min %g feet...\n", _maxElevation, _minElevation);
    // Estimate the size of the subbucket.  We just count the vertices
    // and normals.  There are probably other bits we should count,
    // but I think it's close enough.
    _size = _vertices.size() * sizeof(sgVec3);
    _size += _normals.size() * sizeof(sgVec3);
    
    return true;
}


void draw_tile(Palette *palette, bool discreteContours)
{
    // EYE - this is ugly.  We should somehow make palette a part of this.
    _palette = palette;
    _discreteContours = discreteContours;

    const float *material;

    // EYE - we assume that glColorMaterial() has been called.

    const group_list& tris = _chunk.get_tris_v();
    const string_list& tri_mats = _chunk.get_tri_materials();
    const group_list& tris_normals = _chunk.get_tris_n();

    const group_list& fans = _chunk.get_fans_v();
    const string_list& fan_mats = _chunk.get_fan_materials();
    const group_list& fans_normals = _chunk.get_fans_n();

    const group_list& strips = _chunk.get_strips_v();
    const string_list& strip_mats = _chunk.get_strip_materials();
    const group_list& strips_normals = _chunk.get_strips_n();
  
    triCount += tris.size();
    fanCount += fans.size();
    stripCount += strips.size();
    sprtf("poly-btg: tris=%d, fans=%d, strip=%d\n", triCount, fanCount, stripCount);

    if ( use_new_process ) {
        if( process_bin_load(_chunk) )
            return;
    }
    // EYE - do points too?
    // Triangles
    for (unsigned int i = 0; i < tris.size(); i++) {
        current_material = tri_mats[i];
        material = _palette->colour(tri_mats[i].c_str());

        if (tris_normals[i].size() > 0) {
            ATLAS_ASSERT(tris[i].size() == tris_normals[i].size());
            btg_drawTris(tris[i], tris_normals[i], material);
        } else {
            btg_drawTris(tris[i], tris[i], material);
        }
    }

    // Triangle fans
    for (unsigned int i = 0; i < fans.size(); i++) {
        current_material = fan_mats[i];
        material = _palette->colour(fan_mats[i].c_str());

        if (fans_normals[i].size() > 0) {
            ATLAS_ASSERT(fans[i].size() == fans_normals[i].size());
            btg_drawTrifan(fans[i], fans_normals[i], material);
        } else {
            btg_drawTrifan(fans[i], fans[i], material);
        }
    }
        
    // Triangle strips
    for (unsigned int i = 0; i < strips.size(); i++) {
        current_material = strip_mats[i];
        material = _palette->colour(strip_mats[i].c_str());

        if (strips_normals[i].size() > 0) {
            ATLAS_ASSERT(strips[i].size() == strips_normals[i].size());
            btg_drawTristrip(strips[i], strips_normals[i], material);
        } else {
            btg_drawTristrip(strips[i], strips[i], material);
        }
    }
}


int load_btg_tile( char * file )
{
    string s = file;
    if ( ! load_tile(s) ) {
        prt( "ERROR: Reading file [%s]\n", file );
        return 1;
    }
    return 0;
}

// We keep a list of all palettes.  Initially this is set to the
// installed palettes in Atlas' Palettes directory, but it can expand
// if the user loads custom palettes of her own.
class Palettes {
  public:
    Palettes(const char *paletteDir);
    ~Palettes();

    Palette *currentPalette();
    size_t currentPaletteNo() { return _i; }
    size_t size() { return _palettes.size(); }
    const Palette *setPalette(size_t i);
    const vector<Palette *>& palettes() { return _palettes; }

    // Adds the given path to the list (unless it's there already),
    // loads the given palette (unless it's loaded already), and
    // returns a pointer to it (NULL if it couldn't be loaded, in
    // which case the vector and current palette are unchanged).
    Palette *load(const char *path);
    // Unloads the current palette and replaces it with another.
    const Palette *unload();

  protected:
    size_t _i;
    vector<Palette *> _palettes;
};
Palettes *palettes;

Palettes::Palettes(const char *paletteDir): _i(0)
{
    // Find out what palettes are pre-installed and put them in the
    // 'palettes' vector.
    ulDir *dir = ulOpenDir(paletteDir);
    ulDirEnt *entity;
    while (dir && (entity = ulReadDir(dir))) {
        // All palettes should have the suffix ".ap".
        char *suffix = entity->d_name + strlen(entity->d_name) - strlen(".ap");
        if (!entity->d_isdir && (strcmp(suffix, ".ap") == 0)) {
            SGPath p(paletteDir);
            p.append(entity->d_name);

            try {
                Palette *aPalette = new Palette(p.c_str());
                _palettes.push_back(aPalette);
            } catch (runtime_error e) {
                // EYE - throw an error instead?
                fprintf(stderr, "Palettes::Palettes: couldn't load '%s'", 
                        p.c_str());
            }
        }
    }
}

Palette *Palettes::currentPalette()
{
    if (_i < _palettes.size()) {
        return _palettes[_i];
    } else {
        return NULL;
    }
}

const Palette *Palettes::setPalette(size_t i)
{
    if (i < _palettes.size()) {
        _i = i;
        return _palettes[_i];
    } else {
        return NULL;
    }
}

Palette *Palettes::load(const char *path)
{
    // First check and see if we have it already.  We just compare the
    // paths we're given, which are not guaranteed to be canonical, so
    // this is not a fail-safe test - it's possible to load the same
    // file twice.
    unsigned int i;
    for (i = 0; i < _palettes.size(); i++) {
        if (strcmp(path, _palettes[i]->path()) == 0) {
            _i = i;
            break;
        }
    }

    if (i == _palettes.size()) {
        // It's new, so try loading it.
        try {
            Palette *aPalette = new Palette(path);
            _palettes.push_back(aPalette);
            _i = i;
        } catch (runtime_error e) {
            fprintf(stderr,
                    "Palettes::load: error loading palette file '%s': %s\n", 
                    path, e.what());
            return NULL;
        }
    }

    return _palettes[_i];
}

const Palette *Palettes::unload()
{
    if (_i < _palettes.size()) {
        Palette *p = _palettes[_i];
        _palettes.erase(_palettes.begin() + _i);
        delete p;
        if (_i < _palettes.size()) {
            return _palettes[_i];
        } else if (_palettes.size() > 0) {
            _i = _palettes.size() - 1;
            return _palettes[_i];
        } else {
            _i = 0;
            return NULL;
        }
    } else {
        return NULL;
    }
}


int load_a_palette( string & path, string & file )
{

    // First get our standard palettes.
    //SGPath paletteDir = prefs.path;
    SGPath paletteDir = path;
    paletteDir.append("Palettes");
    try {
        palettes = new Palettes(paletteDir.c_str());
    } catch (runtime_error e) {
        // EYE - but which one?
        fprintf(stderr, "%s: Failed to read palettes from '%s'\n",
                pgm_name, paletteDir.c_str());
        // ATLAS_EXIT(1);
        return 1;
    }

    // Load the preferred palette.
    //globals.palette = palettes->load(prefs.palette.c_str());
    //if (!globals.palette) {
        // Try tacking the palette directory on the front and see what
        // happens.
        paletteDir.append(file);
        _palette = palettes->load(paletteDir.c_str());
        if (!_palette) {
            printf("%s: Failed to read palette file '%s'\n", 
                   pgm_name, file.c_str());
            // EYE - exit?
            //ATLAS_EXIT(1);
            return 1;
        }
    return 0;
}

int load_default_palette(void)
{
    string pal = pal_dir;
    string fil = def_pal;
    return load_a_palette( pal, fil );
}
void unload_atlas_palette(void)
{
    palettes->unload();
}

int draw_btg_tile(void)
{
    if ( _palette ) {
        draw_tile( _palette, true );
        return 1;
    }
    return 0;
}

int load_btg_tile_polys( char * file )
{
    if ( load_btg_tile(file) )
        return 1;

    if ( (_palette == NULL) && load_default_palette() )
        return 1;

    draw_btg_tile();

    return 0;

}


#ifdef TEST

int main( int argc, char * * argv )
{
    int iret = 0;
    char * arg;
    int i;
    pgm_name = argv[0];

    for (i = 1; i < argc; i++) {
        arg = argv[i];
        if (arg[0] == '-') {
            prt("ERROR: Only input is BTG file. Unknonw [%s]\n", arg);
            btg_pgm_exit(1);
        } else {
            in_file = strdup(arg);
            if ( is_file_or_directory( in_file ) != 2 ) {
                prt("ERROR: Can NOT locate file [%s]! Aborting...\n", in_file);
                btg_pgm_exit(1);
            }
        }
    }

    prt("Running %s\n", argv[0]);
    if ( !in_file ) {
        prt("Error: No input file given!\n");
        if ( is_file_or_directory( def_file ) == 2 ) {
            prt("Using default of [%s]...\n", def_file );
            in_file = def_file;
        } else {
            btg_pgm_exit(1);
        }
    }
    
    load_default_palette();
    iret = load_btg_tile(in_file);
    if (iret == 0)
        draw_btg_tile();    // palette, true );

    unload_btg_tile();
    unload_atlas_palette();

    btg_pgm_exit(iret);
    return iret;
}

#ifndef USE_GL_LIB
void m_glColor4fv( const float * v)
{
   int red   = (int)(v[0] * 255.0);
   int green = (int)(v[1] * 255.0);
   int blue  = (int)(v[2] * 255.0);
   int inten = (int)(v[3] * 255.0);
   sprtf("Set color to RGBA(%g,%g,%g,%g) RGB(%3d,%3d,%3d)\n", v[0], v[1], v[2], v[3],
       red, green, blue);
}
void m_glBegin( int type )
{
    sprtf("Begin object %d\n", type);
}
void m_glNormal3fv( const float * v )
{
    sprtf("Set normal3fv %g,%g,%g\n", v[0], v[1], v[2]);
}
void m_glVertex2f( float v1, float v2 )
{
    sprtf("Set vertex2f %g,%g\n", v1, v2);
}
void m_glVertex2fv( const float * v )
{
    sprtf("Set vertex2fv %g,%g\n", v[0], v[1]);
}
void m_glVertex3fv( const float * v )
{
    SGVec3d p;
    for (int i = 0; i < 3; ++i)
        p.data()[i] = v[i];
    SGGeod g = SGGeod::fromCart(p);
    sprtf("Set vertex3fv (%g,%g,%g) llef=%g,%g,%g\n", v[0], v[1], v[2],
        g.getLongitudeDeg(), g.getLatitudeDeg(),
        g.getElevationFt());
}
void m_glEnd(void)
{
    sprtf("End object\n");
}

#endif // !USE_GL_LIB

#endif // #ifdef TEST

// eof - btg_load.cxx
