// poly-ini.cxx - save persistant variables
//
// Written by Geoff McLane, started April, 2009.
//
// Copyright (C) 2009-2011  Geoff R. McLane  - http://geoffair.net/fg
//
// This program is free software; you can redistribute it and/or
// modify it under the terms of the GNU General Public License as
// published by the Free Software Foundation; either version 2 of the
// License, or (at your option) any later version.
//
// This program is distributed in the hope that it will be useful, but
// WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
// General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with this program; if not, write to the Free Software
// Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
//

#ifdef HAVE_CONFIG_H
#include <config.h>
#endif
#ifdef _MSC_VER
#include <windows.h>
#endif
#include <stdio.h>

#include "poly-ini.hxx"
#include "poly-load.hxx"   // poly gloabl items
#include "lib_sprtf.hxx"

#define  m_atoi   atoi
#define  m_sscanf sscanf

#define	GetStg( a, b )	\
	GetPrivateProfileString( a, b, &szBlk[0], lpb, 256, lpini )

#define  it_None        0     // end of list
#define  it_Version     1
#define  it_String      2
#define  it_Int         3
#define  it_Bool        4
#define  it_WinSize     5     // special WINDOWPLACEMENT
#define  it_Rect        6
#define  it_Color       7
#define  it_Double      8

typedef double (*GS_DOUBLE) (void);

typedef struct	tagINILST {	/* i */
	char *	i_Sect;
	char *	i_Item;
	int	   i_Type;
	char *	i_Deft;
	int *	   i_Chg;
	void *   i_Void;
	GS_DOUBLE   gs_double;
} INILST, * PINILST;

static char g_szDefIni[] = "poly-view.ini";
char g_szIni[264] = { "\0" };
char szBlk[] = "\0";
// Sections
char szVer[] = "Version";
char szWin[] = "Window";
char szFil[] = "FileLists";
char szOpt[] = "Options";

char szDt[] = "Version-Date";
char szCVer[] = POLY_VERS_DATE;
int bChgAll = 0;

static char m_szTmpBuf[1024];

// section [Window]
// char szWin[] = "Window";
char szShow[] = "ShowCmd";
char szMaxX[] = "MaxX";
char szMaxY[] = "MaxY";
char szMinX[] = "MinX";
char szMinY[] = "MinY";
char szLeft[] = "NormLeft";
char szTop[]  = "NormTop";
char szRite[] = "NormRight";
char szBot[]  = "NormBottom";

char szGOut[] = "OutSaved";
BOOL  gbGotWP = FALSE;
WINDOWPLACEMENT   g_sWP;
BOOL  bChgWP = FALSE;

char szZm[] = "Zoomed";
char szIc[] = "Iconic";
char szSz[] = "Size";

// section char szOpt[] = "Options";
char szAuto[] = "autozoom";
int gDoAuto = TRUE;
int gChgAut = FALSE;

char szZoom[] = "zoom";
double gdZoom = DEFAULT_ZOOM;
int gChgZoom = FALSE;

char szColor[] = "enable-color";
int giColor = 1;
int gChgColor = FALSE;

char szJoin[] = "join-points";
BOOL gbJoin = 1;
BOOL gbChgJoin = 0;

char szJoinLast[] = "join-last";
BOOL gbJoinLast = 1;
BOOL gbChgJoinLast = 0;

char szPageK[] = "page-key_steps";
int   giPageStep = 10;
BOOL  gbChgPgSt = FALSE;

char szNeib[] = "add-neightbors";
BOOL gbNeib = 0;
BOOL gbChgNeib = 0;

char szPB[] = "paint-buckets";
BOOL gbPB = FALSE;
BOOL gbChgPB = FALSE;

char szPX[] = "paint-X";
BOOL gbPX = FALSE;
BOOL gbChgPX = FALSE;

// ========================================================================
// INI Table
// Note, for each INI added, must also add to
// Post_INI_Read, and Pre_INI_Write
// INI items can be overwritten by command line options
INILST sIniLst[] = {
   { szVer, szDt,   it_Version,          szCVer,        &bChgAll, 0, 0 },  // CHANGE ALL!
   // section "Window"
   { szWin, szGOut, it_WinSize,   (char *)&g_sWP,        &bChgWP, (PVOID)&gbGotWP, 0 },
   // section "Options";
   { szOpt, szAuto, it_Bool,      (char *)&gDoAuto,     &gChgAut, 0,  0 },
   { szOpt, szZoom, it_Double,    (char *)&gdZoom,      &gChgZoom, 0, 0 },
   { szOpt, szColor, it_Bool,     (char *)&giColor,     &gChgColor, 0,  0 },
   { szOpt, szJoin, it_Bool,     (char *)&gbJoin,     &gbChgJoin, 0,  0 },
   { szOpt, szJoinLast, it_Bool, (char *)&gbJoinLast, &gbChgJoinLast, 0,  0 },
   //{ szOpt, szPenW, it_Int,       (PTSTR)&gPenW,       &gChgPen, 0,  0 },
   //{ szOpt, szPenC, it_Color,     (PTSTR)&gPenC,       &gChgPC,  0,  0 },

   { szOpt, szPageK,  it_Int,       (PTSTR)&giPageStep, &gbChgPgSt, 0, 0 },
   { szOpt, szNeib, it_Bool,     (char *)&gbNeib,     &gbChgNeib, 0, 0 },
   { szOpt, szPB, it_Bool,       (char *)&gbPB,     &gbChgPB, 0, 0 },
   { szOpt, szPX, it_Bool,       (char *)&gbPX,     &gbChgPX, 0, 0 },

   // last entry
   { 0,  0,  it_None, 0, 0, 0, 0 }
};


int Chk4Debug( char * lpd )
{
   int     bret = FALSE;
   char * ptmp = &m_szTmpBuf[0];
   char *   p;
   int  dwi;

   strcpy(ptmp, lpd);
   dwi = (int)strlen(ptmp);
   while(dwi--)
   {
      if(ptmp[dwi] == '\\')
      {
         ptmp[dwi] = 0;
         p = strrchr(ptmp, '\\');
         if(p)
         {
            p++;
            if( strcmpi(p, "DEBUG") == 0 )
            {
               *p = 0;
               strcpy(lpd,ptmp);    // use this
               bret = TRUE;
               break;
            }
         }
      }
   }
   return bret;
}

void  GetModulePath( char * lpb )
{
   char *   p;
   GetModuleFileName( NULL, lpb, 256 );
   p = strrchr( lpb, '\\' );
   if( p )
      p++;
   else
      p = lpb;
   *p = 0;
#ifndef  NDEBUG
   Chk4Debug( lpb );
#endif   // !NDEBUG

}

char * GetINIFile(void) {
   char * lpini = g_szIni;
   if( *lpini == 0 ) {
      GetModulePath( lpini );    // does   GetModuleFileName( NULL, lpini, 256 );
      strcat(lpini, g_szDefIni);
   }
   return lpini;
}

///////////////////////////////////////////////////////////////////////////////
// FUNCTION   : IsYes
// Return type: BOOL 
// Argument   : LPTSTR lpb
// Description: Return TRUE if the string given is "Yes" OR "On"
///////////////////////////////////////////////////////////////////////////////
int  IsYes( char * lpb )
{
   int  bRet = FALSE;
   if( ( strcmpi(lpb, "yes") == 0 ) ||
       ( strcmpi(lpb, "on" ) == 0 ) )
       bRet = TRUE;
   return bRet;
}

int  IsNo( char * lpb )
{
   int  bRet = FALSE;
   if( ( strcmpi(lpb, "no" ) == 0 ) ||
       ( strcmpi(lpb, "off") == 0 ) )
       bRet = TRUE;
   return bRet;
}

///////////////////////////////////////////////////////////////////////////////
// FUNCTION   : IsRectOk
// Return type: BOOL 
// Argument   : PRECT pr
// Description: A rough verification that a RECTANGLE 'looks' OK
//              NOTE: Thre must be SOME value, and they must all
// be positive (or zero, but not all).
///////////////////////////////////////////////////////////////////////////////
BOOL  IsRectOk( PRECT pr )
{
   BOOL  bRet = FALSE;
   if( pr->left || pr->top || pr->right || pr->bottom )
   {
      // good start - some value is NOT zero
      // here I am ONLY accepting POSITIVE values
      if( ( pr->left >= 0 ) &&
          ( pr->top >= 0 ) &&
          ( pr->right >= 0 ) &&
          ( pr->bottom >= 0 ) )
      {
         bRet = TRUE;
      }
      else if(( pr->right  > 0 ) &&
              ( pr->bottom > 0 ) )
      {
         // this is a POSSIBLE candidate,
         // but limit neg x,y to say 5 pixels
         if(( pr->left > -5 ) &&
            ( pr->top  > -5 ) )
         {
            bRet = TRUE;
         }
      }
   }
   return bRet;
}

BOOL  ValidShowCmd( UINT ui )
{
   BOOL  bRet = FALSE;
   if( ( ui == SW_HIDE ) ||   //Hides the window and activates another window. 
       ( ui == SW_MAXIMIZE ) ||  //Maximizes the specified window. 
       ( ui == SW_MINIMIZE ) ||  //Minimizes the specified window and activates the next top-level window in the Z order. 
       ( ui == SW_RESTORE ) ||   //Activates and displays the window. If the window is minimized or maximized, the system restores it to its original size and position. An application should specify this flag when restoring a minimized window. 
       ( ui == SW_SHOW ) || //Activates the window and displays it in its current size and position.  
       ( ui == SW_SHOWMAXIMIZED ) || //Activates the window and displays it as a maximized window. 
       ( ui == SW_SHOWMINIMIZED ) || //Activates the window and displays it as a minimized window. 
       ( ui == SW_SHOWMINNOACTIVE ) ||  //Displays the window as a minimized window. 
       ( ui == SW_SHOWNA ) || //Displays the window in its current size and position. 
       ( ui == SW_SHOWNOACTIVATE ) ||  //Displays a window in its most recent size and position. 
       ( ui == SW_SHOWNORMAL ) )
       bRet = TRUE;
   return bRet;
}

///////////////////////////////////////////////////////////////////////////////
// FUNCTION   : GotWP
// Return type: BOOL 
// Arguments  : LPTSTR pSect
//            : LPTSTR pDef
//            : LPTSTR lpb
//            : LPTSTR lpini
// Description: Read in a special BLOCK of window palcement item from
//              the INI file. This is in its own [section].
///////////////////////////////////////////////////////////////////////////////
BOOL  GotWP( PTSTR pSect, PTSTR pDef, PTSTR lpb, PTSTR lpini )
{
   BOOL  bRet = FALSE;
   WINDOWPLACEMENT   wp;
   WINDOWPLACEMENT * pwp = (WINDOWPLACEMENT *)pDef;
   if( !pwp )
      return FALSE;

   *lpb = 0;
   GetStg( pSect, szShow ); // = "ShowCmd";
   if( *lpb == 0 )
      return FALSE;
   wp.showCmd = m_atoi(lpb);
   if( !ValidShowCmd( wp.showCmd ) )
      return FALSE;

   *lpb = 0;
   GetStg( pSect, szMaxX );
   if( *lpb == 0 )
      return FALSE;
   wp.ptMaxPosition.x = m_atoi(lpb);
   *lpb = 0;
   GetStg( pSect, szMaxY );
   if( *lpb == 0 )
      return FALSE;
   wp.ptMaxPosition.y = m_atoi(lpb);

   *lpb = 0;
   GetStg( pSect, szMinX );
   if( *lpb == 0 )
      return FALSE;
   wp.ptMinPosition.x = m_atoi(lpb);
   *lpb = 0;
   GetStg( pSect, szMinY );
   if( *lpb == 0 )
      return FALSE;
   wp.ptMinPosition.y = m_atoi(lpb);

   *lpb = 0;
   GetStg( pSect, szLeft );   // = "NormLeft";
   if( *lpb == 0 )
      return FALSE;
   wp.rcNormalPosition.left = m_atoi(lpb);
   *lpb = 0;
   GetStg( pSect, szTop ); // = "NormTop";
   if( *lpb == 0 )
      return FALSE;
   wp.rcNormalPosition.top = m_atoi(lpb);
   *lpb = 0;
   GetStg( pSect, szRite );   // = "NormRight";
   if( *lpb == 0 )
      return FALSE;
   wp.rcNormalPosition.right = m_atoi(lpb);
   *lpb = 0;
   GetStg( pSect, szBot ); //  = "NormBottom";
   if( *lpb == 0 )
      return FALSE;
   wp.rcNormalPosition.bottom = m_atoi(lpb);

   wp.flags = 0;
   wp.length = sizeof(WINDOWPLACEMENT);

   memcpy( pwp, &wp, sizeof(WINDOWPLACEMENT) );
   bRet = TRUE;
   return bRet;
}

BOOL  ChangedWP( WINDOWPLACEMENT * pw1, WINDOWPLACEMENT * pw2 )
{
   BOOL  bChg = FALSE;
   if( ( pw1->length != sizeof(WINDOWPLACEMENT) ) ||
       ( pw2->length != sizeof(WINDOWPLACEMENT) ) ||
       ( pw1->showCmd != pw2->showCmd ) ||
       ( pw1->ptMaxPosition.x != pw2->ptMaxPosition.x ) ||
       ( pw1->ptMaxPosition.y != pw2->ptMaxPosition.y ) ||
       ( !EqualRect( &pw1->rcNormalPosition, &pw2->rcNormalPosition ) ) )
   {
      bChg = TRUE;
   }
   return bChg;
}

VOID UpdateWP( HWND hwnd )
{
   WINDOWPLACEMENT wp;
   wp.length = sizeof(WINDOWPLACEMENT);
   if( GetWindowPlacement(hwnd,&wp) )
   {
      if( ChangedWP( &wp, &g_sWP ) ) {
         memcpy( &g_sWP, &wp, sizeof(WINDOWPLACEMENT) );
         g_sWP.length = sizeof(WINDOWPLACEMENT);
         bChgWP = TRUE;
      }
   }
}

// transfer INI item (from INI file)
// to poly global items
void Post_INI_Read(void)
{
   PPolyGlobs ppg = get_poly_globs();
   if( gDoAuto )
      ppg->g_auto_zoom = 1;
   else
      ppg->g_auto_zoom = 0;

   ppg->g_map_zoom = gdZoom;

   if( giColor )
      ppg->g_paint_colors = 1;
   else
      ppg->g_paint_colors = 0;

   // { szOpt, szJoin, it_Bool,     (char *)&gbJoin,     &gbChgJoin, 0,  0 },
   if( gbJoin )
      ppg->g_join_poly_points = 1;
   else
      ppg->g_join_poly_points = 0;

   // { szOpt, szJoinLast, it_Bool, (char *)&gbJoinLast, &gbChgJoinLast, 0,  0 },
   if( gbJoinLast )
      ppg->g_join_first_to_last = 1;
   else
      ppg->g_join_first_to_last = 0;

   //    { szOpt, szNeib, it_Bool,     (char *)&gbNeib,     &gbChgNeib, 0, 0 },
   if( gbNeib )
      ppg->g_add_neighbors = 1;
   else
      ppg->g_add_neighbors = 0;

   if (gbPB)
       ppg->g_paint_buckets = 1;
   else
       ppg->g_paint_buckets = 0;
   if (gbPX)
       ppg->g_paint_X = 1;
   else
       ppg->g_paint_X = 0;
}

void toggle_bool_item( int * pItem, int * pChg, int * pParam )
{
   if( *pItem ) { // if INI is ON
      if( ! *pParam ) { // but actual parameter if OFF
         *pItem = 0;    // put INI item OFF
         *pChg = 1;     // and flag changed
      }
   } else {       // INI is OFF
      if( *pParam ) {   // but actual is ON
         *pItem = 1;    // put INI ON
         *pChg = 1;     // and flag change
      }
   }
}

// transfer from global poly options
// to INI options, ready for write
void Pre_INI_Write(void)
{
   double diff;
   PPolyGlobs ppg = get_poly_globs();
   toggle_bool_item( &gDoAuto, &gChgAut, &ppg->g_auto_zoom );
   diff = abs( gdZoom - ppg->g_map_zoom );
   if( diff > SG_EPSILON ) {
      gdZoom = ppg->g_map_zoom;
      gChgZoom = TRUE;
   }
   toggle_bool_item( &giColor, &gChgColor, &ppg->g_paint_colors );
   // { szOpt, szJoin, it_Bool,     (char *)&gbJoin,     &gbChgJoin, 0,  0 },
   toggle_bool_item( &gbJoin, &gbChgJoin, &ppg->g_join_poly_points );
   toggle_bool_item( &gbJoinLast, &gbChgJoinLast, &ppg->g_join_first_to_last );
   //{ szOpt, szNeib, it_Bool,     (char *)&gbNeib,     &gbChgNeib, 0, 0 },
   toggle_bool_item( &gbNeib, &gbChgNeib, &ppg->g_add_neighbors );

   toggle_bool_item( &gbPB, &gbChgPB, &ppg->g_paint_buckets );
   toggle_bool_item( &gbPX, &gbChgPX, &ppg->g_paint_X );

}

void ReadINI( void )
{
   PINILST  plst = &sIniLst[0];
   char *   lpb = &m_szTmpBuf[0];
   unsigned int dwt;
   char *   pSect, * pItem, * pDef;
   int *    pb, * pbd;
   int *     pi;
   int      i, icnt;
   double * pdbl;
   double   dbl;
   PRECT    pr, pr1;

   char * lpini = GetINIFile();
   icnt = 0;
   while( ( dwt = plst->i_Type ) != it_None )
   {
      pSect = plst->i_Sect;   // pointer to [section] name
      pItem = plst->i_Item;   // pointer to itme in section
      pDef  = plst->i_Deft;   // pointer to destination
      pb    = plst->i_Chg;    // pointer to CHANGE flag

      GetStg( pSect, pItem );
      if( *lpb )
      {
         switch(dwt)
         {
         case it_Version:
            if( strcmp( pDef, lpb ) )
               *pb = TRUE;
            break;
         case it_String:
            if( strcmp( pDef, lpb ) )
               strcpy( pDef, lpb );
            break;
         case it_Int:   // also doubles as a DWORD in WIN32
            pi = (int *)pDef;
            i = (int)atoi(lpb);
            *pi = i;
            break;
         case it_Double:   // floating point number
            pdbl = (double *)pDef;
            dbl = atof(lpb);
            *pdbl = dbl;
            break;
         case it_Bool:
            pbd = (int *)pDef;
            if( IsYes(lpb) )
               *pbd = TRUE;
            else if( IsNo(lpb) )
               *pbd = FALSE;
            else
               *pb = TRUE;
            break;
         case it_WinSize:     // special WINDOWPLACEMENT
            if( ( IsYes(lpb) ) &&
                ( GotWP( pSect, pDef, lpb, lpini ) ) )
            {
               // only if SAVED is yes, AND then success
               pb = (PBOOL) plst->i_Void;
               *pb = TRUE; // set that we have a (valid!) WINDOWPLACEMENT
            }
            else
               *pb = TRUE;
            break;
         case it_Rect:
            pr = (PRECT) &lpb[ lstrlen(lpb) + 2 ];
            pr->left = 0;
            pr->top = 0;
            pr->right = 0;
            pr->bottom = 0;
            if( ( m_sscanf(lpb, "%d,%d,%d,%d", &pr->left, &pr->top, &pr->right, &pr->bottom ) == 4 ) &&
                ( IsRectOk( pr ) ) )
            {
               pr1 = (PRECT)pDef;
               pr1->left = pr->left;
               pr1->top  = pr->top;
               pr1->right = pr->right;
               pr1->bottom = pr->bottom;
               pb = (PBOOL) plst->i_Void;
               if(pb)
                  *pb = TRUE;
            }
            break;
         case it_Color:
            pr = (PRECT) &lpb[ lstrlen(lpb) + 2 ];
            pr->left = 0;
            pr->top = 0;
            pr->right = 0;
            pr->bottom = 0;
            if( m_sscanf(lpb, "%d,%d,%d", &pr->left, &pr->top, &pr->right ) == 3 )
            {
               COLORREF * pcr = (COLORREF *)pDef;
               *pcr = RGB( pr->left, pr->top, pr->right );
            }
            break;
         }
      } else {
         *pb = TRUE; // parameter does not EXIST in file
         // mark it as changed
      }
      plst++;
   }
   Post_INI_Read();
}

void trim_trailing_zeros( char * lpb )
{
   int len = strlen(lpb);
   while(len--) {
      if( lpb[len] == '0' )
         lpb[len] = 0;
      else
         break;
      if(len < 2)
         break;
   }
}


#define  WI( a, b )\
   {  sprintf(lpb, "%d", b );\
      WritePrivateProfileString(pSect, a, lpb, lpini ); }

void WriteINI( void )
{
   char *   lpb   = &m_szTmpBuf[0];
   PINILST  plst  = &sIniLst[0];
   int    dwt;
   char * pSect, * pItem, * pDef;
   int     ball = *(plst->i_Chg);
   int     bchg;
   int *   pint;
   int *    pb;
   double * pdbl;
   WINDOWPLACEMENT * pwp;
   PRECT    pr;
   char *  lpini = GetINIFile();
   sprtf("Writting INI file [%s]\n", lpini);
   Pre_INI_Write();
   if( ball )
   {
      // clear down the current INI file
      while( ( dwt = plst->i_Type ) != it_None )
      {
         pSect = plst->i_Sect;
         WritePrivateProfileString( pSect,		// Section
            NULL,    // Res.Word
            NULL,    // String to write
            lpini );	// File Name
         plst++;
      }
   }
   plst = &sIniLst[0];  // start of LIST

   while( ( dwt = plst->i_Type ) != it_None )
   {
      pSect = plst->i_Sect;
      pItem = plst->i_Item;
      pDef  = plst->i_Deft;
      bchg  = *(plst->i_Chg);
      if( ball || bchg )
      {
         *lpb = 0;
         switch(dwt)
         {
         case it_Version:
            strcpy(lpb, pDef);
            break;
         case it_String:
            strcpy(lpb, pDef);
            break;
         case it_Int:
            pint = (int *)pDef;
            sprintf(lpb, "%d", *pint );
            break;
         case it_Double:   // floating point number
            pdbl = (double *)pDef;
            sprintf(lpb, "%0.12f", *pdbl);
            trim_trailing_zeros(lpb);
            break;
         case it_Bool:
            pb = (int *)pDef;
            if( *pb )
               strcpy(lpb, "Yes");
            else
               strcpy(lpb, "No");
            break;
         case it_WinSize:     // special WINDOWPLACEMENT
            pb = (PBOOL)plst->i_Void;
            pwp = (WINDOWPLACEMENT *)pDef;
            if( ( pwp->length == sizeof(WINDOWPLACEMENT) ) &&
                ( ValidShowCmd( pwp->showCmd ) ) )
            {
               WI( szShow, pwp->showCmd );
               WI( szMaxX, pwp->ptMaxPosition.x );
               WI( szMaxY, pwp->ptMaxPosition.y );
               WI( szMinX, pwp->ptMinPosition.x );
               WI( szMinY, pwp->ptMinPosition.y );
               WI( szLeft, pwp->rcNormalPosition.left );
               WI( szTop,  pwp->rcNormalPosition.top  );
               WI( szRite, pwp->rcNormalPosition.right);
               WI( szBot,  pwp->rcNormalPosition.bottom);
               strcpy(lpb, "Yes");
            }
            else
               strcpy(lpb, "No");
            break;
         case it_Rect:
            pr = (PRECT)pDef;
            sprintf(lpb, "%d,%d,%d,%d", pr->left, pr->top, pr->right, pr->bottom );
            break;
         case it_Color:
            {
               COLORREF * pcr = (COLORREF *)pDef;
               sprintf(lpb, "%d,%d,%d",
                  GetRValue(*pcr), GetGValue(*pcr), GetBValue(*pcr) );
            }
            break;
#ifdef   ADD_LINKED_LIST
         case it_SList:
            {
               PLE      plh = (PLE)pDef;
               PLE      pln;
               dwt = 0;
               Traverse_List( plh, pln )
               {
                  PFILLST pfl = (PFILLST)pln;
                  wsprintf(lpb, pItem, (dwt+1)); // build the reserved word
                  WritePrivateProfileString(
						   pSect,		// Section
						   lpb,		// Res.Word
                     &pfl->file[0],		// String to write
                     lpini );	// File Name
                  dwt++;      // bump to next LIST number

                  if( dwt >= plst->i_Res1 )  // do NOT exceed maximum
                     break;
               }
               *lpb = 0;   // ALL DONE - list is written
            }
            break;
#endif // #ifdef   ADD_LINKED_LIST
         }

         *(plst->i_Chg) = FALSE;

         if( *lpb )
         {
            WritePrivateProfileString(
						pSect,		// Section
						pItem,		// Res.Word
						lpb,		// String to write
						lpini );	// File Name
         }
      }
      plst++;
   }
}


// eof - poly-ini.cxx


