// poly-jpeg.cxx
// dump screen to JPEG file
// needs libpng.lib
#ifdef HAVE_CONFIG_H
#include "config.h"
#endif

#include <stdio.h>   // for fopen, FILE *, ...
#include <memory.h>  // for memset()
extern "C" {
#include <jpeglib.h>
}
#include "lib_sprtf.hxx"

static int jpeg_quality = 75;

int set_jpeg_quality( int val )
{
   int prev = jpeg_quality;
   jpeg_quality = val;
   return prev;
}

int write_jpeg_file( char * filename, int current_size, unsigned char * image )
{
   int   top_down = 1;
   FILE *fp = fopen(filename, "wb");
   if (!fp) {
      sprtf("ERROR: wrint_png_file: can't create '%s'!\n", filename);
      return 0;
   }

   jpeg_compress_struct cinfo;
   memset( &cinfo, 0, sizeof cinfo );

   jpeg_error_mgr jerr;
   memset( &jerr, 0, sizeof jerr );
   cinfo.err = jpeg_std_error( &jerr );

   jpeg_create_compress( &cinfo );
   jpeg_stdio_dest( &cinfo, fp );

   cinfo.image_width = current_size;
   cinfo.image_height = current_size;
   cinfo.input_components = 3;
   cinfo.in_color_space = JCS_RGB;

   jpeg_set_defaults(&cinfo);
   jpeg_set_quality(&cinfo,jpeg_quality,false);

   jpeg_start_compress( &cinfo, TRUE );

   while ( cinfo.next_scanline < cinfo.image_height ) {
      unsigned char *buf;
      if ( top_down ) {
         buf = (unsigned char *)&image[ current_size * ( current_size - ( cinfo.next_scanline + 1 ) ) * 3 ];
      } else {
         buf = (unsigned char *)&image[ current_size * cinfo.next_scanline * 3 ];
      }
      jpeg_write_scanlines( &cinfo, (JSAMPARRAY)&buf, 1 );
      
   }

   jpeg_finish_compress( &cinfo );
   jpeg_destroy_compress( &cinfo );
   return 1;
}

// eof - poly-jpeg.cxx
