// poly-load.hxx
#ifndef _poly_load_hxx_
#define _poly_load_hxx_

#include "load-poly.hxx"

#define DEFAULT_ZOOM        0.00003
#define DEFAULT_ZOOM_CHANGE 5E-07;

typedef struct tagDRECT {
   double left;
   double right;
   double top;
   double bottom;
}DRECT, * PDRECT;

// global items
typedef struct tagPolyGlobs {
    int g_verbosity;
   double g_set_c_lon, g_set_c_lat; // center of this set of polys
   double g_c_lon, g_c_lat;   // current active center of display
   double g_map_size;         // map size = size of current window
   double g_map_zoom;         // current zoom factor
   double g_prev_map_zoom;   // for a 'revert'
   double g_prev_c_lon, g_prev_c_lat;  // 'r' key
   double g_zoom_change;
   double g_offset_lon;       // any offset applied to lon
   double g_offset_lat;       // any offset applied to lat;
   int g_pixel_move_x;          // 1 or more
   int g_pixel_move_y;          // 1 or more
   double g_offset_change_x;    // = 0.1, or to achieve above
   double g_offset_change_y;    // = 0.1; pixel move
   double g_min_lon, g_max_lon, g_min_lat, g_max_lat;
   double g_xdist, g_ydist;   // width and height of load
   int g_auto_zoom;           // adjust zoom value so range will fill screen
   int g_join_poly_points, g_join_first_to_last;
   int g_paint_fit_points; // --[enable|disable]-paint-fit-points
   int g_fit_point_count;
   int g_paint_fit_tris;   // --[enable|diable\-paint-fit-tris = g_paint_fit_tris
   int g_fit_tris_count;   // count of fit tris to paint
   int g_paint_bounding_box;  // paint_bounding_box( hdc, &mm ); can overwrite points!
   int g_paint_airports;      // only 1 or 2 selected - could load apt.dat...
   int g_paint_colors;        // use a set of colors
   int g_fill_polygon;        // 'f' toggle
   int g_fill_scene;       // 'F' toggle
   DRECT g_drc_work;         // a sort of inner work rect - leave out top/bot 2 lines, etc
   int g_got_fg_scenery;      // --fg-scenery=<path> is valid
   int g_use_fg_scenery;    // path valid, and no --disable-scenery
   int g_enable_scenery;    // no --disable-scenery-paint
   int g_enable_scenery_wsg84;  // --enable-scenery-wsg84
   int g_enable_scenery_normals;  // --enable-scenery-normals
   string g_fg_scenery;       // and the PATH
   int g_show_point_paint;
   int g_page_key_steps;      // number of steps per PAGE UP or DOWN keys
   int g_add_neighbors;    // if load scenery, load neighboring buckets
   int g_user_center;   // user set center from command line
   int g_paint_X;       // paint a BIG X for each point
   int g_fixed_spread;  // if paint X, and this has value, use this
   int g_var_line_size; // vary the line size when joining lines
   int g_paint_buckets; // paint the Buckets
   int g_bucket_count; // number of buckets in current scene
}PolyGlobs, * PPolyGlobs;

extern double get_g_center_lon( void );   //  { return get_poly_globs()->g_c_lon; }
extern double get_g_center_lat( void );   //  { return get_poly_globs()->g_c_lat; }
extern void get_g_center( double * plon, double * plat );
extern int get_g_user_center(void); // { return get_poly_globs()->g_user_center; }

extern void init_poly_load(void);   // initial setup
extern PPolyGlobs get_poly_globs(void);   // { return &polyglobs; }
extern void delete_loaded_poly( void );
extern TGPolyLoad * get_new_loaded_poly( void ); // create new poly, and set as 'active'

extern PPolyCounter Get_Poly_Counts( void );
extern PPolyCounter Set_Poly_Counts( TGPolyLoad * ppl );
// iterate through the points collected/loaded
typedef struct tagsGETPT {
   double * px;
   double * py;
   int * pcnum;
}sGETPT, * PsGETPT;

extern void * get_first_point( PsGETPT psgp );
extern void * get_next_point( void * vp, PsGETPT psgp );

// for painting polys...
extern int get_loaded_poly_count( void ); // { return loaded_polys.size(); }
extern int get_poly_enabled_count(void); // number of polys ENABLED
extern TGPolyLoad * get_first_loaded_poly( void );
extern TGPolyLoad * get_next_loaded_poly( void );
extern int is_poly_enabled( int num );
extern int is_current_poly_enabled( void );
extern void toggle_poly_enabled( int num );

// adjusting map
extern void Increment_ZOOM( void );
extern void Decement_ZOOM( void );
extern void Restore_ZOOM( void );
extern void Restore_Previous( void );
extern void calculate_scroll_sizes( void );  // done after each ZOOM action
// or when the set_ center changes
extern void set_g_center_lon_lat( double lon, double lat );
extern void set_user_center_lon_lat( double lon, double lat );

extern double get_g_map_size( void );  //    { return g_map_size; }
extern double set_g_map_size( double size );  //    { return g_map_size; }
extern double get_g_map_zoom( void );  //    { return g_map_zoom; }
extern double set_g_map_zoom( double zoom ); // and return previous
extern double get_g_zoom_change( void );  // { return zoom_change; }
extern void toggle_join_points(void);
extern void toggle_join_first_to_last(void);
extern void toggle_scenery_paint(void);

extern void toggle_fill_poly(void);
extern void toggle_fill_poly2(void);
extern void toggle_paint_x(void);
extern void toggle_paint_fit_points(void); // { toggle_int( &get_poly_globs()->g_paint_fit_points ); }
extern void toggle_paint_fit_tris(void); // { toggle_int( &get_poly_globs()->g_paint_fit_tris ); }

extern void increase_lon_offset( void );
extern void increase_lat_offset( void );
extern void decrease_lon_offset( void );
extern void decrease_lat_offset( void );
extern void reset_lat_lon_offset( void );

// some macros
#define  mm_c_lat    get_g_center_lat()
#define  mm_c_lon    get_g_center_lon()
#define  mm_map_size get_g_map_size()
#define  mm_map_zoom get_g_map_zoom()
#define  mm_pt2ll(plat,plon,ix,iy)    win_pt2ll( plat, plon, mm_c_lat, mm_c_lon, mm_map_size, mm_map_zoom, (double)ix, (double)iy )

#define VERB1   (get_poly_globs()->g_verbosity > 0)
#define VERB2   (get_poly_globs()->g_verbosity > 1)
#define VERB3   (get_poly_globs()->g_verbosity > 2)
#define VERB4   (get_poly_globs()->g_verbosity > 3)
#define VERB5   (get_poly_globs()->g_verbosity > 4)
#define VERB9   (get_poly_globs()->g_verbosity > 8)

#endif //ifndef _poly_load_hxx_
// eof - poly-load.hxx

