// poly-memory.cxx
#ifdef HAVE_CONFIG_H
#include <config.h>
#endif
#ifdef _MSC_VER
#include <windows.h>
#include <psapi.h>
#include "poly-text.hxx"
#include "poly-utils.hxx"  // for win_int() macro
#include "lib_sprtf.hxx"

extern int g_in_exit_process;

/* ------------------------------------------------
typedef struct _PROCESS_MEMORY_COUNTERS {
   DWORD cb;
   DWORD PageFaultCount;
   SIZE_T PeakWorkingSetSize;
   SIZE_T WorkingSetSize;
   SIZE_T QuotaPeakPagedPoolUsage;
   SIZE_T QuotaPagedPoolUsage;
   SIZE_T QuotaPeakNonPagedPoolUsage;
   SIZE_T QuotaNonPagedPoolUsage;
   SIZE_T PagefileUsage;
   SIZE_T PeakPagefileUsage;
} PROCESS_MEMORY_COUNTERS, *PPROCESS_MEMORY_COUNTERS;

typedef struct _PROCESS_MEMORY_COUNTERS_EX {
   DWORD cb;
   DWORD PageFaultCount;
   SIZE_T PeakWorkingSetSize;
   SIZE_T WorkingSetSize;
   SIZE_T QuotaPeakPagedPoolUsage;
   SIZE_T QuotaPagedPoolUsage;
   SIZE_T QuotaPeakNonPagedPoolUsage;
   SIZE_T QuotaNonPagedPoolUsage;
   SIZE_T PagefileUsage;
   SIZE_T PeakPagefileUsage;
   SIZE_T PrivateUsage;
} PROCESS_MEMORY_COUNTERS_EX, *PPROCESS_MEMORY_COUNTERS_EX;
--------------------------------------------------- */

static PROCESS_MEMORY_COUNTERS pmc, pmc_one;
static char _s_tmp_membuf[1024];
static int done_first_memory = 0;

void show_memory_usage( void )
{
   char * ps = _s_tmp_membuf;
   DWORD cb = sizeof(pmc);
   ZeroMemory( &pmc, cb );
   pmc.cb = cb;
   if( GetProcessMemoryInfo(
      GetCurrentProcess(), // GetCurrentProcessId(), // HANDLE Process,
      &pmc, // PPROCESS_MEMORY_COUNTERS ppsmemCounters,
      cb ) ) // DWORD cb
   {
      if( done_first_memory ) {
         int diff1 = win_int(((double)(pmc.PeakWorkingSetSize - pmc_one.PeakWorkingSetSize) /
            (double)pmc_one.PeakWorkingSetSize) * 100.0);
         int diff2 = win_int(((double)(pmc.QuotaPeakPagedPoolUsage - pmc_one.QuotaPeakPagedPoolUsage) /
            (double)pmc_one.QuotaPeakPagedPoolUsage) * 100.0);
         int diff3 = win_int(((double)(pmc.QuotaPeakNonPagedPoolUsage - pmc_one.QuotaPeakNonPagedPoolUsage) /
            (double)pmc_one.QuotaPeakNonPagedPoolUsage) * 100.0);
         int diff4 = win_int(((double)(pmc.PeakPagefileUsage - pmc_one.PeakPagefileUsage) /
            (double)pmc_one.PeakPagefileUsage) * 100.0);
         sprintf( ps, "Memory: wss=%10d(%2d) qpppu=%7d(%2d) qpnppu=%5d(%2d) ppfu=%10d(%2d)",
            pmc.PeakWorkingSetSize, diff1,
            pmc.QuotaPeakPagedPoolUsage, diff2,
            pmc.QuotaPeakNonPagedPoolUsage, diff3,
            pmc.PeakPagefileUsage, diff4 );

      } else {
         sprintf( ps, "Memory: wss=%10d(--) qpppu=%7d(--) qpnppu=%5d(--) ppfu=%10d(--)",
            pmc.PeakWorkingSetSize,
            pmc.QuotaPeakPagedPoolUsage,
            pmc.QuotaPeakNonPagedPoolUsage,
            pmc.PeakPagefileUsage );
         memcpy( &pmc_one, &pmc, cb );
         done_first_memory = 1;
      }
      if(g_in_exit_process)
         sprtf("%s\n", ps);
      else
         paint_next_line_text(ps);
   }
}
#else
void show_memory_usage( void ) { }
#endif // #ifdef _MSC_VER y/n

// eof - poly-memory.cxx

