// poly-menu.cxx
// handle WM_INITMENUPOPUP - add current context

#include "poly-view.hxx"
#include "poly-menu.hxx"
#include "poly-load.hxx"    // for PPolyGlobs

#define  MENU_FILE      0
#define  MENU_VIEW      1
#define  MENU_ABOUT     2

#define  mf_Enab     (MF_BYCOMMAND | MF_ENABLED)
#define  mf_Disab    (MF_BYCOMMAND | MF_DISABLED | MF_GRAYED)
#define  EMI(a,b) EnableMenuItem(hMenu, a, ((b) ? mf_Enab : mf_Disab))
#define  CMI(a,b) CheckMenuItem(hMenu,  a, ((b) ? MF_CHECKED : MF_UNCHECKED) )

// menu initialisation
long  Do_WM_INITMENUPOPUP( HWND hWnd, WPARAM wParam, LPARAM lParam )
{
    long lRet = 0;
    HMENU    hMenu = (HMENU)wParam;
    DWORD    dwPos = LOWORD(lParam);
    BOOL     bSys  = HIWORD(lParam);
   if( bSys ) {
      // is the windows (system) menu
      lRet = 1;   // use default processing
   } else {
       PPolyGlobs ppg = get_poly_globs();
       switch( dwPos )
       {
       case MENU_FILE:
           // nothing here
           break;
       case MENU_VIEW:
           CMI( IDM_FILL_POLY, ppg->g_fill_polygon );
           CMI( IDM_FILL_SCENE, ppg->g_fill_scene  );
           CMI( IDM_PAINT_X, ppg->g_paint_X );
           if (ppg->g_fit_point_count)
               CMI( IDM_PAINT_FIT_POINTS, ppg->g_paint_fit_points );
           else
               EMI( IDM_PAINT_FIT_POINTS, FALSE );
           if (ppg->g_fit_tris_count)
               CMI( IDM_PAINT_FIT_TRIS, ppg->g_paint_fit_tris );
           else
               EMI( IDM_PAINT_FIT_TRIS, FALSE );
           if (ppg->g_bucket_count > 1)
               CMI( IDM_PAINT_BUCKETS, ppg->g_paint_buckets );
           else
               EMI( IDM_PAINT_BUCKETS, FALSE );

           break;
       }
   }
   return lRet;
}

// eof - poly-menu.cxx
