// poly-paint.cxx
// WIN32 paint module
#ifdef HAVE_CONFIG_H
#include "config.h"
#endif
#include "poly-view.hxx"
#include "poly-utils.hxx"
#include "load-poly.hxx"
#include "poly-load.hxx"
#include "poly-help.hxx"
#include "poly-paint.hxx"
#include "poly-paint2.hxx"
#include "poly-ptools.hxx"
#include "load-scene.hxx"
#include "poly-grid.hxx"
#include "poly-pmacs.hxx"  // some paint macros
#include "poly-outGL.hxx"  // paint polys and points
#include "poly-text.hxx"    // handles TEXT to screen

extern HWND g_hWnd;

// forward reference
void paint_line_text_to_DC( HDC hdc, char * ps, int line );
void re_paint_lines_to_DC( HDC hdc );

#define RC_TOP_LEFT     0
#define RC_TOP_RIGHT    1
#define RC_BOTTOM_RIGHT 2
#define RC_BOTTOM_LEFT  3
#define RC_CENTER_SPACE 4
#define RC_MAX_RECTS    5
RECT g_rcCornerPaints[RC_MAX_RECTS];  // 4 corners + 1 inner + ???

PRECT get_corner_rect(void) { return &g_rcCornerPaints[0]; }

int had_scenery_paint = 0; // only after first POLY paint
// double g_map_size = 600.0;
int add_last_join = 0;

int paint_all_points = 1;  // this seems best, but NOT for polygon fill!

static char _s_tmpbuf[1024];
int ap_line_len = 30;

vec_pp paintPoints;
vec_pt painted_points;
#define  sprtf_clear_pts

void clear_painted_points(void) {
   size_t sz = painted_points.size();
   painted_points.clear();
   if(sz)
      sprtf_clear_pts( "Cleared painted_points of %d pts. (%d)\n", sz, painted_points.size() );
}

void clear_paintPoints(void) 
{
   size_t sz = paintPoints.size();
   paintPoints.clear();
   if(sz)
      sprtf_clear_pts( "CLEAR: paintPoints of %d pts. (%d)\n", sz, paintPoints.size() );
}

void add_painted_point( int x, int y, double lon, double lat )
{
   POINT p;
   PP pp;
   p.x = x; p.y = y;
   pp.pt.x = x; pp.pt.y = y; pp.lat = lat; pp.lon = lon;
   painted_points.push_back(p);
   paintPoints.push_back(pp);
}

void draw_line( HDC hdc, int x1, int y1, int x2, int y2 )
{
   MoveToEx( hdc, x1, y1, NULL ); // start
   LineTo( hdc, x2, y2 ); // to center bottom
}

void paint_pixel_X( HDC hdc, int x, int y, COLORREF cr, int spread )
{
   if( spread < 1 ) {
      SetPixel( hdc, x, y, cr ); // paint the POINT
   } else { // if (spread == 1) {   // 20091210 - NOTE: LineTo stop before last point! So
      draw_line(hdc, x - spread, y - spread, x + spread + 1, y + spread + 1);
      draw_line(hdc, x - spread, y + spread, x + spread + 1, y - spread - 1);
      //draw_line(hdc, x - spread, y - spread, x + spread, y + spread);
      //draw_line(hdc, x - spread, y + spread, x + spread, y - spread);
   }
}

void paint_gray_line( HDC hdc, int x1, int y1, int x2, int y2 )
{
   HPEN hp = Get_GRAY_Pen_1();  // paint_gray_line:
   HPEN hpOld;
   if(hp)
      hpOld = (HPEN)SelectObject(hdc,hp);
   draw_line( hdc, x1, y1, x2, y2 );
   if(hp)
      hpOld = (HPEN)SelectObject(hdc,hpOld);
}

#ifdef NDEBUG
#define get_ll2pt win_ll2pt
#else
void get_ll2pt( double obj_latr, double obj_lonr,
           double cent_latr, double cent_lonr,
           double map_size,  double map_zoom,
           double * px_pixel, double * py_pixel )
{
   win_ll2pt( obj_latr, obj_lonr,
      cent_latr, cent_lonr,
      map_size,  map_zoom,
      px_pixel, py_pixel );
   sprtf( "ll2pt: lon,lat %0.6f,%0.6f = x,y %0.2f,%0.2f (%d,%d)\n",
      obj_lonr, obj_latr, *px_pixel, *py_pixel, win_int(*px_pixel), win_int(*py_pixel) );
}
#endif

void paint_bounding_box( HDC hdc, PRECT pmm )
{
   HPEN hp = Get_BOX_Pen();
   HPEN hpOld;

   if(hp)
      hpOld = (HPEN)SelectObject(hdc,hp);

   // top line
   draw_line( hdc, pmm->left, pmm->top, pmm->right, pmm->top );
   // right side
   draw_line( hdc, pmm->right, pmm->top, pmm->right, pmm->bottom );
   // bottom side
   draw_line( hdc, pmm->left, pmm->bottom, pmm->right, pmm->bottom );
   // left side
   draw_line( hdc, pmm->left, pmm->top, pmm->left, pmm->bottom );

   if(hp)
      hpOld = (HPEN)SelectObject(hdc,hpOld);
}

int   def_x_size = 4;

void paint_x( HDC hdc, int x, int y, COLORREF cr )
{
   int   ltx, lty;
   int   rbx, rby;
   int   lbx, lby;
   int   rtx, rty;

   ltx = x - def_x_size;
   lty = y - def_x_size;
   rbx = x + def_x_size;
   rby = y + def_x_size;

   lbx = ltx;
   lby = rby;
   rtx = rbx;
   rty = lty; 

   HPEN hp = Get_Solid_Pen_1(cr);   // paint_x:
   HPEN hpOld;
   if(hp)
      hpOld = (HPEN)SelectObject(hdc,hp);

   draw_line( hdc, ltx, lty, rbx, rby );
   draw_line( hdc, lbx, lby, rtx, rty );

   if(hp) {
      hpOld = (HPEN)SelectObject(hdc,hpOld);
      DeleteObject(hp);
   }
}

void paint_sydney_YSSY( HDC hdc, double c_lat, double c_lon,
                       double map_size, double map_zoom,
                       PRECT prc)
{
   // paint Sydney marker, if on MAP
   double dlat = -33.9433920625;
   double dlon = 151.179773052083;
   double rdx, rdy;
   int   x, y;
   SIZE  sz;
   win_ll2pt( dlat, dlon, c_lat, c_lon, map_size, map_zoom, &rdx, &rdy );
   x = win_int(rdx);
   y = win_int(rdy);
   if (( x > prc->left ) && ( x < prc->right ) &&
       ( y > prc->top ) && ( y < prc->bottom ) ) {
      get_CN8_Text_Size( hdc, &sz );
      paint_x( hdc, x, y, RGB(0,255,0) );
      int x2 = x + ap_line_len;
      int y2 = y;
      paint_gray_line( hdc, x, y, x2, y2 );
      y2 -= (sz.cy / 2);
      paint_std_text( hdc, x2, y2, "YSSY" );
   }
}

// YWLM Williamtown (-32.7953080294118,151.842202705882) tile=e150s30
void paint_sydney_YWLM( HDC hdc, double c_lat, double c_lon,
                       double map_size, double map_zoom,
                       PRECT prc)
{
   // paint Newcastle (Williamtown) marker, if on MAP
   double dlat = -32.7953080294118;
   double dlon = 151.842202705882;
   double rdx, rdy;
   int   x, y;
   SIZE sz;
   win_ll2pt( dlat, dlon, c_lat, c_lon, map_size, map_zoom, &rdx, &rdy );
   x = win_int(rdx);
   y = win_int(rdy);
   if (( x > prc->left ) && ( x < prc->right ) &&
       ( y > prc->top ) && ( y < prc->bottom ) ) {
      get_CN8_Text_Size( hdc, &sz );
      paint_x( hdc, x, y, RGB(0,255,0) );
      int x2 = x + ap_line_len;
      int y2 = y + ap_line_len;
      paint_gray_line( hdc, x, y, x2, y2 );
      y2 -= (sz.cy / 2);
      paint_std_text( hdc, x2, y2, "YWLM" );
   }
}

void paint_airports( HDC hdc, double c_lat, double c_lon,
                       double map_size, double map_zoom,
                       PRECT prc)
{
   paint_sydney_YWLM( hdc, c_lat, c_lon, map_size, map_zoom, prc );
   paint_sydney_YSSY( hdc, c_lat, c_lon, map_size, map_zoom, prc );
}

#define add_normals_direct pps->ppg->g_enable_scenery_normals
#define add_wsg84_direct pps->ppg->g_enable_scenery_wsg84

void paint_scenery( HDC hdc_in )
{
    size_t tot = 0;
   PPPSET pps = get_act_paint_set();
   if (! pps->ppg->g_enable_scenery )
       return;  // all done
   pps->hdc = hdc_in;
   vec_pt3d * pts = get_first_wgs84_nodes();
   //double dlat, dlon, dx, dy;
   //int x, y, first_x, first_y, cnt, last_x, last_y;
   pps->cr = Get_LBrown_Color();
   HPEN hp = Get_LBrown_Pen_1();  // paint_scenery:
   HPEN hpOld;
   paint_GL_polys( pps->hdc );
   if(pts && add_wsg84_direct) {
       tot += pts->size();
       sprtf("paint_scenery: wsg84 points %u\n", pts->size());
      if(hp)
         hpOld = (HPEN)SelectObject(pps->hdc,hp);
      do {
         clear_painted_points();
         pps->cnt = 0;
         for( iter_pt3d it = pts->begin(); it != pts->end(); it++ ) {
            Point3D pt = *it;
            paint_a_point(pt);  // paint_scenery: wsg84 points
         }
      } while((pts = get_next_wgs84_nodes()) != NULL );

      if(hp)
         SelectObject(pps->hdc,hpOld);
   }

   pps->cr = Get_LGreen_Color();
   hp = Get_LGreen_Pen();
   pts = get_first_normal_nodes();
   if(pts && add_normals_direct) {
       tot += pts->size();
       sprtf("paint_scenery: normals points %u\n", pts->size());
      if(hp)
         hpOld = (HPEN)SelectObject(pps->hdc,hp);
      do {
         clear_painted_points();
         pps->cnt = 0;
         for( iter_pt3d it = pts->begin(); it != pts->end(); it++ ) {
            Point3D pt = *it;
            paint_a_point(pt);  // paint_scenery: normals
         }
      } while((pts = get_next_normal_nodes()) != NULL );

      if(hp)
         SelectObject(pps->hdc,hpOld);
   }
   sprtf("Done paint_scenery: painted %d %s! add wgs = %s, norms = %s\n",
       tot,
       (tot ? "points" : "nothing" ),
       (add_wsg84_direct ? "On" : "Off"),
       (add_normals_direct ? "On" : "Off") );
}


// ******************************************************************

//	SetBkColor(crOldBack);
//	oldcr = SetTextColor(hdc, cr);
//double xdist = ppc->pdist.lon();
//double ydist = ppc->pdist.lat();
//min_lat = ppc->pmin.lat();
//min_lon = ppc->pmin.lon();
//max_lat = ppc->pmax.lat();
//max_lon = ppc->pmax.lon();
// **********************************************************
// main paint service
// **********************************************************
void fill_polygon( HDC hdc, PRECT prc )
{
   HBRUSH hb = get_act_brush();
   fill_polygon_with_brush( hdc, prc, hb );
}

// **************************************************************************
#define IN_SCREEN_RANGE(x,y,r) (( x >= r.left ) && \
   ( x <= r.right ) && ( y >= r.top ) && ( y <= r.bottom))

//#define P_IN_SCREEN_RANGE(x,y,r) (( x >= r->left ) && \
//   ( x <= r->right ) && ( y >= r->top ) && ( y <= r->bottom))


#define  VALID_FIRST_LAST  ((first_x != -1)&& \
   (last_x  != -1)&& \
   (last_y  != -1)&& \
   (first_y != -1)&& \
   !((first_x == last_x)&&(first_y == last_y)) )

//#define  P_VALID_FIRST_LAST  ((pps->first_x != -1)&& \
//   (pps->last_x  != -1)&& \
//   (pps->last_y  != -1)&& \
//   (pps->first_y != -1)&& \
//   !((pps->first_x == pps->last_x)&&(pps->first_y == pps->last_y)) )

int first_last_all_in_range(PPPSET pps)
{
   if( P_VALID_FIRST_LAST &&
      (paint_all_points ||
      (P_IN_SCREEN_RANGE(pps->last_x,pps->last_y,pps->prc) &&
       P_IN_SCREEN_RANGE(pps->first_x,pps->first_y,pps->prc) ) ) )
       return 1;

   return 0;
}

// ===========================================================================
// eof - poly-paint.cxx
