// poly-paint.hxx
#ifndef _poly_paint_hxx_
#define _poly_paint_hxx_

#ifdef HAVE_CONFIG_H
#include <config.h>
#endif
#include <simgear/compiler.h>

#include <iostream>
#include <string>
#include <vector>

#include <plib/sg.h>

#include <simgear/constants.h>
#include <simgear/bucket/newbucket.hxx>
#include <simgear/debug/logstream.hxx>
#include <simgear/math/polar3d.hxx>

#include <Geometry/poly_support.hxx>
#include <Array/array.hxx>
#include <Clipper/clipper.hxx>
#include <GenOutput/genobj.hxx>
#include <Match/match.hxx>
#include <Triangulate/triangle.hxx>
#include <landcover/landcover.hxx>
#include <Osgb36/osgb36.hxx>
#include <sstream>   // for ostringstream

using std::ostringstream;

#include "load-poly.hxx"
#include "poly-paint2.hxx"

#define RC_TOP_LEFT     0
#define RC_TOP_RIGHT    1
#define RC_BOTTOM_RIGHT 2
#define RC_BOTTOM_LEFT  3
#define RC_CENTER_SPACE 4
#define RC_MAX_RECTS    5
// RECT g_rcCornerPaints[RC_MAX_RECTS];  // 4 corners + 1 inner + ???
extern PRECT get_corner_rect(void);

extern void paint_polys(void);

extern void paint_pixel_X( HDC hdc, int x, int y, COLORREF cr, int spread );
extern void add_painted_point( int x, int y, double lon, double lat );
extern void draw_line( HDC hdc, int x1, int y1, int x2, int y2 );
extern void clear_painted_points(void);
extern void clear_paintPoints(void);

extern int first_last_all_in_range(PPPSET pps);

extern int had_scenery_paint; // only after first POLY paint


#endif // #ifndef _poly_paint_hxx_
// eof - poly-paint.hxx
