// poly-paint2.hxx
#ifndef _poly_paint2_hxx_
#define _poly_paint2_hxx_
#include "poly-load.hxx"   // global

typedef struct tagPPSET {
   int done_init;
   HDC hdc;
   double c_lon;
   double c_lat;
   double map_size;
   double map_zoom;
   PRECT prc;
   double dlat, dlon, dx, dy;
   COLORREF cr;
   int   spread_x, pen_size;
   int x, y, first_x, first_y, cnt, last_x, last_y;
   PPolyGlobs ppg; // pointer to some globals
   RECT mm;
   HPEN  hp, hpOld;
   HBRUSH hb, hbOld;
   double ps_min_slat, ps_max_slat, ps_min_slon, ps_max_slon;
   double ps_max_north, ps_max_south, ps_max_west, ps_max_east;
}PPSET, * PPPSET;


#define min_slat pps->ps_min_slat
#define max_slat pps->ps_max_slat
#define min_slon pps->ps_min_slon
#define max_slon pps->ps_max_slon
#define max_north pps->ps_max_north
#define max_south pps->ps_max_south
#define max_west  pps->ps_max_west
#define max_east  pps->ps_max_east

// flags for PNTOBJ
#define PO_FILL      1
#define PO_JOIN      2
#define PO_WPEN      4
#define PO_WBRUSH    8

#define PO_DEBUG     0x8000000   // LAST BIT

#define PO_ALL (PO_FILL|PO_JOIN|PO_WPEN|PO_WBRUSH)

typedef struct tagPNTOBJ {
   int type;
   COLORREF cr;
   unsigned int flag;
   int save_dbg;
   vector<Point3D> v_pts;
}PNTOBJ, * PPNTOBJ;

typedef struct tagPP {
   POINT pt;
   double lat,lon;
}PP, *PPP;
typedef vector<PP>   vec_pp;
typedef vector<POINT>   vec_pt;

extern vec_pp paintPoints;
extern vec_pt painted_points;

extern void obj_glBegin_paint( PPNTOBJ ppo );
extern void obj_glEnd_paint( PPNTOBJ ppo );
extern void paint_a_point( Point3D & pt );
extern void paint_GL_point( Point3D & pt );
extern PPPSET get_act_paint_set(void);
extern PPPSET init_act_paint_set( void );
extern PPNTOBJ get_act_paint_obj(void);

extern void fill_polygon_with_brush( HDC hdc, PRECT prc, HBRUSH hb );


#endif // #ifndef _poly_paint2_hxx_
// eof - poly-paint2.hxx
