// poly-png.cxx
// dump screen to PNG file
// needs libpng.lib
#ifdef HAVE_CONFIG_H
#include "config.h"
#endif

#include <png.h>
#include "lib_sprtf.hxx"
#include "poly-png.hxx"

int write_png_file( char * filename, int current_size, unsigned char * image )
{
   FILE *fp = fopen(filename, "wb");
   if (!fp) {
      sprtf("ERROR: write_png_file: can't create '%s'!\n", filename);
      return 0;
  }

  png_structp png_ptr = 
     png_create_write_struct(PNG_LIBPNG_VER_STRING, NULL, NULL, NULL);
  if (!png_ptr) {
      sprtf("ERROR: write_png_file: failed create write struct!\n");
     fclose(fp);
     return 0;
  }
  png_infop info_ptr = png_create_info_struct(png_ptr);
  if (!info_ptr) {
     sprtf("ERROR: write_png_file: failed create info struct!\n");
     png_destroy_write_struct(&png_ptr,(png_infopp)NULL);
     fclose(fp);
     return 0;
  }

  if (setjmp(png_ptr->jmpbuf)) {
     sprtf("ERROR: write_png_file: failed setfmp()!\n");
     png_destroy_write_struct(&png_ptr, &info_ptr);
     fclose(fp);
     return 0;
  }

  png_init_io(png_ptr, fp);
  png_set_IHDR(png_ptr, info_ptr, current_size, current_size, 8, PNG_COLOR_TYPE_RGB,
		 PNG_INTERLACE_NONE, PNG_COMPRESSION_TYPE_DEFAULT,
		 PNG_FILTER_TYPE_DEFAULT);

  png_write_info(png_ptr, info_ptr);

  png_byte **row_pointers = new png_byte*[current_size];
  if (!row_pointers) {
     sprtf("ERROR: write_png_file: memory FAILED %d bytes!\n", (sizeof(png_byte *)*current_size));
     return 0;
  }

  // setup the pointers
  for (int i = 1; i <= current_size; i++) {
     row_pointers[i-1] = (png_byte*)(image + current_size * (current_size-i) * 3);
  }

  // actually write the image
  png_write_image(png_ptr, row_pointers);

  // done with row pointers
  delete[] row_pointers;   

  // finish the file
  png_write_end(png_ptr, info_ptr);

  // clean up the structures
  png_destroy_write_struct(&png_ptr, &info_ptr);

  fclose(fp);

  sprtf("Written '%s', width,height = %d\n", filename, current_size);

  return 1;
}

int write_png_file2( char * filename, int width, int height, unsigned char * image )
{
   FILE *fp = fopen(filename, "wb");
   if (!fp) {
      sprtf("ERROR: write_png_file: can't create '%s'!\n", filename);
      return 0;
  }

  png_structp png_ptr = 
     png_create_write_struct(PNG_LIBPNG_VER_STRING, NULL, NULL, NULL);
  if (!png_ptr) {
      sprtf("ERROR: write_png_file: failed create write struct!\n");
     fclose(fp);
     return 0;
  }
  png_infop info_ptr = png_create_info_struct(png_ptr);
  if (!info_ptr) {
     sprtf("ERROR: write_png_file: failed create info struct!\n");
     png_destroy_write_struct(&png_ptr,(png_infopp)NULL);
     fclose(fp);
     return 0;
  }

  if (setjmp(png_ptr->jmpbuf)) {
     sprtf("ERROR: write_png_file: failed setfmp()!\n");
     png_destroy_write_struct(&png_ptr, &info_ptr);
     fclose(fp);
     return 0;
  }

  png_init_io(png_ptr, fp);
  png_set_IHDR(png_ptr, info_ptr, width, height, 8, PNG_COLOR_TYPE_RGB,
		 PNG_INTERLACE_NONE, PNG_COMPRESSION_TYPE_DEFAULT,
		 PNG_FILTER_TYPE_DEFAULT);

  png_write_info(png_ptr, info_ptr);

  png_byte **row_pointers = new png_byte*[height];
  if (!row_pointers) {
     sprtf("ERROR: write_png_file: memory FAILED %d bytes!\n", (sizeof(png_byte *)*height));
     return 0;
  }

  // setup the pointers
  for (int i = 1; i <= height; i++) {
     row_pointers[i-1] = (png_byte*)(image + (width * (height - i ) * 3));
  }

  // actually write the image
  png_write_image(png_ptr, row_pointers);

  // done with row pointers
  delete[] row_pointers;   

  // finish the file
  png_write_end(png_ptr, info_ptr);

  // clean up the structures
  png_destroy_write_struct(&png_ptr, &info_ptr);

  fclose(fp);

  sprtf("Written '%s', width=%d, height=%d\n", filename, width, height);

  return 1;
}

// eof - poly-png.cxx


