// poly-test.cxx
// text painting

#include "poly-view.hxx"
#include "poly-text.hxx"
#include "poly-paint.hxx"   // get_corner_rect(), int had_scenery_paint
#include "poly-ptools.hxx"  // get_CN8_FOnt(...)
#include "poly-utils.hxx"   // GetNxtBuf();
// forward references
void paint_center_bottom_to_DC( HDC hdc, char * ps );

static char _last_c_text[1024] = "\0";
static char _s_center_bottom_text[256] = "\0";

void paint_text_to_hdc( HDC hdc, char * ps, PRECT prc, char * pc )
{
   int   format = DT_CENTER | DT_SINGLELINE | DT_NOCLIP; // | DT_VCENTER;
   PRECT prcp = get_corner_rect(); // stored corner paints
   HFONT hf = Get_CN8_Font(hdc);
   HFONT hfOld;
   int plen = 0;
   int len  = strlen(ps);  // length of new

   if(pc)
      plen = strlen(pc);  // length of old, fi given, and if any

   if(hf)
      hfOld = (HFONT)SelectObject(hdc, hf);

   // remove any LAST text there
   if ( plen && (plen > len)) {
      for(int i = 0; i < plen; i++)
         pc[i] = ' '; // space it out
      // and use it to clear the area before next text
      DrawText( hdc, pc, plen, prc, format );
   }

   DrawText( hdc, // handle to DC
      ps,         // text to draw
      len,        // text length
      prc,        // formatting dimensions
      format );   // text-drawing options

   if(hf)
      hfOld = (HFONT)SelectObject(hdc, hfOld);

   if(pc)
      strcpy( pc, ps );

}

PRECT get_client_prec( void ) { return &g_rcClient; }

static char _s_previous_color_text[32] = "\0";
void paint_color_to_hdc( HDC hdc, COLORREF cr)
{
   char * cp = GetNxtBuf();
   char * pc = _s_previous_color_text;
   SIZE sz;
   PRECT prc = get_client_prec();
   RECT  rc;
   int len = sprintf(cp, "RGB(%d,%d,%d)", GetRValue(cr), GetGValue(cr), GetBValue(cr) );
   get_text_size_len_hdc( &sz, cp, len, hdc );
   rc.left = prc->left;
   rc.right = rc.left + sz.cx;
   rc.top   = prc->top + sz.cy;
   rc.bottom = rc.top + sz.cy;
   paint_text_to_hdc( hdc, cp, &rc, pc );
}

void paint_top_red_text( char * ps ) { paint_line_text( ps, 0 ); }

#define  MX_LINES    32
#define  MX_LINE_BUF 256
#define  DEF_BEGIN_LINE 1

static char _s_line_text[MX_LINES+1][MX_LINE_BUF];
static int done_line_init = 0;
static int next_line_text = 1;
int poly_indent_line = 5;

void do_line_init( void )
{
   done_line_init = 1;
   int i;
   for( i = 0; i < MX_LINES; i++ )
      _s_line_text[i][0] = 0;
   next_line_text = DEF_BEGIN_LINE;
}

void paint_line_text_to_DC( HDC hdc, char * ps, int line )
{
   int   format = DT_LEFT | DT_SINGLELINE | DT_NOCLIP;
   RECT  rc;
   HFONT hf = Get_CN8_Font( hdc );
   HFONT hfOld;
   COLORREF crOld;
   COLORREF cr = (line == 0) ? Get_Top_Color() : get_std_text_color();
   SIZE sz;
   char * cp = &_s_line_text[line][0];
   int len = strlen(ps);
   int plen = strlen(cp);
   GetClientRect(g_hWnd, &rc);
   get_CN8_Text_Size( hdc, &sz );
   int tlines = rc.bottom / sz.cy;

   rc.top = sz.cy * line;
   rc.bottom = rc.top + sz.cy;
   rc.left = poly_indent_line;

   if( len > MX_LINE_BUF - 1 ) {
      // use additional buffer
      strncpy( &_s_line_text[MX_LINES][0], ps, MX_LINE_BUF - 1 );
      ps = &_s_line_text[MX_LINES][0];
      ps[MX_LINE_BUF - 1] = 0;
      len = strlen(ps);
   }

   if(hf)
      hfOld = (HFONT)SelectObject(hdc,hf);
   crOld = SetTextColor(hdc,cr);

   if( plen && (plen > len) && (line < tlines) )
   {
      for(int i = 0; i < plen; i++)
         cp[i] = ' ';
      DrawText( hdc, cp, plen, &rc, format );
   }

   strcpy(cp, ps);

   if(len && (line < tlines)) {
      DrawText( hdc, ps, len, &rc, format );
      sprtf( "LTXT %d: %s\n", line, ps );
   }
   if(hf)
      SelectObject(hdc,hfOld);
   SetTextColor(hdc,crOld);

}

void re_paint_lines_to_DC( HDC hdc )
{
   char * ps;
   int   i;
   for( i = 0; i < MX_LINES; i++ ) {
      ps = &_s_line_text[i][0];
      if( *ps )
         paint_line_text_to_DC( hdc, ps, i );
   }
}

void paint_line_text( char * ps, int line )
{
   if( !done_line_init )
      do_line_init();

   if( had_scenery_paint ) // we have the polys on display
      return;  // so NOT line (debug) stuff...

   if(( line < MX_LINES ) && g_hWnd ) {
      HDC hdc = GetDC(g_hWnd);
      if(hdc) {
         paint_line_text_to_DC( hdc, ps, line );
      }
   }
}

void paint_next_line_text( char * ps )
{
   if( next_line_text >= MX_LINES )
      next_line_text = DEF_BEGIN_LINE;
   paint_line_text( ps, next_line_text );
   next_line_text++;
   if( next_line_text >= MX_LINES )
      next_line_text = DEF_BEGIN_LINE;
   paint_line_text( "", next_line_text );
}

void re_paint_lines( void )
{
   char * ps;
   int   i;
   for( i = 0; i < MX_LINES; i++ ) {
      ps = &_s_line_text[i][0];
      if( *ps )
         paint_line_text( ps, i );
   }
}

void paint_center_bottom( char * ps )
{
   if(g_hWnd) {
      HDC hdc = GetDC(g_hWnd);
      if(hdc) {
         paint_center_bottom_to_DC( hdc, ps );
         ReleaseDC(g_hWnd,hdc);
      }
   }
}

void paint_mouse_coordinates( int x, int y, int shift, int ctrl )
{
   if ( !had_scenery_paint )
      return;
   // paint to bottom line
   static char _s_mousecoord[256];
   char * ps = _s_mousecoord;
   double dlat, dlon;
   double dx = (double)x;
   double dy = (double)y;
   int iLen = 0;
   size_t max = paintPoints.size();
   size_t i;
   //PPolyGlobs ppg = get_poly_globs();
   mm_pt2ll( &dlat, &dlon, dx, dy );
   *ps = 0;
   if( shift ) {
      SGBucket b( dlon, dlat );
      iLen = sprintf(ps, "%s/%s", b.gen_base_path().c_str(),
         b.gen_index_str().c_str() );
   } else {
      iLen = sprintf(ps, " %0.6f,%0.6f ", dlon, dlat );
   }
   if( ctrl && max ) {
      PP pp;
      POINT pp2, pp3;
      size_t closest = -1;
      for(i = 0; i < max; i++) {
         pp = paintPoints[i];
         pp2.x = pp.pt.x + 1;
         pp3.x = pp.pt.x - 1;
         pp2.y = pp.pt.y + 1;
         pp3.y = pp.pt.y - 1;
         if(( pp.pt.x == x )&&
            ( pp.pt.y == y )) {
               break;
         }
         if(( x >= pp3.x )&& ( x <= pp2.x )&&
            ( y >= pp3.y )&& ( y >= pp2.y ))
            closest = i;
      }
      if( i < max ) {
         double diflat = fabs( pp.lat - dlat );
         double diflon = fabs( pp.lon - dlon );
         iLen = sprintf(EndBuf(ps), " e=%0.6f,%0.6f ", pp.lon, pp.lat );
         sprtf("Compare: %s pt x,y %d,%d (D=%0.6f,%06f)\n", ps, x, y, diflon, diflat);
      } else if( closest != -1 ) {
         pp = paintPoints[closest];
         iLen = sprintf(EndBuf(ps), " c=%0.6f,%0.6f ", pp.lon, pp.lat );
      }
   }
   paint_center_bottom(ps);
}

//#define RC_TOP_LEFT     0
//#define RC_TOP_RIGHT    1
//#define RC_BOTTOM_RIGHT 2
//#define RC_BOTTOM_LEFT  3
void paint_center_bottom_to_DC( HDC hdc, char * ps )
{
   PRECT prcp = get_corner_rect(); // stored corner paints
   char * pc = _s_center_bottom_text;
   RECT  rc;
   rc.left   = prcp[RC_BOTTOM_LEFT].right;
   rc.right  = prcp[RC_BOTTOM_RIGHT].left;
   rc.top    = prcp[RC_BOTTOM_LEFT].top;
   rc.bottom = prcp[RC_BOTTOM_RIGHT].bottom;
   paint_text_to_hdc( hdc, ps, &rc, pc );
}


void paint_center_bottom_to_DC_ok( HDC hdc, char * ps )
{
   int   format = DT_CENTER | DT_SINGLELINE | DT_NOCLIP; // | DT_VCENTER;
   PRECT prcp = get_corner_rect(); // stored corner paints
   RECT  rc;
   HFONT hf = Get_CN8_Font(hdc);
   HFONT hfOld;
   char * pc = _s_center_bottom_text;
   int plen = strlen(pc);  // length of old, if any
   int len  = strlen(ps);  // length of new

   //GetWindowRect(g_hWnd, &rc);
   rc.left   = prcp[RC_BOTTOM_LEFT].right;
   rc.right  = prcp[RC_BOTTOM_RIGHT].left;
   rc.top    = prcp[RC_BOTTOM_LEFT].top;
   rc.bottom = prcp[RC_BOTTOM_RIGHT].bottom;
   if(hf)
      hfOld = (HFONT)SelectObject(hdc, hf);
   // remove any LAST text there
   if ( plen && (plen > len)) {
      for(int i = 0; i < plen; i++)
         pc[i] = ' '; // space it out
      // and use it to clear the area before next text
      DrawText( hdc, pc, plen, &rc, format );
   }

   DrawText( hdc, // handle to DC
      ps,         // text to draw
      len,        // text length
      &rc,        // formatting dimensions
      format );   // text-drawing options

   if(hf)
      hfOld = (HFONT)SelectObject(hdc, hfOld);
   strcpy( pc, ps );
}

void paint_center_text_to_DC( HDC hdc, char * ps )
{
   int   format = DT_CENTER | DT_SINGLELINE | DT_VCENTER | DT_NOCLIP;
   RECT  rc;
   HFONT hf = Get_CN8_Font( hdc );
   HFONT hfOld;
   COLORREF crOld;
   char * pc = _last_c_text;
   int len = strlen(ps);
   int plen = strlen(pc);
   if( !g_hWnd )
      return;

   GetWindowRect(g_hWnd, &rc);

   if(hf)
      hfOld = (HFONT)SelectObject(hdc, hf);
   crOld = SetTextColor( hdc, Get_Cntr_Color() );

   if ( plen && (len < plen) ) {    // remove any LAST text there, if longer
      for(int i = 0; i < plen; i++)
         pc[i] = ' '; // space it out
      // and use it to clear the area before next text
      DrawText( hdc, pc, plen, &rc, format );
   }

   DrawText( hdc, // handle to DC
      ps,         // text to draw
      len,        // text length
      &rc,        // formatting dimensions
      format );   // text-drawing options

   SetTextColor( hdc, crOld );
   if(hf)
      SelectObject(hdc, hfOld);
   strcpy( pc, ps ); // update previous text
}

void paint_center_text( char * ps ) // paint line to center of screen
{
   if(g_hWnd && ps && *ps) {
      HDC hdc = GetDC(g_hWnd);
      if(hdc) {
         paint_center_text_to_DC( hdc, ps );
         ReleaseDC(g_hWnd,hdc);
      }
   }
}

void clear_center_bottom_text(void) { _s_center_bottom_text[0] = 0; }

void paint_std_text( HDC hdc, int x, int y, char * ps )
{
   COLORREF crOld;
   HFONT hf = Get_CN8_Font( hdc );
   HFONT hfOld;

   crOld = SetTextColor( hdc, get_std_text_color() );   // set text color
   if(hf)
      hfOld = (HFONT)SelectObject(hdc, hf);  // and font

   TextOut( hdc, x, y, ps, strlen(ps) ); // out the TEXT

   crOld = SetTextColor( hdc, crOld );    // retore OLD color
   if(hf)
      hfOld = (HFONT)SelectObject(hdc, hfOld);  // and old font
}

void paint_top_center_text_wcolor( char * ps, COLORREF cr )
{
   PPPSET pps = get_act_paint_set();
   PRECT prcp = get_corner_rect(); // store the corner paints
   int iLen = strlen(ps);
   COLORREF crOld;
   HFONT hf = Get_CN8_Font( pps->hdc );
   HFONT hfOld;
   SIZE  sz;
   POINT pT;

   crOld = SetTextColor( pps->hdc, cr );   // set text color
   if(hf)
      hfOld = (HFONT)SelectObject(pps->hdc, hf);  // and font

   GetTextExtentPoint32( pps->hdc, ps, iLen, &sz );
   if( (prcp[RC_TOP_RIGHT].left - prcp[RC_TOP_LEFT].right) > sz.cx ) {
      pT.x = ((prcp[RC_TOP_RIGHT].left + prcp[RC_TOP_LEFT].right) / 2) - (sz.cx / 2);
      pT.y = 0;
      TextOut( pps->hdc, pT.x, pT.y, ps, iLen );
      sprtf( "Put %s(%d) at x,y %d,%d (sz %d,%d)\n",
         ps, iLen, pT.x, pT.y, sz.cx, sz.cy );
   } else {
      unsigned int uForm = DT_SINGLELINE | DT_CENTER | DT_WORD_ELLIPSIS;
      RECT rc;
      rc.left  = prcp[RC_TOP_LEFT].right;
      rc.right = prcp[RC_TOP_RIGHT].left;
      rc.top   = prcp[RC_TOP_LEFT].top;
      rc.bottom = rc.top + sz.cy;
      DrawText( pps->hdc,  // HDC hDC,          // handle to DC
         ps,               // LPCTSTR lpString, // text to draw
         iLen,             // int nCount,       // text length
         &rc,              // LPRECT lpRect,    // formatting dimensions
         uForm );          // UINT uFormat      // text-drawing options
      sprtf( "Formated %s(%d) due to space!\n",
         ps, iLen );
   }


   crOld = SetTextColor( pps->hdc, crOld );    // retore OLD color
   if(hf)
      SelectObject(pps->hdc, hfOld);  // and old font
}


void paint_top_center_text( char * ps )
{
   paint_top_center_text_wcolor( ps, get_std_text_color() );
}

// eof - poly-text.cxx
