// poly-paint.cxx

#include "poly-view.h"
#include "poly-utils.hxx"
#include "load-poly.hxx"
#include "poly-load.hxx"
#include "parseargs.h"

extern HWND g_hWnd;

#define  DEFAULT_ZOOM   0.00003

double current_zoom = DEFAULT_ZOOM;
//double current_zoom = 0.000015;
//double current_zoom = 0.000013;
//double current_zoom = 0.01;
double zoom_change = 5E-07;

double offset_lon = 0.0;
double offset_lat = 0.0;
double offset_change = 0.1;

void increase_lon_offset( void )
{
   offset_lon += offset_change;
}
void increase_lat_offset( void )
{
   offset_lat += offset_change;
}
void decrease_lon_offset( void )
{
   offset_lon -= offset_change;
}
void decrease_lat_offset( void )
{
   offset_lat -= offset_change;
}
void reset_lat_lon_offset( void )
{
   offset_lat = 0.0;
   offset_lon = 0.0;
}

bool modify_xy = false;

static char _s_tmpbuf[1024];
static char _last_c_text[1024] = "\0";

int ap_line_len = 30;
COLORREF crGrid = RGB(90,90,90);
COLORREF crBox = RGB(190,190,190);
COLORREF crGray = RGB(90,90,90);
COLORREF crText = RGB(90,90,90);
HPEN  hpGrid = NULL;
HFONT hfCN8  = NULL;
HPEN  hpBox  = NULL;
HPEN  hpGray = NULL;

int join_poly_points = 1;

int done_std_text = 0;
SIZE  szStdText = { 14, 14 };

#define  MX_COLORS   3

COLORREF colors[MX_COLORS] = {
   RGB(255,0,0),
   RGB(0,0,255),
   RGB(0,255,0)
};

void Increment_ZOOM( void )
{
   current_zoom += zoom_change;
}
void Decement_ZOOM( void )
{
   current_zoom -= zoom_change;
}
void Restore_ZOOM( void )
{
   current_zoom = DEFAULT_ZOOM;
}

int   next_color = 0;
COLORREF get_next_color( void )
{
   COLORREF cr = colors[next_color];
   next_color++;
   if( next_color >= MX_COLORS )
      next_color = 0;
   return cr;
}


HFONT Get_CN8_Font( HDC hdc )
{
   LOGFONT lf;
   LOGFONT * plf = &lf;
   HFONT hf = hfCN8;
   if(hf)
      return hf;
   ZeroMemory( plf, sizeof(LOGFONT) );
   plf->lfHeight = -MulDiv( 8, GetDeviceCaps(hdc, LOGPIXELSY), 72 );
   strcpy( &plf->lfFaceName[0], "Courier New" );
   //plf->lfWeight = FW_BOLD;   // set BOLD font
   hf = CreateFontIndirect( plf );
   hfCN8 = hf;
   return hf;
}

void get_CN8_Text_Size( HDC hdc, PSIZE psz )
{
   if( done_std_text ) {
      psz->cx = szStdText.cx;
      psz->cy = szStdText.cy;
      return;
   }
   HFONT hf = Get_CN8_Font( hdc );
   HFONT hfOld;
   if(hf)
      hfOld = (HFONT)SelectObject(hdc, hf);

   GetTextExtentPoint32( hdc, "A", 1, &szStdText );

   if(hf)
      hfOld = (HFONT)SelectObject(hdc, hfOld);

   psz->cx = szStdText.cx;
   psz->cy = szStdText.cy;
   done_std_text = 1;   // only do this once
}

HPEN Get_Solid_Pen_1( COLORREF cr )
{
   return CreatePen( PS_SOLID, 1, cr );
}

HPEN Get_GRAY_Pen( void )
{
   if( hpGray )
      return hpGray;
   hpGray = Get_Solid_Pen_1( crGray );   // COLORREF crColor
   return hpGray;
}


HPEN Get_GRID_Pen( void )
{
   if( hpGrid )
      return hpGrid;
   hpGrid = Get_Solid_Pen_1( crGrid );   // COLORREF crColor
   return hpGrid;
}

HPEN Get_BOX_Pen( void )
{
   if( hpBox )
      return hpBox;
   hpBox = CreatePen( PS_DASH, // int fnPenStyle, 
      1, // int nWidth, 
      crBox );   // COLORREF crColor
   return hpBox;
}


void draw_line( HDC hdc, int x1, int y1, int x2, int y2 )
{
   MoveToEx( hdc, x1, y1, NULL ); // start
   LineTo( hdc, x2, y2 ); // to center bottom
}

void paint_gray_line( HDC hdc, int x1, int y1, int x2, int y2 )
{
   HPEN hp = Get_GRAY_Pen();
   HPEN hpOld;
   if(hp)
      hpOld = (HPEN)SelectObject(hdc,hp);
   draw_line( hdc, x1, y1, x2, y2 );
   if(hp)
      hpOld = (HPEN)SelectObject(hdc,hpOld);
}

int get_steps( double min, double max, int msteps )
{
   int step = 1;
   int   scnt;
   while(msteps) {
      int imin = (int)min;
      if( (double)imin < min )
         imin++;
      scnt = 0;
      while((double)imin < max) {
         scnt++;
         imin += step;
      }
      if( scnt > msteps )
         step++;
      else
         return step;
   }
   return step;
}

void get_ll2pt( double obj_latr, double obj_lonr,
           double cent_latr, double cent_lonr,
           double map_size,  double map_zoom,
           double * px_pixel, double * py_pixel )
{
   win_ll2pt( obj_latr, obj_lonr,
      cent_latr, cent_lonr,
      map_size,  map_zoom,
      px_pixel, py_pixel );
   sprtf( "lat,lon %0.6f,%0.6f yielded x,y %0.2f,%0.2f\n",
      obj_latr, obj_lonr, *px_pixel, *py_pixel );
}

void paint_min_max_box_NOT_USED( HDC hdc, PRECT prc, double map_size,
                        double max_lat, double max_lon,
                        double min_lat, double min_lon,
                        double c_lat,   double c_lon )
{
   double dx,dy;
   int x, y, last_x, last_y;
   sprtf( "Paint box lon,lat MIN %0.6f,%0.6f MAX %0.6f,%0.6f\n",
      min_lon, min_lat, max_lon, max_lat );
   // fixed max_lat
   get_ll2pt( max_lat, max_lon, c_lat, c_lon, map_size, current_zoom, &dx, &dy );
   x = (int)( dx + 0.5 );
   y = (int)( dy + 0.5 );
   if( x < prc->left )
      x = prc->left;
   else if( x > prc->right )
      x = prc->right;
   if( y < prc->top )
      y = prc->top;
   else if( y > prc->bottom )
      y = prc->bottom;
   last_x = x;
   last_y = y;
   get_ll2pt( max_lat, min_lon, c_lat, c_lon, map_size, current_zoom, &dx, &dy );
   x = (int)( dx + 0.5 );
   y = (int)( dy + 0.5 );
   if( x < prc->left )
      x = prc->left;
   else if( x > prc->right )
      x = prc->right;
   if( y < prc->top )
      y = prc->top;
   else if( y > prc->bottom )
      y = prc->bottom;
   draw_line( hdc, last_x, last_y, x, y );
   sprtf( "Painted from %d,%d to %d,%d\n", last_x, last_y, x, y );
   // fixed min_lat
   get_ll2pt( min_lat, max_lon, c_lat, c_lon, map_size, current_zoom, &dx, &dy );
   x = (int)( dx + 0.5 );
   y = (int)( dy + 0.5 );
   if( x < prc->left )
      x = prc->left;
   else if( x > prc->right )
      x = prc->right;
   if( y < prc->top )
      y = prc->top;
   else if( y > prc->bottom )
      y = prc->bottom;
   last_x = x;
   last_y = y;
   get_ll2pt( min_lat, min_lon, c_lat, c_lon, map_size, current_zoom, &dx, &dy );
   x = (int)( dx + 0.5 );
   y = (int)( dy + 0.5 );
   if( x < prc->left )
      x = prc->left;
   else if( x > prc->right )
      x = prc->right;
   if( y < prc->top )
      y = prc->top;
   else if( y > prc->bottom )
      y = prc->bottom;
   draw_line( hdc, last_x, last_y, x, y );
   sprtf( "Painted from %d,%d to %d,%d\n", last_x, last_y, x, y );

   // fixed max_lon
   get_ll2pt( max_lat, max_lon, c_lat, c_lon, map_size, current_zoom, &dx, &dy );
   x = (int)( dx + 0.5 );
   y = (int)( dy + 0.5 );
   if( x < prc->left )
      x = prc->left;
   else if( x > prc->right )
      x = prc->right;
   if( y < prc->top )
      y = prc->top;
   else if( y > prc->bottom )
      y = prc->bottom;
   last_x = x;
   last_y = y;
   get_ll2pt( min_lat, max_lon, c_lat, c_lon, map_size, current_zoom, &dx, &dy );
   x = (int)( dx + 0.5 );
   y = (int)( dy + 0.5 );
   if( x < prc->left )
      x = prc->left;
   else if( x > prc->right )
      x = prc->right;
   if( y < prc->top )
      y = prc->top;
   else if( y > prc->bottom )
      y = prc->bottom;
   draw_line( hdc, last_x, last_y, x, y );
   sprtf( "Painted from %d,%d to %d,%d\n", last_x, last_y, x, y );

   // fixed min_lon
   get_ll2pt( max_lat, min_lon, c_lat, c_lon, map_size, current_zoom, &dx, &dy );
   x = (int)( dx + 0.5 );
   y = (int)( dy + 0.5 );
   if( x < prc->left )
      x = prc->left;
   else if( x > prc->right )
      x = prc->right;
   if( y < prc->top )
      y = prc->top;
   else if( y > prc->bottom )
      y = prc->bottom;
   last_x = x;
   last_y = y;
   get_ll2pt( min_lat, min_lon, c_lat, c_lon, map_size, current_zoom, &dx, &dy );
   x = (int)( dx + 0.5 );
   y = (int)( dy + 0.5 );
   if( x < prc->left )
      x = prc->left;
   else if( x > prc->right )
      x = prc->right;
   if( y < prc->top )
      y = prc->top;
   else if( y > prc->bottom )
      y = prc->bottom;
   draw_line( hdc, last_x, last_y, x, y );
   sprtf( "Painted from %d,%d to %d,%d\n", last_x, last_y, x, y );
}

void paint_bounding_box( HDC hdc, PRECT pmm )
{
   HPEN hp = Get_BOX_Pen();
   HPEN hpOld;

   if(hp)
      hpOld = (HPEN)SelectObject(hdc,hp);

   // top line
   draw_line( hdc, pmm->left, pmm->top, pmm->right, pmm->top );
   // right side
   draw_line( hdc, pmm->right, pmm->top, pmm->right, pmm->bottom );
   // bottom side
   draw_line( hdc, pmm->left, pmm->bottom, pmm->right, pmm->bottom );
   // left side
   draw_line( hdc, pmm->left, pmm->top, pmm->left, pmm->bottom );

   if(hp)
      hpOld = (HPEN)SelectObject(hdc,hpOld);
}

void paint_center_text_to_DC( HDC hdc, HWND hWnd, char * ps )
{
   int   format = DT_CENTER | DT_SINGLELINE | DT_VCENTER;
   RECT  rc;
   HFONT hf = Get_CN8_Font( hdc );
   HFONT hfOld;
   GetWindowRect(g_hWnd, &rc);
   if(hf)
      hfOld = (HFONT)SelectObject(hdc, hf);
   // remove any LAST text there
   if ( _last_c_text[0] ) {
      size_t len = strlen(_last_c_text);
      for(int i = 0; i < len; i++)
         _last_c_text[i] = ' '; // space it out
      // and use it to clear the area before next text
      DrawText( hdc, _last_c_text, len, &rc, format );
   }

   DrawText( hdc, // handle to DC
      ps,         // text to draw
      strlen(ps), // text length
      &rc,        // formatting dimensions
      format ); // text-drawing options

   strcpy( _last_c_text, ps );
}

void paint_center_text( char * ps )
{
   if(g_hWnd && ps && *ps) {
      HDC hdc = GetDC(g_hWnd);
      if(hdc) {
         paint_center_text_to_DC( hdc, g_hWnd, ps );
         ReleaseDC(g_hWnd,hdc);
      }
   }
}

int   def_x_size = 4;

void paint_x( HDC hdc, int x, int y, COLORREF cr )
{
   int   ltx, lty;
   int   rbx, rby;
   int   lbx, lby;
   int   rtx, rty;

   ltx = x - def_x_size;
   lty = y - def_x_size;
   rbx = x + def_x_size;
   rby = y + def_x_size;

   lbx = ltx;
   lby = rby;
   rtx = rbx;
   rty = lty; 

   HPEN hp = Get_Solid_Pen_1(cr);
   HPEN hpOld;
   if(hp)
      hpOld = (HPEN)SelectObject(hdc,hp);

   draw_line( hdc, ltx, lty, rbx, rby );
   draw_line( hdc, lbx, lby, rtx, rty );

   if(hp) {
      hpOld = (HPEN)SelectObject(hdc,hpOld);
      DeleteObject(hp);
   }
}

void paint_std_text( HDC hdc, int x, int y, char * ps )
{
   COLORREF crOld;
   HFONT hf = Get_CN8_Font( hdc );
   HFONT hfOld;

   crOld = SetTextColor( hdc, crText );
   if(hf)
      hfOld = (HFONT)SelectObject(hdc, hf);
   crOld = SetTextColor( hdc, crText );

   TextOut( hdc, x, y, ps, strlen(ps) );

   crOld = SetTextColor( hdc, crOld );
   if(hf)
      hfOld = (HFONT)SelectObject(hdc, hfOld);
}


void paint_sydney_YSSY( HDC hdc, double c_lat, double c_lon,
                       double map_size, double map_zoom,
                       PRECT prc)
{
   // paint Sydney marker, if on MAP
   double dlat = -33.9433920625;
   double dlon = 151.179773052083;
   double rdx, rdy;
   int   x, y;
   SIZE  sz;
   win_ll2pt( dlat, dlon, c_lat, c_lon, map_size, current_zoom, &rdx, &rdy );
   x = win_int(rdx);
   y = win_int(rdy);
   if (( x > prc->left ) && ( x < prc->right ) &&
       ( y > prc->top ) && ( y < prc->bottom ) ) {
      get_CN8_Text_Size( hdc, &sz );
      paint_x( hdc, x, y, RGB(0,255,0) );
      int x2 = x + ap_line_len;
      int y2 = y;
      paint_gray_line( hdc, x, y, x2, y2 );
      y2 -= (sz.cy / 2);
      paint_std_text( hdc, x2, y2, "YSSY " );
   }
}

// YWLM Williamtown (-32.7953080294118,151.842202705882) tile=e150s30
void paint_sydney_YWLM( HDC hdc, double c_lat, double c_lon,
                       double map_size, double map_zoom,
                       PRECT prc)
{
   // paint Newcastle (Williamtown) marker, if on MAP
   double dlat = -32.7953080294118;
   double dlon = 151.842202705882;
   double rdx, rdy;
   int   x, y;
   SIZE sz;
   win_ll2pt( dlat, dlon, c_lat, c_lon, map_size, current_zoom, &rdx, &rdy );
   x = win_int(rdx);
   y = win_int(rdy);
   if (( x > prc->left ) && ( x < prc->right ) &&
       ( y > prc->top ) && ( y < prc->bottom ) ) {
      get_CN8_Text_Size( hdc, &sz );
      paint_x( hdc, x, y, RGB(0,255,0) );
      int x2 = x + ap_line_len;
      int y2 = y + ap_line_len;
      paint_gray_line( hdc, x, y, x2, y2 );
      y2 -= (sz.cy / 2);
      paint_std_text( hdc, x2, y2, "YWLM " );
   }
}

void paint_airports( HDC hdc, double c_lat, double c_lon,
                       double map_size, double map_zoom,
                       PRECT prc)
{
   paint_sydney_YWLM( hdc, c_lat, c_lon, map_size, map_zoom, prc );
   paint_sydney_YSSY( hdc, c_lat, c_lon, map_size, map_zoom, prc );
}


static RECT rcCornerPaints[4];

void paint_lat_lon_grid( HDC hdc, double c_lon, double c_lat,
                        double map_size, PRECT prc )
{
   COLORREF crOld;
   HFONT hf = Get_CN8_Font( hdc );
   HFONT hfOld;
   HPEN hpGrid = Get_GRID_Pen();
   HPEN hpOld;
   double dx, dy;
   double dlon, dlat;
   double rdx,rdy;
   double min_slat, max_slat, min_slon, max_slon;
   RECT  rc = *prc;
   int   x, y;
   int   last_x, last_y;
   PRECT prcp = &rcCornerPaints[0]; // strore the corner paints
   int   crcp = 0;
   int   i;

   min_slat = 2000.0;
   max_slat = -2000.0;
   min_slon = 2000.0;
   max_slon = -2000.0;
            SIZE sz;
            POINT pT;
            char * ps = _s_tmpbuf;  // temporary (SHARED) buffer
            int   iLen;

            sprtf( "Paint: center lon,lat %0.4f,%0.4f, size %f, zoom %f\n",
               c_lon, c_lat, map_size, current_zoom );
            crOld = SetTextColor( hdc, crText );
            if(hf)
               hfOld = (HFONT)SelectObject(hdc, hf);
            if(hpGrid)
               hpOld = (HPEN)SelectObject(hdc, hpGrid);

            // get screen extents
            // =========================================
            crcp = 0;
            // TOP LEFT
            dx = 0.0;
            dy = 0.0;
            win_pt2ll( &dlat, &dlon, c_lat, c_lon, map_size, current_zoom, dx, dy );
            iLen = sprintf(ps, " %0.6f,%0.6f ", dlon, dlat );
            win_ll2pt( dlat, dlon, c_lat, c_lon, map_size, current_zoom, &rdx, &rdy );
            GetTextExtentPoint32( hdc, ps, iLen, &sz );
            pT.x = 0;
            pT.y = 0;
            TextOut( hdc, pT.x, pT.y, ps, iLen );
            prcp[crcp].left   = pT.x;
            prcp[crcp].right  = prcp->left + sz.cx;
            prcp[crcp].top    = pT.y;
            prcp[crcp].bottom = prcp->top + sz.cy;
            crcp++;
            sprtf( "For %0.1f,%0.1f, put %s(%d) at %d,%d (sz %d,%d)(r %0.6f,%o.6f\n", dx, dy, ps, iLen,
               pT.x, pT.y, sz.cx, sz.cy, rdx, rdy);
            if( dlon < min_slon )
               min_slon = dlon;
            if( dlon > max_slon )
               max_slon = dlon;
            if( dlat < min_slat )
               min_slat = dlat;
            if( dlat > max_slat )
               max_slat = dlat;

            // TOP RIGHT
            dx = (double) rc.right;
            dy = 0.0;
            win_pt2ll( &dlat, &dlon, c_lat, c_lon, map_size, current_zoom, dx, dy );
            iLen = sprintf(ps, " %0.6f,%0.6f ", dlon, dlat );
            win_ll2pt( dlat, dlon, c_lat, c_lon, map_size, current_zoom, &rdx, &rdy );
            GetTextExtentPoint32( hdc, ps, iLen, &sz );
            pT.x = rc.right - sz.cx - 2;
            pT.y = 0;
            TextOut( hdc, pT.x, pT.y, ps, iLen );
            prcp[crcp].left   = pT.x;
            prcp[crcp].right  = prcp->left + sz.cx;
            prcp[crcp].top    = pT.y;
            prcp[crcp].bottom = prcp->top + sz.cy;
            crcp++;
            sprtf( "For %0.1f,%0.1f, put %s(%d) at %d,%d (sz %d,%d)(r %0.6f,%o.6f\n", dx, dy, ps, iLen,
               pT.x, pT.y, sz.cx, sz.cy, rdx, rdy);
            if( dlon < min_slon )
               min_slon = dlon;
            if( dlon > max_slon )
               max_slon = dlon;
            if( dlat < min_slat )
               min_slat = dlat;
            if( dlat > max_slat )
               max_slat = dlat;

            // BOTTOM RIGHT
            dx = (double) rc.right;
            dy = (double) rc.bottom;
            win_pt2ll( &dlat, &dlon, c_lat, c_lon, map_size, current_zoom, dx, dy );
            iLen = sprintf(ps, " %0.6f,%0.6f ", dlon, dlat );
            win_ll2pt( dlat, dlon, c_lat, c_lon, map_size, current_zoom, &rdx, &rdy );
            GetTextExtentPoint32( hdc, ps, iLen, &sz );
            pT.x = rc.right - sz.cx - 2;
            pT.y = rc.bottom - sz.cy - 2;
            TextOut( hdc, pT.x, pT.y, ps, iLen );
            prcp[crcp].left   = pT.x;
            prcp[crcp].right  = prcp->left + sz.cx;
            prcp[crcp].top    = pT.y;
            prcp[crcp].bottom = prcp->top + sz.cy;
            crcp++;
            sprtf( "For %0.1f,%0.1f, put %s(%d) at %d,%d (sz %d,%d)(r %0.6f,%o.6f\n", dx, dy, ps, iLen,
               pT.x, pT.y, sz.cx, sz.cy, rdx, rdy);
            if( dlon < min_slon )
               min_slon = dlon;
            if( dlon > max_slon )
               max_slon = dlon;
            if( dlat < min_slat )
               min_slat = dlat;
            if( dlat > max_slat )
               max_slat = dlat;

            // BOTTOM LEFT
            dx = 0.0;
            dy = (double) rc.bottom;
            win_pt2ll( &dlat, &dlon, c_lat, c_lon, map_size, current_zoom, dx, dy );
            iLen = sprintf(ps, " %0.6f,%0.6f ", dlon, dlat );
            win_ll2pt( dlat, dlon, c_lat, c_lon, map_size, current_zoom, &rdx, &rdy );
            GetTextExtentPoint32( hdc, ps, iLen, &sz );
            pT.x = 0;
            pT.y = rc.bottom - sz.cy;
            TextOut( hdc, pT.x, pT.y, ps, iLen );
            prcp[crcp].left   = pT.x;
            prcp[crcp].right  = prcp->left + sz.cx;
            prcp[crcp].top    = pT.y;
            prcp[crcp].bottom = prcp->top + sz.cy;
            crcp++;
            sprtf( "For %0.1f,%0.1f, put %s(%d) at %d,%d (sz %d,%d)(r %0.6f,%o.6f\n", dx, dy, ps, iLen,
               pT.x, pT.y, sz.cx, sz.cy, rdx, rdy);
            if( dlon < min_slon )
               min_slon = dlon;
            if( dlon > max_slon )
               max_slon = dlon;
            if( dlat < min_slat )
               min_slat = dlat;
            if( dlat > max_slat )
               max_slat = dlat;
            // =========================================
            strcpy(ps, "Enab ");
            for( i = 0; i < 10; i++ ) {
               if( is_poly_enabled(i) ) {
                  char c[2];
                  c[0] = (i + '1');
                  c[1] = 0;
                  strcat(ps, c);
               }
            }
            sprintf( EndBuf(ps), " Zoom(M) %G", (current_zoom * 1000) );

            iLen = strlen(ps);
            GetTextExtentPoint32( hdc, ps, iLen, &sz );
            if( (prcp[1].left - prcp[0].right) > sz.cx ) {
               pT.x = ((prcp[1].left + prcp[0].right) / 2) - (sz.cx / 2);
               pT.y = 0;
               TextOut( hdc, pT.x, pT.y, ps, iLen );
               sprtf( "Put %s(%d) at x,y %d,%d (sz %d,%d)\n",
                  ps, iLen, pT.x, pT.y, sz.cx, sz.cy );
            } else {
               sprtf( "NO put %s(%d) due to no space!\n",
                  ps, iLen );
            }

            // =========================================

            int step_lat = get_steps( min_slat, max_slat, 5 );
            int step_lon = get_steps( min_slon, max_slon, 5 );

            int imin_lon = (int)min_slon;
            if((double)imin_lon < min_slon)
               imin_lon++;

            int imin_lat = (int)min_slat;
            if( (double)imin_lat < min_slat )
               imin_lat++;

            if(( (max_slon - min_slon) > 1.0 ) && (step_lon > 0) )
            {
               while((double)imin_lon < max_slon) {
                  get_ll2pt( max_slat, (double)imin_lon, c_lat, c_lon, map_size, current_zoom, &dx, &dy );
                  x = (int)( dx + 0.5 );
                  y = (int)( dy + 0.5 );
                  if( modify_xy ) {
                     if( x < rc.left )
                        x = rc.left;
                     else if( x > rc.right )
                        x = rc.right;
                     if( y < rc.top )
                        y = rc.top;
                     else if( y > rc.bottom )
                        y = rc.bottom;
                  }
                  last_x = x;
                  last_y = y;
                  get_ll2pt( min_slat, (double)imin_lon, c_lat, c_lon, map_size, current_zoom, &dx, &dy );
                  x = (int)( dx + 0.5 );
                  y = (int)( dy + 0.5 );
                  if( modify_xy ) {
                     if( x < rc.left )
                        x = rc.left;
                     else if( x > rc.right )
                        x = rc.right;
                     if( y < rc.top )
                        y = rc.top;
                     else if( y > rc.bottom )
                        y = rc.bottom;
                  }
                  draw_line( hdc, last_x, last_y, x, y );
                  sprtf( "Painted GRID lon %d from %d,%d to %d,%d\n",
                     imin_lon, last_x, last_y, x, y );

                  iLen = sprintf(ps, " %d ", imin_lon );
                  GetTextExtentPoint32( hdc, ps, iLen, &sz );
                  pT.x = last_x - (sz.cx / 2);  // centered on top lon last_x
                  pT.y = rc.top + sz.cy;        // 2nd line from top
                  TextOut( hdc, pT.x, pT.y, ps, iLen );
                  sprtf( "Painted lon [%s] at %d,%d\n",
                     ps, pT.x, pT.y );
                  pT.x = x - (sz.cx / 2);          // centered on bottom lon x
                  pT.y = rc.bottom - (2 * sz.cy);  // 2nd line from bottom
                  TextOut( hdc, pT.x, pT.y, ps, iLen );
                  sprtf( "Painted lon [%s] at %d,%d\n",
                     ps, pT.x, pT.y );
                  
                  imin_lon += step_lon; // done, bump to next
               }
            }
            if(( (max_slat - min_slat) > 1.0 ) && (step_lat > 0))
            {
               while((double)imin_lat < max_slat) {
                  get_ll2pt( (double)imin_lat, max_slon, c_lat, c_lon, map_size, current_zoom, &dx, &dy );
                  x = (int)( dx + 0.5 );
                  y = (int)( dy + 0.5 );
                  if( modify_xy ) {
                     if( x < rc.left )
                        x = rc.left;
                     else if( x > rc.right )
                        x = rc.right;
                     if( y < rc.top )
                        y = rc.top;
                     else if( y > rc.bottom )
                        y = rc.bottom;
                  }
                  last_x = x;
                  last_y = y;
                  get_ll2pt( (double)imin_lat, min_slon, c_lat, c_lon, map_size, current_zoom, &dx, &dy );
                  x = (int)( dx + 0.5 );
                  y = (int)( dy + 0.5 );
                  if( modify_xy ) {
                     if( x < rc.left )
                        x = rc.left;
                     else if( x > rc.right )
                        x = rc.right;
                     if( y < rc.top )
                        y = rc.top;
                     else if( y > rc.bottom )
                        y = rc.bottom;
                  }
                  draw_line( hdc, last_x, last_y, x, y );
                  sprtf( "Painted GRID lat %d from %d,%d to %d,%d\n",
                     imin_lat, last_x, last_y, x, y );

                  iLen = sprintf(ps, " %d ", imin_lat );
                  GetTextExtentPoint32( hdc, ps, iLen, &sz );
                  pT.x = 0;                     // at left x
                  pT.y = last_y - (sz.cy / 2);  // centered on lat line
                  TextOut( hdc, pT.x, pT.y, ps, iLen );
                  sprtf( "Painted lat [%s] at %d,%d\n",
                     ps, pT.x, pT.y );
                  pT.x = rc.right - sz.cx;      // at right - length
                  pT.y = y - (sz.cy / 2);       // centered on lat line
                  TextOut( hdc, pT.x, pT.y, ps, iLen );
                  sprtf( "Painted lat [%s] at %d,%d\n",
                     ps, pT.x, pT.y );
                  imin_lat += step_lat; // done - bump to next
               }
            }
            crOld = SetTextColor( hdc, crOld );
            if(hf)
               hfOld = (HFONT)SelectObject(hdc, hfOld);
            if(hpGrid)
               hpOld = (HPEN)SelectObject(hdc, hpOld);
}

//	SetBkColor(crOldBack);
//	oldcr = SetTextColor(hdc, cr);
//double xdist = ppc->pdist.lon();
//double ydist = ppc->pdist.lat();
//min_lat = ppc->pmin.lat();
//min_lon = ppc->pmin.lon();
//max_lat = ppc->pmax.lat();
//max_lon = ppc->pmax.lon();

void paint_poly_OK( HWND hwnd, HDC hdc )
{
   RECT rc;
   TGPolyLoad * polyload = NULL;
   RECT mm;
   int points_painted = 0;
   double map_size = 600.0;
   int polys_painted = 0;
   double c_lat = 0.0;
   double c_lon = 0.0;
   double dlon, dlat, rdx, rdy;
   int   cnum;
   sGETPT sgp;

   GetClientRect( hwnd, &rc );
   sprtf( "\nPaint: Got window size x,y [%d,%d,%d,%d]\n", rc.left, rc.top, rc.right, rc.bottom  );
   if( !done_arguments ) {
      sprtf("Not done arguments...\n");
      return;
   }
   mm.bottom = -10000;
   mm.left   =  10000;
   mm.right  = -10000;
   mm.top    =  10000;
   if( rc.right > rc.bottom )
      map_size = (double)rc.right;
   else
      map_size = (double)rc.bottom;

   sgp.pcnum = &cnum;
   sgp.px    = &dlon;
   sgp.py    = &dlat;
   next_color = 0;
   points_painted = 0;

   polyload = get_first_loaded_poly();
   while( polyload ) {
      PPolyCounter ppc = Get_Poly_Counts();
      COLORREF cr = get_next_color();  //RGB(255,0,0);
      if ( ppc->total )
      {
         double dx, dy;
         int x, y, last_x, last_y;
         polys_painted++;
         if( polys_painted == 1 ) {
            c_lon = ppc->pcenter.lon();
            c_lat = ppc->pcenter.lat();
            paint_lat_lon_grid( hdc, c_lon, c_lat, map_size, &rc );
         } // only painted for FIRST poly

         // === BEGIN PAINT POINTS ===
         void * vp = get_first_point( &sgp );
         if ( vp ) {
            last_x = -5000;
            last_y = -5000;
            do {
               win_ll2pt( dlat, dlon, c_lat, c_lon, map_size, current_zoom, &dx, &dy );
               x = win_int(dx);
               y = win_int(dy);
               if(( x > rc.left  ) &&
                  ( x < rc.right ) &&
                  ( y > rc.top   ) &&
                  ( y < rc.bottom) ) {
                  // point is in screen RANGE
                  if(( x != last_x ) || ( y != last_y )) {
                     SetPixel( hdc, x, y, cr );
                     points_painted++;
                     last_x = x;
                     last_y = y;
                     if( x < mm.left )
                        mm.left = x;
                     if( x > mm.right )
                        mm.right = x;
                     if( y < mm.top )
                        mm.top = y;
                     if( y > mm.bottom )
                        mm.bottom = y;
                  }
               }
            } while (( vp = get_next_point( vp, &sgp ) ) != NULL );
         }  // if vp - got first point
         // === END PAINT POINTS ===
      }
      polyload = get_next_loaded_poly();  // skip to next poly set loaded
   }

   if( points_painted ) {
      paint_bounding_box( hdc, &mm );
      paint_airports( hdc, c_lat, c_lon, map_size, current_zoom, &rc ); 
   }
}

void paint_poly( HWND hwnd, HDC hdc )
{
   RECT rc;
   TGPolyLoad * polyload = NULL;
   RECT mm;
   int points_painted = 0;
   double map_size = 600.0;
   int polys_painted = 0;
   double c_lat = 0.0;
   double c_lon = 0.0;
   double dlon, dlat, rdx, rdy;
   int   cnum;
   sGETPT sgp;
   int last_contour;
   HPEN  hp, hpOld;

   GetClientRect( hwnd, &rc );
   sprtf( "\nPaint: Got window size x,y [%d,%d,%d,%d]\n", rc.left, rc.top, rc.right, rc.bottom  );
   if( !done_arguments ) {
      sprtf("Not done arguments...\n");
      return;
   }
   mm.bottom = -10000;
   mm.left   =  10000;
   mm.right  = -10000;
   mm.top    =  10000;
   if( rc.right > rc.bottom )
      map_size = (double)rc.right;
   else
      map_size = (double)rc.bottom;

   sgp.pcnum = &cnum;
   sgp.px    = &dlon;
   sgp.py    = &dlat;
   next_color = 0;
   points_painted = 0;
   polyload = get_first_loaded_poly();
   while( polyload ) {
      PPolyCounter ppc = Get_Poly_Counts();
      COLORREF cr = get_next_color();  //RGB(255,0,0);
      hp = Get_Solid_Pen_1(cr);
      if(hp)
         hpOld = (HPEN)SelectObject(hdc,hp);

      if ( ppc->total && is_current_poly_enabled() )
      {
         double dx, dy;
         int x, y, last_x, last_y;
         polys_painted++;
         if( polys_painted == 1 ) {
            c_lon = offset_lon + ppc->pcenter.lon();
            c_lat = offset_lat + ppc->pcenter.lat();
            paint_lat_lon_grid( hdc, c_lon, c_lat, map_size, &rc );
         } // only painted for FIRST poly

         // === BEGIN PAINT POINTS ===
         last_contour = -1; // restart contour number
         void * vp = get_first_point( &sgp );
         if ( vp ) {
            last_x = -5000;
            last_y = -5000;
            do {
               win_ll2pt( dlat, dlon, c_lat, c_lon, map_size, current_zoom, &dx, &dy );
               x = win_int(dx);
               y = win_int(dy);
               if(( x > rc.left  ) &&
                  ( x < rc.right ) &&
                  ( y > rc.top   ) &&
                  ( y < rc.bottom) ) {
                  // point is in screen RANGE
                  if(( x != last_x ) || ( y != last_y )) {
                     SetPixel( hdc, x, y, cr );
                     points_painted++;
                     if( join_poly_points ) {
                        if( cnum == last_contour ) {
                           MoveToEx( hdc, last_x, last_y, NULL ); // start
                           LineTo( hdc, x, y ); // join with pen
                        } else {
                           last_contour = cnum; // not same contour, just update number
                        }
                     }
                     last_x = x;
                     last_y = y;
                     if( x < mm.left )
                        mm.left = x;
                     if( x > mm.right )
                        mm.right = x;
                     if( y < mm.top )
                        mm.top = y;
                     if( y > mm.bottom )
                        mm.bottom = y;
                  }
               } else {
                  last_contour = -1;
               }
            } while (( vp = get_next_point( vp, &sgp ) ) != NULL );
         }  // if vp - got first point
         // === END PAINT POINTS ===
      }
      if(hp) {
         hpOld = (HPEN)SelectObject(hdc,hpOld);
         DeleteObject(hp);
      }
      polyload = get_next_loaded_poly();  // skip to next poly set loaded
   }

   if( points_painted ) {
      paint_bounding_box( hdc, &mm );
      paint_airports( hdc, c_lat, c_lon, map_size, current_zoom, &rc ); 
   } else {
      paint_center_text_to_DC( hdc, g_hWnd, "No points painted!" );
   }
}

void toggle_join_points(void)
{
   if(join_poly_points)
      join_poly_points = 0;
   else
      join_poly_points = 1;
}

// eof - poly-paint.cxx
