// poly-paint.cxx
// WIN32 paint module

#include "poly-view.hxx"
#include "poly-utils.hxx"
#include "load-poly.hxx"
#include "poly-load.hxx"
#include "poly-help.hxx"
#include "poly-paint.hxx"
#include "load-scene.hxx"

extern HWND g_hWnd;

// DEBUG ITEMS
// to show the painted grid
//#define sprtf_showgrid  sprtf
#define sprtf_showgrid
// to show painted point - CARE: this can be THOUSANDS
//#define sprtf_showpoint sprtf
#define sprtf_showpoint


// forward reference
//void paint_center_text_to_DC( HDC hdc, char * ps );
void paint_line_text_to_DC( HDC hdc, char * ps, int line );
//void re_paint_lines( void );
void re_paint_lines_to_DC( HDC hdc );

#define RC_TOP_LEFT     0
#define RC_TOP_RIGHT    1
#define RC_BOTTOM_RIGHT 2
#define RC_BOTTOM_LEFT  3
#define RC_CENTER_SPACE 4
#define RC_MAX_RECTS    5
RECT g_rcCornerPaints[RC_MAX_RECTS];  // 4 corners + 1 inner + ???

int got_global_center = 0; // only after first POLY paint
// double g_map_size = 600.0;
int g_got_map_size = 0;    // set by first PAINT
int add_last_join = 0;

int paint_all_points = 1;  // this seems best, but NOT for polygon fill!

RECT g_rcClient;

static char _s_tmpbuf[1024];
static char _last_c_text[1024] = "\0";
static char _s_center_bottom_text[256] = "\0";

int ap_line_len = 30;
COLORREF crGrid = RGB(90,90,90);
COLORREF crBox = RGB(190,190,190);
COLORREF crGray = RGB(90,90,90);
COLORREF crText = RGB(90,90,90);
COLORREF crCntr = RGB(255,0,0);
COLORREF crTop = RGB(255,0,0);
COLORREF crPurp = RGB(128,0,255);
COLORREF crLBrown = RGB(192,128,32);

HPEN  hpGrid = NULL;
HPEN  hpGrid2 = NULL;
HFONT hfCN8  = NULL;
HPEN  hpBox  = NULL;
HPEN  hpGray = NULL;
HPEN  hpPurp = NULL;
HPEN  hpLBrown = NULL;
//int join_poly_points = 1;
//int join_first_to_last = 1;
//int g_paint_bounding_box = 0; // paint_bounding_box( hdc, &mm ); can overwrite points!
//int g_paint_airports = 1;     // only 1 or 2 selected - could load apt.dat...
// paint_airports( hdc, g_c_lat, g_c_lon, map_size, map_zoom, &rc );

int done_CN8_text = 0;
SIZE g_szCN8Text = { 14, 14 };

#define  MX_COLORS   12
typedef struct tagColorSet {
   COLORREF cr;
   char * desc;
   int   style;
   HPEN  hp;
   HBRUSH hb;
}ColorSet, * PColorSet;

ColorSet colors[MX_COLORS] = {
   { RGB(255,0,0), "red", HS_BDIAGONAL, 0, 0 }, // 45-degree upward left-to-right hatch 
   { RGB(0,0,255), "blue", HS_CROSS, 0, 0 },    // Horizontal and vertical crosshatch
   { RGB(0,255,0), "green", HS_DIAGCROSS, 0, 0 }, // 45-degree crosshatch
   { RGB(255,255,0), "redgreen", HS_FDIAGONAL, 0, 0 }, // 45-degree downward left-to-right hatch 
   { RGB(255,0,255), "redblue", HS_HORIZONTAL, 0, 0 }, // Horizontal hatch
   { RGB(0,255,255), "greenblue", HS_VERTICAL, 0, 0 }, // Vertical hatch
   { RGB(125,0,0), "halfred", HS_BDIAGONAL, 0, 0 },
   { RGB(0,0,125), "halfblue", HS_CROSS, 0, 0 },
   { RGB(0,125,0), "halfgreen", HS_DIAGCROSS, 0, 0 },
   { RGB(125,125,0), "halfredgreen", HS_FDIAGONAL, 0, 0 },
   { RGB(125,0,125), "halfredblue", HS_HORIZONTAL, 0, 0 },
   { RGB(0,125,125), "halfgreenblue", HS_VERTICAL, 0, 0 }
};

typedef struct tagPP {
   POINT pt;
   double lat,lon;
}PP, *PPP;
typedef vector<PP>   vec_pp;
vec_pp paintPoints;
typedef vector<POINT>   vec_pt;
vec_pt painted_points;
void clear_painted_points(void) {
   size_t sz = painted_points.size();
   painted_points.clear();
   if(sz)
      sprtf( "Cleared painted_points of %d pts. (%d)\n", sz, painted_points.size() );
}

void clear_paintPoints(void) 
{
   size_t sz = paintPoints.size();
   paintPoints.clear();
   if(sz)
      sprtf( "CLEAR: paintPoints of %d pts. (%d)\n", sz, paintPoints.size() );
}

void clean_up_paint_tools(void)
{
   int i;
   PColorSet pcs = &colors[0];
   for(i = 0; i < MX_COLORS; i++, pcs++)
   {
      if(pcs->hp)
         DeleteObject(pcs->hp);
      pcs->hp = 0;
      if(pcs->hb)
         DeleteObject(pcs->hb);
      pcs->hb = 0;
   }
   if(hpGrid)
      DeleteObject(hpGrid);
   hpGrid = NULL;
   if(hpGrid2)
      DeleteObject(hpGrid2);
   hpGrid2 = NULL;
   if(hpBox)
      DeleteObject(hpBox);
   hpBox = NULL;
   if(hpGray)
      DeleteObject(hpGray);
   hpGray = NULL;
   if(hpPurp)
      DeleteObject(hpPurp);
   hpPurp = NULL;
   if(hpLBrown)
      DeleteObject(hpLBrown);
   hpLBrown = NULL;
   if(hfCN8)
      DeleteObject(hfCN8);
   hfCN8 = NULL;
   clear_painted_points();
   clear_paintPoints();
}

HBRUSH CreateStyledBrush( int fnStyle, COLORREF clrref )
{
   return CreateHatchBrush( fnStyle,      // hatch style
      clrref );   // foreground color
}

char * get_rectangle_string( PRECT prc )
{
   static char _s_rc_string[256];
   char * cp = _s_rc_string;
   sprintf( cp, "[%d,%d,%d,%d]",
      prc->left, prc->top, prc->right, prc->bottom );
   return cp;
}

HFONT Get_CN8_Font( HDC hdc )
{
   LOGFONT lf;
   LOGFONT * plf = &lf;
   HFONT hf = hfCN8;
   if(hf)
      return hf;
   ZeroMemory( plf, sizeof(LOGFONT) );
   plf->lfHeight = -MulDiv( 8, GetDeviceCaps(hdc, LOGPIXELSY), 72 );
   strcpy( &plf->lfFaceName[0], "Courier New" );
   //plf->lfWeight = FW_BOLD;   // set BOLD font
   hf = CreateFontIndirect( plf );
   hfCN8 = hf;
   return hf;
}

void get_CN8_Text_Size( HDC hdc, PSIZE psz )
{
   if( done_CN8_text ) {
      psz->cx = g_szCN8Text.cx;
      psz->cy = g_szCN8Text.cy;
      return;
   }
   HFONT hf = Get_CN8_Font( hdc );
   HFONT hfOld;
   if(hf)
      hfOld = (HFONT)SelectObject(hdc, hf);

   GetTextExtentPoint32( hdc, "A", 1, &g_szCN8Text );

   if(hf)
      hfOld = (HFONT)SelectObject(hdc, hfOld);

   psz->cx = g_szCN8Text.cx;
   psz->cy = g_szCN8Text.cy;
   done_CN8_text = 1;   // only do this once
}

HPEN Get_Solid_Pen_1( COLORREF cr )  { return CreatePen( PS_SOLID, 1, cr ); }
HPEN Get_Dotted_Pen_1( COLORREF cr ) { return CreatePen( PS_DOT, 1, cr );   }

HPEN Get_GRAY_Pen( void )
{
   if( hpGray )
      return hpGray;
   hpGray = Get_Solid_Pen_1( crGray );   // COLORREF crColor
   return hpGray;
}

HPEN Get_GRID_Pen( void )
{
   if( hpGrid )
      return hpGrid;
   hpGrid = Get_Solid_Pen_1( crGrid );   // COLORREF crColor
   return hpGrid;
}

HPEN Get_GRID2_Pen( void )
{
   if( hpGrid2 )
      return hpGrid2;
   hpGrid2 = Get_Dotted_Pen_1( crGrid );   // COLORREF crColor
   return hpGrid2;
}

HPEN Get_Purp_Pen( void )
{
   if( hpPurp )
      return hpPurp;
   hpPurp = Get_Dotted_Pen_1( crPurp );   // COLORREF crColor
   return hpPurp;
}
HPEN Get_LBrown_Pen( void )
{
   if( hpLBrown )
      return hpLBrown;
   hpLBrown = Get_Solid_Pen_1( crLBrown );   // COLORREF crColor
   return hpLBrown;
}

HPEN Get_BOX_Pen( void )
{
   if( hpBox )
      return hpBox;
   hpBox = CreatePen( PS_DASH, // int fnPenStyle, 
      1, // int nWidth, 
      crBox );   // COLORREF crColor
   return hpBox;
}

int   g_map_next_color = 0;
int   curr_act_color;
char * g_act_color = "none";
PColorSet ps_act_pcs = NULL;
HPEN Get_Act_Pen(void)
{
   if(ps_act_pcs)
      return ps_act_pcs->hp;
   return NULL;
}
HBRUSH get_act_brush(void)
{
   if(ps_act_pcs)
      return ps_act_pcs->hb;
   return NULL;
}

COLORREF get_next_color( void )
{
   curr_act_color = g_map_next_color;
   ps_act_pcs = &colors[curr_act_color];
   COLORREF cr = ps_act_pcs->cr;
   g_act_color = ps_act_pcs->desc;
   if( !ps_act_pcs->hp )
      ps_act_pcs->hp = Get_Solid_Pen_1(cr);
   if( !ps_act_pcs->hb )
      ps_act_pcs->hb = CreateStyledBrush( ps_act_pcs->style, cr );

   // if changing colors, bump tot next, wrapping
   if( get_poly_globs()->g_paint_colors ) {
      g_map_next_color++;  // bump to NEXT
      if( g_map_next_color >= MX_COLORS )
         g_map_next_color = 0;
   }
   return cr;  // return color to use
}

void draw_line( HDC hdc, int x1, int y1, int x2, int y2 )
{
   MoveToEx( hdc, x1, y1, NULL ); // start
   LineTo( hdc, x2, y2 ); // to center bottom
}

void paint_gray_line( HDC hdc, int x1, int y1, int x2, int y2 )
{
   HPEN hp = Get_GRAY_Pen();
   HPEN hpOld;
   if(hp)
      hpOld = (HPEN)SelectObject(hdc,hp);
   draw_line( hdc, x1, y1, x2, y2 );
   if(hp)
      hpOld = (HPEN)SelectObject(hdc,hpOld);
}

#ifdef NDEBUG
#define get_ll2pt win_ll2pt
#else
void get_ll2pt( double obj_latr, double obj_lonr,
           double cent_latr, double cent_lonr,
           double map_size,  double map_zoom,
           double * px_pixel, double * py_pixel )
{
   win_ll2pt( obj_latr, obj_lonr,
      cent_latr, cent_lonr,
      map_size,  map_zoom,
      px_pixel, py_pixel );
   sprtf( "ll2pt: lon,lat %0.6f,%0.6f = x,y %0.2f,%0.2f (%d,%d)\n",
      obj_lonr, obj_latr, *px_pixel, *py_pixel, win_int(*px_pixel), win_int(*py_pixel) );
}
#endif

void paint_bounding_box( HDC hdc, PRECT pmm )
{
   HPEN hp = Get_BOX_Pen();
   HPEN hpOld;

   if(hp)
      hpOld = (HPEN)SelectObject(hdc,hp);

   // top line
   draw_line( hdc, pmm->left, pmm->top, pmm->right, pmm->top );
   // right side
   draw_line( hdc, pmm->right, pmm->top, pmm->right, pmm->bottom );
   // bottom side
   draw_line( hdc, pmm->left, pmm->bottom, pmm->right, pmm->bottom );
   // left side
   draw_line( hdc, pmm->left, pmm->top, pmm->left, pmm->bottom );

   if(hp)
      hpOld = (HPEN)SelectObject(hdc,hpOld);
}

int   def_x_size = 4;

void paint_x( HDC hdc, int x, int y, COLORREF cr )
{
   int   ltx, lty;
   int   rbx, rby;
   int   lbx, lby;
   int   rtx, rty;

   ltx = x - def_x_size;
   lty = y - def_x_size;
   rbx = x + def_x_size;
   rby = y + def_x_size;

   lbx = ltx;
   lby = rby;
   rtx = rbx;
   rty = lty; 

   HPEN hp = Get_Solid_Pen_1(cr);
   HPEN hpOld;
   if(hp)
      hpOld = (HPEN)SelectObject(hdc,hp);

   draw_line( hdc, ltx, lty, rbx, rby );
   draw_line( hdc, lbx, lby, rtx, rty );

   if(hp) {
      hpOld = (HPEN)SelectObject(hdc,hpOld);
      DeleteObject(hp);
   }
}

void paint_std_text( HDC hdc, int x, int y, char * ps )
{
   COLORREF crOld;
   HFONT hf = Get_CN8_Font( hdc );
   HFONT hfOld;

   crOld = SetTextColor( hdc, crText );   // set text color
   if(hf)
      hfOld = (HFONT)SelectObject(hdc, hf);  // and font

   TextOut( hdc, x, y, ps, strlen(ps) ); // out the TEXT

   crOld = SetTextColor( hdc, crOld );    // retore OLD color
   if(hf)
      hfOld = (HFONT)SelectObject(hdc, hfOld);  // and old font
}


void paint_sydney_YSSY( HDC hdc, double c_lat, double c_lon,
                       double map_size, double map_zoom,
                       PRECT prc)
{
   // paint Sydney marker, if on MAP
   double dlat = -33.9433920625;
   double dlon = 151.179773052083;
   double rdx, rdy;
   int   x, y;
   SIZE  sz;
   win_ll2pt( dlat, dlon, c_lat, c_lon, map_size, map_zoom, &rdx, &rdy );
   x = win_int(rdx);
   y = win_int(rdy);
   if (( x > prc->left ) && ( x < prc->right ) &&
       ( y > prc->top ) && ( y < prc->bottom ) ) {
      get_CN8_Text_Size( hdc, &sz );
      paint_x( hdc, x, y, RGB(0,255,0) );
      int x2 = x + ap_line_len;
      int y2 = y;
      paint_gray_line( hdc, x, y, x2, y2 );
      y2 -= (sz.cy / 2);
      paint_std_text( hdc, x2, y2, "YSSY" );
   }
}

// YWLM Williamtown (-32.7953080294118,151.842202705882) tile=e150s30
void paint_sydney_YWLM( HDC hdc, double c_lat, double c_lon,
                       double map_size, double map_zoom,
                       PRECT prc)
{
   // paint Newcastle (Williamtown) marker, if on MAP
   double dlat = -32.7953080294118;
   double dlon = 151.842202705882;
   double rdx, rdy;
   int   x, y;
   SIZE sz;
   win_ll2pt( dlat, dlon, c_lat, c_lon, map_size, map_zoom, &rdx, &rdy );
   x = win_int(rdx);
   y = win_int(rdy);
   if (( x > prc->left ) && ( x < prc->right ) &&
       ( y > prc->top ) && ( y < prc->bottom ) ) {
      get_CN8_Text_Size( hdc, &sz );
      paint_x( hdc, x, y, RGB(0,255,0) );
      int x2 = x + ap_line_len;
      int y2 = y + ap_line_len;
      paint_gray_line( hdc, x, y, x2, y2 );
      y2 -= (sz.cy / 2);
      paint_std_text( hdc, x2, y2, "YWLM" );
   }
}

void paint_airports( HDC hdc, double c_lat, double c_lon,
                       double map_size, double map_zoom,
                       PRECT prc)
{
   paint_sydney_YWLM( hdc, c_lat, c_lon, map_size, map_zoom, prc );
   paint_sydney_YSSY( hdc, c_lat, c_lon, map_size, map_zoom, prc );
}

// default - between 3 and 6 lines
int   target_min = 3;
int   target_max = 6;

void paint_scenery_OK( HDC hdc )
{
   PPolyGlobs ppg = get_poly_globs();
   vec_pt3d * pts = get_first_wgs84_nodes();
   double dlat, dlon, dx, dy;
   int x, y, first_x, first_y, cnt, last_x, last_y;
   COLORREF cr = crLBrown;
   double map_zoom = mm_map_zoom;
   int large = ((map_zoom < 0.001) ? 0 : win_int(map_zoom * 1000.0));
   HPEN hp = Get_LBrown_Pen();
   HPEN hpOld;
   double c_lon = mm_c_lon;
   double c_lat = mm_c_lat;
   double map_size = mm_map_size;
   PRECT prc = get_client_prec();
   if(pts) {
      if(hp)
         hpOld = (HPEN)SelectObject(hdc,hp);
      do {
         clear_painted_points();
         cnt = 0;
         for( iter_pt3d it = pts->begin(); it != pts->end(); it++ ) {
            Point3D pt = *it;
            dlat = pt.lat();
            dlon = pt.lon();
            win_ll2pt( dlat, dlon, c_lat, c_lon, map_size, map_zoom, &dx, &dy );
            x = win_int(dx);
            y = win_int(dy);
            paint_pixel_X( hdc, x, y, cr, large );
            add_painted_point( x, y, dlon, dlat );
            if( cnt == 0 ) {
               first_x = x;
               first_y = y;
            } else if( ppg->g_join_poly_points ) {
               draw_line( hdc, last_x, last_y, x, y ); // join with pen
            }
            last_x = x;
            last_y = y;
            cnt++;
         }
      } while((pts = get_next_wgs84_nodes()) != NULL );

      if(hp)
         SelectObject(hdc,hpOld);
   }
   cr = crLGreen;
   hp = Get_LGreen_Pen();
   pts = get_first_normal_nodes();
   if(pts) {
      if(hp)
         hpOld = (HPEN)SelectObject(hdc,hp);
      do {
         clear_painted_points();
         cnt = 0;
         for( iter_pt3d it = pts->begin(); it != pts->end(); it++ ) {
            Point3D pt = *it;
            dlat = pt.lat();
            dlon = pt.lon();
            win_ll2pt( dlat, dlon, c_lat, c_lon, map_size, map_zoom, &dx, &dy );
            x = win_int(dx);
            y = win_int(dy);
            paint_pixel_X( hdc, x, y, cr, large );
            add_painted_point( x, y, dlon, dlat );
            if( cnt == 0 ) {
               first_x = x;
               first_y = y;
            }
            cnt++;
         }
      } while((pts = get_next_normal_nodes()) != NULL );
      if(hp)
         SelectObject(hdc,hpOld);
   }
}

void paint_scenery_BEGIN( HDC hdc, double c_lon, double c_lat,
                        double map_size, double map_zoom, PRECT prc )
{
   vec_pt3d * pts = get_first_wgs84_nodes();
   double dlat, dlon, dx, dy;
   int x, y;
   if(pts) {
      do {
         for( iter_pt3d it = pts->begin(); it != pts->end(); it++ )
         {
            Point3D pt = *it;
            dlat = pt.lat();
            dlon = pt.lon();
            win_ll2pt( dlat, dlon, c_lat, c_lon, map_size, map_zoom, &dx, &dy );
            x = win_int(dx);
            y = win_int(dy);

         }
      } while((pts = get_next_wgs84_nodes()) != NULL );
   }
}


// ==========================================================
// this one paints all types of LAT/LON lines
// whole values are solid lines
// intermediate lines are dotted
// ==========================================================
//char * pszLonLat = " %0.6f,%0.6f ";
char * pszLonLat = "%0.4f,%0.4f";

void paint_lat_lon_grid( HDC hdc, double c_lon, double c_lat,
                        double map_size, double map_zoom, PRECT prc )
{
   COLORREF crOld;
   HFONT hf = Get_CN8_Font( hdc );
   HFONT hfOld;
   HPEN hpGrid  = Get_GRID_Pen();
   HPEN hpGrid2 = Get_GRID2_Pen();
   HPEN hpOld;
   double dx, dy;
   double dlon, dlat;
   double rdx,rdy;
   double min_slat, max_slat, min_slon, max_slon;
   RECT  rc = *prc;
   int   x, y;
   int   last_x, last_y;
   PRECT prcp = &g_rcCornerPaints[0]; // store the corner paints
   int   i;
   int   total_polys = get_loaded_poly_count();
   int   enab_polys  = get_poly_enabled_count();

   min_slat = 2000.0;
   max_slat = -2000.0;
   min_slon = 2000.0;
   max_slon = -2000.0;
   SIZE sz;
   POINT pT;
   char * ps = _s_tmpbuf;  // temporary (SHARED) buffer
   int   iLen;

   get_CN8_Text_Size( hdc, &sz );
   prcp[RC_CENTER_SPACE].left = sz.cx;
   prcp[RC_CENTER_SPACE].right = prc->right - sz.cx;

   sprtf( "Paint: center lon,lat %0.4f,%0.4f, size %f, zoom %f\n",
      c_lon, c_lat, map_size, map_zoom );
   crOld = SetTextColor( hdc, crText );
   if(hf)
      hfOld = (HFONT)SelectObject(hdc, hf);
   if(hpGrid)
      hpOld = (HPEN)SelectObject(hdc, hpGrid);

   // get screen extents
   // =========================================
   // TOP LEFT
   dx = 0.0;
   dy = 0.0;
   win_pt2ll( &dlat, &dlon, c_lat, c_lon, map_size, map_zoom, dx, dy );
   iLen = sprintf(ps, pszLonLat, dlon, dlat );
   win_ll2pt( dlat, dlon, c_lat, c_lon, map_size, map_zoom, &rdx, &rdy );
   GetTextExtentPoint32( hdc, ps, iLen, &sz );
   pT.x = 0;
   pT.y = 0;
   TextOut( hdc, pT.x, pT.y, ps, iLen );
   prcp[RC_TOP_LEFT].left   = pT.x;
   prcp[RC_TOP_LEFT].right  = prcp->left + sz.cx;
   prcp[RC_TOP_LEFT].top    = pT.y;
   prcp[RC_TOP_LEFT].bottom = prcp->top + sz.cy;

   sprtf( "For %0.1f,%0.1f, put %s(%d) at %d,%d (sz %d,%d)(r %0.6f,%o.6f\n", dx, dy, ps, iLen,
      pT.x, pT.y, sz.cx, sz.cy, rdx, rdy);
   if( dlon < min_slon )
      min_slon = dlon;
   if( dlon > max_slon )
      max_slon = dlon;
   if( dlat < min_slat )
      min_slat = dlat;
   if( dlat > max_slat )
      max_slat = dlat;

   // TOP RIGHT
   dx = (double) rc.right;
   dy = 0.0;
   win_pt2ll( &dlat, &dlon, c_lat, c_lon, map_size, map_zoom, dx, dy );
   iLen = sprintf(ps, pszLonLat, dlon, dlat );
   win_ll2pt( dlat, dlon, c_lat, c_lon, map_size, map_zoom, &rdx, &rdy );
   GetTextExtentPoint32( hdc, ps, iLen, &sz );
   pT.x = rc.right - sz.cx - 2;
   pT.y = 0;
   TextOut( hdc, pT.x, pT.y, ps, iLen );
   prcp[RC_TOP_RIGHT].left   = pT.x;
   prcp[RC_TOP_RIGHT].right  = prcp->left + sz.cx;
   prcp[RC_TOP_RIGHT].top    = pT.y;
   prcp[RC_TOP_RIGHT].bottom = prcp->top + sz.cy;
   sprtf( "For %0.1f,%0.1f, put %s(%d) at %d,%d (sz %d,%d)(r %0.6f,%o.6f\n", dx, dy, ps, iLen,
      pT.x, pT.y, sz.cx, sz.cy, rdx, rdy);
   if( dlon < min_slon )
      min_slon = dlon;
   if( dlon > max_slon )
      max_slon = dlon;
   if( dlat < min_slat )
      min_slat = dlat;
   if( dlat > max_slat )
      max_slat = dlat;

   // BOTTOM RIGHT
   dx = (double) rc.right;
   dy = (double) rc.bottom;
   win_pt2ll( &dlat, &dlon, c_lat, c_lon, map_size, map_zoom, dx, dy );
   iLen = sprintf(ps, pszLonLat, dlon, dlat );
   win_ll2pt( dlat, dlon, c_lat, c_lon, map_size, map_zoom, &rdx, &rdy );
   GetTextExtentPoint32( hdc, ps, iLen, &sz );
   pT.x = rc.right - sz.cx - 2;
   pT.y = rc.bottom - sz.cy - 2;
   TextOut( hdc, pT.x, pT.y, ps, iLen );
   prcp[RC_BOTTOM_RIGHT].left   = pT.x;
   prcp[RC_BOTTOM_RIGHT].right  = prcp->left + sz.cx;
   prcp[RC_BOTTOM_RIGHT].top    = pT.y;
   prcp[RC_BOTTOM_RIGHT].bottom = prcp->top + sz.cy;
   sprtf( "For %0.1f,%0.1f, put %s(%d) at %d,%d (sz %d,%d)(r %0.6f,%o.6f\n", dx, dy, ps, iLen,
      pT.x, pT.y, sz.cx, sz.cy, rdx, rdy);
   if( dlon < min_slon )
      min_slon = dlon;
   if( dlon > max_slon )
      max_slon = dlon;
   if( dlat < min_slat )
      min_slat = dlat;
   if( dlat > max_slat )
      max_slat = dlat;

   // BOTTOM LEFT
   dx = 0.0;
   dy = (double) rc.bottom;
   win_pt2ll( &dlat, &dlon, c_lat, c_lon, map_size, map_zoom, dx, dy );
   iLen = sprintf(ps, pszLonLat, dlon, dlat );
   win_ll2pt( dlat, dlon, c_lat, c_lon, map_size, map_zoom, &rdx, &rdy );
   GetTextExtentPoint32( hdc, ps, iLen, &sz );
   pT.x = 0;
   pT.y = rc.bottom - sz.cy;
   TextOut( hdc, pT.x, pT.y, ps, iLen );
   prcp[RC_BOTTOM_LEFT].left   = pT.x;
   prcp[RC_BOTTOM_LEFT].right  = prcp->left + sz.cx;
   prcp[RC_BOTTOM_LEFT].top    = pT.y;
   prcp[RC_BOTTOM_LEFT].bottom = prcp->top + sz.cy;
   sprtf( "For %0.1f,%0.1f, put %s(%d) at %d,%d (sz %d,%d)(r %0.6f,%o.6f\n", dx, dy, ps, iLen,
      pT.x, pT.y, sz.cx, sz.cy, rdx, rdy);
   if( dlon < min_slon )
      min_slon = dlon;
   if( dlon > max_slon )
      max_slon = dlon;
   if( dlat < min_slat )
      min_slat = dlat;
   if( dlat > max_slat )
      max_slat = dlat;
   prcp[RC_CENTER_SPACE].bottom = rc.bottom - sz.cy;
   prcp[RC_CENTER_SPACE].top    = sz.cy;
   // =========================================
   sprintf(ps, "Enab(%d): ", total_polys);
   for( i = 0; i < 9; i++ ) {
      char c[2];
      c[1] = 0;
      if( is_poly_enabled(i) ) {
         c[0] = (i + '1');
      } else {
         c[0] = '-';
      }
      strcat(ps, c);
   }
   if( i < total_polys )
      strcat(ps,"+");
   sprintf(EndBuf(ps),"(%d)", enab_polys);
   sprintf( EndBuf(ps), " Zoom(M) %G", (map_zoom * 1000) );

   iLen = strlen(ps);
   GetTextExtentPoint32( hdc, ps, iLen, &sz );
   if( (prcp[RC_TOP_RIGHT].left - prcp[RC_TOP_LEFT].right) > sz.cx ) {
      pT.x = ((prcp[RC_TOP_RIGHT].left + prcp[RC_TOP_LEFT].right) / 2) - (sz.cx / 2);
      pT.y = 0;
      TextOut( hdc, pT.x, pT.y, ps, iLen );
      sprtf( "Put %s(%d) at x,y %d,%d (sz %d,%d)\n",
         ps, iLen, pT.x, pT.y, sz.cx, sz.cy );
   } else {
      sprtf( "NO put %s(%d) due to no space!\n",
         ps, iLen );
   }

   // =========================================
   // PAINT LON, LAT GRID
   // ----------------------
   if(hpGrid2)
      SelectObject(hdc, hpGrid2);

   double dfirst_lat, dstep_lat;
   double dfirst_lon, dstep_lon;
   int   lat_dec, lon_dec;
   int   lat_steps, lon_steps;
   int lat_ok = poly_get_dstep2( min_slat, max_slat,  // from here to here
               target_min, target_max,  // target min and max
               &dfirst_lat, &dstep_lat, // first value, and step
               &lat_steps, &lat_dec );  // last 2 can be NULL
   int lon_ok = poly_get_dstep2( min_slon, max_slon,  // from here to here
               target_min, target_max,  // target min and max
               &dfirst_lon, &dstep_lon, // first value, and step
               &lon_steps, &lon_dec );  // last 2 can be NULL

   int lat_count = 0;
   int lon_count = 0;
   int is_int;
   double step_dlat, step_dlon;
   // paint all grid stuff within these limits
   PRECT prcLimits = &prcp[RC_CENTER_SPACE];
   sprtf( "Rectangle limits left,top,right,bottom %s\n",
      get_rectangle_string(prcLimits) );

   //int imin_lon = (int)min_slon;
   //if((double)imin_lon < min_slon)
   //   imin_lon++;
   //int imin_lat = (int)min_slat;
   //if( (double)imin_lat < min_slat )
   //   imin_lat++;

   get_CN8_Text_Size( hdc, &sz );
   if(lon_ok)
   {
      for( step_dlon = dfirst_lon; step_dlon < max_slon; step_dlon += dstep_lon )
      {
         is_int = double_value_is_integer( step_dlon );
         get_ll2pt( max_slat, step_dlon, c_lat, c_lon, map_size, map_zoom, &dx, &dy );
         x = win_int(dx);
         y = win_int(dy);
         last_x = x;
         last_y = y;
         get_ll2pt( min_slat, step_dlon, c_lat, c_lon, map_size, map_zoom, &dx, &dy );
         x = win_int(dx);
         y = win_int(dy);
         if( is_int && hpGrid )
            SelectObject(hdc, hpGrid);
         else if( hpGrid2 )
            SelectObject(hdc, hpGrid2);
         // draw vertical lon grid line, but start it one
         // line down from the top, and stop one line from bottom
         if( y < prcLimits->top )
            y = prcLimits->top;
         if( y > prcLimits->bottom )
            y = prcLimits->bottom;
         if( last_y < prcLimits->top )
            last_y = prcLimits->top;
         if( last_y > prcLimits->bottom )
            last_y = prcLimits->bottom;

         draw_line( hdc, last_x, last_y, x, y );
         sprtf_showgrid( "Painted GRID lon %0.12g from %d,%d to %d,%d\n",
            step_dlon, last_x, last_y, x, y );
         if( is_int )
            iLen = sprintf(ps, " %d ", win_int(step_dlon));
         else
            iLen = sprintf(ps, " %g ", step_dlon);
         GetTextExtentPoint32( hdc, ps, iLen, &sz );
         pT.x = last_x - (sz.cx / 2);  // centered on top lon last_x
         pT.y = rc.top + sz.cy;        // 2nd line from top
         TextOut( hdc, pT.x, pT.y, ps, iLen );
         sprtf_showgrid( "Painted lon [%s] at %d,%d\n",
            ps, pT.x, pT.y );
         pT.x = x - (sz.cx / 2);          // centered on bottom lon x
         pT.y = rc.bottom - (2 * sz.cy);  // 2nd line from bottom
         TextOut( hdc, pT.x, pT.y, ps, iLen );
         sprtf_showgrid( "Painted lon [%s] at %d,%d\n",
            ps, pT.x, pT.y );
         lon_count++;   // count an integer lon painted
      }
   }
   if(lat_ok)
   {
      for( step_dlat = dfirst_lat; step_dlat < max_slat; step_dlat += dstep_lat )
      {
         is_int = double_value_is_integer( step_dlat );
         get_ll2pt( step_dlat, max_slon, c_lat, c_lon, map_size, map_zoom, &dx, &dy );
         x = win_int(dx);
         y = win_int(dy);
         last_x = x;
         last_y = y;
         get_ll2pt( step_dlat, min_slon, c_lat, c_lon, map_size, map_zoom, &dx, &dy );
         x = win_int(dx);
         y = win_int(dy);
         // avoid the bottom horizontal lat grid cutting up
         // the 2 bottom lines...
         if(( y >= (prcLimits->bottom - sz.cy))||
            ( last_y >= (prcLimits->bottom - sz.cy)))
            continue;
         // avoid the top horizontal lat grid cutting up
         // the 2 top lines...
         if(( y <= (prcLimits->top + sz.cy))||
            ( last_y <= (prcLimits->top + sz.cy)))
            continue;

         if( is_int && hpGrid )
            SelectObject(hdc, hpGrid);
         else if( hpGrid2 )
            SelectObject(hdc, hpGrid2);
         draw_line( hdc, last_x, last_y, x, y );
         sprtf_showgrid( "Painted GRID lat %0.12g from %d,%d to %d,%d\n",
            step_dlat, last_x, last_y, x, y );
         if( is_int )
            iLen = sprintf(ps, " %d ", win_int(step_dlat) );
         else
            iLen = sprintf(ps, " %g ", step_dlat );
         GetTextExtentPoint32( hdc, ps, iLen, &sz );
         pT.x = 0;                     // at left x
         pT.y = last_y - (sz.cy / 2);  // centered on lat line
         TextOut( hdc, pT.x, pT.y, ps, iLen );
         sprtf_showgrid( "Painted lat [%s] at %d,%d\n",
            ps, pT.x, pT.y );
         pT.x = rc.right - sz.cx;      // at right - length
         pT.y = y - (sz.cy / 2);       // centered on lat line
         TextOut( hdc, pT.x, pT.y, ps, iLen );
         sprtf_showgrid( "Painted lat [%s] at %d,%d\n",
            ps, pT.x, pT.y );
         lat_count++;   // count an integer lat painted
      }
   }

   // clean up
   // ========
   crOld = SetTextColor( hdc, crOld );
   if(hf)
      hfOld = (HFONT)SelectObject(hdc, hfOld);
   if(hpGrid)
      hpOld = (HPEN)SelectObject(hdc, hpOld);

}


//#define RC_TOP_LEFT     0
//#define RC_TOP_RIGHT    1
//#define RC_BOTTOM_RIGHT 2
//#define RC_BOTTOM_LEFT  3
void paint_center_bottom_to_DC( HDC hdc, char * ps )
{
   int   format = DT_CENTER | DT_SINGLELINE | DT_NOCLIP; // | DT_VCENTER;
   PRECT prcp = &g_rcCornerPaints[0]; // stored corner paints
   RECT  rc;
   HFONT hf = Get_CN8_Font(hdc);
   HFONT hfOld;
   char * pc = _s_center_bottom_text;
   int plen = strlen(pc);  // length of old, if any
   int len  = strlen(ps);  // length of new

   //GetWindowRect(g_hWnd, &rc);
   rc.left   = prcp[RC_BOTTOM_LEFT].right;
   rc.right  = prcp[RC_BOTTOM_RIGHT].left;
   rc.top    = prcp[RC_BOTTOM_LEFT].top;
   rc.bottom = prcp[RC_BOTTOM_RIGHT].bottom;
   if(hf)
      hfOld = (HFONT)SelectObject(hdc, hf);
   // remove any LAST text there
   if ( plen && (plen > len)) {
      for(int i = 0; i < plen; i++)
         pc[i] = ' '; // space it out
      // and use it to clear the area before next text
      DrawText( hdc, pc, plen, &rc, format );
   }

   DrawText( hdc, // handle to DC
      ps,         // text to draw
      len,        // text length
      &rc,        // formatting dimensions
      format );   // text-drawing options

   if(hf)
      hfOld = (HFONT)SelectObject(hdc, hfOld);
   strcpy( pc, ps );
}

void paint_center_text_to_DC( HDC hdc, char * ps )
{
   int   format = DT_CENTER | DT_SINGLELINE | DT_VCENTER | DT_NOCLIP;
   RECT  rc;
   HFONT hf = Get_CN8_Font( hdc );
   HFONT hfOld;
   COLORREF crOld;
   char * pc = _last_c_text;
   int len = strlen(ps);
   int plen = strlen(pc);
   if( !g_hWnd )
      return;

   GetWindowRect(g_hWnd, &rc);

   if(hf)
      hfOld = (HFONT)SelectObject(hdc, hf);
   crOld = SetTextColor( hdc, crCntr );

   if ( plen && (len < plen) ) {    // remove any LAST text there, if longer
      for(int i = 0; i < plen; i++)
         pc[i] = ' '; // space it out
      // and use it to clear the area before next text
      DrawText( hdc, pc, plen, &rc, format );
   }

   DrawText( hdc, // handle to DC
      ps,         // text to draw
      len,        // text length
      &rc,        // formatting dimensions
      format );   // text-drawing options

   SetTextColor( hdc, crOld );
   if(hf)
      SelectObject(hdc, hfOld);
   strcpy( pc, ps ); // update previous text
}

void paint_center_text_NOT_USED( char * ps )
{
   if(g_hWnd && ps && *ps) {
      HDC hdc = GetDC(g_hWnd);
      if(hdc) {
         paint_center_text_to_DC( hdc, ps );
         ReleaseDC(g_hWnd,hdc);
      }
   }
}
void paint_center_text( char * ps ) { paint_line_text( ps, 0 ); }

#define  MX_LINES    32
#define  MX_LINE_BUF 256
#define  DEF_BEGIN_LINE 1

static char _s_line_text[MX_LINES+1][MX_LINE_BUF];
static int done_line_init = 0;
static int next_line_text = 1;
int poly_indent_line = 5;

void do_line_init( void )
{
   done_line_init = 1;
   int i;
   for( i = 0; i < MX_LINES; i++ )
      _s_line_text[i][0] = 0;
   next_line_text = DEF_BEGIN_LINE;
}

void paint_line_text_to_DC( HDC hdc, char * ps, int line )
{
   int   format = DT_LEFT | DT_SINGLELINE | DT_NOCLIP;
   RECT  rc;
   HFONT hf = Get_CN8_Font( hdc );
   HFONT hfOld;
   COLORREF crOld;
   COLORREF cr = (line == 0) ? crTop : crText;
   SIZE sz;
   char * cp = &_s_line_text[line][0];
   int len = strlen(ps);
   int plen = strlen(cp);
   GetClientRect(g_hWnd, &rc);
   get_CN8_Text_Size( hdc, &sz );
   int tlines = rc.bottom / sz.cy;

   rc.top = sz.cy * line;
   rc.bottom = rc.top + sz.cy;
   rc.left = poly_indent_line;

   if( len > MX_LINE_BUF - 1 ) {
      // use additional buffer
      strncpy( &_s_line_text[MX_LINES][0], ps, MX_LINE_BUF - 1 );
      ps = &_s_line_text[MX_LINES][0];
      ps[MX_LINE_BUF - 1] = 0;
      len = strlen(ps);
   }

   if(hf)
      hfOld = (HFONT)SelectObject(hdc,hf);
   crOld = SetTextColor(hdc,cr);

   if( plen && (plen > len) && (line < tlines) )
   {
      for(int i = 0; i < plen; i++)
         cp[i] = ' ';
      DrawText( hdc, cp, plen, &rc, format );
   }

   strcpy(cp, ps);

   if(len && (line < tlines)) {
      DrawText( hdc, ps, len, &rc, format );
      sprtf( "LTXT %d: %s\n", line, ps );
   }
   if(hf)
      SelectObject(hdc,hfOld);
   SetTextColor(hdc,crOld);

}

void re_paint_lines_to_DC( HDC hdc )
{
   char * ps;
   int   i;
   for( i = 0; i < MX_LINES; i++ ) {
      ps = &_s_line_text[i][0];
      if( *ps )
         paint_line_text_to_DC( hdc, ps, i );
   }
}

void paint_line_text( char * ps, int line )
{
   if( !done_line_init )
      do_line_init();

   if( got_global_center ) // we have the polys on display
      return;  // so NOT line (debug) stuff...

   if(( line < MX_LINES ) && g_hWnd ) {
      HDC hdc = GetDC(g_hWnd);
      if(hdc) {
         paint_line_text_to_DC( hdc, ps, line );
      }
   }
}

void paint_next_line_text( char * ps )
{
   if( next_line_text >= MX_LINES )
      next_line_text = DEF_BEGIN_LINE;
   paint_line_text( ps, next_line_text );
   next_line_text++;
   if( next_line_text >= MX_LINES )
      next_line_text = DEF_BEGIN_LINE;
   paint_line_text( "", next_line_text );
}

void re_paint_lines( void )
{
   char * ps;
   int   i;
   for( i = 0; i < MX_LINES; i++ ) {
      ps = &_s_line_text[i][0];
      if( *ps )
         paint_line_text( ps, i );
   }
}

void paint_center_bottom( char * ps )
{
   if(g_hWnd) {
      HDC hdc = GetDC(g_hWnd);
      if(hdc) {
         paint_center_bottom_to_DC( hdc, ps );
         ReleaseDC(g_hWnd,hdc);
      }
   }
}

void paint_mouse_coordinates( int x, int y, int shift, int ctrl )
{
   if ( !got_global_center )
      return;
   // paint to bottom line
   static char _s_mousecoord[256];
   char * ps = _s_mousecoord;
   double dlat, dlon;
   double dx = (double)x;
   double dy = (double)y;
   int iLen = 0;
   size_t max = paintPoints.size();
   size_t i;
   //PPolyGlobs ppg = get_poly_globs();
   mm_pt2ll( &dlat, &dlon,
      dx, dy );
   *ps = 0;
   if( shift ) {
      SGBucket b( dlon, dlat );
      iLen = sprintf(ps, "%s/%s", b.gen_base_path().c_str(),
         b.gen_index_str().c_str() );
   } else {
      iLen = sprintf(ps, " %0.6f,%0.6f ", dlon, dlat );
   }
   if( ctrl && max ) {
      PP pp;
      POINT pp2, pp3;
      size_t closest = -1;
      for(i = 0; i < max; i++) {
         pp = paintPoints[i];
         pp2.x = pp.pt.x + 1;
         pp3.x = pp.pt.x - 1;
         pp2.y = pp.pt.y + 1;
         pp3.y = pp.pt.y - 1;
         if(( pp.pt.x == x )&&
            ( pp.pt.y == y )) {
               break;
         }
         if(( x >= pp3.x )&& ( x <= pp2.x )&&
            ( y >= pp3.y )&& ( y >= pp2.y ))
            closest = i;
      }
      if( i < max ) {
         double diflat = fabs( pp.lat - dlat );
         double diflon = fabs( pp.lon - dlon );
         iLen = sprintf(EndBuf(ps), " e=%0.6f,%0.6f ", pp.lon, pp.lat );
         sprtf("Compare: %s pt x,y %d,%d (D=%0.6f,%06f)\n", ps, x, y, diflon, diflat);
      } else if( closest != -1 ) {
         pp = paintPoints[closest];
         iLen = sprintf(EndBuf(ps), " c=%0.6f,%0.6f ", pp.lon, pp.lat );
      }
   }
   paint_center_bottom(ps);
}

// ******************************************************************

//	SetBkColor(crOldBack);
//	oldcr = SetTextColor(hdc, cr);
//double xdist = ppc->pdist.lon();
//double ydist = ppc->pdist.lat();
//min_lat = ppc->pmin.lat();
//min_lon = ppc->pmin.lon();
//max_lat = ppc->pmax.lat();
//max_lon = ppc->pmax.lon();
// **********************************************************
// main paint service
// **********************************************************

void add_painted_point( int x, int y, double lon, double lat )
{
   POINT p;
   PP pp;
   p.x = x; p.y = y;
   pp.pt.x = x; pp.pt.y = y; pp.lat = lat; pp.lon = lon;
   painted_points.push_back(p);
   paintPoints.push_back(pp);
}

static int add_one_more = 0;
// debug
static int debug_fill_service = 0;

void fill_polygon( HDC hdc, PRECT prc )
{
   int   i, max;
   HBRUSH hb = get_act_brush();
   max = painted_points.size();
   if((max > 2) && hb) {  
      // convert vector to simple array
      // BUT if some point off screen, then HOW to 'fix'
      // the points so they correctly have only an 
      // 'inside'... even when all ON-SCREEN
      PPOINT pp = new POINT[max + 1];
      if(pp) {
         for( i = 0; i < max; i++ ) {
            pp[i] = painted_points[i];
         }
         pp[i] = pp[0];
         if(add_one_more)
            max++;
         if( debug_fill_service ) {
            int i2;
            HPEN hp = Get_Purp_Pen();
            HPEN hpold;
            if(hp)
               hpold = (HPEN)SelectObject(hdc,hp);
            for( i = 0; i < max; i++ ) {
               i2 = i + 1;
               if( i2 >= max )
                  i2 = 0;
               POINT pt1 = pp[i];
               POINT pt2 = pp[i2];
               pt1.x += 1;
               pt1.y += 1;
               pt2.x += 1;
               pt2.y += 1;
               draw_line(hdc, pt1.x, pt1.y, pt2.x, pt2.y );
            }
            if(hp)
               SelectObject(hdc,hpold);
         } else {
            //HRGN hRgn = CreatePolygonRgn( pp, max, WINDING );
            HRGN hRgn = CreatePolygonRgn( pp, max, ALTERNATE );
            if(hRgn) {
               sprtf( "Filled region: %d points.\n", max );
               FillRgn( hdc, hRgn, hb );
               DeleteObject( hRgn );
            } else {
               sprtf( "FAILED CreatePolygonRgn %d points.\n", max );
            }
         }
         delete pp;
      }
   } else if(hb) {
      sprtf( "No fill of region: just %d points.\n", max );
   } else {
      sprtf( "No fill of region: %d points, but NO BRUSH.\n", max );
   }
}

void paint_pixel_X( HDC hdc, int x, int y, COLORREF cr, int spread )
{
   if( spread < 1 ) {
      SetPixel( hdc, x, y, cr ); // paint the POINT
   } else {
      draw_line(hdc, x - spread, y - spread, x + spread, y + spread);
      draw_line(hdc, x - spread, y + spread, x + spread, y - spread);
   }
}

void paint_poly_OK_BUT( HWND hwnd, HDC hdc )
{
   RECT rc;
   TGPolyLoad * polyload = NULL;
   RECT mm;
   int points_painted = 0;
   double map_size = 600.0;
   int polys_painted = 0;
   double dlon, dlat, rdx, rdy;
   int   cnum;
   sGETPT sgp;
   int last_contour;
   HPEN  hp, hpOld;
   PPolyGlobs ppg = get_poly_globs();
   double map_zoom = ppg->g_map_zoom;
   int large = ((map_zoom < 0.001) ? 0 : win_int(map_zoom * 1000.0));
   GetClientRect( hwnd, &g_rcClient );
   rc = g_rcClient;
   sprtf( "\nPaint: Got window size x,y %s\n", get_rectangle_string(&rc)  );
   if( rc.right > rc.bottom )
      map_size = (double)rc.right;
   else
      map_size = (double)rc.bottom;
   ppg->g_map_size = map_size;
   g_got_map_size = 1;
   if( !done_arguments ) {
      sprtf("Not done arguments...\n");
      paint_line_text_to_DC( hdc, "Not done arguments...", 1 );
      re_paint_lines_to_DC( hdc );
      return;
   }
   polyload = get_first_loaded_poly();
   if( !polyload ) {
      sprtf("No polys loaded...\n");
      paint_line_text_to_DC( hdc, "No polys loaded...", 1 );
      re_paint_lines_to_DC( hdc );
      return;
   }
   if( get_poly_enabled_count() == 0 ) {
      sprtf("No polys enabled...\n");
      paint_line_text_to_DC( hdc, "No polys enabled...", 1 );
      re_paint_lines_to_DC( hdc );
      return;
   }

   double c_lon = mm_c_lon;
   double c_lat = mm_c_lat;
   int points_outside;
   got_global_center = 1;
   paint_lat_lon_grid( hdc, c_lon, c_lat, map_size, map_zoom, &rc );

   mm.bottom = -10000;
   mm.left   =  10000;
   mm.right  = -10000;
   mm.top    =  10000;
   sgp.pcnum = &cnum;
   sgp.px    = &dlon;
   sgp.py    = &dlat;
   g_map_next_color = 0;
   points_painted = 0;
   points_outside = 0;
   clear_painted_points();
   clear_paintPoints();
   polyload = get_first_loaded_poly();
   do {
      PPolyCounter ppc = Get_Poly_Counts();
      COLORREF cr = get_next_color();  //RGB(255,0,0);
      //hp = Get_Solid_Pen_1(cr);
      hp = Get_Act_Pen();
      if(hp)
         hpOld = (HPEN)SelectObject(hdc,hp);

      if ( ppc->total && is_current_poly_enabled() )
      {
         double dx, dy;
         int x, y, last_x, last_y, first_x, first_y;
         polys_painted++;
         // === BEGIN PAINT POINTS ===
         last_contour = -1; // restart contour number
         void * vp = get_first_point( &sgp );
         if ( vp ) {
            last_x = last_y = first_x = first_y = -1;
            do {
               win_ll2pt( dlat, dlon, c_lat, c_lon, map_size, map_zoom, &dx, &dy );
               x = win_int(dx);
               y = win_int(dy);
               if( cnum != last_contour ) {  // if NOT SAME group
                  sprtf("Changed contour %d (from %d)\n", cnum, last_contour);
               }
               if( paint_all_points ||
                  (( x >= rc.left  ) &&
                  ( x <= rc.right ) &&
                  ( y >= rc.top   ) &&
                  ( y <= rc.bottom))) {
                  // ===================================================
                  // point is in screen RANGE
                  if(( x != last_x ) || ( y != last_y )) {
                     paint_pixel_X( hdc, x, y, cr, large );
                     add_painted_point( x, y, dlon, dlat );
                     sprtf_showpoint( "Pxy: %0.6f,%0.6f at %d,%d in %s\n",
                        dlon, dlat, x, y, g_act_color ); 
                     points_painted++; // count a painted point
                     if( ppg->g_join_poly_points ) {
                        if( cnum == last_contour ) {  // if SAME group
                           draw_line( hdc, last_x, last_y, x, y ); // join with pen
                           sprtf_showpoint( "Pln: %d,%d to %d,%d in %s (c=%d)\n",
                              last_x, last_y, x, y,
                              g_act_color, cnum ); 
                        } else {
                           if( ppg->g_join_first_to_last ) {
                              if((first_x != -1) &&
                                 (last_x  != -1) &&
                                 (last_y  != -1) &&
                                 (first_y != -1) ) {
                                 draw_line( hdc, first_x, first_y, last_x, last_y ); // join with pen
                                 sprtf_showpoint( "Pln: %d,%d to %d,%d (1st2last) in %s\n",
                                    first_x, first_y, last_x, last_y,
                                    g_act_color ); 
                              }
                              if(ppg->g_fill_polygon &&
                                 (points_outside == 0)) {
                                 //add_painted_point( first_x, first_y );
                                 fill_polygon(hdc, &rc);
                              }
                           }
                           first_x = x;
                           first_y = y;
                           sprtf_showpoint( "Pln: NONE contour %d to %d\n", last_contour, cnum ); 
                           last_contour = cnum; // not same contour, just update number
                           clear_painted_points();
                        }
                     }
                     last_x = x;
                     last_y = y;
                     if( x < mm.left )
                        mm.left = x;
                     if( x > mm.right )
                        mm.right = x;
                     if( y < mm.top )
                        mm.top = y;
                     if( y > mm.bottom )
                        mm.bottom = y;
                  }
                  if( cnum != last_contour ) { // if NOT SAME group
                     points_outside = 0;  // for new polygon, clear outside points
                     last_x = -1;  // have NOT had last
                     last_y = -1;
                  }
               } else {
                  last_contour = -1;
                  sprtf_showpoint( "Pxy: OFF SCREEN %0.6f,%0.6f at %d,%d\n", dlon, dlat, x, y ); 
                  clear_painted_points();
                  if( cnum != last_contour ) {  // if NOT SAME group
                     points_outside = 0;  // for new group, clear outside points
                  } else {
                     points_outside++; // same group, and outside
                  }
               }
            } while (( vp = get_next_point( vp, &sgp ) ) != NULL );
            // OUT OF POINTS
            // ======== try for last join, if ok =======
            if( ppg->g_join_poly_points && ppg->g_join_first_to_last &&
               add_last_join )  {
               // if all in range
               if(( last_x >= rc.left  ) &&
                  ( last_x <= rc.right ) &&
                  ( last_y >= rc.top   ) &&
                  ( last_y <= rc.bottom) &&
                  ( first_x >= rc.left  ) &&
                  ( first_x <= rc.right ) &&
                  ( first_y >= rc.top   ) &&
                  ( first_y <= rc.bottom))
               {
                  draw_line( hdc, first_x, first_y, last_x, last_y ); // join with pen
                  sprtf_showpoint( "Pln: %d,%d to %d,%d (1st2last) in %s\n",
                     first_x, first_y, last_x, last_y, g_act_color );
               }
            }
            // =============================================================
         }  // if vp - got first point
         // === END PAINT POINTS ===
      }
      if(hp) {
         hpOld = (HPEN)SelectObject(hdc,hpOld);
         //DeleteObject(hp);
      }
      // skip to next poly set loaded
   } while( (polyload = get_next_loaded_poly()) != NULL );

   if( points_painted ) {
      if( ppg->g_paint_bounding_box )
         paint_bounding_box( hdc, &mm );
      if( ppg->g_paint_airports )
         paint_airports( hdc, c_lat, c_lon, map_size, map_zoom, &rc ); 
   } else {
      //paint_center_text_to_DC( hdc, "No points painted!" );
      paint_line_text_to_DC( hdc, "No points painted!", 0 );
   }
   _s_center_bottom_text[0] = 0; // we are bitblt-ing this HDC, so NO bottom text
}

// **************************************************************************
#define IN_SCREEN_RANGE(x,y,r) (( x >= r.left ) && \
   ( x <= r.right ) && ( y >= r.top ) && ( y <= r.bottom))

#define  VALID_FIRST_LAST  ((first_x != -1)&& \
   (last_x  != -1)&& \
   (last_y  != -1)&& \
   (first_y != -1)&& \
   !((first_x == last_x)&&(first_y == last_y)) )

void paint_poly( HWND hwnd, HDC hdc )
{
   RECT rc;
   TGPolyLoad * polyload = NULL;
   RECT mm;
   int points_painted = 0;
   double map_size = 600.0;
   int polys_painted = 0;
   double dlon, dlat, rdx, rdy;
   int   cnum;
   sGETPT sgp;
   int last_contour;
   HPEN  hp, hpOld;
   PPolyGlobs ppg = get_poly_globs();
   double map_zoom = ppg->g_map_zoom;
   int large = ((map_zoom < 0.001) ? 0 : win_int(map_zoom * 1000.0));
   GetClientRect( hwnd, &g_rcClient );
   rc = g_rcClient;
   sprtf( "\nPaint: Got window size x,y %s\n", get_rectangle_string(&rc)  );
   if( rc.right > rc.bottom )
      map_size = (double)rc.right;
   else
      map_size = (double)rc.bottom;
   ppg->g_map_size = map_size;
   g_got_map_size = 1;
   if( !done_arguments ) {
      sprtf("Not done arguments...\n");
      paint_line_text_to_DC( hdc, "Not done arguments...", 1 );
      re_paint_lines_to_DC( hdc );
      return;
   }
   polyload = get_first_loaded_poly();
   if( !polyload ) {
      sprtf("No polys loaded...\n");
      paint_line_text_to_DC( hdc, "No polys loaded...", 1 );
      re_paint_lines_to_DC( hdc );
      return;
   }
   if( get_poly_enabled_count() == 0 ) {
      sprtf("No polys enabled...\n");
      paint_line_text_to_DC( hdc, "No polys enabled...", 1 );
      re_paint_lines_to_DC( hdc );
      return;
   }

   double c_lon = mm_c_lon;
   double c_lat = mm_c_lat;
   int points_outside;
   got_global_center = 1;
   paint_lat_lon_grid( hdc, c_lon, c_lat, map_size, map_zoom, &rc );

   paint_scenery( hdc, c_lon, c_lat, map_size, map_zoom, &rc );

   mm.bottom = -10000;
   mm.left   =  10000;
   mm.right  = -10000;
   mm.top    =  10000;
   sgp.pcnum = &cnum;
   sgp.px    = &dlon;
   sgp.py    = &dlat;
   g_map_next_color = 0;
   points_painted = 0;
   points_outside = 0;
   clear_painted_points();
   clear_paintPoints();
   polyload = get_first_loaded_poly();
   do {
      PPolyCounter ppc = Get_Poly_Counts();
      COLORREF cr = get_next_color();  //RGB(255,0,0);
      //hp = Get_Solid_Pen_1(cr);
      hp = Get_Act_Pen();
      if(hp)
         hpOld = (HPEN)SelectObject(hdc,hp);

      if ( ppc->total && is_current_poly_enabled() )
      {
         double dx, dy;
         int x, y, last_x, last_y, first_x, first_y;
         int to_paint;
         polys_painted++;
         // === BEGIN PAINT POINTS ===
         last_contour = -1; // restart contour number
         void * vp = get_first_point( &sgp );
         if ( vp ) {
            last_x = last_y = first_x = first_y = -1;
            do {
               win_ll2pt( dlat, dlon, c_lat, c_lon, map_size, map_zoom, &dx, &dy );
               x = win_int(dx);
               y = win_int(dy);
               to_paint = (( paint_all_points || IN_SCREEN_RANGE(x,y,rc)) ? 1 : 0 );
               if( cnum != last_contour ) {
                  // things to do BEFORE dealing with this NEW point
                  sprtf("Changed contour %d (from %d)\n", cnum, last_contour);
                  if( ppg->g_join_first_to_last ) {
                     if(VALID_FIRST_LAST) {
                        draw_line( hdc, first_x, first_y, last_x, last_y ); // join with pen
                        sprtf_showpoint( "Pln: %d,%d to %d,%d (1st2last) in %s\n",
                           first_x, first_y, last_x, last_y,
                           g_act_color ); 
                     }
                     if(ppg->g_fill_polygon) {
                        fill_polygon(hdc, &rc);
                     }
                  }
                  first_x = x;
                  first_y = y;
                  last_x = -1;
                  last_y = -1;
                  last_contour = cnum; // not same contour, just update number
                  clear_painted_points();
               }
               if( to_paint ) {
                  paint_pixel_X( hdc, x, y, cr, large );
                  add_painted_point( x, y, dlon, dlat );
                  sprtf_showpoint( "Pxy: %0.6f,%0.6f at %d,%d in %s\n",
                     dlon, dlat, x, y, g_act_color ); 
                  points_painted++; // count a painted point
                  if( ppg->g_join_poly_points ) {
                     if((last_x != -1)&&(last_y != -1)) {
                        draw_line( hdc, last_x, last_y, x, y ); // join with pen
                        sprtf_showpoint( "Pln: %d,%d to %d,%d in %s (c=%d)\n",
                           last_x, last_y, x, y,
                           g_act_color, cnum ); 
                     }
                  }
                  last_x = x;
                  last_y = y;
                  if( x < mm.left )
                     mm.left = x;
                  if( x > mm.right )
                     mm.right = x;
                  if( y < mm.top )
                     mm.top = y;
                  if( y > mm.bottom )
                     mm.bottom = y;
               } else {
                  last_contour = -1;
                  sprtf_showpoint( "Pxy: OFF SCREEN %0.6f,%0.6f at %d,%d\n", dlon, dlat, x, y ); 
                  points_outside++; // same group, and outside
                  last_x = -1;
                  last_y = -1;
               }
            } while (( vp = get_next_point( vp, &sgp ) ) != NULL );
            // OUT OF POINTS
            // ======== try for last join, if ok =======
            if( ppg->g_join_poly_points && ppg->g_join_first_to_last &&
               add_last_join )  {
               // if all in range
               if( VALID_FIRST_LAST &&
                  (paint_all_points ||
                  (IN_SCREEN_RANGE(last_x,last_y,rc) &&
                  IN_SCREEN_RANGE(first_x,first_y,rc) &&
                  VALID_FIRST_LAST ) ) )
               {
                  draw_line( hdc, first_x, first_y, last_x, last_y ); // join with pen
                  sprtf_showpoint( "Pln: %d,%d to %d,%d (1st2last) in %s\n",
                     first_x, first_y, last_x, last_y, g_act_color );
               }
            }
            // =============================================================
         }  // if vp - got first point
         // === END PAINT POINTS ===
      }
      if(hp) {
         hpOld = (HPEN)SelectObject(hdc,hpOld);
         //DeleteObject(hp);
      }
      // skip to next poly set loaded
   } while( (polyload = get_next_loaded_poly()) != NULL );

   if( points_painted ) {
      if( ppg->g_paint_bounding_box )
         paint_bounding_box( hdc, &mm );
      if( ppg->g_paint_airports )
         paint_airports( hdc, c_lat, c_lon, map_size, map_zoom, &rc ); 
   } else {
      //paint_center_text_to_DC( hdc, "No points painted!" );
      paint_line_text_to_DC( hdc, "No points painted!", 0 );
   }
   _s_center_bottom_text[0] = 0; // we are bitblt-ing this HDC, so NO bottom text
}


// ===========================================================================
// eof - poly-paint.cxx
