using System;
using System.IO;
using System.Text.RegularExpressions;
using System.Collections;
// using System.Security.Permissions;
using System.Globalization;
using System.Threading; // for Sleep

// nice simple source from http://sourceforge.net/project/showfiles.php?group_id=100017
// 02/09/2008  15:59  46,229 xdel.source.1.0.zip
// Written by John Lauer. Bugs and comments to: jlauer@simplewire.com.
// 02/09/2008  Add some PERSONAL changes - geoff r mclane
namespace xdel
{
	/// <summary>
	/// Summary description for Class1.
	/// </summary>
    class App
    {
        static DateTime ctime;
        static bool usectime = false;
        static DateTime mtime;
        static bool usemtime = false;
        static bool filesonly = true;
        static bool dirsonly = false;
        static bool listonly = false;
        static bool dodelete = false;   // must add -dodelete before action
        static bool recurse = false;    // allow -r
        static string directory = "";
        static string pattern = "";
        static bool debug = false;
        static bool dolog = false;
        static bool append = true;
        static int verbose = 0;    // similar to -debug but can use -v
        static string cmdline;
        static System.Collections.ArrayList missed = new ArrayList();
        static System.Collections.ArrayList Items = new ArrayList();
        private static System.IO.StreamWriter sw = null;
        static int delcount = 0;
        static Int64 deltotal = 0;
        static Int64 nodel_total = 0;
        static Int64 skippedtotal = 0;
        static Int64 grandtotal = 0;
        static Int64 diskblock = 4096; // assumed disk BLOCK size
        static System.Collections.ArrayList DbgStgs = new ArrayList();
        static Int64 maxnamelen = 0;
        static Int64 maxfilesiz = 0;
        static Int64 maxnumlen = 9;
        static bool oldway = false;
        static bool enumcultures = false;
        static string datetimeform = "en-GB"; // default dd/mm/YYYY HH:MM:SS
        static bool force_option = false;
        static string logfile = "xdel.log.txt";
        static bool please_NO_confirmation = false;
        static int waitforsecs = 30;
        static MyStats mystats = new MyStats();

        /// <summary>
        /// The main entry point for the application.
        /// </summary>
        [STAThread]
        static int Main(string[] args)
        {
            string s;
            ClearMyStats();
            if (args.Length == 0)
            {
                App.Help();
                return 1;
            }
            // check for -dolog first
            //if (String.Join(",", args).IndexOf("-dolog") >= 0)
            //    dolog = true;
            //also set culture, if present ... which is enumerated to check
            if (ScanForSpecials(args) > 0)
                return 2;

            cmdline = String.Join(" ", args);

            WriteLine("Run at: " + DateTime.Now + ", in directory [" +
                Directory.GetCurrentDirectory() + "]");

            // OK, the following showed the FIRST is NOT
            // the runtime file name - stranger things can happen
            // for (ctr = 0; ctr < args.Length; ctr++){ WriteLine(args[ctr]); }
            if (ParseArguments(args) > 0)
                return 2;

            if (enumcultures)
            {
                //dolog = true;
                //append = false;
                ParseDateTime(true);
                return 1;
            }
            // now get all the files/dirs in the dir/pattern to look at
            WriteLine("Directory: " + directory);
            WriteLine("Pattern: " + pattern);
            // do recursive search, in ALL cases, to get totals
            // and to check if any file is marked READ-ONLY,
            // which BLOCKS the operation ...
            GetFilesRecurse(".", directory, 0);
            SetChildDelete();   // propogate any directory delete to the children
            // loop thru file list
            // if dirsonly, reverse the order (NOT)
            WriteLine("Scanned " + Items.Count + " items ...");

            if (verbose > 9)
            {
                int scnt = 0;
                foreach (Object oj in DbgStgs)
                {
                    string dbs = (string)oj;
                    scnt++;
                    WriteLine(" " + scnt + dbs);
                }
            }

            delcount = 0;
            foreach (object obj in Items)
            {
                Class1 cref = (Class1)obj;
                if (cref.to_delete)
                    delcount++;
                Int64 nlen = cref.file.FullName.Length;
                if (nlen > maxnamelen)
                    maxnamelen = nlen;
                if (cref.size > maxfilesiz)
                    maxfilesiz = cref.size;
            }
            ShowMyStats(true);

            // add in    'DEL: <DIR> '
            maxnamelen += 12;
            s = " " + maxfilesiz;
            maxnumlen = s.Length;
            if (delcount == 0)
            {
                WriteLine("With present command, found nothing to delete!");
                //if (!filesonly && !dirsonly){
                //    WriteLine("No TYPE given - neither filesonly, nor dirsonly found ...");
                //} else if (!usectime && !usemtime){
                //    WriteLine("No TIME given - neither ctime, nor mtime=now-nd found ...");
                //} else
                if (Items.Count > 0)
                {
                    if (usectime)
                        WriteLine("No objects created earlier than " + ctime.ToString());

                    if (usemtime)
                        WriteLine("No objects modified earlier than " + mtime.ToString());
                }
            }
            else
            {
                WriteLine("Found " + delcount + " objects to delete.");
                if (listonly || !dodelete)
                {
                    Write("but will only list them, due to ");
                    if (listonly == true)
                        Write("listonly is ON");
                    else
                        Write("dodelete is OFF");
                    WriteLine("!");
                }
            }
            bool savelist = listonly;
            listonly = true;
            bool confirmed = false;
            ProcessItems();
            listonly = savelist;
            if (delcount > 0)
            {
                ShowMyStats(true);
                Write("Listed " + delcount + " for DELETION");
                if (listonly || !dodelete)
                {
                    if (listonly)
                    {
                        Write(", but listonly is ON. Remove the -listonly");
                        if (!dodelete)
                            Write(", and add -dodelete");
                    }
                    else
                    {
                        Write(", but dodelete is OFF. Add -dodelete to the command.");
                    }
                    WriteLine("!");
                }
                else
                {
                    WriteLine(". Confirmation required. Use 'Y' key, and <Enter>");
                    string inp = GetConfirmation("Proceed with DELETION? : ");
                    if ((inp.Length > 0) && (inp.Substring(0, 1).ToLower() == "y"))
                    {
                        ShowMyStats(false);
                        inp = GetConfirmation("ARE YOU *** REALLY *** SURE? : ");
                        if ((inp.Length > 0) && (inp.Substring(0, 1).ToLower() == "y"))
                        {
                            confirmed = true;
                        }
                        else
                        {
                            WriteLine("No confirmation. No deletions. Aborting process ...");
                        }
                    }
                    else
                    {
                        WriteLine("No confirmation. No deletions. Aborting process ...");
                    }
                }
            }
            if (confirmed)
            {
                WriteLine("Proceeding with actual DELETION ...");
                ProcessItems();
            }
            Write("Finished at: " + DateTime.Now);
            if (deltotal > 0)
            {
                Write(", deleted (approx) " + deltotal + " bytes");
                if (deltotal == grandtotal)
                    Write(" (=all found)");
                else
                    Write(", of about " + grandtotal);
                if (verbose > 1)
                {
                    if (grandtotal > deltotal)
                        Write(", difference " + (grandtotal - deltotal));
                    else if (deltotal > grandtotal)
                        Write(", ne.diff? " + (grandtotal - deltotal));
                    if (skippedtotal > 0)
                        Write(", skipped " + skippedtotal);
                    if (nodel_total > 0)
                        Write(", no delete " + nodel_total);
                }
            }
            WriteLine("");

            if (sw != null) sw.Close();
            return 0;     // return to the OS
        }

        private static void WriteFileInfo(Class1 cref)
        {
            bool is_dir = cref.is_dir;
            string typ = cref.type;
            //Write("analyzing: " + typ + file.FullName);
            Write("analyzing: " + typ + " " + cref.file.Name);
            if (verbose > 0)
            {
                if (!is_dir)
                {
                    System.IO.FileInfo i = new System.IO.FileInfo(cref.file.FullName);
                    Write(", size: " + i.Length);
                    Write(", lastwrite: " + cref.file.LastWriteTime);
                }
            }
            WriteLine("");
        }

        private static void WriteOps(string txt, string value)
        {
            Write(txt + "=" + value + " ");
        }
        private static void WriteOpt(string txt, bool opt)
        {
            Log(txt, true);
            if (opt) Write("=On ");
            else Write("=Off ");
        }
        private static void Write(string txt)
        {
            Log(txt, true);
        }

        private static void WriteLine(string txt)
        {
            Log(txt, false);
        }

        private static string WaitForSecs(int secs)
        {
            string res = "y";
            ConsoleKeyInfo cki = new ConsoleKeyInfo();
            int ms = secs * 1000;
            while (ms > 0)
            {
                Thread.Sleep(55);
                if (ms > 55)
                    ms -= 55;
                else
                    ms = 0;
                if (Console.KeyAvailable)
                {
                    cki = Console.ReadKey();
                    if (cki.Key != ConsoleKey.Y)
                    {
                        res = "N";
                    }
                    while (Console.KeyAvailable)
                        cki = Console.ReadKey();

                    break;
                }
            }
            return res;
        }

        private static string GetConfirmation(string msg)
        {
            string line;
            if (msg.Length > 0) Write(msg);
            if (please_NO_confirmation)
            {
                WriteLine("please-NO-confirmation is ON");
                Write("but WAITING " + waitforsecs + " seconds, just in case : ");
                line = WaitForSecs(waitforsecs);
                WriteLine(line);
            }
            else
            {
                line = Console.ReadLine();
            }
            return line;
        }

        private static void Log(string txt, bool noNewline)
        {
            // see if need to create a log
            if (dolog == true)
            {
                // append to, or start new log log file
                if (sw == null)
                {
                    sw = new System.IO.StreamWriter(logfile, append);
                    sw.WriteLine("file: " + logfile);
                }

                if (noNewline)
                    sw.Write(txt);
                else
                    sw.WriteLine(txt);

                sw.Flush(); // ensure it IS written to disk NOW
            }

            if (noNewline)
                Console.Write(txt);
            else
                Console.WriteLine(txt);
        }

        private static int CheckIfExists(string p)
        {
            if (System.IO.File.Exists(p))
                return 1;
            else if (System.IO.Directory.Exists(p))
                return 2;

            return 0;
        }

        private static bool CheckIfDirectory(string p)
        {
            // this func is necessary because directories appear
            // as files when they are using operating system compression
            //System.IO.FileInfo i = new System.IO.FileInfo(p);
            // bool exists = System.IO.File.Exists(p);
            return System.IO.Directory.Exists(p);
        }

        private static bool InItemList(string name)
        {
            foreach (Object obj in Items)
            {
                Class1 cref = (Class1)obj;
                if (cref.file.FullName == name)
                    return true;
            }
            return false;
        }

        private static void GetFilesRecurse(string parent, string dirname, int level)
        {
            // we will push all of our files onto the ArrayList
            // and dirctories found
            string p;
            Dirs d;
            Object obj;
            Class1 cref;
            Int64 iSize;
            System.IO.FileInfo i;
            System.Collections.ArrayList dirs = new ArrayList();
            DirectoryInfo dir = new DirectoryInfo(dirname);
            FileSystemInfo[] f = dir.GetFileSystemInfos(pattern);
            foreach (FileSystemInfo file in f)
            {
                cref = new Class1();
                cref.file = file;
                cref.to_delete = false;
                cref.size = 0;      // start size as zero
                cref.is_dir = App.CheckIfDirectory(file.FullName);
                cref.level = level;
                cref.parent = parent;
                cref.is_deleted = false;
                if (cref.is_dir)
                {
                    mystats.dir_count++;
                    cref.type = "<DIR>";
                }
                else
                {
                    mystats.file_count++;
                    cref.type = "<FIL>";
                }

                if (debug) WriteFileInfo(cref);

                if (cref.is_dir)
                {
                    mystats.disk_total += GetiSize(0);
                    if (dirsonly)
                    {
                        if ((level == 0) || (recurse))
                        {
                            if (((usectime == true) && (file.CreationTime < ctime)) ||
                                ((usemtime == true) && (file.LastWriteTime < mtime)))
                            {
                                cref.to_delete = true;
                                mystats.dirs_to_delete++;
                            }
                        }
                    }
                }
                else
                {
                    // is a FILE - get Length and RO attribute
                    i = new System.IO.FileInfo(file.FullName);
                    cref.size = i.Length;
                    // maybe this is the SAME thing!!!
                    cref.is_ro = (i.IsReadOnly || ((i.Attributes & FileAttributes.ReadOnly) != 0));
                    mystats.disk_total += GetiSize(cref.size);
                    if (filesonly)
                    {
                        if ((level == 0) || (recurse))
                        {
                            if (((usectime == true) && (file.CreationTime < ctime)) ||
                                ((usemtime == true) && (file.LastWriteTime < mtime)))
                            {
                                mystats.files_to_delete++;
                                cref.to_delete = true;
                            }
                        }
                    }
                }
                iSize = GetiSize(cref.size);
                grandtotal += iSize;
                AddToDbg(cref, "RC:" + parent);
                Items.Add(cref);
                //if (file.Attributes == System.IO.FileAttributes.Directory)
                if (cref.is_dir)
                {
                    d = new Dirs();
                    p = parent + "\\" + file.Name;
                    d.parent = p;
                    d.directory = file.FullName;
                    dirs.Add(d);
                    //GetFilesRecurse( p, file.FullName, (level + 1) );
                }
            }
            // now, if the pattern was NOT the ultimate WILD, '*',
            // then we MUST search again ... using the "*" wild
            if (pattern != "*")
            {
                f = dir.GetFileSystemInfos("*");
                foreach (FileSystemInfo fil in f)
                {
                    if (!InItemList(fil.FullName))
                    {
                        cref = new Class1();
                        cref.file = fil;
                        cref.to_delete = false;
                        cref.size = 0;      // start size as zero
                        cref.is_dir = App.CheckIfDirectory(fil.FullName);
                        cref.level = level;
                        cref.parent = parent;
                        cref.is_deleted = false;
                        if (cref.is_dir)
                        {
                            mystats.dir_count++;
                            cref.type = "<DIR>";
                        }
                        else
                        {
                            mystats.file_count++;
                            cref.type = "<FIL>";
                        }

                        if (debug) WriteFileInfo(cref);
                        if (cref.is_dir)
                        {
                            int j;
                            p = parent + "\\" + fil.Name;
                            for (j = 0; j < dirs.Count; j++)
                            {
                                obj = dirs[j];
                                d = (Dirs)obj;
                                if (d.directory == fil.FullName)
                                    break;
                            }
                            if (j >= dirs.Count)
                            {
                                d = new Dirs();
                                d.parent = p;
                                d.directory = fil.FullName;
                                dirs.Add(d);
                            }
                        }
                        else
                        {
                            i = new System.IO.FileInfo(fil.FullName);
                            cref.size = i.Length;
                            // maybe this is the SAME thing!!!
                            cref.is_ro = (i.IsReadOnly || ((i.Attributes & FileAttributes.ReadOnly) != 0));
                            mystats.disk_total += GetiSize(cref.size);
                        }
                        iSize = GetiSize(cref.size);
                        grandtotal += iSize;
                        AddToDbg(cref, "RC:" + parent);
                        Items.Add(cref);
                    }
                }
            }
            foreach (Object ob in dirs)
            {
                d = (Dirs)ob;
                GetFilesRecurse(d.parent, d.directory, (level + 1));
            }
        }

        private static Int64 GetiSize(Int64 size)
        {
            Int64 iSize = 0;
            if (size == 0)
                iSize = diskblock;  // minimum is one disk block
            else
            {
                int blocks = (int)(size / diskblock);
                if ((size % diskblock) > 0)
                    blocks++;
                iSize = (blocks * diskblock);
            }
            return iSize;
        }

        private static void AddToDbg(Class1 cref, string msg)
        {
            if (verbose > 9)
            {
                string s;
                Int64 iSize = GetiSize(cref.size);
                if (cref.is_dir)
                    s = "<DIR>";
                else
                    s = "<FIL>";
                s += " " + iSize + " " + cref.file.Name + " " + msg;
                WriteLine(s);
                DbgStgs.Add(s);
            }
        }

        private static void AddToDelTotal(Class1 cref)
        {
            Int64 size = cref.size;
            Int64 iSize = GetiSize(size);
            deltotal += iSize;
        }

        private static void SetChildDelete()
        {
            foreach (Object ob in Items)
            {
                Class1 cref = (Class1)ob;
                if (cref.is_dir && cref.to_delete)
                {
                    string par = cref.parent + "\\" + cref.file.Name;
                    // ok, also mark the children of this directory
                    foreach (Object obj in Items)
                    {
                        Class1 rf = (Class1)obj;
                        if (cref != rf)
                        {
                            int ind = rf.parent.IndexOf(par);
                            if (ind == 0)
                            {
                                // is a CHILD of
                                if (!rf.to_delete)
                                {
                                    rf.to_delete = true;
                                    mystats.delete_total += GetiSize(rf.size);
                                    if (rf.is_dir)
                                    {
                                        mystats.dirs_to_delete++;
                                    }
                                    else
                                    {
                                        mystats.files_to_delete++;
                                    }
                                }
                            }
                        }
                    }
                }
            }
        }

        private static void SetDelTotal(Class1 cref)
        {
            string par = cref.parent + "\\" + cref.file.Name;
            AddToDelTotal(cref);
            AddToDbg(cref, "SD:parent:" + par);
            cref.is_deleted = true;
            foreach (Object ob in Items)
            {
                Class1 rf = (Class1)ob;
                if (cref != rf)
                {
                    // deleted ALL files and directories below here
                    // that is, if it is of the same parentage ...
                    int ind = rf.parent.IndexOf(par);
                    if (ind == 0)
                    {
                        AddToDelTotal(rf);
                        AddToDbg(rf, "SD:child:" + rf.parent);
                        rf.is_deleted = true;
                    }
                }
            }
        }

        private static int RemoveROAttribute(string file)
        {
            FileAttributes fa = File.GetAttributes(file);
            fa &= ~(FileAttributes.ReadOnly);
            File.SetAttributes(file, fa);
            return 0;
        }

        private static string AnyROChildren(Class1 cref)
        {
            string result = "";
            string par = cref.parent + "\\" + cref.file.Name;
            foreach (Object ob in Items)
            {
                Class1 rf = (Class1)ob;
                if (cref != rf)
                {
                    int ind = rf.parent.IndexOf(par);
                    if (ind == 0) // has same parent
                    {
                        if (rf.is_ro)   // is the child RO
                        {
                            if (force_option) // is the force option ON
                                RemoveROAttribute(rf.file.FullName);
                            else
                                result += rf.file.Name + " "; /// can NOT be deleted
                        }
                    }
                }
            }
            return result;
        }
        private static bool HasWild(string path)
        {
            if (path.IndexOf('*') >= 0)
                return true;
            else if (path.IndexOf('?') >= 0)
                return true;

            return false;
        }

        private static int SetDirPat(string path)
        {
            // grab info
            string pat, dir;
            int ind;
            if (oldway)
            {
                // last char should always be a *, 
                // if it's not assume it should be there
                if (oldway && !path.EndsWith("*"))
                {
                    pattern = "*";
                    directory = path;
                    if (directory.EndsWith("\""))
                        directory = directory.Substring(0, directory.Length - 1);
                    //if (! directory.EndsWith(@"\"))
                    //	directory = directory + @"\";

                    return 0;
                }

                // proceed as normal
                pattern = path.Substring(path.LastIndexOf(@"\") + 1);
                directory = path.Substring(0, path.Length - pattern.Length);
            }
            else
            {
                ind = path.LastIndexOf('\\');
                if (ind >= 0)
                {
                    pat = path.Substring(ind + 1);
                    dir = path.Substring(0, path.Length - pat.Length);
                }
                else
                {
                    // hmmmmm, no path separator - is this a file, or directory
                    // or neither ...
                    if (HasWild(path))
                    {
                        // has a wild '*' or '?' - choose it is a pattern
                        pat = path;
                        dir = ".";
                    }
                    else
                    {
                        ind = CheckIfExists(path);
                        if (ind == 2)
                        {
                            // it is a DIRECTORY
                            dir = path;
                            pat = "*";
                        }
                        else if (ind == 1)
                        {
                            // it is a FILE
                            dir = ".";
                            pat = path;
                        }
                        else
                        {
                            // HMMMM, neither directory, nor file
                            dir = path;
                            pat = "";
                        }
                    }
                    
                }
                ind = CheckIfExists(dir);
                if (ind == 2)
                {
                    pattern = pat;
                    directory = dir;
                }
                else
                {
                    WriteLine("ERROR: Directory " + dir + " does NOT exist!");
                    WriteLine("Failed to correctly parse [" + path + "]! Aborting!!");
                    return 1;
                }
            }
            return 0;
        }

        private static DateTime ParseCTime(string time)
        {
            // parse the ctime
            int loc = 0;
            DateTime d = DateTime.Now;
            string dateString = time;
            if (time.Substring(loc, 3).ToLower() == "now")
            {
                // 1. string starts with "now"
                d = DateTime.Now;
                loc += 3;
                // now read the length of days
                Match m = Regex.Match(time, @"-(?<num>\d+)d");
                if (m.Success)
                {
                    // found our number
                    string num = m.Groups["num"].Value;

                    //Console.WriteLine("now minus:" + num);
                    int days = int.Parse(num);
                    d = d.AddDays(days * -1);
                }
                else
                {
                    WriteLine("ERROR: [" + time + "] did NOT yield DateTime value! No -nnd found!!");
                    return DateTime.MinValue;
                }
            }
            else if(time.Substring(0,5).ToLower() == "file=") 
            {
                // 2. string starts with "file"
                string file = time.Substring(5);
                if (CheckIfExists(file) == 1)
                {
                    System.IO.FileInfo fi = new System.IO.FileInfo(file);
                    d = fi.LastWriteTime;
                }
                else
                {
                    WriteLine("ERROR: [" + time + "] did NOT yield DateTime value! File does NOT exist!!");
                    return DateTime.MinValue;
                }
            }
            else
            {
                // 3. assume string is a DateTime format
                // default is BRITISH DateTime format, like DD/MM/YYYY HH:MM:SS
                // but can be altered with -datetime culture, like fr-FR
                // which can be enumerated with -enumcultures
                CultureInfo culture;
                DateTimeStyles styles;
                culture = CultureInfo.CreateSpecificCulture(datetimeform);
                styles = DateTimeStyles.None;
                try
                {
                    d = DateTime.Parse(dateString, culture, styles);
                    WriteLine(string.Format("DateTime {0} converted to {1}, using {2} culture.",
                                      dateString, d, datetimeform));
                }
                catch (FormatException)
                {
                    WriteLine(string.Format("ERROR: Unable to convert {0} to DateTime using {2} culture.",
                                      dateString, datetimeform));
                    // Give some MORE help on this 'tricky' topic
                    // Try to SHOW what was EXPECTED ...
                    DateTimeFormatInfo myDTFI = new CultureInfo(datetimeform, false).DateTimeFormat;
                    WriteLine(string.Format("Expect {0} {1} ", myDTFI.ShortDatePattern, "(ShortDatePattern)"));
                    //WriteLine(string.Format("or     {0} {1}\n", myDTFI.LongDatePattern, "(LongDatePattern)"));
                    WriteLine("DateTime format can be set with [-datetime culture], like 'fr-FR', 'en-US', etc ...");
                    WriteLine("Use -enumcultures to list the possible formats available.");
                    return DateTime.MinValue;
                }
            }
            return d;
        }

        private static void Help()
        {
            // print the help message out
            // get from resource
            //System.Resources.ResourceManager rm = System.AppDomain.CurrentDomain.GetData("help");
            //rm.
            //Console.WriteLine(rm.GetString("test1"));
            System.IO.Stream strm = System.Reflection.Assembly.GetExecutingAssembly().GetManifestResourceStream("xdel.readme.txt");
            System.IO.StreamReader rdr = new StreamReader(strm);
            Console.Write(rdr.ReadToEnd());
        }

        // only a scan for adding the LOG file output,
        // and newlog, to create a NEW log, rather than append
        private static int ScanForSpecials(string[] args)
        {
            // get args
            for (int ctr = 0; ctr < args.Length; ctr++)
            {
                string first = args[ctr].Substring(0, 1);
                if ((first == "-") || (first == "/"))
                {
                    string arg = args[ctr].Substring(1);
                    // we have an OPTION
                    switch (arg)
                    {
                        case "ctime":
                        case "mtime":
                            ctr++;
                            break;
                        case "dolog":
                        case "l":
                            dolog = true;
                            break;
                        case "newlog":
                            append = false;
                            break;
                        case "setlog":
                            ctr++;
                            if (ctr < args.Length)
                            {
                                logfile = args[ctr];
                            }
                            else
                            {
                                WriteLine("ERROR: Must supply LOGFILE name to [" + args[ctr - 1] + "]! Aborting!!");
                                return 10;
                            }
                            break;

                        case "datetime":
                            ctr++;
                            if (ctr < args.Length)
                            {
                                if (SetCulture(args[ctr]) > 0)
                                    return 8;
                            }
                            else
                            {
                                WriteLine("ERROR: Must supply CULTURE agument to [" + args[ctr - 1] + "]! Aborting!!");
                                return 7;
                            }
                            break;
                    }
                }
            }
            return 0;
        }

        private static int ParseArguments(string[] args)
        {
            // get args
            for (int ctr = 0; ctr < args.Length; ctr++)
            {
                // should check for leading '-' or perhaps '/' character
                // rather than just the default being the directory
                // or file mask ...
                // then can ABORT if an invalid command found
                string first = args[ctr].Substring(0, 1);
                if ((first == "-") || (first == "/"))
                {
                    string arg = args[ctr].Substring(1);
                    // we have an OPTION
                    switch (arg)
                    {
                        case "ctime":
                            // get the -ctime
                            ctr++;
                            if (ctr < args.Length)
                            {
                                ctime = App.ParseCTime(args[ctr]);
                                if (ctime == DateTime.MinValue)
                                {
                                    WriteLine("ERROR: Unable to parse ctime [" + args[ctr] + "]! Aborting!!");
                                    return 6;
                                }
                                WriteLine("Looking at files with creation time older than: " + ctime.ToString());
                                usectime = true;
                            }
                            else
                            {
                                WriteLine("ERROR: Must supply TIME agument to [" + args[ctr - 1] + "]! Aborting!!");
                                return 1;
                            }
                            break;

                        case "mtime":
                            // get the -mtime
                            ctr++;
                            if (ctr < args.Length)
                            {
                                mtime = App.ParseCTime(args[ctr]);
                                if (mtime == DateTime.MinValue)
                                {
                                    WriteLine("ERROR: Unable to parse mtime [" + args[ctr] + "]! Aborting!!");
                                    return 7;
                                }
                                WriteLine("Looking at files with modification time older than: " + mtime.ToString());
                                usemtime = true;
                            }
                            else
                            {
                                WriteLine("ERROR: Must supply TIME agument to [" + args[ctr - 1] + "]! Aborting!!");
                                return 2;
                            }
                            break;

                        case "recurse":
                        case "r":
                            recurse = true;
                            break;

                        case "dirsonly":
                            // set that we are looking at directories only
                            dirsonly = true;
                            filesonly = false;
                            break;

                        case "filesonly":
                            // set that we are looking at directories only
                            dirsonly = false;
                            filesonly = true;
                            break;

                        case "listonly":
                            listonly = true;
                            break;

                        case "dodelete":
                            dodelete = true;
                            break;

                        case "debug":
                            debug = true;
                            break;

                        case "verbose":
                        case "v":
                            debug = true;
                            verbose++;
                            break;

                        case "dolog":
                        case "l":
                            dolog = true;
                            break;

                        case "newlog":
                            append = false;
                            break;

                        case "setlog":
                            ctr++;
                            break;

                        case "datetime":
                            // already done in ScanForSpecials()
                            ctr++;
                            break;

                        case "enumcultures":
                            enumcultures = true;
                            break;

                        case "force":
                            force_option = true;
                            break;

                        case "please-NO-confirmation":
                            please_NO_confirmation = true;
                            break;

                        case "?":
                        case "h":
                        case "help":
                        case "-help":
                            App.Help();
                            return 3;
                        //break;

                        default:
                            WriteLine("ERROR: Unknown option [" + args[ctr] + "]! Aborting!!");
                            return 4;

                    }
                }
                else
                {
                    if ((directory.Length > 0) || (pattern.Length > 0))
                    {
                        WriteLine("ERROR: Only one file or directory allowed! Found [" + args[ctr] + "]!");
                        WriteLine("Previously found [" + directory + pattern + "] ... aborting!!");
                        return 5;
                    }
                    if (SetDirPat(args[ctr]) > 0)
                        return 6;
                }
            }

            if (verbose > 0)
                WriteLine("CMD: [" + cmdline + "]");

            if (!usectime && !usemtime)
            {
                usemtime = true;
                mtime = DateTime.Now;
                if (verbose > 1)
                    WriteLine("No TIME given - using modifation time of Now()");
            }

            if (verbose > 1)
            {
                Write("Options: ");
                WriteOpt("dodelete", dodelete);
                WriteOpt("force", force_option);
                if (filesonly)
                    WriteOpt("filesonly", filesonly);
                else
                    WriteOpt("dirsonly", dirsonly);
                WriteOpt("listonly", listonly);
                WriteOpt("recurse", recurse);
                WriteLine(" ");
                Write("         ");
                WriteOpt("usectime", usectime);
                WriteOpt("usemtime", usemtime);
                WriteOps("datetime", datetimeform);
                WriteOpt("dolog", dolog);
                WriteLine(" ");
            }

            if ((directory.Length == 0) && (pattern.Length == 0))
            {
                WriteLine("ERROR: No file or directory found in command! Aborting!!");
                if ((verbose == 0) && dolog)
                {
                    Console.WriteLine("CMD: [" + cmdline + "]");
                }
                return 6;
            }
            else if (directory.Length == 0)
            {
                directory = ".";    // use current
                if (verbose > 1)
                    WriteLine("No directory given - using current directory.");
            }

            if (dirsonly && recurse)
            {
                if (verbose > 2)
                {
                    WriteLine("WARNING: -dirsonly AND -recurse are BOTH ON!");
                    WriteLine("This is no problem, but deleting a directory, deletes");
                    WriteLine("ALL the directories contents, INCLUDING any directories");
                    WriteLine("below it, hence is already recursive by nature.");
                }
            }
            return 0;
        }

        private static int SetCulture(string name)
        {
            string form;
            foreach (CultureInfo ci in CultureInfo.GetCultures(CultureTypes.AllCultures))
            {
                try
                {
                    form = CultureInfo.CreateSpecificCulture(ci.Name).Name;
                    if (form == name)
                    {
                        datetimeform = name;
                        return 0;
                    }
                }
                catch (ArgumentException)
                {
                    // forget it
                    form = "Exception";
                }
            }
            WriteLine("ERROR: Culture [" + name + "] NOT found!");
            WriteLine("Use -enumcultures to see list avalable.");
            return 1;
        }

        private static void TryParsing(string dateString, CultureInfo culture, DateTimeStyles styles)
        {
            DateTime result;
            try
            {
                result = DateTime.Parse(dateString, culture, styles);
                WriteLine(string.Format("{0} converted to {1} {2}.",
                                  dateString, result, result.Kind.ToString()));
            }
            catch (FormatException)
            {
                WriteLine(string.Format("Unable to convert {0} to a date and time.",
                                  dateString));
            }
        }

        private static void ProcessItems()
        {

            foreach (object o in Items)
            {
                Class1 cref = (Class1)o;
                FileSystemInfo file = cref.file;
                string stg, num;
                // after deletion of a directory,
                // it is possible this item may no longer exist,
                // in which case forget it (silently)
                num = " " + cref.size;
                while (num.Length < maxnumlen)
                    num = " " + num;
                if (CheckIfExists(file.FullName) > 0)
                {
                    if (cref.to_delete)
                    {
                        stg = "DEL: " + cref.type + " " + file.FullName + " ";
                        while (stg.Length < maxnamelen)
                            stg += " ";
                        if (usectime)
                            stg += " (ct:" + file.CreationTime + ")";
                        else if (usemtime)
                            stg += " (mt:" + file.LastWriteTime + ")";
                        Write(stg);

                        // do the delete, but only if REQUESTED
                        if (!listonly && dodelete)
                        {
                            // is it a DIRECTORY
                            if (App.CheckIfDirectory(file.FullName))
                            {
                                // make SURE is EXIST
                                if (System.IO.Directory.Exists(file.FullName))
                                {
                                    // check if any CHILDREN are READ ONLY
                                    string ro = AnyROChildren(cref);
                                    if (ro.Length > 0)
                                    {
                                        WriteLine("... no access (skipping)! ");
                                        //if ((i.Attributes & FileAttributes.ReadOnly) != 0)
                                        Write("Child READ-ONLY: " + ro);
                                    }
                                    else
                                    {
                                        try
                                        {
                                            System.IO.Directory.Delete(file.FullName, true);
                                            Write("... Deleted");
                                            SetDelTotal(cref);
                                        }
                                        catch (System.IO.IOException e)
                                        {
                                            missed.Add(file);
                                            Write("Error deleting DIR (skipping): " + e.Message);
                                        }
                                    }
                                }
                            }
                            else
                            {
                                try
                                {
                                    //FileIOPermission f2 = new FileIOPermission(FileIOPermissionAccess.Write, file.FullName);
                                    // NOT FileIOPermissionAccess.Write
                                    //System.IO.FileInfo i = new System.IO.FileInfo(file.FullName);
                                    //if (i.Attributes == FileAttributes.Archive)
                                    //if (((i.Attributes & FileAttributes.ReadOnly) == 0)&&
                                    //    ((i.Attributes & FileAttributes.Hidden) == 0))
                                    // seems can NOT delete READ-ONLY file,
                                    // but not all types checked
                                    // Archive    - The file's archive status. ie mark for backup or removal.
                                    // Compressed - The file is compressed.
                                    // Device     - Reserved for future use.
                                    // Directory  - The file is a directory.
                                    // Encrypted  - The file or directory is encrypted.
                                    //              For a file, this means that all data in the file is encrypted.
                                    //              For a directory, this means that encryption is the default for newly created files and directories.
                                    // Hidden     - The file is hidden, and thus is not included in an ordinary directory listing.
                                    // Normal     - The file is normal and has no other attributes set. This attribute is valid only if used alone. (=0)
                                    // NotContentIndexed - The file will not be indexed by the operating system's content indexing service.
                                    // Offline    - The file is offline. The data of the file is not immediately available.
                                    // ReadOnly   - The file is read-only.
                                    // ReparsePoint - The file contains a reparse point, which is a block of user-defined data associated
                                    //                with a file or a directory.
                                    // SparseFile - The file is a sparse file. Sparse files are typically large files whose data are mostly zeros.
                                    // System     - The file is a system file. The file is part of the operating system
                                    //              or is used exclusively by the operating system.
                                    // Temporary  - The file is temporary. File systems attempt to keep all of the data in memory
                                    //              for quicker access rather than flushing the data back to mass storage. 
                                    //              A temporary file should be deleted by the application as soon as it is no longer needed.  
                                    //if ((i.Attributes & FileAttributes.ReadOnly) == 0)
                                    if (!cref.is_ro)
                                    {
                                        System.IO.File.Delete(file.FullName);
                                        Write("... Deleted");
                                        AddToDelTotal(cref);
                                    }
                                    else
                                    {
                                        if (force_option)
                                        {
                                            RemoveROAttribute(file.FullName);
                                            System.IO.File.Delete(file.FullName);
                                            Write("... Deleted");
                                            AddToDelTotal(cref);
                                        }
                                        else
                                        {
                                            missed.Add(file);
                                            Write("... no access (skipping)! ");
                                            //if ((i.Attributes & FileAttributes.ReadOnly) != 0)
                                            Write("READ-ONLY ");
                                            //if ((i.Attributes & FileAttributes.Hidden) != 0)
                                            //    Write("HIDDEN ");
                                        }
                                    }
                                }
                                catch (System.IO.IOException e)
                                {
                                    skippedtotal += GetiSize(cref.size);
                                    Write("Error deleting FILE (skipping): " + e.Message);
                                    missed.Add(file);
                                }
                            }
                        }
                        else
                        {
                            // we are ONLY LISTING the files due to 
                            // either -dodelete not set, or -listonly set
                            // so ADD some information
                            if (cref.is_ro)
                                Write(" *** READ_ONLY ***");
                            else
                            {
                                if (!cref.is_dir)
                                    Write(num + " bytes.");
                            }
                        }
                        WriteLine("");
                    }   // is_delete is set
                    else
                    {   // delete is NOT set
                        nodel_total += GetiSize(cref.size);
                        if (verbose > 2)
                            WriteLine("Skipping: " + cref.type + " [" + file.FullName + "]");
                    }
                }
                else
                {
                    // skippedtotal += GetiSize(cref.size);
                    if (verbose > 2)
                        WriteLine("Assumed Deleted: " + cref.type + " [" + file.FullName + "]");
                }
            }
        }

        private static void ParseDateTime( bool doenum )
        {
            string dateString;
            CultureInfo culture;
            DateTimeStyles styles;
            if (doenum)
            {
                // ENUMERATE THE CULTURES SUPPORTED
                // Prints the header.
                WriteLine("CULTURE                                              SPECIFIC CULTURE");
                // Determines the specific culture associated with each culture in the .NET Framework.
                foreach (CultureInfo ci in CultureInfo.GetCultures(CultureTypes.AllCultures))
                {
                    Write(string.Format("{0,-12} {1,-40}", ci.Name, ci.EnglishName));
                    try
                    {
                        WriteLine(string.Format("{0}", CultureInfo.CreateSpecificCulture(ci.Name).Name));
                    }
                    catch
                    {
                        WriteLine("(no associated specific culture)");
                    }
                }
            }
            // Parse a date and time with no styles.
            // dateString = "03/01/2009 10:00 AM";
            dateString = "29/09/2008 10:00 AM"; // this will FAIL under US
            // since it is MM/DD/YYYY
            WriteLine("GB, FR, US - Unspecified (DateTimeStyles.None)");
            styles = DateTimeStyles.None;

            // should pass under Great Britain
            culture = CultureInfo.CreateSpecificCulture("en-GB");
            TryParsing(dateString, culture, styles);

            // and ok undef FRENCH
            culture = CultureInfo.CreateSpecificCulture("fr-FR");
            TryParsing(dateString, culture, styles);

            culture = CultureInfo.CreateSpecificCulture("en-US");
            TryParsing(dateString, culture, styles);

            WriteLine("Some USA tests ... (DateTimeStyles - None, Local, Utc)");
            styles = DateTimeStyles.None;
            dateString = "04/19/2008 10:00 AM";
            culture = CultureInfo.CreateSpecificCulture("en-US");
            TryParsing(dateString, culture, styles);

            // Parse the same date and time with the AssumeLocal style.
            styles = DateTimeStyles.AssumeLocal;
            TryParsing(dateString, culture, styles);

            styles = DateTimeStyles.AdjustToUniversal | DateTimeStyles.AssumeLocal;
            TryParsing(dateString, culture, styles);
            
            // Parse a date and time that is assumed to be local.
            // This time is five hours behind UTC. The local system's time zone is 
            // eight hours behind UTC.
            // Using ISO 8601 format.
            styles = DateTimeStyles.AssumeLocal;
            dateString = "2009/03/01T10:00:00-5:00";
            TryParsing(dateString, culture, styles);

            // Attempt to convert a string in improper ISO 8601 format.
            dateString = "03/01/2009T10:00:00-5:00";
            TryParsing(dateString, culture, styles);

            //dateString = "2008-03-01 10:00";
            dateString = "2008-09-23 10:00";
            culture = CultureInfo.CreateSpecificCulture("fr-FR");
            styles = DateTimeStyles.AdjustToUniversal | DateTimeStyles.AssumeLocal;
            TryParsing(dateString, culture, styles);
        }
        private static void ClearMyStats()
        {
            mystats.delete_total = 0;
            mystats.dir_count = 0;
            mystats.dirs_to_delete = 0;
            mystats.disk_total = 0;
            mystats.file_count = 0;
            mystats.file_size_total = 0;
            mystats.files_to_delete = 0;
        }
        private static void ShowMyStats(bool all)
        {
            if (all)
            {
                Write("MyStats: ");
                Write(", dir count=" + mystats.dir_count);
                Write(", file count=" + mystats.file_count);
                WriteLine(", est. disk total=" + mystats.disk_total);
            }
            Write("Deletes: ");
            Write(", dir count=" + mystats.dirs_to_delete);
            Write(", file count=" + mystats.files_to_delete);
            WriteLine(", est. disk total=" + mystats.delete_total);
        }
    }
}
