@setlocal
@REM set projects
@set PROOT=lib_flite
@set PROOT2=flite_main
@set PROOT3=flite_time_main
@set PROOT4=t2p_main

@REM set input file
@set TEMPI1=%PROOT%.inp
@set TEMPI2=%PROOT2%.inp
@set TEMPI3=%PROOT3%.inp
@set TEMPI4=%PROOT4%.inp

@if NOT EXIST %TEMPI1% goto ERR1
@if NOT EXIST %TEMPI2% goto ERR2
@if NOT EXIST %TEMPI3% goto ERR3
@if NOT EXIST %TEMPI4% goto ERR4

@echo Completely re-build project %PROOT%
@echo *** CONTINUE? *** Ctrl+C to abort. All other keys continue...
@pause

@REM clean up last build...
@set NO_PAUSE=yes
@call killall NOPAUSE

@REM set project names
@set PROJ=%PROOT%.dsp
@set PROJW=%PROOT%.dsw
@set PROJ2=%PROOT2%.dsp
@set PROJ3=%PROOT3%.dsp
@set PROJ4=%PROOT4%.dsp

@if NOT EXIST %PROJ% goto DOIT
@if NOT EXIST %PROJ%.old goto RENOLD
@if NOT EXIST %PROJ%.bak goto RENBAK
@del %PROJ%.bak >nul 2>&1
:RENBAK
@ren %PROJ% %PROJ%.bak
@goto DOIT

:RENOLD
@ren %PROJ% %PROJ%.old
@goto DOIT

:DOIT

@call createdsp -@%TEMPI1%

@call tempcb

@if NOT EXIST %PROJ% goto FAILED1

@if NOT EXIST %PROJ2% goto DOIT2
@if NOT EXIST %PROJ2%.old goto RENOLD2
@if NOT EXIST %PROJ2%.bak goto RENBAK2
@del %PROJ2%.bak >nul 2>&1
:RENBAK2
@ren %PROJ2% %PROJ2%.bak
@goto DOIT2
:RENOLD2
@ren %PROJ2% %PROJ2%.old
@goto DOIT2
:DOIT2
@call createdsp -@%TEMPI2%
@call tempcb
@if NOT EXIST %PROJ2% goto FAILED2

@if NOT EXIST %PROJ3% goto DOIT3
@if NOT EXIST %PROJ3%.old goto RENOLD3
@if NOT EXIST %PROJ3%.bak goto RENBAK3
@del %PROJ3%.bak >nul 2>&1
:RENBAK3
@ren %PROJ3% %PROJ3%.bak
@goto DOIT3
:RENOLD3
@ren %PROJ3% %PROJ3%.old
@goto DOIT3
:DOIT3
@call createdsp -@%TEMPI3%
@call tempcb
@if NOT EXIST %PROJ3% goto FAILED3

@if NOT EXIST %PROJ4% goto DOIT4
@if NOT EXIST %PROJ4%.old goto RENOLD4
@if NOT EXIST %PROJ4%.bak goto RENBAK4
@del %PROJ4%.bak >nul 2>&1
:RENBAK4
@ren %PROJ4% %PROJ4%.bak
@goto DOIT4
:RENOLD4
@ren %PROJ4% %PROJ4%.old
@goto DOIT4
:DOIT4
@call createdsp -@%TEMPI4%
@call tempcb
@if NOT EXIST %PROJ4% goto FAILED4

@REM LOAD DSW FILE

@if EXIST %PROJW% (
@echo Loading %PROJW%
@start %PROJW%
) else (
@echo FAILED to find %PROJW%
)

@goto END

:ERR1
@echo ERROR: Missing %TEMPI1% input file...
@goto WEND

:ERR2
@echo ERROR: Missing %TEMPI2% input file...
@goto WEND

:ERR3
@echo ERROR: Missing %TEMPI3% input file...
@goto WEND

:ERR4
@echo ERROR: Missing %TEMPI4% input file...
@goto WEND

:FAILED1
@echo ERROR: File %PROJ% NOT created...
@goto WEND

:FAILED2
@echo ERROR: File %PROJ2% NOT created...
@goto WEND

:FAILED3
@echo ERROR: File %PROJ3% NOT created...
@goto WEND

:FAILED4
@echo ERROR: File %PROJ4% NOT created...
@goto WEND

:WEND
@pause
:END
@endlocal
