// glutkbd.cxx : Defines the entry point for the console application.
// from ogl-keys.cxx (ogl02) example

#include "glutkbd.hxx"
#include <vector>
#include <string>
#define PER_FREEGLUT_SOURCE

using namespace std;

static int g_width = 0;
static int g_height = 0;
static void * fixedFont = GLUT_BITMAP_TIMES_ROMAN_24; // GLUT_BITMAP_TIMES_ROMAN_10;
static size_t max_lines; // calculated maximum lines per screen

typedef vector<string> vSTRING;
typedef vSTRING::iterator vSi;

vSTRING strings;

#define  MX_BUFFER_SIZE    264
#define  MX_BUFFER_COUNT   64
static int nxt_gen_buf = 0;
static char _s_nxt_buf[MX_BUFFER_SIZE * MX_BUFFER_COUNT];
char * GetNxtBuf(void)
{
   nxt_gen_buf++;
   if(nxt_gen_buf >= MX_BUFFER_COUNT)
      nxt_gen_buf = 0;
   return &_s_nxt_buf[(MX_BUFFER_SIZE * nxt_gen_buf)];
}

/*!
    Does printf()-like work using freeglut/OpenGLUT
    glutBitmapString().  Uses a fixed font.  Prints
    at the indicated row/column position.

    Limitation: Cannot address pixels.
    Limitation: Renders in screen coords, not model coords.
*/
static void not_used_Printf (int row, int col, const char *fmt, ...)
{
    static char buf[256];
    int viewport[4];
    void *font = GLUT_BITMAP_9_BY_15;
    va_list args;

    va_start(args, fmt);
#if defined(WIN32) && !defined(__CYGWIN__)
    (void) _vsnprintf (buf, sizeof(buf), fmt, args);
#else
    (void) vsnprintf (buf, sizeof(buf), fmt, args);
#endif
    va_end(args);

    glGetIntegerv(GL_VIEWPORT,viewport);

    glPushMatrix();
    glLoadIdentity();

    glMatrixMode(GL_PROJECTION);
    glPushMatrix();
    glLoadIdentity();

        glOrtho(0,viewport[2],0,viewport[3],-1,1);

        glRasterPos2i
        (
              glutBitmapWidth(font, ' ') * col,
            - glutBitmapHeight(font) * (row+2) + viewport[3]
        );
        glutBitmapString (font, (unsigned char*)buf);

    glPopMatrix();
    glMatrixMode(GL_MODELVIEW);
    glPopMatrix();
}

static void output_font_stg(void *font, int x, int y, char *string)
{
  glRasterPos2f((GLfloat)x, (GLfloat)y);
#ifdef __FREEGLUT_EXT_H__
     glutBitmapString( font, (const unsigned char *)string );
#else
     len = (int) strlen(string);
     for (i = 0; i < len; i++) {
        glutBitmapCharacter(font, string[i]);
     }
#endif
}

static void drawKeys( void )
{
   GLsizei winWidth, winHeight;
   GLfloat skip = glutBitmapHeight(fixedFont);
   GLfloat left = 10.0;
   GLfloat bottom = 15.0;
   GLfloat top = skip; // one font down

   char * cp = GetNxtBuf();
   sprintf(cp,"Only last %d lines will be shown...", max_lines);
	/* save the ModelView matrix */
	glPushMatrix(); 

	/* clear any current modeling or viewing xforms */
	glLoadIdentity(); 

	/* setup the Projection matrix */
	glMatrixMode( GL_PROJECTION );
	glPushMatrix();

		/* make new world space to display status in */
		glLoadIdentity();
		winWidth = glutGet(GLUT_WINDOW_WIDTH); 
		winHeight = glutGet(GLUT_WINDOW_HEIGHT);
		glOrtho( -0.5, winWidth-0.5, -0.5, winHeight-0.5, -1, 1.0 );

		glPushAttrib( GL_DEPTH_BUFFER_BIT );
	
		/* don't want text to be hidden */
		glDisable( GL_DEPTH_TEST ); 

		glColor3f( 1.0f, 1.0f, 1.0f );

        // paint the lines available
        size_t max = strings.size();
        size_t i, start;
        i = start = 0;
        if ( max > 0) {
            if (max_lines > max)
                start = 0;
            else
                start = max - max_lines;
            vSi it = strings.begin();
            for (i = 0 ; it != strings.end(); it++, i++ )
            {
                if (i >= start) {
                    string s = *it;
                    output_font_stg(fixedFont, 10,
                       (int)(winHeight-(top + (skip * (i - start)))),
                       (char *)s.c_str() );
                }
            }

        }
        if (start == 0) {
            i++;
            if (i < max_lines)
                output_font_stg(fixedFont, 10,
                   (int)(winHeight-(top + (skip * i))),
                   (char *)"Enter a key to see results... ESC key to exit");
            i++;
            if (i < max_lines)
                output_font_stg(fixedFont, 10,
                   (int)(winHeight-(top + (skip * i))),
                   (char *)"Keys out of the range 0x20 - 0x7e");
            i++;
            if (i < max_lines)
                output_font_stg(fixedFont, 10,
                   (int)(winHeight-(top + (skip * i))),
                   (char *)" will be shown just as a '.'");
            i++;
            if (i < max_lines)
                output_font_stg(fixedFont, 10,
                   (int)(winHeight-(top + (skip * i))),
                   (char *)"N.key = Normal, S.key = Special Keys");
            i++;
            if (i < max_lines)
                output_font_stg(fixedFont, 10,
                   (int)(winHeight-(top + (skip * i))),
                   cp );
        }

		glPopAttrib();

	/* restore matrixes */
	glPopMatrix();

	glMatrixMode( GL_MODELVIEW );
	glPopMatrix();
     
} /* drawKeys */

static void display_keys(void)
{
   glClear(GL_COLOR_BUFFER_BIT);
   glLoadIdentity();
   drawKeys();
   glFlush();
}

static void reshape_keys(int w, int h)
{
   g_width = w;
   g_height = h;
   glViewport (0, 0, (GLsizei) w, (GLsizei) h);
   glMatrixMode(GL_PROJECTION);
   glLoadIdentity();
   gluPerspective (45.0, (GLfloat) w/(GLfloat) h, 1.0, 100.0);
   glMatrixMode(GL_MODELVIEW);
   glLoadIdentity();

   // how many lines will fit this height?
   max_lines = (h / glutBitmapHeight(fixedFont));   // integer math
}

static void mouse_keys(int button, int state, int x, int y) 
{

}

typedef struct tagGLUT_KEYS {
    int val;
    char * name;
}GLUT_KEYS, * PGLUT_KEYS;

GLUT_KEYS glut_keys[] = {
    { GLUT_KEY_F1, (char *)"F1" },
    { GLUT_KEY_F2, (char *)"F2" }, //0x0002
    { GLUT_KEY_F3, (char *)"F3" }, //0x0003
    { GLUT_KEY_F4, (char *)"F4" }, //0x0004
    { GLUT_KEY_F5, (char *)"F5" }, //0x0005
    { GLUT_KEY_F6, (char *)"F6" }, //0x0006
    { GLUT_KEY_F7, (char *)"F7" }, //0x0007
    { GLUT_KEY_F8, (char *)"F8" }, //0x0008
    { GLUT_KEY_F9, (char *)"F9" }, //0x0009
    { GLUT_KEY_F10, (char *)"F10" }, //0x000A
    { GLUT_KEY_F11, (char *)"F11" }, //0x000B
    { GLUT_KEY_F12, (char *)"F12" }, //0x000C
    { GLUT_KEY_LEFT, (char *)"Left" }, //0x0064
    { GLUT_KEY_UP, (char *)"Up" }, //0x0065
    { GLUT_KEY_RIGHT, (char *)"Right" }, //0x0066
    { GLUT_KEY_DOWN, (char *)"Down" }, //0x0067
    { GLUT_KEY_PAGE_UP, (char *)"PgUp" }, //0x0068
    { GLUT_KEY_PAGE_DOWN, (char *)"PgDn" }, //0x0069
    { GLUT_KEY_HOME, (char *)"Home" }, //0x006A
    { GLUT_KEY_END, (char *)"End" }, //0x006B
    { GLUT_KEY_INSERT, (char *)"Ins" }, //0x006C
    { 0, NULL }
};

// 2011-03-09 - Found that only this set of 'special' callbacks
// that one can NOT call glutGetModifiers() !!!!
GLUT_KEYS win_keys[] = {
#ifdef GLUT_KEY_SHIFT_L // just chose one
    // have not seem these first 3!!!
    { GLUT_KEY_NUM_LOCK, (char *)"NumLoc" }, // 0x6D
    { GLUT_KEY_BEGIN, (char *)"Being" }, // 0x6E
    { GLUT_KEY_DELETE, (char *)"Delete" }, // 0x6F
    // have seen these, but NOT in all cases???
    { GLUT_KEY_SHIFT_L, (char *)"L.Shift" }, // 112 0x70
    { GLUT_KEY_SHIFT_R, (char *)"R.Shift" }, // 113 0x71
    { GLUT_KEY_CTRL_L, (char *)"L.Ctrl" },   // 114 0x72
    { GLUT_KEY_CTRL_R, (char *)"R.Ctrl" },   // 115 0x73
    { GLUT_KEY_ALT_L, (char *)"L.Alt" },     // 116 0x74
    { GLUT_KEY_ALT_R, (char *)"R.Alt" },     // 117 0x75
#endif // earlier freeglut_ext.h did NOT have these values
    { 0, NULL }
};

static int is_special_specials( unsigned char key )
{
    PGLUT_KEYS pgk = &win_keys[0];
    while (pgk->name) {
        if (pgk->val == key)
            return 1;
        pgk++;
    }
    return 0;
}

static char * get_special_name( unsigned char key )
{
    PGLUT_KEYS pgk = &glut_keys[0];
    while (pgk->name) {
        if (pgk->val == key)
            return pgk->name;
        pgk++;
    }
    pgk = &win_keys[0];
    while (pgk->name) {
        if (pgk->val == key)
            return pgk->name;
        pgk++;
    }
    return (char *)"[Not listed!]";
}

// prepare a display string for the key
static void process_a_key(unsigned char key, char * ptype)
{
    int mods = 0;
    string s;
    char * cp = GetNxtBuf();
    unsigned char c = key;
    char * mb = GetNxtBuf();
    char * psp = (char *)"";

    *mb = 0;
    if (*ptype == 'S') {
        strcat(mb,"Spl");
        psp = get_special_name(key);
#ifdef PER_FREEGLUT_SOURCE
        if ( !is_special_specials(key) ) {
            mods = glutGetModifiers();
            if (mods & GLUT_ACTIVE_SHIFT)
                strcat(mb,"Shift");
            if (mods & GLUT_ACTIVE_CTRL)
                strcat(mb,"Ctrl");
            if (mods & GLUT_ACTIVE_ALT)
                strcat(mb,"Alt");
            if (*mb == 0)
                strcat(mb,"None");
        }
#endif // PER_FREEGLUT_SOURCE
    } else {
        mods = glutGetModifiers();
        if (mods & GLUT_ACTIVE_SHIFT)
            strcat(mb,"Shift");
        if (mods & GLUT_ACTIVE_CTRL)
            strcat(mb,"Ctrl");
        if (mods & GLUT_ACTIVE_ALT)
            strcat(mb,"Alt");
        if (*mb == 0)
            strcat(mb,"None");
    }
    if ((c < ' ') || (c >= 127))
        c = '.';

    sprintf(cp, 
        "%s.key [%c] d=%3d (0x%02X), mods %s %s",
        ptype, c, key, (key & 0xff), mb, psp);

    s = cp;
    strings.push_back(s);
    printf("%s\n",s.c_str());
}

static void keyboard_keys( unsigned char key, int x, int y )
{
    process_a_key(key,(char *)"N");
    // keyboard_pgm_exit(key,x,y);
    switch (key) 
    {
    case 0x1b:
        glutLeaveMainLoop (); // does NOT work in freeglut, but program EXITS ok.
        break;
    }
    glutPostRedisplay();
}

static void special_keys(int key, int x, int y)
{
    process_a_key(key,(char *)"S");
    glutPostRedisplay();
}


static void init_keys(void)
{
   glMatrixMode(GL_PROJECTION);
   gluOrtho2D( 0.0, 500.0, 500.0, 0.0 );
   glMatrixMode(GL_MODELVIEW);
   glLoadIdentity();
   printf("Shows keyboard events. ESC to exit...\n");
}


int main_keys(int argc, char** argv)
{
   //SHOW_FUNC;
   glutInit(&argc, argv);
   glutInitDisplayMode (GLUT_SINGLE | GLUT_RGB);
   glutInitWindowSize (500, 500); 
   glutInitWindowPosition (100, 100);
   glutCreateWindow ("Keyboard Events");
   glutDisplayFunc(display_keys); 
   glutReshapeFunc(reshape_keys); 
   glutKeyboardFunc(keyboard_keys);
   glutSpecialFunc(special_keys);

   glutMouseFunc(mouse_keys);
   init_keys();
   glutMainLoop();
   return 0;
}

// eof - ogl-keys.cxx


int main(int argc, char * argv[])
{
    int iret;
    printf("Running executable [%s]\nBuilt on %s, at %s\n", argv[0],
        __DATE__, __TIME__);
    iret = main_keys(argc, argv);
	return iret; // never get here in freeglut
}

// eof - glutkbd.cxx
