// testINI.cxx - 20130121
// ======================
#ifdef _MSC_VER
#pragma warning ( disable : 4996 ) // The POSIX name for this item is deprecated. 
#endif

#include <sys/types.h>
#include <sys/stat.h>
#include <stdio.h>
#include <stdlib.h>
#include "INI.h"

#ifndef TEST_INI
#define TEST_INI "test.ini"
#endif

enum ini_typ {
    it_none = 0,
    it_string,
    it_int
};

typedef struct	tagINILIST {	/* i */
	char *  i_Sect;
    char *  i_Name;
	char *	i_Item;
	ini_typ i_Type;
	char *	i_Deft;
}INILIST, *PINILIST;

char *sect1 = (char *)"First";

char *item1 = (char *)"String";
char *def1  = (char *)"";
char *val1  = 0;

char *item2 = (char *)"Val";
int   def2  = 0;
int   val2  = -1;

char *sect2 = (char *)"Second";

char *item21 = (char *)"String";
char *def21  = (char *)"";
char *val21  = 0;

char *item22 = (char *)"Val";
int   def22  = 0;
int   val22  = -1;

char *item23 = (char *)"Length";
int   def23  = 0;
int   val23  = -1;

char *sect3 = (char *)"Third";
char *item31 = (char *)"Name";
char *def31 = (char *)"zute";
char *val31 = 0;

INILIST iniList[] = {
    { sect1, item1, val1, it_string, def1 },
    { sect1, item2, (char *)&val2, it_int, (char *)&def2 },
    { sect2, item21, val21, it_string, def21 },
    { sect2, item22, (char *)&val22, it_int, (char *)&def22 },
    { sect2, item23, (char *)&val23, it_int, (char *)&def23 },
    { sect3, item31, val31, it_string, def31 },
    // last in list
    { 0, 0, 0, it_none, 0 }
};




std::string file(TEST_INI);
int load_def_file( std::string &fil, bool verb = false );

int load_def_file( std::string &fil, bool verb )
{
    INI<> ini(fil,false);
    if (!ini.Parse()) {
        std::cout << "Load of file [" << fil << "] FAILED!" << std::endl;
        return 1;
    }
    PINILIST pini = &iniList[0];
    char *sect;
    char *name;
    char *item;
    char *def;
    ini_typ typ;
    std::string s;
    if (verb)
        std::cout << "Loaded file [" << fil << "]" << std::endl;
    while (pini->i_Type != it_none) {
        sect = pini->i_Sect;
        name = pini->i_Name;
        item = pini->i_Item;
        def  = pini->i_Deft;
        typ  = pini->i_Type;
        if (verb)
            std::cout << "Section [" << sect << "], name " << name;
        switch (typ)
        {
        case it_string:
            s = def;    // set default, whether there is a section or not
            if (verb)
                std::cout << ", string, def " << s;
            if (ini.Select(sect)) {
                s = ini.Get<std::string,std::string>(name,def);
                if (verb) {
                    if (strcmp(def,s.c_str()))
                        std::cout << ", fnd value " << s;
                    else
                        std::cout << ", NOT found, using def";
                }
            } else if (verb) {
                std::cout << ", section NOT found! Used def";
            }
            item = strdup(s.c_str());
            break;

        case it_int:
            int *pint = (int *)def;
            int idef = *pint;   // set default, whether a section or not
            if (verb)
                std::cout << ", int, def " << idef;
            if (ini.Select(sect)) {
                idef = ini.Get<std::string,int>(name,idef);
                if (verb) {
                    if (idef == *pint)
                        std::cout << ", not found, using default";
                    else
                        std::cout << ", fnd value " << idef;
                }
            } else if (verb) {
                std::cout << ", section NOT found! Used def";
            }
            pint = (int *)item;
            *pint = idef;
            break;
        }
        if (verb)
            std::cout << std::endl;
        pini++;
    }
    return 0;
}

/////////////////////////////////////////////////////////////////////
// Load and enumerate an INI file
/////////////////////////////////////////////////////////////////////
void load_ini_file( std::string &file )
{
    size_t cnt;
    std::string s;
    //INI<std::string,std::string,std::string> ini(file,false);
    INI<> ini(file,false);
    if (ini.Parse()) {
        cnt = ini.sections.size();
        std::cout << "File: [" << file << "] has " << cnt << " sections." << std::endl;
        for(INI<>::sectionsit_t i = ini.sections.begin(); i != ini.sections.end(); i++) {
            cnt = i->second->size();
            const std::string sect = i->first;
            std::cout << "Section [" << sect << "], has " << cnt << " key=val pairs" << std::endl;
            cnt = 0;
            for(INI<>::keysit_t j = i->second->begin(); j != i->second->end(); j++) {
                //key and value
                cnt++;
                const std::string key = j->first;
                const std::string val = j->second;
                std::cout << "#" << cnt << ": " << key << " = " << val << std::endl;
            }
        }
        // ini.Clear();    // delete the load
    } else {
        std::cout << "Load of file [" << file << "] FAILED!" << std::endl;
    }
}

////////////////////////////////////////////////////////////////////////////
// If no input, attempt to load the default test file
// else treat input as INI file names
// Load and enumerate each
////////////////////////////////////////////////////////////////////////////
int main( int argc, char **argv )
{
    int iret = 0;
    std::string s;
    char *arg;
    int val;
    if ( argc < 2 ) {
        std::cout << "No input. Loading default test INI file " << file << std::endl;
        load_def_file( file, true );  // try loading the default test file
    } else {
        for (val = 1; val < argc; val++) {
            arg = argv[val];
            if (*arg == '-') {
                std::cout << "Only input are INI file names! Aborting..." << std::endl;
                return 1;
            }
            s = arg;
            load_ini_file(s);  // try loading the users file
        }
    }
    return iret;
}

// eof

