// Example that shows simple usage of the INIReader class

#include <iostream>
#include "INIReader.h"

#ifndef TEST_INI
#define TEST_INI "../examples/test.ini"
#endif

int main()
{
    INIReader reader(TEST_INI);

    if (reader.ParseError() < 0) {
        std::cout << "Can't load 'test.ini'\n";
        return 1;
    }
    std::cout << "Config loaded from 'test.ini': version="
              << reader.GetInteger("protocol", "version", -1) << ", name="
              << reader.Get("user", "name", "UNKNOWN") << ", email="
              << reader.Get("user", "email", "UNKNOWN") << ", active="
              << reader.GetBoolean("user", "active", true) << "\n";
    return 0;
}
