@setlocal
@echo # Script to test most of the SPCS zones.
@echo #
@echo # Original script generated from execution of NMD's program l176, where
@echo #   the second pair of numbers are respective easting and northing output.
@echo # This is a WIN32 port of that script
@echo #
@echo # Proj will vary in the .001ft range with projections using Transverse
@echo #   Mercator due to greater precision of meridinal distance function.
@echo #

@if "%PROJ_LIB%x" == "x" (
@set PROJ_LIB=..\..\nad
)
@REM To SEE what is, and is NOT loaded...
@REM set PROJ_DEBUG=9

@set EXE=bin\proj.exe
@set OUT=temp_out83.txt
@set INIT_FILE=%PROJ_LIB%\nad83
@set DIST=%PROJ_LIB%\pj_out83.dist
@set INP=temp_in83.txt

@if NOT EXIST %EXE% goto NOEXE
@if NOT EXIST %PROJ_LIB%\. goto NODIR
@if NOT EXIST %INIT_FILE% goto NONAD

@REM Test for GNU type 'diff' in the PATH
@diff --version >nul
@if ERRORLEVEL 1 goto USECOMP
@set DIFF=diff -w
@echo Found, and using [%DIFF%] for the difference at the end...
@goto DNDIFF

:USECOMP
@REM NO the windows native 'comp.exe' will NOT 'ignore spaces'!!!
@REM So do NOT do a DIFF !!!
@set DIFF=NO
@echo NOTE: diff NOT found in PATH, so CAN NOT DO a difference at the end. Not good...
@echo Go to http://unxutils.sourceforge.net/ for Native Win32 ports of some GNU utilities
@echo and extract and place the 'diff.exe' in a folder in your PATH environment.
@echo.
:DNDIFF

@if EXIST %DIST% goto DNDIST
@echo.
@echo WARNING: Can NOT locate file [%DIST%]! So will be UNABLE to do comparison at end...
@echo.
:DNDIST

@echo *** CONTINUE? *** Ctrl+C to abort... Environment [PROJ_LIB=%PROJ_LIB%]
@if "%TEMPNP%x" == "yesx" (
@echo NO PAUSE [TEMPNP=yes] set in environment...
@set EXE=@%EXE%
) else (
@pause
)

@echo ============================================
@echo Running %0, using %EXE%, PROJ_LIB=%PROJ_LIB%
@echo ============================================

@if EXIST %OUT% @del %OUT%

@echo Doing tests into file [%OUT%], please wait...

@echo  -134d00'00.000  55d00'00.000   2616018.154   1156379.643 AK 1 GP1 >%INP%
%EXE% +units=us-ft +init=%INIT_FILE%:5001 -E -f %%.3f %INP% >%OUT%

@echo  -133d40'00.000  57d00'00.000   2685941.919   1886799.668 AK 1 GP2 >%INP%
%EXE% +units=us-ft +init=%INIT_FILE%:5001 -E -f %%.3f %INP% >>%OUT%

@echo  -131d35'45.432  54d39'02.654   3124531.426   1035343.511 AK 1 GP3 >%INP%
%EXE% +units=us-ft +init=%INIT_FILE%:5001 -E -f %%.3f %INP% >>%OUT%

@echo  -129d32'30.000  54d32'30.000   3561448.345   1015025.876 AK 1 GP4 >%INP%
%EXE% +units=us-ft +init=%INIT_FILE%:5001 -E -f %%.3f %INP% >>%OUT%

@echo  -141d30'00.000  60d30'00.000   1276328.587   3248159.207 AK 1 GP6 >%INP%
%EXE% +units=us-ft +init=%INIT_FILE%:5001 -E -f %%.3f %INP% >>%OUT%

@echo  -142d00'00.000  56d30'30.000   1640416.667    916074.825 AK 2 GP1 >%INP%
%EXE% +units=us-ft +init=%INIT_FILE%:5002 -E -f %%.3f %INP% >>%OUT%

@echo  -146d00'00.000  56d30'30.000   1640416.667    916074.825 AK 3 GP1 >%INP%
%EXE% +units=us-ft +init=%INIT_FILE%:5003 -E -f %%.3f %INP% >>%OUT%

@echo  -150d00'00.000  56d30'30.000   1640416.667    916074.825 AK 4 GP1 >%INP%
%EXE% +units=us-ft +init=%INIT_FILE%:5004 -E -f %%.3f %INP% >>%OUT%

@echo  -152d28'56.134  60d53'28.765   1910718.662   2520810.680 AK 5 GP1 >%INP%
%EXE% +units=us-ft +init=%INIT_FILE%:5005 -E -f %%.3f %INP% >>%OUT%

@echo  -154d00'00.000  56d30'30.000   1640416.667    916074.825 AK 5 GP2 >%INP%
%EXE% +units=us-ft +init=%INIT_FILE%:5005 -E -f %%.3f %INP% >>%OUT%

@echo  -155d00'00.000  71d00'00.000   1998036.998   6224208.217 AK 6 GP1 >%INP%
%EXE% +units=us-ft +init=%INIT_FILE%:5006 -E -f %%.3f %INP% >>%OUT%

@echo  -158d00'00.000  71d00'00.000   1640416.667   6215353.367 AK 6 GP1 >%INP%
%EXE% +units=us-ft +init=%INIT_FILE%:5006 -E -f %%.3f %INP% >>%OUT%

@echo  -162d00'00.000  65d15'00.000   1640416.667   4111446.441 AK 7 GP1 >%INP%
%EXE% +units=us-ft +init=%INIT_FILE%:5007 -E -f %%.3f %INP% >>%OUT%

@echo  -166d00'00.000  65d15'00.000   1640416.667   4111446.441 AK 8 GP1 >%INP%
%EXE% +units=us-ft +init=%INIT_FILE%:5008 -E -f %%.3f %INP% >>%OUT%

@echo  -170d00'00.000  63d20'00.000   1640416.667   3410489.717 AK 9 GP1 >%INP%
%EXE% +units=us-ft +init=%INIT_FILE%:5009 -E -f %%.3f %INP% >>%OUT%

@echo  -164d02'30.000  54d27'30.000   5814167.604   1473788.834 AK10 GP1 >%INP%
%EXE% +units=us-ft +init=%INIT_FILE%:5010 -E -f %%.3f %INP% >>%OUT%

@echo  -176d00'00.000  52d30'00.000   3280833.333    547580.542 AK10 GP2 >%INP%
%EXE% +units=us-ft +init=%INIT_FILE%:5010 -E -f %%.3f %INP% >>%OUT%

@echo   -85d50'00.000  31d20'00.000    656166.667    303104.183 AL E GP1 >%INP%
%EXE% +units=us-ft +init=%INIT_FILE%:101 -E -f %%.3f %INP% >>%OUT%

@echo   -85d12'41.738  32d38'57.737    847539.085    782420.807 AL E GP2 >%INP%
%EXE% +units=us-ft +init=%INIT_FILE%:101 -E -f %%.3f %INP% >>%OUT%

@echo   -86d36'58.670  34d48'58.708    421151.975   1571298.908 AL E GP3 >%INP%
%EXE% +units=us-ft +init=%INIT_FILE%:101 -E -f %%.3f %INP% >>%OUT%

@echo   -87d30'00.000  33d20'00.000   1968500.000   1212527.587 AL W GP1 >%INP%
%EXE% +units=us-ft +init=%INIT_FILE%:102 -E -f %%.3f %INP% >>%OUT%

@echo   -87d30'00.000  33d20'30.000   1968500.000   1215559.708 AL W GP2 >%INP%
%EXE% +units=us-ft +init=%INIT_FILE%:102 -E -f %%.3f %INP% >>%OUT%

@echo   -91d34'46.321  35d18'37.443   1437779.156    355900.759 AR N GP1 >%INP%
%EXE% +units=us-ft +init=%INIT_FILE%:301 -E -f %%.3f %INP% >>%OUT%

@echo   -92d04'11.625  35d19'34.269   1291483.982    361385.695 AR N GP2 >%INP%
%EXE% +units=us-ft +init=%INIT_FILE%:301 -E -f %%.3f %INP% >>%OUT%

@echo   -92d00'00.000  34d45'00.000   1312333.333   2070451.744 AR S GP1 >%INP%
%EXE% +units=us-ft +init=%INIT_FILE%:302 -E -f %%.3f %INP% >>%OUT%

@echo   -92d00'00.000  33d15'00.000   1312333.333   1524603.730 AR S GP2 >%INP%
%EXE% +units=us-ft +init=%INIT_FILE%:302 -E -f %%.3f %INP% >>%OUT%

@echo  -111d55'00.000  34d45'00.000    699998.600   1364309.666 AZ C GP1 >%INP%
%EXE% +units=us-ft +init=%INIT_FILE%:202 -E -f %%.3f %INP% >>%OUT%

@echo  -111d55'00.000  32d20'00.000    699998.600    484994.340 AZ C GP2 >%INP%
%EXE% +units=us-ft +init=%INIT_FILE%:202 -E -f %%.3f %INP% >>%OUT%

@echo  -110d24'59.771  35d09'58.568    625301.460   1515899.830 AZ E GP1 >%INP%
%EXE% +units=us-ft +init=%INIT_FILE%:201 -E -f %%.3f %INP% >>%OUT%

@echo  -109d34'33.127  31d59'53.103    883142.524    363539.663 AZ E GP2 >%INP%
%EXE% +units=us-ft +init=%INIT_FILE%:201 -E -f %%.3f %INP% >>%OUT%

@echo  -110d30'34.948  35d07'28.243    597423.277   1500785.235 AZ E GP3 >%INP%
%EXE% +units=us-ft +init=%INIT_FILE%:201 -E -f %%.3f %INP% >>%OUT%

@echo  -109d45'13.226  32d08'41.778    827818.955    416705.394 AZ E GP4 >%INP%
%EXE% +units=us-ft +init=%INIT_FILE%:201 -E -f %%.3f %INP% >>%OUT%

@echo  -113d45'00.000  34d45'00.000    699998.600   1364355.147 AZ W GP1 >%INP%
%EXE% +units=us-ft +init=%INIT_FILE%:203 -E -f %%.3f %INP% >>%OUT%

@echo  -113d45'00.000  34d45'30.000    699998.600   1367387.968 AZ W GP2 >%INP%
%EXE% +units=us-ft +init=%INIT_FILE%:203 -E -f %%.3f %INP% >>%OUT%

@echo  -113d45'00.000  34d46'00.000    699998.600   1370420.793 AZ W GP3 >%INP%
%EXE% +units=us-ft +init=%INIT_FILE%:203 -E -f %%.3f %INP% >>%OUT%

@echo  -122d00'00.000  41d30'00.000   6561666.667   2429744.729 CA 1 GP1 >%INP%
%EXE% +units=us-ft +init=%INIT_FILE%:401 -E -f %%.3f %INP% >>%OUT%

@echo  -122d00'00.000  41d30'30.000   6561666.667   2432781.128 CA 1 GP2 >%INP%
%EXE% +units=us-ft +init=%INIT_FILE%:401 -E -f %%.3f %INP% >>%OUT%

@echo  -122d00'00.000  39d20'00.000   6561666.667   2247404.250 CA 2 GP1 >%INP%
%EXE% +units=us-ft +init=%INIT_FILE%:402 -E -f %%.3f %INP% >>%OUT%

@echo  -122d00'00.000  39d20'30.000   6561666.667   2250439.391 CA 2 GP2 >%INP%
%EXE% +units=us-ft +init=%INIT_FILE%:402 -E -f %%.3f %INP% >>%OUT%

@echo  -120d30'00.000  37d05'00.000   6561666.667   1852815.760 CA 3 GP1 >%INP%
%EXE% +units=us-ft +init=%INIT_FILE%:403 -E -f %%.3f %INP% >>%OUT%

@echo  -121d22'26.019  37d30'30.324   6308189.835   2008776.145 CA 3 GP2 >%INP%
%EXE% +units=us-ft +init=%INIT_FILE%:403 -E -f %%.3f %INP% >>%OUT%

@echo  -119d46'32.733  37d07'41.470   6772808.251   1869963.783 CA 3 GP3 >%INP%
%EXE% +units=us-ft +init=%INIT_FILE%:403 -E -f %%.3f %INP% >>%OUT%

@echo  -119d38'26.434  36d55'48.009   6812851.254   1798140.563 CA 3 GP4 >%INP%
%EXE% +units=us-ft +init=%INIT_FILE%:403 -E -f %%.3f %INP% >>%OUT%

@echo  -120d42'59.779  38d06'52.815   6499349.432   2228414.867 CA 3 GP5 >%INP%
%EXE% +units=us-ft +init=%INIT_FILE%:403 -E -f %%.3f %INP% >>%OUT%

@echo  -119d00'00.000  36d20'00.000   6561666.667   2004462.102 CA 4 GP1 >%INP%
%EXE% +units=us-ft +init=%INIT_FILE%:404 -E -f %%.3f %INP% >>%OUT%

@echo  -119d00'00.000  36d20'30.000   6561666.667   2007495.782 CA 4 GP2 >%INP%
%EXE% +units=us-ft +init=%INIT_FILE%:404 -E -f %%.3f %INP% >>%OUT%

@echo  -118d00'00.000  34d45'00.000   6561666.667   2095323.781 CA 5 GP1 >%INP%
%EXE% +units=us-ft +init=%INIT_FILE%:405 -E -f %%.3f %INP% >>%OUT%

@echo  -118d00'00.000  34d45'30.000   6561666.667   2098356.568 CA 5 GP2 >%INP%
%EXE% +units=us-ft +init=%INIT_FILE%:405 -E -f %%.3f %INP% >>%OUT%

@echo  -116d15'00.000  33d20'00.000   6561666.667   2064911.626 CA 6 GP1 >%INP%
%EXE% +units=us-ft +init=%INIT_FILE%:406 -E -f %%.3f %INP% >>%OUT%

@echo  -116d15'00.000  33d20'30.000   6561666.667   2067943.810 CA 6 GP2 >%INP%
%EXE% +units=us-ft +init=%INIT_FILE%:406 -E -f %%.3f %INP% >>%OUT%

@echo  -118d20'00.000  34d30'00.000   5933874.572   2495758.727 CA 7 GP1 >%INP%
%EXE% +units=us-ft +init=%INIT_FILE%:406 -E -f %%.3f %INP% >>%OUT%

@echo  -105d30'00.000  39d15'00.000   3000000.000   1515946.820 CO C GP1 >%INP%
%EXE% +units=us-ft +init=%INIT_FILE%:502 -E -f %%.3f %INP% >>%OUT%

@echo  -105d30'00.000  39d15'30.000   3000000.000   1518981.963 CO C GP2 >%INP%
%EXE% +units=us-ft +init=%INIT_FILE%:502 -E -f %%.3f %INP% >>%OUT%

@echo  -108d45'55.378  40d25'33.504   2091110.958   1414758.884 CO N GP1 >%INP%
%EXE% +units=us-ft +init=%INIT_FILE%:501 -E -f %%.3f %INP% >>%OUT%

@echo  -105d14'45.588  40d12'42.711   3070938.779   1320125.979 CO N GP2 >%INP%
%EXE% +units=us-ft +init=%INIT_FILE%:501 -E -f %%.3f %INP% >>%OUT%

@echo  -105d30'00.000  37d30'00.000   3000000.000   1303432.168 CO S GP1 >%INP%
%EXE% +units=us-ft +init=%INIT_FILE%:503 -E -f %%.3f %INP% >>%OUT%

@echo  -105d30'00.000  37d30'30.000   3000000.000   1306466.471 CO S GP2 >%INP%
%EXE% +units=us-ft +init=%INIT_FILE%:503 -E -f %%.3f %INP% >>%OUT%

@echo   -72d43'30.515  41d16'55.847   1006831.954    663542.786 CT   GP1 >%INP%
%EXE% +units=us-ft +init=%INIT_FILE%:600 -E -f %%.3f %INP% >>%OUT%

@echo   -73d01'15.609  41d13'25.985    925448.220    642418.129 CT   GP2 >%INP%
%EXE% +units=us-ft +init=%INIT_FILE%:600 -E -f %%.3f %INP% >>%OUT%

@echo   -75d33'00.748  39d21'15.214    618403.524    493238.843 DE   GP1 >%INP%
%EXE% +units=us-ft +init=%INIT_FILE%:700 -E -f %%.3f %INP% >>%OUT%

@echo   -75d19'01.889  39d45'14.765    684135.532    638883.528 DE   GP2 >%INP%
%EXE% +units=us-ft +init=%INIT_FILE%:700 -E -f %%.3f %INP% >>%OUT%

@echo   -82d45'52.412  29d39'06.589   2519743.236    241248.726 FL N GP1 >%INP%
%EXE% +units=us-ft +init=%INIT_FILE%:903 -E -f %%.3f %INP% >>%OUT%

@echo   -84d55'11.533  29d38'51.982   1835122.674    235823.399 FL N GP2 >%INP%
%EXE% +units=us-ft +init=%INIT_FILE%:903 -E -f %%.3f %INP% >>%OUT%

@echo   -81d27'15.592  32d38'03.003    875449.222    958850.568 GA E GP1 >%INP%
%EXE% +units=us-ft +init=%INIT_FILE%:1001 -E -f %%.3f %INP% >>%OUT%

@echo   -83d15'39.990  33d29'58.626    322535.391   1274748.301 GA E GP2 >%INP%
%EXE% +units=us-ft +init=%INIT_FILE%:1001 -E -f %%.3f %INP% >>%OUT%

@echo  -155d59'16.911  19d37'23.477   1472470.137    287083.198 HI 1 GP1 >%INP%
%EXE% +units=us-ft +init=%INIT_FILE%:5101 -E -f %%.3f %INP% >>%OUT%

@echo  -155d18'06.262  19d31'24.578   1708685.701    250676.240 HI 1 GP2 >%INP%
%EXE% +units=us-ft +init=%INIT_FILE%:5101 -E -f %%.3f %INP% >>%OUT%

@echo  -155d30'00.000  19d42'00.000   1640416.667    314739.275 HI 1 GP3 >%INP%
%EXE% +units=us-ft +init=%INIT_FILE%:5101 -E -f %%.3f %INP% >>%OUT%

@echo  -155d30'00.000  19d42'30.000   1640416.667    317765.760 HI 1 GP4 >%INP%
%EXE% +units=us-ft +init=%INIT_FILE%:5101 -E -f %%.3f %INP% >>%OUT%

@echo  -156d40'00.000  20d42'00.000   1640416.667    133177.588 HI 2 GP1 >%INP%
%EXE% +units=us-ft +init=%INIT_FILE%:5102 -E -f %%.3f %INP% >>%OUT%

@echo  -156d40'00.000  20d42'30.000   1640416.667    136204.417 HI 2 GP2 >%INP%
%EXE% +units=us-ft +init=%INIT_FILE%:5102 -E -f %%.3f %INP% >>%OUT%

@echo  -158d00'00.000  21d30'00.000   1640416.667    121084.931 HI 3 GP1 >%INP%
%EXE% +units=us-ft +init=%INIT_FILE%:5103 -E -f %%.3f %INP% >>%OUT%

@echo  -158d01'30.000  21d37'30.000   1631925.017    166493.704 HI 3 GP2 >%INP%
%EXE% +units=us-ft +init=%INIT_FILE%:5103 -E -f %%.3f %INP% >>%OUT%

@echo  -159d30'00.000  22d05'00.000   1640416.667     90820.525 HI 4 GP1 >%INP%
%EXE% +units=us-ft +init=%INIT_FILE%:5104 -E -f %%.3f %INP% >>%OUT%

@echo  -160d10'00.000  21d42'00.000   1640416.667     12109.121 HI 5 GP1 >%INP%
%EXE% +units=us-ft +init=%INIT_FILE%:5105 -E -f %%.3f %INP% >>%OUT%

@echo   -93d28'33.966  42d44'50.101   4927669.136   3735362.601 IA N GP1 >%INP%
%EXE% +units=us-ft +init=%INIT_FILE%:1401 -E -f %%.3f %INP% >>%OUT%

@echo   -93d54'22.084  42d40'23.699   4812032.409   3708655.393 IA N GP2 >%INP%
%EXE% +units=us-ft +init=%INIT_FILE%:1401 -E -f %%.3f %INP% >>%OUT%

@echo  -111d42'29.824  43d48'07.616    777180.670    778579.414 ID E GP1 >%INP%
%EXE% +units=us-ft +init=%INIT_FILE%:1101 -E -f %%.3f %INP% >>%OUT%

@echo  -112d22'35.516  43d35'26.260    600566.613    701226.817 ID E GP2 >%INP%
%EXE% +units=us-ft +init=%INIT_FILE%:1101 -E -f %%.3f %INP% >>%OUT%

@echo  -116d22'02.592  48d07'50.941   2473902.726   2357266.577 ID W GP1 >%INP%
%EXE% +units=us-ft +init=%INIT_FILE%:1103 -E -f %%.3f %INP% >>%OUT%

@echo   -88d07'06.790  41d46'11.855   1042839.901   1858837.259 IL E GP1 >%INP%
%EXE% +units=us-ft +init=%INIT_FILE%:1201 -E -f %%.3f %INP% >>%OUT%

@echo   -88d41'35.208  40d43'37.202    884532.422   1478959.912 IL E GP2 >%INP%
%EXE% +units=us-ft +init=%INIT_FILE%:1201 -E -f %%.3f %INP% >>%OUT%

@echo   -85d40'00.000  40d00'00.000    328083.333   1730697.447 IN E GP1 >%INP%
%EXE% +units=us-ft +init=%INIT_FILE%:1301 -E -f %%.3f %INP% >>%OUT%

@echo   -85d40'00.000  40d00'30.000    328083.333   1733733.066 IN E GP2 >%INP%
%EXE% +units=us-ft +init=%INIT_FILE%:1301 -E -f %%.3f %INP% >>%OUT%

@echo   -86d14'27.780  40d00'12.690    167175.533   1732499.995 IN E GP3 >%INP%
%EXE% +units=us-ft +init=%INIT_FILE%:1301 -E -f %%.3f %INP% >>%OUT%

@echo   -86d14'27.790  40d00'31.660    167187.126   1734419.540 IN E GP4 >%INP%
%EXE% +units=us-ft +init=%INIT_FILE%:1301 -E -f %%.3f %INP% >>%OUT%

@echo   -86d14'28.103  40d00'47.412    167173.047   1736013.616 IN E GP6 >%INP%
%EXE% +units=us-ft +init=%INIT_FILE%:1301 -E -f %%.3f %INP% >>%OUT%

@echo   -87d05'00.000  40d00'00.000   2952750.000   1730697.447 IN W GP1 >%INP%
%EXE% +units=us-ft +init=%INIT_FILE%:1302 -E -f %%.3f %INP% >>%OUT%

@echo   -87d05'00.000  40d00'30.000   2952750.000   1733733.066 IN W GP2 >%INP%
%EXE% +units=us-ft +init=%INIT_FILE%:1302 -E -f %%.3f %INP% >>%OUT%

@echo   -86d45'10.717  39d41'24.840   3045717.498   1618031.699 IN W GP3 >%INP%
%EXE% +units=us-ft +init=%INIT_FILE%:1302 -E -f %%.3f %INP% >>%OUT%

@echo   -87d41'44.075  37d54'24.755   2776105.988    968944.255 IN W GP4 >%INP%
%EXE% +units=us-ft +init=%INIT_FILE%:1302 -E -f %%.3f %INP% >>%OUT%

@echo   -86d32'13.179  39d32'46.419   3106817.690   1565874.113 IN W GP5 >%INP%
%EXE% +units=us-ft +init=%INIT_FILE%:1302 -E -f %%.3f %INP% >>%OUT%

@echo   -87d25'26.675  38d26'17.646   2855150.544   1162044.125 IN W GP6 >%INP%
%EXE% +units=us-ft +init=%INIT_FILE%:1302 -E -f %%.3f %INP% >>%OUT%

@echo   -86d14'28.103  40d00'47.412   3188649.790   1736609.724 IN W GP7 >%INP%
%EXE% +units=us-ft +init=%INIT_FILE%:1302 -E -f %%.3f %INP% >>%OUT%

@echo   -86d14'27.780  40d00'12.690   3188708.130   1733096.467 IN W GP8 >%INP%
%EXE% +units=us-ft +init=%INIT_FILE%:1302 -E -f %%.3f %INP% >>%OUT%

@echo   -86d14'27.790  40d00'31.660   3188689.210   1735016.020 IN W GP9 >%INP%
%EXE% +units=us-ft +init=%INIT_FILE%:1302 -E -f %%.3f %INP% >>%OUT%

@echo   -96d47'54.567  38d58'52.096   1653880.047    238201.110 KS N GP1 >%INP%
%EXE% +units=us-ft +init=%INIT_FILE%:1501 -E -f %%.3f %INP% >>%OUT%

@echo   -98d35'23.954  39d58'41.967   1146983.460    599694.197 KS N GP2 >%INP%
%EXE% +units=us-ft +init=%INIT_FILE%:1501 -E -f %%.3f %INP% >>%OUT%

@echo   -84d05'43.283  38d14'35.963   1684830.325    270726.733 KY N GP1 >%INP%
%EXE% +units=us-ft +init=%INIT_FILE%:1601 -E -f %%.3f %INP% >>%OUT%

@echo   -84d26'49.265  39d04'03.099   1584475.157    570918.805 KY N GP2 >%INP%
%EXE% +units=us-ft +init=%INIT_FILE%:1601 -E -f %%.3f %INP% >>%OUT%

@echo   -91d34'46.483  31d57'26.243   3566283.410    531318.874 LA N GP1 >%INP%
%EXE% +units=us-ft +init=%INIT_FILE%:1701 -E -f %%.3f %INP% >>%OUT%

@echo   -92d52'46.615  32d54'52.264   3164322.062    878564.036 LA N GP2 >%INP%
%EXE% +units=us-ft +init=%INIT_FILE%:1701 -E -f %%.3f %INP% >>%OUT%

@echo   -91d29'09.480  31d56'44.721   3595353.711    527382.519 LA N GP3 >%INP%
%EXE% +units=us-ft +init=%INIT_FILE%:1701 -E -f %%.3f %INP% >>%OUT%

@echo   -93d59'38.241  32d48'43.467   2821809.119    844247.864 LA N GP4 >%INP%
%EXE% +units=us-ft +init=%INIT_FILE%:1701 -E -f %%.3f %INP% >>%OUT%

@echo   -89d00'00.000  28d50'00.000   4027995.272    128836.330 LA S GP1 >%INP%
%EXE% +units=us-ft +init=%INIT_FILE%:1702 -E -f %%.3f %INP% >>%OUT%

@echo   -89d30'00.000  28d50'00.000   3867904.667    125925.406 LA S GP2 >%INP%
%EXE% +units=us-ft +init=%INIT_FILE%:1702 -E -f %%.3f %INP% >>%OUT%

@echo   -89d29'59.999  29d19'59.994   3864995.756    307730.820 LA S GP3 >%INP%
%EXE% +units=us-ft +init=%INIT_FILE%:1702 -E -f %%.3f %INP% >>%OUT%

@echo   -89d00'00.004  29d19'59.998   4024292.645    310627.715 LA S GP4 >%INP%
%EXE% +units=us-ft +init=%INIT_FILE%:1702 -E -f %%.3f %INP% >>%OUT%

@echo   -89d10'23.487  29d20'32.615   3969054.663    312839.922 LA S GP5 >%INP%
%EXE% +units=us-ft +init=%INIT_FILE%:1702 -E -f %%.3f %INP% >>%OUT%

@echo   -89d06'34.632  29d15'19.642   3989919.298    281618.678 LA S GP6 >%INP%
%EXE% +units=us-ft +init=%INIT_FILE%:1702 -E -f %%.3f %INP% >>%OUT%

@echo   -89d01'33.803  29d07'47.918   4017480.813    236523.957 LA S GP7 >%INP%
%EXE% +units=us-ft +init=%INIT_FILE%:1702 -E -f %%.3f %INP% >>%OUT%

@echo   -89d08'45.781  28d58'27.979   3980254.597    179219.900 LA S GP9 >%INP%
%EXE% +units=us-ft +init=%INIT_FILE%:1702 -E -f %%.3f %INP% >>%OUT%

@echo   -70d27'00.716  41d40'15.808    942982.782   2706924.168 MA M GP1 >%INP%
%EXE% +units=us-ft +init=%INIT_FILE%:2001 -E -f %%.3f %INP% >>%OUT%

@echo   -73d25'59.173  42d06'06.860    131613.265   2868104.007 MA M GP2 >%INP%
%EXE% +units=us-ft +init=%INIT_FILE%:2001 -E -f %%.3f %INP% >>%OUT%

@echo   -76d11'27.492  39d12'06.132   1541600.105    560062.872 MD   GP1 >%INP%
%EXE% +units=us-ft +init=%INIT_FILE%:1900 -E -f %%.3f %INP% >>%OUT%

@echo   -77d02'30.406  38d26'37.492   1300367.185    283004.738 MD   GP2 >%INP%
%EXE% +units=us-ft +init=%INIT_FILE%:1900 -E -f %%.3f %INP% >>%OUT%

@echo   -77d30'10.460  38d59'25.903   1169392.711    482527.897 MD   GP3 >%INP%
%EXE% +units=us-ft +init=%INIT_FILE%:1900 -E -f %%.3f %INP% >>%OUT%

@echo   -68d24'25.489  46d32'46.920   1007629.154   1049880.999 ME E GP1 >%INP%
%EXE% +units=us-ft +init=%INIT_FILE%:1801 -E -f %%.3f %INP% >>%OUT%

@echo   -68d37'29.366  47d02'12.659    953127.598   1228762.971 ME E GP2 >%INP%
%EXE% +units=us-ft +init=%INIT_FILE%:1801 -E -f %%.3f %INP% >>%OUT%

@echo   -83d29'17.919  42d19'19.299  13360865.013    300809.378 MI S GP1 >%INP%
%EXE% +units=us-ft +init=%INIT_FILE%:2113 -E -f %%.3f %INP% >>%OUT%

@echo   -83d35'24.656  42d20'02.682  13333276.507    304929.978 MI S GP2 >%INP%
%EXE% +units=us-ft +init=%INIT_FILE%:2113 -E -f %%.3f %INP% >>%OUT%

@echo   -85d55'26.569  41d50'10.236  12698916.149    126441.631 MI S GP3 >%INP%
%EXE% +units=us-ft +init=%INIT_FILE%:2113 -E -f %%.3f %INP% >>%OUT%

@echo   -85d45'59.490  41d49'22.346  12741759.240    120840.463 MI S GP4 >%INP%
%EXE% +units=us-ft +init=%INIT_FILE%:2113 -E -f %%.3f %INP% >>%OUT%

@echo   -91d27'51.183  47d08'19.177   3031741.394    565338.600 MN N GP1 >%INP%
%EXE% +units=us-ft +init=%INIT_FILE%:2201 -E -f %%.3f %INP% >>%OUT%

@echo   -95d51'05.998  48d19'26.552   1955378.869   1005314.701 MN N GP2 >%INP%
%EXE% +units=us-ft +init=%INIT_FILE%:2201 -E -f %%.3f %INP% >>%OUT%

@echo   -92d30'00.000  38d15'00.000   1640416.667    879854.176 MO C GP1 >%INP%
%EXE% +units=us-ft +init=%INIT_FILE%:2402 -E -f %%.3f %INP% >>%OUT%

@echo   -92d30'00.000  38d15'30.000   1640416.667    882888.780 MO C GP2 >%INP%
%EXE% +units=us-ft +init=%INIT_FILE%:2402 -E -f %%.3f %INP% >>%OUT%

@echo   -91d42'04.297  37d22'05.932    471136.507    561031.592 MO E GP1 >%INP%
%EXE% +units=us-ft +init=%INIT_FILE%:2401 -E -f %%.3f %INP% >>%OUT%

@echo   -90d08'08.896  36d53'44.124    926703.606    386902.829 MO E GP2 >%INP%
%EXE% +units=us-ft +init=%INIT_FILE%:2401 -E -f %%.3f %INP% >>%OUT%

@echo   -94d30'00.000  38d15'00.000   2788708.333    758522.219 MO W GP1 >%INP%
%EXE% +units=us-ft +init=%INIT_FILE%:2403 -E -f %%.3f %INP% >>%OUT%

@echo   -94d30'00.000  38d15'30.000   2788708.333    761556.846 MO W GP2 >%INP%
%EXE% +units=us-ft +init=%INIT_FILE%:2403 -E -f %%.3f %INP% >>%OUT%

@echo   -89d10'14.013  30d30'51.338    878059.046    369015.468 MS E GP1 >%INP%
%EXE% +units=us-ft +init=%INIT_FILE%:2301 -E -f %%.3f %INP% >>%OUT%

@echo   -88d26'04.338  30d43'01.454   1109567.483    442842.466 MS E GP2 >%INP%
%EXE% +units=us-ft +init=%INIT_FILE%:2301 -E -f %%.3f %INP% >>%OUT%

@echo  -106d29'11.521  47d52'21.103   2707564.623   1334850.273 MT N GP1 >%INP%
%EXE% +units=us-ft +init=%INIT_FILE%:2500 -E -f %%.3f %INP% >>%OUT%

@echo  -114d30'43.122  48d52'46.764    763315.457   1726511.247 MT N GP2 >%INP%
%EXE% +units=us-ft +init=%INIT_FILE%:2500 -E -f %%.3f %INP% >>%OUT%

@echo   -81d12'31.790  35d09'31.049   1339869.379    520003.003 NC   GP1 >%INP%
%EXE% +units=us-ft +init=%INIT_FILE%:3200 -E -f %%.3f %INP% >>%OUT%

@echo   -76d31'54.918  35d33'51.452   2733923.842    669426.932 NC   GP2 >%INP%
%EXE% +units=us-ft +init=%INIT_FILE%:3200 -E -f %%.3f %INP% >>%OUT%

@echo   -78d28'26.580  36d15'15.480   2155084.559    911885.081 NC   GP3 >%INP%
%EXE% +units=us-ft +init=%INIT_FILE%:3200 -E -f %%.3f %INP% >>%OUT%

@echo   -98d46'03.232  48d08'13.483   2391470.474    419526.909 ND N GP1 >%INP%
%EXE% +units=us-ft +init=%INIT_FILE%:3301 -E -f %%.3f %INP% >>%OUT%

@echo  -101d18'21.456  47d39'18.935   1769873.906    240054.790 ND N GP2 >%INP%
%EXE% +units=us-ft +init=%INIT_FILE%:3301 -E -f %%.3f %INP% >>%OUT%

@echo   -96d17'52.930  42d04'48.305   2644820.409    839912.565 NE N GP1 >%INP%
%EXE% +units=us-ft +init=%INIT_FILE%:2600 -E -f %%.3f %INP% >>%OUT%

@echo  -100d49'26.949  41d58'54.025   1416403.828    783622.046 NE N GP2 >%INP%
%EXE% +units=us-ft +init=%INIT_FILE%:2600 -E -f %%.3f %INP% >>%OUT%

@echo   -70d56'11.287  43d08'15.006   1179151.981    233188.620 NH   GP1 >%INP%
%EXE% +units=us-ft +init=%INIT_FILE%:2800 -E -f %%.3f %INP% >>%OUT%

@echo   -72d32'32.197  42d51'25.984    749470.166    131406.173 NH   GP2 >%INP%
%EXE% +units=us-ft +init=%INIT_FILE%:2800 -E -f %%.3f %INP% >>%OUT%

@echo   -74d13'55.737  39d52'02.095    567304.543    376673.733 NJ   GP1 >%INP%
%EXE% +units=us-ft +init=%INIT_FILE%:2900 -E -f %%.3f %INP% >>%OUT%

@echo   -74d51'24.058  41d12'07.401    393979.614    863010.549 NJ   GP2 >%INP%
%EXE% +units=us-ft +init=%INIT_FILE%:2900 -E -f %%.3f %INP% >>%OUT%

@echo  -106d15'00.000  33d30'00.000   1640416.667    909448.493 NM C GP1 >%INP%
%EXE% +units=us-ft +init=%INIT_FILE%:3002 -E -f %%.3f %INP% >>%OUT%

@echo  -106d15'00.000  33d30'30.000   1640416.667    912480.595 NM C GP2 >%INP%
%EXE% +units=us-ft +init=%INIT_FILE%:3002 -E -f %%.3f %INP% >>%OUT%

@echo  -104d11'42.410  33d17'21.732    583573.491    832847.194 NM E GP1 >%INP%
%EXE% +units=us-ft +init=%INIT_FILE%:3001 -E -f %%.3f %INP% >>%OUT%

@echo  -104d47'37.948  33d22'32.349    400747.149    864523.566 NM E GP2 >%INP%
%EXE% +units=us-ft +init=%INIT_FILE%:3001 -E -f %%.3f %INP% >>%OUT%

@echo  -107d50'00.000  32d30'00.000   2723091.667    545634.896 NM W GP1 >%INP%
%EXE% +units=us-ft +init=%INIT_FILE%:3003 -E -f %%.3f %INP% >>%OUT%

@echo  -107d50'00.000  32d30'30.000   2723091.667    548666.562 NM W GP2 >%INP%
%EXE% +units=us-ft +init=%INIT_FILE%:3003 -E -f %%.3f %INP% >>%OUT%

@echo  -114d49'09.337  35d43'09.299    882966.545  26600313.129 NV E GP1 >%INP%
%EXE% +units=us-ft +init=%INIT_FILE%:2701 -E -f %%.3f %INP% >>%OUT%

@echo  -116d50'32.766  41d30'37.869    311338.993  28710910.565 NV E GP2 >%INP%
%EXE% +units=us-ft +init=%INIT_FILE%:2701 -E -f %%.3f %INP% >>%OUT%

@echo   -74d02'53.671  42d17'01.775    614362.369   1257287.611 NY E GP1 >%INP%
%EXE% +units=us-ft +init=%INIT_FILE%:3101 -E -f %%.3f %INP% >>%OUT%

@echo   -74d44'39.818  42d30'07.382    426225.275   1336579.561 NY E GP2 >%INP%
%EXE% +units=us-ft +init=%INIT_FILE%:3101 -E -f %%.3f %INP% >>%OUT%

@echo   -73d02'36.247  40d47'50.624   1249103.533    231235.845 NY L GP1 >%INP%
%EXE% +units=us-ft +init=%INIT_FILE%:3104 -E -f %%.3f %INP% >>%OUT%

@echo   -74d06'58.125  40d36'07.281    951997.667    158630.811 NY L GP2 >%INP%
%EXE% +units=us-ft +init=%INIT_FILE%:3104 -E -f %%.3f %INP% >>%OUT%

@echo   -74d00'00.000  40d45'00.000    984250.000    212521.887 NY L GP3 >%INP%
%EXE% +units=us-ft +init=%INIT_FILE%:3104 -E -f %%.3f %INP% >>%OUT%

@echo   -73d15'00.000  40d37'30.000   1192442.028    167871.999 NY L GP4 >%INP%
%EXE% +units=us-ft +init=%INIT_FILE%:3104 -E -f %%.3f %INP% >>%OUT%

@echo   -73d22'30.000  40d45'00.000   1157419.074    213139.664 NY L GP5 >%INP%
%EXE% +units=us-ft +init=%INIT_FILE%:3104 -E -f %%.3f %INP% >>%OUT%

@echo   -80d49'28.238  40d17'50.894   2435851.621    234309.717 OH N GP1 >%INP%
%EXE% +units=us-ft +init=%INIT_FILE%:3401 -E -f %%.3f %INP% >>%OUT%

@echo   -82d37'31.021  40d20'14.678   1933572.857    244396.244 OH N GP2 >%INP%
%EXE% +units=us-ft +init=%INIT_FILE%:3401 -E -f %%.3f %INP% >>%OUT%

@echo   -98d42'45.414  36d50'19.568   1759953.675    670136.468 OK N GP1 >%INP%
%EXE% +units=us-ft +init=%INIT_FILE%:3501 -E -f %%.3f %INP% >>%OUT%

@echo   -95d38'44.046  35d20'36.925   2670659.833    133589.112 OK N GP2 >%INP%
%EXE% +units=us-ft +init=%INIT_FILE%:3501 -E -f %%.3f %INP% >>%OUT%

@echo  -119d46'26.562  44d24'25.943   5110990.827    999684.042 OR S GP1 >%INP%
%EXE% +units=us-ft +init=%INIT_FILE%:3602 -E -f %%.3f %INP% >>%OUT%

@echo  -121d09'56.105  44d23'08.924   4747225.642    991752.635 OR S GP2 >%INP%
%EXE% +units=us-ft +init=%INIT_FILE%:3602 -E -f %%.3f %INP% >>%OUT%

@echo   -74d33'20.644  41d23'48.566   2844678.533    464365.610 PA N GP1 >%INP%
%EXE% +units=us-ft +init=%INIT_FILE%:3701 -E -f %%.3f %INP% >>%OUT%

@echo   -78d09'48.121  40d51'35.455   1854155.505    252833.700 PA N GP2 >%INP%
%EXE% +units=us-ft +init=%INIT_FILE%:3701 -E -f %%.3f %INP% >>%OUT%

@echo   -67d08'56.930  18d29'56.972    408161.046    898432.808 PR F GP1 >%INP%
%EXE% +units=us-ft +init=%INIT_FILE%:5200 -E -f %%.3f %INP% >>%OUT%

@echo   -66d52'30.000  18d15'00.000    502925.440    807654.009 PR F GP2 >%INP%
%EXE% +units=us-ft +init=%INIT_FILE%:5200 -E -f %%.3f %INP% >>%OUT%

@echo   -66d26'00.000  18d15'00.000    656166.667    807469.207 PR F GP3 >%INP%
%EXE% +units=us-ft +init=%INIT_FILE%:5200 -E -f %%.3f %INP% >>%OUT%

@echo   -66d26'00.000  18d30'00.000    656166.667    898253.524 PR F GP4 >%INP%
%EXE% +units=us-ft +init=%INIT_FILE%:5200 -E -f %%.3f %INP% >>%OUT%

@echo   -67d08'56.930  18d29'56.972    408161.046    898432.808 PR M GP1 >%INP%
%EXE% +units=us-ft +init=%INIT_FILE%:5200 -E -f %%.3f %INP% >>%OUT%

@echo   -66d52'30.000  18d15'00.000    502925.440    807654.009 PR M GP2 >%INP%
%EXE% +units=us-ft +init=%INIT_FILE%:5200 -E -f %%.3f %INP% >>%OUT%

@echo   -66d26'00.000  18d15'00.000    656166.667    807469.207 PR M GP3 >%INP%
%EXE% +units=us-ft +init=%INIT_FILE%:5200 -E -f %%.3f %INP% >>%OUT%

@echo   -66d26'00.000  18d30'00.000    656166.667    898253.524 PR M GP4 >%INP%
%EXE% +units=us-ft +init=%INIT_FILE%:5200 -E -f %%.3f %INP% >>%OUT%

@echo   -71d16'00.833  41d32'24.848    391898.667    166566.121 RI   GP1 >%INP%
%EXE% +units=us-ft +init=%INIT_FILE%:3800 -E -f %%.3f %INP% >>%OUT%

@echo   -71d37'13.730  41d23'53.266    295027.785    114722.837 RI   GP2 >%INP%
%EXE% +units=us-ft +init=%INIT_FILE%:3800 -E -f %%.3f %INP% >>%OUT%

@echo   -80d32'30.000  34d32'30.000   2138015.480    985710.127 SC N GP1 >%INP%
%EXE% +units=us-ft +init=%INIT_FILE%:3900 -E -f %%.3f %INP% >>%OUT%

@echo   -81d00'00.000  34d32'30.000   1999996.000    985404.077 SC N GP2 >%INP%
%EXE% +units=us-ft +init=%INIT_FILE%:3900 -E -f %%.3f %INP% >>%OUT%

@echo   -80d32'30.000  33d32'30.000   2139629.138    621856.156 SC S GP1 >%INP%
%EXE% +units=us-ft +init=%INIT_FILE%:3900 -E -f %%.3f %INP% >>%OUT%

@echo   -81d00'00.000  33d32'30.000   1999996.000    621546.527 SC S GP2 >%INP%
%EXE% +units=us-ft +init=%INIT_FILE%:3900 -E -f %%.3f %INP% >>%OUT%

@echo   -99d12'21.983  44d06'08.121   2177060.848     99066.761 SD N GP1 >%INP%
%EXE% +units=us-ft +init=%INIT_FILE%:4001 -E -f %%.3f %INP% >>%OUT%

@echo  -100d32'28.873  44d32'34.917   1827356.330    259209.712 SD N GP2 >%INP%
%EXE% +units=us-ft +init=%INIT_FILE%:4001 -E -f %%.3f %INP% >>%OUT%

@echo   -85d13'55.967  36d21'48.503   2194569.476    739881.374 TN   GP1 >%INP%
%EXE% +units=us-ft +init=%INIT_FILE%:4100 -E -f %%.3f %INP% >>%OUT%

@echo   -88d43'05.849  36d30'08.410   1169616.875    800645.091 TN   GP2 >%INP%
%EXE% +units=us-ft +init=%INIT_FILE%:4100 -E -f %%.3f %INP% >>%OUT%

@echo  -100d33'06.303  34d39'35.684    941333.504   3522390.511 TX N GP1 >%INP%
%EXE% +units=us-ft +init=%INIT_FILE%:4201 -E -f %%.3f %INP% >>%OUT%

@echo  -102d48'50.949  34d43'39.249    261294.654   3548271.494 TX N GP2 >%INP%
%EXE% +units=us-ft +init=%INIT_FILE%:4201 -E -f %%.3f %INP% >>%OUT%

@echo  -111d30'00.000  38d40'00.000   1640416.667   6683084.515 UT C GP1 >%INP%
%EXE% +units=us-ft +init=%INIT_FILE%:4302 -E -f %%.3f %INP% >>%OUT%

@echo  -111d30'00.000  38d40'30.000   1640416.667   6686119.851 UT C GP2 >%INP%
%EXE% +units=us-ft +init=%INIT_FILE%:4302 -E -f %%.3f %INP% >>%OUT%

@echo  -111d30'00.000  41d30'00.000   1640416.667   3705897.565 UT N GP1 >%INP%
%EXE% +units=us-ft +init=%INIT_FILE%:4301 -E -f %%.3f %INP% >>%OUT%

@echo  -111d30'00.000  41d30'30.000   1640416.667   3708933.975 UT N GP2 >%INP%
%EXE% +units=us-ft +init=%INIT_FILE%:4301 -E -f %%.3f %INP% >>%OUT%

@echo  -109d48'37.967  38d29'30.877   2123972.902  10511502.846 UT S GP1 >%INP%
%EXE% +units=us-ft +init=%INIT_FILE%:4303 -E -f %%.3f %INP% >>%OUT%

@echo  -113d52'56.922  37d09'18.788    946139.893  10029235.592 UT S GP2 >%INP%
%EXE% +units=us-ft +init=%INIT_FILE%:4303 -E -f %%.3f %INP% >>%OUT%

@echo   -77d13'46.945  38d55'12.407  11844323.043   7020638.975 VA N GP1 >%INP%
%EXE% +units=us-ft +init=%INIT_FILE%:4501 -E -f %%.3f %INP% >>%OUT%

@echo   -79d18'51.557  38d09'59.020  11248797.976   6744688.474 VA N GP2 >%INP%
%EXE% +units=us-ft +init=%INIT_FILE%:4501 -E -f %%.3f %INP% >>%OUT%

@echo   -77d38'10.823  37d49'23.964  11732395.294   6619889.590 VA N GP3 >%INP%
%EXE% +units=us-ft +init=%INIT_FILE%:4501 -E -f %%.3f %INP% >>%OUT%

@echo   -79d26'19.475  37d47'25.852  11211628.032   6608155.232 VA N GP4 >%INP%
%EXE% +units=us-ft +init=%INIT_FILE%:4501 -E -f %%.3f %INP% >>%OUT%

@echo   -77d44'30.336  39d00'06.804  11698399.159   7048812.266 VA N GP6 >%INP%
%EXE% +units=us-ft +init=%INIT_FILE%:4501 -E -f %%.3f %INP% >>%OUT%

@echo   -77d43'47.013  38d59'55.454  11701828.676   7047692.496 VA N GP9 >%INP%
%EXE% +units=us-ft +init=%INIT_FILE%:4501 -E -f %%.3f %INP% >>%OUT%

@echo   -78d30'00.000  37d30'00.000  11482916.667   3705606.876 VA S GP1 >%INP%
%EXE% +units=us-ft +init=%INIT_FILE%:4502 -E -f %%.3f %INP% >>%OUT%

@echo   -78d30'00.000  37d30'30.000  11482916.667   3708641.137 VA S GP2 >%INP%
%EXE% +units=us-ft +init=%INIT_FILE%:4502 -E -f %%.3f %INP% >>%OUT%

@echo   -77d32'33.000  36d54'42.507  11762849.074   3492868.579 VA S GP3 >%INP%
%EXE% +units=us-ft +init=%INIT_FILE%:4502 -E -f %%.3f %INP% >>%OUT%

@echo   -77d21'55.732  38d04'53.901  11809480.679   3919367.025 VA S GP4 >%INP%
%EXE% +units=us-ft +init=%INIT_FILE%:4502 -E -f %%.3f %INP% >>%OUT%

@echo   -64d45'30.000  17d45'30.000   1238952.313    631597.723 VI F GP1 >%INP%
%EXE% +units=us-ft +init=%INIT_FILE%:5200 -E -f %%.3f %INP% >>%OUT%

@echo   -66d26'00.000  17d45'56.426    656166.667    631597.858 VI F GP2 >%INP%
%EXE% +units=us-ft +init=%INIT_FILE%:5200 -E -f %%.3f %INP% >>%OUT%

@echo   -64d45'30.000  17d45'30.000   1238952.313    631597.723 VI M GP1 >%INP%
%EXE% +units=us-ft +init=%INIT_FILE%:5200 -E -f %%.3f %INP% >>%OUT%

@echo   -66d26'00.000  17d45'56.426    656166.667    631597.858 VI M GP2 >%INP%
%EXE% +units=us-ft +init=%INIT_FILE%:5200 -E -f %%.3f %INP% >>%OUT%

@echo   -72d29'31.418  43d09'58.526   1642534.834    242819.594 VT   GP1 >%INP%
%EXE% +units=us-ft +init=%INIT_FILE%:4400 -E -f %%.3f %INP% >>%OUT%

@echo   -73d12'06.978  44d22'22.810   1456873.971    683480.189 VT   GP2 >%INP%
%EXE% +units=us-ft +init=%INIT_FILE%:4400 -E -f %%.3f %INP% >>%OUT%

@echo  -119d51'37.006  47d50'51.069   1879336.368    310659.110 WA N GP1 >%INP%
%EXE% +units=us-ft +init=%INIT_FILE%:4601 -E -f %%.3f %INP% >>%OUT%

@echo  -123d59'49.087  48d09'29.131    868484.545    438307.526 WA N GP2 >%INP%
%EXE% +units=us-ft +init=%INIT_FILE%:4601 -E -f %%.3f %INP% >>%OUT%

@echo   -88d44'40.778  45d22'21.598   2291123.165     77666.637 WI N GP1 >%INP%
%EXE% +units=us-ft +init=%INIT_FILE%:4801 -E -f %%.3f %INP% >>%OUT%

@echo   -92d12'19.275  45d48'35.812   1406198.343    242375.264 WI N GP2 >%INP%
%EXE% +units=us-ft +init=%INIT_FILE%:4801 -E -f %%.3f %INP% >>%OUT%

@echo   -77d53'39.269  39d14'39.339   2423253.113    275144.536 WV N GP1 >%INP%
%EXE% +units=us-ft +init=%INIT_FILE%:4701 -E -f %%.3f %INP% >>%OUT%

@echo   -81d33'23.549  39d18'08.535   1386588.889    298906.239 WV N GP2 >%INP%
%EXE% +units=us-ft +init=%INIT_FILE%:4701 -E -f %%.3f %INP% >>%OUT%

@echo   -77d30'10.460  38d59'25.903   2536117.742    184974.384 WV N GP3 >%INP%
%EXE% +units=us-ft +init=%INIT_FILE%:4701 -E -f %%.3f %INP% >>%OUT%

@echo  -105d31'02.882  43d30'40.600    563107.342   1097477.489 WY E GP1 >%INP%
%EXE% +units=us-ft +init=%INIT_FILE%:4901 -E -f %%.3f %INP% >>%OUT%

@echo  -105d22'42.856  43d30'14.685    599946.619   1094729.119 WY E GP2 >%INP%
%EXE% +units=us-ft +init=%INIT_FILE%:4901 -E -f %%.3f %INP% >>%OUT%

@echo  -105d28'42.827  43d36'33.391    573561.723   1133155.514 WY E GP3 >%INP%
%EXE% +units=us-ft +init=%INIT_FILE%:4901 -E -f %%.3f %INP% >>%OUT%

@echo  -105d23'43.223  42d00'59.422    594028.794    552611.396 WY E GP4 >%INP%
%EXE% +units=us-ft +init=%INIT_FILE%:4901 -E -f %%.3f %INP% >>%OUT%

@echo  -104d35'06.686  42d34'50.366    812768.620    758647.940 WY E GP5 >%INP%
%EXE% +units=us-ft +init=%INIT_FILE%:4901 -E -f %%.3f %INP% >>%OUT%

@echo  -106d13'03.224  41d36'14.640   1617477.770    732300.770 WYEC GP1 >%INP%
%EXE% +units=us-ft +init=%INIT_FILE%:4902 -E -f %%.3f %INP% >>%OUT%

@echo  -108d01'56.720  41d51'57.518   1121920.469    826536.345 WYEC GP2 >%INP%
%EXE% +units=us-ft +init=%INIT_FILE%:4902 -E -f %%.3f %INP% >>%OUT%

@if EXIST %DIST% goto DoDiff
@echo Did NOT find file [%DIST%], so can NOT do a comparision...
@echo so no real way to tell if the output was all good from [%EXE%]
@echo to file %OUT%, but you can visually check it...
@goto FAILED

:DoDiff
@if "%DIFF%x" == "NOx" goto NODIFF
@echo Doing %DIFF% %OUT% with %DIST%"
@%DIFF% %OUT% %DIST% >nul
@if ERRORLEVEL 1 goto CHKDIFF
@call testok
@goto END

:CHKDIFF
@call testbad
@goto FAILED

:NODIFF
@echo Did NOT find [diff.exe], so can NOT do a comparision...
@echo so no real way to tell if the output was all good from [%EXE%]
@echo to file %OUT%, but you can visually check it...
@echo Go to http://unxutils.sourceforge.net/ for a native Win32 port of some GNU utilities
@echo and extract and place the 'diff.exe' in a folder in your PATH environment.
@goto FAILED

:NOEXE
@echo ERROR: Can NOT locate %EXE% file! Check name, location, and FIX
@goto FAILED
:NONAD
@echo ERROR: Can NOT locate %INIT_FILE% file! Check name, location, and FIX
@goto FAILED
:NODIR
@echo ERROR: Can NOT locate %PROJ_LIB% directory! Check name, location, and FIX
@goto FAILED

:FAILED
@if EXIST %INP% @del %INP%
@endlocal
@set TEMPFAILED=yes
@if "%TEMPNP%x" == "yesx" (
@pause
)
@goto DONE

:END
@if EXIST %INP% @del %INP%
@endlocal
:DONE
