@setlocal
@echo # Script to test some points in IGNF managed SRS.
@echo # The expected coordinates have been calculed by
@echo # other means.
@echo # Real points locations are found in proj_outIGNF.dist-real
@echo # while distribution results are found in proj_outIGNF.dist
@echo #
@(call :SHOWSUG)

@if NOT "%PROJ_LIB%x" == "x" goto DNLIB
@set PROJ_LIB=..\..\nad
:DNLIB
@REM To SEE what is, and is NOT loaded...
@REM set PROJ_DEBUG=9

@set EXE=bin\cs2cs.exe
@set DIST=%PROJ_LIB%\proj_outIGNF.dist
@set OUT=temp_proj_outIGNF.txt
@set INIT_FILE=%PROJ_LIB%\IGNF
@set INIT_OUT=./IGNF
@set RES=-f %%.3f
@set INP=temp_in.txt

@if NOT EXIST %EXE% goto NOEXE
@if NOT EXIST %PROJ_LIB%\. goto NODIR
@if NOT EXIST %INIT_FILE% goto NONAD

@REM Test for GNU type 'diff' in the PATH
@diff --version >nul
@if ERRORLEVEL 1 goto USECOMP
@set DIFF=diff -w
@echo Found, and using [%DIFF%] for the difference at the end...
@goto DNDIFF

:SHOWSUG
@echo # 2009-03-08 :  the null grid (nad2bin null null.lla) MUST
@echo #               be around otherwise the LAMBE to LAMB93
@echo #               transformations will be wrong and vice-versa
@echo # 2009-10-04 :  addition of NTFG to RGF93G test to check if
@echo #               the gsb grid is still ok
@goto :EOF

:USECOMP
@REM NO the windows native 'comp.exe' will NOT 'ignore spaces'!!!
@REM So do NOT do a DIFF !!!
@set DIFF=NO
@echo NOTE: diff NOT found in PATH, so CAN NOT DO a difference at the end. Not good...
@echo Go to http://unxutils.sourceforge.net/ for Native Win32 ports of some GNU utilities
@echo and extract and place the 'diff.exe' in a folder in your PATH environment.
@echo.
:DNDIFF

@if EXIST %DIST% goto DNDIST
@echo.
@echo WARNING: Can NOT locate file [%DIST%]!
@echo So will be UNABLE to do comparison at end...
@echo.
:DNDIST
@echo *** CONTINUE? *** Ctrl+C to abort...  Environment [PROJ_LIB=%PROJ_LIB%]
@if "%TEMPNP%x" == "yesx" (
@echo NO PAUSE [TEMPNP] set in environment...
@set EXE=@%EXE%
) else (
@pause
)

@echo ============================================
@echo Running %0, using [%EXE%], PROJ_LIB=%PROJ_LIB%
@echo ============================================

@echo "Doing tests into file [%OUT%], please wait...
@if EXIST %OUT% @del %OUT%

@echo +init=%INIT_OUT%:NTFG +to +init=%INIT_OUT%:RGF93G >>%OUT%
@echo  3.300866856 43.4477976569 0.0000 >%INP%
%EXE% +init=%INIT_FILE%:NTFG +to +init=%INIT_FILE%:RGF93G -E %INP% >>%OUT%

@echo +init=%INIT_OUT%:LAMBE +to +init=%INIT_OUT%:LAMB93 >>%OUT%
@echo  600000.0000 2600545.4523  0.0000 >%INP%
%EXE% +init=%INIT_FILE%:LAMBE +to +init=%INIT_FILE%:LAMB93 -E -f %%.3f %INP% >>%OUT%

@echo  135638.3592 2418760.4094  0.0000 >%INP%
%EXE% +init=%INIT_FILE%:LAMBE +to +init=%INIT_FILE%:LAMB93 -E -f %%.3f %INP% >>%OUT%

@echo  998137.3947 2413822.2844  0.0000 >%INP%
%EXE% +init=%INIT_FILE%:LAMBE +to +init=%INIT_FILE%:LAMB93 -E -f %%.3f %INP% >>%OUT%

@echo  600000.0000 2200000.0000  0.0000 >%INP%
%EXE% +init=%INIT_FILE%:LAMBE +to +init=%INIT_FILE%:LAMB93 -E -f %%.3f %INP% >>%OUT%

@echo  311552.5340 1906457.4840  0.0000 >%INP%
%EXE% +init=%INIT_FILE%:LAMBE +to +init=%INIT_FILE%:LAMB93 -E -f %%.3f %INP% >>%OUT%

@echo  960488.4138 1910172.8812  0.0000 >%INP%
%EXE% +init=%INIT_FILE%:LAMBE +to +init=%INIT_FILE%:LAMB93 -E -f %%.3f %INP% >>%OUT%

@echo  600000.0000 1699510.8340  0.0000 >%INP%
%EXE% +init=%INIT_FILE%:LAMBE +to +init=%INIT_FILE%:LAMB93 -E -f %%.3f %INP% >>%OUT%

@echo 1203792.5981 626873.17210  0.0000 >%INP%
%EXE% +init=%INIT_FILE%:LAMBE +to +init=%INIT_FILE%:LAMB93 -E -f %%.3f %INP% >>%OUT%

@echo +init=%INIT_OUT%:LAMBE +to +init=%INIT_OUT%:GEOPORTALFXX >>%OUT%
@echo  600000.0000 2600545.4523  0.0000 >%INP%
%EXE% +init=%INIT_FILE%:LAMBE +to +init=%INIT_FILE%:GEOPORTALFXX -E -f %%.3f %INP% >>%OUT%

@echo  135638.3592 2418760.4094  0.0000 >%INP%
%EXE% +init=%INIT_FILE%:LAMBE +to +init=%INIT_FILE%:GEOPORTALFXX -E -f %%.3f %INP% >>%OUT%

@echo  998137.3947 2413822.2844  0.0000 >%INP%
%EXE% +init=%INIT_FILE%:LAMBE +to +init=%INIT_FILE%:GEOPORTALFXX -E -f %%.3f %INP% >>%OUT%

@echo  600000.0000 2200000.0000  0.0000 >%INP%
%EXE% +init=%INIT_FILE%:LAMBE +to +init=%INIT_FILE%:GEOPORTALFXX -E -f %%.3f %INP% >>%OUT%

@echo  311552.5340 1906457.4840  0.0000 >%INP%
%EXE% +init=%INIT_FILE%:LAMBE +to +init=%INIT_FILE%:GEOPORTALFXX -E -f %%.3f %INP% >>%OUT%

@echo  960488.4138 1910172.8812  0.0000 >%INP%
%EXE% +init=%INIT_FILE%:LAMBE +to +init=%INIT_FILE%:GEOPORTALFXX -E -f %%.3f %INP% >>%OUT%

@echo  600000.0000 1699510.8340  0.0000 >%INP%
%EXE% +init=%INIT_FILE%:LAMBE +to +init=%INIT_FILE%:GEOPORTALFXX -E -f %%.3f %INP% >>%OUT%

@echo 1203792.5981 626873.17210  0.0000 >%INP%
%EXE% +init=%INIT_FILE%:LAMBE +to +init=%INIT_FILE%:GEOPORTALFXX -E -f %%.3f %INP% >>%OUT%

@echo +init=%INIT_OUT%:RGF93G +to +init=%INIT_OUT%:GEOPORTALFXX >>%OUT%
@echo 2d20'11.4239243" 50d23'59.7718445" 0.0 >%INP%
%EXE% +init=%INIT_FILE%:RGF93G +to +init=%INIT_FILE%:GEOPORTALFXX -E -f %%.3f %INP% >>%OUT%

@echo -3d57'49.4051448" 48d35'59.7121716" 0.0 >%INP%
%EXE% +init=%INIT_FILE%:RGF93G +to +init=%INIT_FILE%:GEOPORTALFXX -E -f %%.3f %INP% >>%OUT%

@echo 7d44'12.1439796" 48d35'59.7832558" 0.0 >%INP%
%EXE% +init=%INIT_FILE%:RGF93G +to +init=%INIT_FILE%:GEOPORTALFXX -E -f %%.3f %INP% >>%OUT%

@echo 2d20'11.4951975" 46d47'59.8029841" 0.0 >%INP%
%EXE% +init=%INIT_FILE%:RGF93G +to +init=%INIT_FILE%:GEOPORTALFXX -E -f %%.3f %INP% >>%OUT%

@echo -1d15'48.9240599" 44d05'59.8251878" 0.0 >%INP%
%EXE% +init=%INIT_FILE%:RGF93G +to +init=%INIT_FILE%:GEOPORTALFXX -E -f %%.3f %INP% >>%OUT%

@echo 6d50'12.2276489" 44d06'00.0517019" 0.0 >%INP%
%EXE% +init=%INIT_FILE%:RGF93G +to +init=%INIT_FILE%:GEOPORTALFXX -E -f %%.3f %INP% >>%OUT%

@echo 2d20'11.7754730" 42d18'00.0824436" 0.0 >%INP%
%EXE% +init=%INIT_FILE%:RGF93G +to +init=%INIT_FILE%:GEOPORTALFXX -E -f %%.3f %INP% >>%OUT%

@echo 9d32'12.6680218" 41d24'00.3542556" 0.0 >%INP%
%EXE% +init=%INIT_FILE%:RGF93G +to +init=%INIT_FILE%:GEOPORTALFXX -E -f %%.3f %INP% >>%OUT%

@echo +init=%INIT_OUT%:RGF93G +to +init=%INIT_OUT%:MILLER >>%OUT%
@echo 2d20'11.4239243" 50d23'59.7718445" 0.0 >%INP%
%EXE% +init=%INIT_FILE%:RGF93G +to +init=%INIT_FILE%:MILLER -E -f %%.3f %INP% >>%OUT%

@echo -3d57'49.4051448" 48d35'59.7121716" 0.0 >%INP%
%EXE% +init=%INIT_FILE%:RGF93G +to +init=%INIT_FILE%:MILLER -E -f %%.3f %INP% >>%OUT%

@echo 7d44'12.1439796" 48d35'59.7832558" 0.0 >%INP%
%EXE% +init=%INIT_FILE%:RGF93G +to +init=%INIT_FILE%:MILLER -E -f %%.3f %INP% >>%OUT%

@echo 2d20'11.4951975" 46d47'59.8029841" 0.0 >%INP%
%EXE% +init=%INIT_FILE%:RGF93G +to +init=%INIT_FILE%:MILLER -E -f %%.3f %INP% >>%OUT%

@echo -1d15'48.9240599" 44d05'59.8251878" 0.0 >%INP%
%EXE% +init=%INIT_FILE%:RGF93G +to +init=%INIT_FILE%:MILLER -E -f %%.3f %INP% >>%OUT%

@echo 6d50'12.2276489" 44d06'00.0517019" 0.0 >%INP%
%EXE% +init=%INIT_FILE%:RGF93G +to +init=%INIT_FILE%:MILLER -E -f %%.3f %INP% >>%OUT%

@echo 2d20'11.7754730" 42d18'00.0824436" 0.0 >%INP%
%EXE% +init=%INIT_FILE%:RGF93G +to +init=%INIT_FILE%:MILLER -E -f %%.3f %INP% >>%OUT%

@echo 9d32'12.6680218" 41d24'00.3542556" 0.0 >%INP%
%EXE% +init=%INIT_FILE%:RGF93G +to +init=%INIT_FILE%:MILLER -E -f %%.3f %INP% >>%OUT%

@echo +init=%INIT_OUT%:RGR92 +to +init=%INIT_OUT%:REUN47 >>%OUT%
@echo 3356123.5400 1303218.3090 5247430.6050 >%INP%
%EXE% +init=%INIT_FILE%:RGR92 +to +init=%INIT_FILE%:REUN47 -E -f %%.3f %INP% >>%OUT%

@if EXIST %DIST% goto DoDiff
@echo Did NOT find file [%DIST%], so can NOT do a comparision...
@echo so no real way to tell if the output was all good from [%EXE%]
@echo to file %OUT%, but you can visually check it...
@goto FAILED

:DoDiff
@if "%DIFF%x" == "NOx" goto NODIFF
@echo do 'diff' with distribution results...
@echo Doing: "%DIFF% %OUT% %DIST%"
@%DIFF% %OUT% %DIST% >nul
@if ERRORLEVEL 1 goto CHKDIFF
@call testok
@goto END

:CHKDIFF
@call testbad
@echo To repeat the earlier 'advice' again...
@(call :SHOWSUG)
@echo.
@goto FAILED

:NODIFF
@echo Did NOT find [diff.exe], so can NOT do a comparision...
@echo so no real way to tell if the output was all good from [%EXE%]
@echo to file %OUT%, but you can visually check it...
@echo Go to http://unxutils.sourceforge.net/ for a native Win32 port of some GNU utilities
@echo and extract and place the 'diff.exe' in a folder in your PATH environment.
@goto FAILED

:NOEXE
@echo ERROR: Can NOT locate %EXE% file! Check name, location, and FIX
@goto FAILED
:NONAD
@echo ERROR: Can NOT locate %INIT_FILE% file! Check name, location, and FIX
@goto FAILED
:NODIR
@echo ERROR: Can NOT locate %PROJ_LIB% directory! Check name, location, and FIX
@goto FAILED

:FAILED
@if EXIST %INP% @del %INP%
@endlocal
@set TEMPFAILED=yes
@if "%TEMPNP%x" == "yesx" (
@pause
)
@goto DONE

:END
@if EXIST %INP% @del %INP%
@endlocal
:DONE
