@setlocal
@echo #
@echo # Test NTv2 (.gsb) support.  Assumes ntv2_0.gsb is installed.
@echo #
@echo # Personal note: The 'ntv2_0.gsb' can be downlaoded (after registering)
@echo # from : http://csrsjava.geod.nrcan.gc.ca/csrsicp/CsrsLogin?userlang=en
@echo # but in my case it did _NOT_ produce a clean conversion test 
@echo # ;=(( - geoff mclane - 2010-08-18
@echo.

@if NOT "%PROJ_LIB%x" == "x" goto DNLIB
@set PROJ_LIB=..\..\nad
:DNLIB
@REM To SEE what is, and is NOT loaded...
@REM set PROJ_DEBUG=9

@set EXE=bin\cs2cs.exe
@set OUT=temp_ntv2_out
@set INP=temp_int.txt
@set DIST=%PROJ_LIB%\ntv2_out.dist
@set INIT_FILE=%PROJ_LIB%\NTV2_0.GSB

@if NOT EXIST %EXE% goto NOEXE
@if NOT EXIST %PROJ_LIB%\. goto NODIR
@if NOT EXIST %INIT_FILE% goto NONAD

@if EXIST %DIST% goto DNDIST
@echo.
@echo WARNING: Can NOT locate file [%DIST%]!
@echo So will be UNABLE to do comparison at end...
@echo.

:DNDIST
@REM Test for GNU type 'diff' in the PATH
@diff --version >nul
@if ERRORLEVEL 1 goto USECOMP
@set DIFF=diff -w
@echo Found, and using [%DIFF%] for the difference at the end...
@goto DNDIFF

:USECOMP
@REM NO the windows native 'comp.exe' will NOT 'ignore spaces'!!!
@REM So do NOT do a DIFF !!!
@set DIFF=NO
@echo NOTE: diff NOT found in PATH, so CAN NOT DO a difference at the end. Not good...
@echo Go to http://unxutils.sourceforge.net/ for Native Win32 ports of some GNU utilities
@echo and extract and place the 'diff.exe' in a folder in your PATH environment.
@echo.
:DNDIFF

@echo *** CONTINUE? *** Ctrl+C to abort... Environment [PROJ_LIB=%PROJ_LIB%]
@if "%TEMPNP%x" == "yesx" (
@echo NO PAUSE [TEMPNP=yes] set in environment...
@set EXE=@%EXE%
) else (
@pause
)

@echo ============================================
@echo Running %0, using %EXE%, PROJ_LIB=%PROJ_LIB%
@echo ============================================

@if EXIST %OUT% @del %OUT%

@echo Doing tests into file [%OUT%], please wait...

@echo ############################################################## >> %OUT%
@echo Point in the ONwinsor subgrid. >> %OUT%

@echo 82d00'00.000"W 42d00'00.000"N 0.0 >%INP%
@echo 82d00'01.000"W 42d00'00.000"N 0.0 >>%INP%
@echo 82d00'02.000"W 42d00'00.000"N 0.0 >>%INP%
@echo 84d00'00.000"W 42d00'00.000"N 0.0 >>%INP%
%EXE% +proj=latlong +ellps=clrk66 +nadgrids=ntv2_0.gsb +to +proj=latlong +datum=NAD83 -E -w6 %INP% >>%OUT%

@echo ############################################################## >> %OUT%
@echo Try with NTv2 and NTv1 together ... falls back to NTv1 >> %OUT%

@echo 99d00'00.000"W 65d00'00.000"N 0.0 >%INP%
@echo 111d00'00.000"W 46d00'00.000"N 0.0 >>%INP%
@echo 111d00'00.000"W 47d30'00.000"N 0.0 >>%INP%
%EXE% +proj=latlong +ellps=clrk66 +nadgrids=ntv2_0.gsb,ntv1_can.dat,conus +to +proj=latlong +datum=NAD83 -E -w6 %INP% >>%OUT%

@REM ##############################################################################
@REM # Done! 

@if EXIST %DIST% goto DoDiff
@echo Did NOT find file [%DIST%], so can NOT do a comparision...
@echo so no real way to tell if the output was all good from [%EXE%]
@echo to file %OUT%, but you can visually check it...
@goto FAILED

:DoDiff
@if "%DIFF%x" == "NOx" goto NODIFF
@echo do 'diff' with distribution results...
@echo Doing: "%DIFF% %OUT% %DIST%"
@%DIFF% %OUT% %DIST% >nul
@if ERRORLEVEL 1 goto CHKDIFF
@call testok
@goto END

:CHKDIFF
@call testbad
@goto FAILED

:NODIFF
@echo Did NOT find [diff.exe], so can NOT do a comparision...
@echo so no real way to tell if the output was all good from [%EXE%]
@echo to file %OUT%, but you can visually check it...
@echo Go to http://unxutils.sourceforge.net/ for a native Win32 port of some GNU utilities
@echo and extract and place the 'diff.exe' in a folder in your PATH environment.
@goto FAILED

:NOEXE
@echo ERROR: Can NOT locate %EXE% file! Check name, location, and FIX
@goto FAILED
:NONAD
@echo ERROR: Can NOT locate %INIT_FILE% file! Check name, location, and FIX
@goto FAILED
:NODIR
@echo ERROR: Can NOT locate %PROJ_LIB% directory! Check name, location, and FIX
@goto FAILED

:FAILED
@if EXIST %INP% @del %INP%
@if NOT EXIST ntv2_out2.dist goto DNTST2
@%DIFF% %OUT% ntv2_out2.dist >nul
@if ERRORLEVEL 1 goto DNTST2
@echo.
@echo NOTE: The output exactly conforms to a MODIFIED ntv2_out2.dist file,
@echo where only very insignificant decimal point changes were made,
@echo so shall treat this as a fully *** SUCCESSFUL *** test
@echo.
@goto END

:DNTST2
@endlocal
@set TEMPFAILED=yes
@if "%TEMPNP%x" == "yesx" (
@pause
)
@goto DONE

:END
@if EXIST %INP% @del %INP%
@endlocal
:DONE
