@setlocal
@echo # Script to do some testing of various transformation that do not depend
@echo # on datum files.

@if NOT "%PROJ_LIB%x" == "x" goto DNLIB
@set PROJ_LIB=..\..\nad
:DNLIB
@REM To SEE what is, and is NOT loaded...
@REM set PROJ_DEBUG=9

@set EXE=bin\cs2cs.exe
@set OUT=temp_tv_out.txt
@set DIST=%PROJ_LIB%\tv_out.dist
@set INP=temp_tv_in.txt

@if NOT EXIST %EXE% goto NOEXE
@if NOT EXIST %PROJ_LIB%\. goto NODIR
@REM if NOT EXIST %INIT_FILE% goto NONAD

@if EXIST %DIST% goto DNDIST
@echo.
@echo WARNING: Can NOT locate file [%DIST%]!
@echo So will be UNABLE to do comparison at end...
@echo.
:DNDIST

@REM Test for GNU type 'diff' in the PATH
@diff --version >nul
@if ERRORLEVEL 1 goto USECOMP
@set DIFF=diff -w
@echo Found, and using [%DIFF%] for the difference at the end...
@goto DNDIFF
:USECOMP
@REM NO the windows native 'comp.exe' will NOT 'ignore spaces'!!!
@REM So do NOT do a DIFF !!!
@set DIFF=NO
@echo NOTE: diff NOT found in PATH, so CAN NOT DO a difference at the end. Not good...
@echo Go to http://unxutils.sourceforge.net/ for Native Win32 ports of some GNU utilities
@echo and extract and place the 'diff.exe' in a folder in your PATH environment.
@echo.
:DNDIFF

@echo *** CONTINUE? *** Ctrl+C to abort... Environment [PROJ_LIB=%PROJ_LIB%]
@if "%TEMPNP%x" == "yesx" (
@echo NO PAUSE [TEMPNP=yes] set in environment...
@set EXE=@%EXE%
) else (
@pause
)

@echo ============================================
@echo Running %0, using %EXE%, PROJ_LIB=%PROJ_LIB%
@echo ============================================

@if EXIST %OUT% @del %OUT%

@echo ############################################################## >> %OUT%
@echo Test raw ellipse to raw ellipse >> %OUT%

@echo 79d58'00.000"W 37d02'00.000"N 0.0 >%INP%
@echo 79d58'00.000"W 36d58'00.000"N 0.0 >>%INP%
%EXE% +proj=latlong +ellps=clrk66 +to +proj=latlong +ellps=bessel -E %INP% >>%OUT%

@echo ############################################################## >> %OUT%
@echo Test NAD27 to raw ellipse >> %OUT%

@echo 79d00'00.000"W 35d00'00.000"N 0.0 >%INP%
%EXE% +proj=latlong +datum=NAD27 +to +proj=latlong +ellps=bessel -E %INP% >>%OUT%

@echo ############################################################## >> %OUT%
@echo Between two 3parameter approximations on same ellipsoid >> %OUT%
@echo 0d00'00.000"W 0d00'00.000"N 0.0 >%INP%
@echo 79d00'00.000"W 45d00'00.000"N 0.0 >>%INP%
%EXE% +proj=latlong +ellps=bessel +towgs84=5,0,0 +to +proj=latlong +ellps=bessel +towgs84=1,0,0 -E %INP% >>%OUT%

@echo ############################################################## >> %OUT%
@echo 3param to raw ellipsoid on same ellipsoid >> %OUT%
@echo 0d00'00.000"W 0d00'00.000"N 0.0 >%INP%
@echo 79d00'00.000"W 45d00'00.000"N 0.0 >>%INP%
%EXE% +proj=latlong +ellps=bessel +towgs84=5,0,0 +to +proj=latlong +ellps=bessel -E %INP% >>%OUT%

@echo ############################################################## >> %OUT%
@echo Test simple prime meridian handling. >> %OUT%
@echo 0d00'00.000"W 0d00'00.000"N 0.0 >%INP%
@echo 79d00'00.000"W 45d00'00.000"N 0.0 >>%INP%
%EXE% +proj=latlong +datum=WGS84 +pm=greenwich +to +proj=latlong +datum=WGS84 +pm=1 -E %INP% >>%OUT%

@echo ############################################################## >> %OUT%
@echo Test support for the lon_wrap switch. >> %OUT%
@echo 1d00'00.000"W 10d00'00.000"N 0.0 >%INP%
@echo 0d00'00.000"W 10d00'00.000"N 0.0 >>%INP%
@echo 0d00'00.000"E 10d00'00.000"N 0.0 >>%INP%
@echo 1d00'00.000"E 45d00'00.000"N 0.0 >>%INP%
@echo 179d00'00.000"E 45d00'00.000"N 0.0 >>%INP%
@echo 181d00'00.000"E 45d00'00.000"N 0.0 >>%INP%
@echo 350d00'00.000"E 45d00'00.000"N 0.0 >>%INP%
@echo 370d00'00.000"E 45d00'00.000"N 0.0 >>%INP%
%EXE% +proj=latlong +datum=WGS84 +to +proj=latlong +datum=WGS84 +lon_wrap=180 -E %INP% >>%OUT%

@echo ############################################################## >> %OUT%
@echo Test simple prime meridian handling within a projection. >> %OUT%
@echo 500000 3000000 >%INP%
%EXE% +proj=utm +zone=11 +datum=WGS84 +pm=3 +to +proj=latlong +datum=WGS84 +pm=1w -E %INP% >>%OUT%

@echo ############################################################## >> %OUT%
@echo Test geocentric x/y/z generation. >> %OUT%
@echo 0d00'00.001"W 0d00'00.001"N 0.0 >%INP%
@echo 0d00'00.001"W 0d00'00.001"N 10.0 >>%INP%
@echo 79d00'00.000"W 45d00'00.000"N 0.0 >>%INP%
@echo 45d00'00.000"W 89d59'59.990"N 0.0 >>%INP%
%EXE% +proj=latlong +datum=WGS84 +to +proj=geocent +datum=WGS84 -E %INP% >>%OUT%

@echo ############################################################## >> %OUT%
@echo Test geocentric x/y/z consumption. >> %OUT%
@echo 6378137.00      -0.00 0.00 >%INP%
@echo 6378147.00      -0.00 0.00 >>%INP%
@echo 861996.98       -4434590.01 4487348.41 >>%INP%
@echo 0.00    -0.00 6356752.31 >>%INP%
%EXE% +proj=geocent +datum=WGS84 +to +proj=latlong +datum=WGS84 -E %INP% >>%OUT%

@REM #echo "#############################################################" >> %OUT%
@REM #echo Test conversion between geocentric latlong and geodetic latlong >> %OUT%
@REM #
@REM # The +geoc flag does not currently work with pj_transform() so this is 
@REM # disabled. 
@REM #
@echo 0d00'00.000"W 0d00'00.000"N 0.0 >%INP%
@echo 79d00'00.000"W 45d00'00.000"N 0.0 >>%INP%
@echo 12d00'00.000"W 45d00'00.000"N 0.0 >>%INP%
@echo 0d00'00.000"W 90d00'00.000"N 0.0 >>%INP%
@REM #%EXE% +proj=latlong +datum=WGS84 +geoc +to +proj=latlong +datum=WGS84 -E %INP% >>%OUT%

@echo ############################################################## >> %OUT%
@echo Test stere projection (re: win32 ticket 12) >> %OUT%
@echo 105 40 >%INP%
%EXE% +proj=latlong +datum=WGS84 +to +proj=stere +lat_0=90 +lon_0=0 +lat_ts=70 +datum=WGS84 -E %INP% >>%OUT%

@echo ############################################################## >> %OUT%
@echo Test sts projection (re: ticket 12) >> %OUT%
@echo 4.897000 52.371000 >%INP%
%EXE% +proj=latlong +ellps=WGS84 +to +proj=kav5 +ellps=WGS84 +units=m -E %INP% >>%OUT%

@echo 383646.088858 5997047.888175 >%INP%
%EXE% +proj=kav5 +ellps=WGS84 +units=m +to +proj=latlong +ellps=WGS84 -E %INP% >>%OUT%

@echo ############################################################## >> %OUT%
@echo Test RSO Borneo projection (re: ticket 62) >> %OUT%
@echo 116d2'11.12630 5d54'19.90183 >%INP%
@REM %EXE% +proj=latlong +a=6377298.556 +rf=300.8017 +to +proj=omerc +a=6377298.556 +rf=300.8017 +lat_0=4 +lonc=115 +alpha=53d18\'56.9537 +gamma=53d7\'48.3685  +k_0=0.99984 +x_0=590476.87 +y_0=442857.65 -E %INP% >>%OUT%
%EXE% +proj=latlong +a=6377298.556 +rf=300.8017 +to +proj=omerc +a=6377298.556 +rf=300.8017 +lat_0=4 +lonc=115 +alpha=53d18'56.9537 +gamma=53d7'48.3685  +k_0=0.99984 +x_0=590476.87 +y_0=442857.65 -E %INP% >>%OUT%

@REM ##############################################################################
@REM # Done! 
@REM # do 'diff' with distribution results

@if EXIST %DIST% goto DoDiff
@echo Did NOT find file [%DIST%], so can NOT do a comparision...
@echo so no real way to tell if the output was all good from [%EXE%]
@echo to file %OUT%, but you can visually check it...
@goto FAILED

:DoDiff
@if "%DIFF%x" == "NOx" goto NODIFF
@echo do 'diff' with distribution results...
@echo Doing: "%DIFF% %OUT% %DIST%"
@%DIFF% %OUT% %DIST% >nul
@if ERRORLEVEL 1 goto CHKDIFF
@call testok
@goto END

:CHKDIFF
@call testbad
@goto FAILED

:NODIFF
@echo Did NOT find [diff.exe], so can NOT do a comparision...
@echo so no real way to tell if the output was all good from [%EXE%]
@echo to file %OUT%, but you can visually check it...
@echo Go to http://unxutils.sourceforge.net/ for a native Win32 port of some GNU utilities
@echo and extract and place the 'diff.exe' in a folder in your PATH environment.
@goto FAILED

:NOEXE
@echo ERROR: Can NOT locate %EXE% file! Check name, location, and FIX
@goto FAILED
:NONAD
@echo ERROR: Can NOT locate %INIT_FILE% file! Check name, location, and FIX
@goto FAILED
:NODIR
@echo ERROR: Can NOT locate %PROJ_LIB% directory! Check name, location, and FIX
@goto FAILED

:FAILED
@if EXIST %INP% @del %INP%
@endlocal
@set TEMPFAILED=yes
@if "%TEMPNP%x" == "yesx" (
@pause
)
@goto DONE

:END
@if EXIST %INP% @del %INP%
@endlocal
:DONE
